/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { ALLOW_MULTIPLE_PLATFORMS as ɵALLOW_MULTIPLE_PLATFORMS, internalCreateApplication as ɵinternalCreateApplication } from './application_ref';
export { APP_ID_RANDOM_PROVIDER as ɵAPP_ID_RANDOM_PROVIDER } from './application_tokens';
export { defaultIterableDiffers as ɵdefaultIterableDiffers, defaultKeyValueDiffers as ɵdefaultKeyValueDiffers } from './change_detection/change_detection';
export { Console as ɵConsole } from './console';
export { getDebugNodeR2 as ɵgetDebugNodeR2 } from './debug/debug_node';
export { convertToBitFlags as ɵconvertToBitFlags, setCurrentInjector as ɵsetCurrentInjector } from './di/injector_compatibility';
export { getInjectableDef as ɵgetInjectableDef } from './di/interface/defs';
export { isEnvironmentProviders as ɵisEnvironmentProviders } from './di/interface/provider';
export { INJECTOR_SCOPE as ɵINJECTOR_SCOPE } from './di/scope';
export { XSS_SECURITY_URL as ɵXSS_SECURITY_URL } from './error_details_base_url';
export { formatRuntimeError as ɵformatRuntimeError, RuntimeError as ɵRuntimeError } from './errors';
export { findLocaleData as ɵfindLocaleData, getLocaleCurrencyCode as ɵgetLocaleCurrencyCode, getLocalePluralCase as ɵgetLocalePluralCase, LocaleDataIndex as ɵLocaleDataIndex, registerLocaleData as ɵregisterLocaleData, unregisterAllLocaleData as ɵunregisterLocaleData } from './i18n/locale_data_api';
export { DEFAULT_LOCALE_ID as ɵDEFAULT_LOCALE_ID } from './i18n/localization';
export { ComponentFactory as ɵComponentFactory } from './linker/component_factory';
export { clearResolutionOfComponentResourcesQueue as ɵclearResolutionOfComponentResourcesQueue, resolveComponentResources as ɵresolveComponentResources } from './metadata/resource_loading';
export { ReflectionCapabilities as ɵReflectionCapabilities } from './reflection/reflection_capabilities';
export { allowSanitizationBypassAndThrow as ɵallowSanitizationBypassAndThrow, getSanitizationBypassType as ɵgetSanitizationBypassType, unwrapSafeValue as ɵunwrapSafeValue } from './sanitization/bypass';
export { _sanitizeHtml as ɵ_sanitizeHtml } from './sanitization/html_sanitizer';
export { _sanitizeUrl as ɵ_sanitizeUrl } from './sanitization/url_sanitizer';
export { TESTABILITY as ɵTESTABILITY, TESTABILITY_GETTER as ɵTESTABILITY_GETTER } from './testability/testability';
export { coerceToBoolean as ɵcoerceToBoolean } from './util/coercion';
export { devModeEqual as ɵdevModeEqual } from './util/comparison';
export { makeDecorator as ɵmakeDecorator } from './util/decorators';
export { global as ɵglobal } from './util/global';
export { isObservable as ɵisObservable, isPromise as ɵisPromise, isSubscribable as ɵisSubscribable } from './util/lang';
export { stringify as ɵstringify } from './util/stringify';
export { NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR as ɵNOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR } from './view/provider_flags';
//# sourceMappingURL=data:application/json;base64,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