"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.forceAutocomplete = exports.ngDebug = exports.disableVersionCheck = exports.isCI = exports.analyticsDisabled = void 0;
function isPresent(variable) {
    return typeof variable === 'string' && variable !== '';
}
function isDisabled(variable) {
    return isPresent(variable) && (variable === '0' || variable.toLowerCase() === 'false');
}
function isEnabled(variable) {
    return isPresent(variable) && (variable === '1' || variable.toLowerCase() === 'true');
}
function optional(variable) {
    if (!isPresent(variable)) {
        return undefined;
    }
    return isEnabled(variable);
}
exports.analyticsDisabled = isDisabled(process.env['NG_CLI_ANALYTICS']);
exports.isCI = isEnabled(process.env['CI']);
exports.disableVersionCheck = isEnabled(process.env['NG_DISABLE_VERSION_CHECK']);
exports.ngDebug = isEnabled(process.env['NG_DEBUG']);
exports.forceAutocomplete = optional(process.env['NG_FORCE_AUTOCOMPLETE']);
//# sourceMappingURL=data:application/json;base64,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