/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Checks whether a modifier key is pressed.
 * @param event Event to be checked.
 */
export function hasModifierKey(event, ...modifiers) {
    if (modifiers.length) {
        return modifiers.some(modifier => event[modifier]);
    }
    return event.altKey || event.shiftKey || event.ctrlKey || event.metaKey;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9kaWZpZXJzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vc3JjL2Nkay9rZXljb2Rlcy9tb2RpZmllcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBSUg7OztHQUdHO0FBQ0gsTUFBTSxVQUFVLGNBQWMsQ0FBQyxLQUFvQixFQUFFLEdBQUcsU0FBd0I7SUFDOUUsSUFBSSxTQUFTLENBQUMsTUFBTSxFQUFFO1FBQ3BCLE9BQU8sU0FBUyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0tBQ3BEO0lBRUQsT0FBTyxLQUFLLENBQUMsTUFBTSxJQUFJLEtBQUssQ0FBQyxRQUFRLElBQUksS0FBSyxDQUFDLE9BQU8sSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDO0FBQzFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIExMQyBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuZXhwb3J0IHR5cGUgTW9kaWZpZXJLZXkgPSAnYWx0S2V5JyB8ICdzaGlmdEtleScgfCAnY3RybEtleScgfCAnbWV0YUtleSc7XG5cbi8qKlxuICogQ2hlY2tzIHdoZXRoZXIgYSBtb2RpZmllciBrZXkgaXMgcHJlc3NlZC5cbiAqIEBwYXJhbSBldmVudCBFdmVudCB0byBiZSBjaGVja2VkLlxuICovXG5leHBvcnQgZnVuY3Rpb24gaGFzTW9kaWZpZXJLZXkoZXZlbnQ6IEtleWJvYXJkRXZlbnQsIC4uLm1vZGlmaWVyczogTW9kaWZpZXJLZXlbXSk6IGJvb2xlYW4ge1xuICBpZiAobW9kaWZpZXJzLmxlbmd0aCkge1xuICAgIHJldHVybiBtb2RpZmllcnMuc29tZShtb2RpZmllciA9PiBldmVudFttb2RpZmllcl0pO1xuICB9XG5cbiAgcmV0dXJuIGV2ZW50LmFsdEtleSB8fCBldmVudC5zaGlmdEtleSB8fCBldmVudC5jdHJsS2V5IHx8IGV2ZW50Lm1ldGFLZXk7XG59XG4iXX0=