var e=require("@angular-eslint/utils"),t=require("@typescript-eslint/experimental-utils/dist/eslint-utils"),r=require("@typescript-eslint/experimental-utils");const s=(o=e=>`https://github.com/angular-eslint/angular-eslint/blob/master/packages/eslint-plugin-template/docs/rules/${e}.md`,function({name:e,meta:r,defaultOptions:s,create:a}){return{meta:Object.assign(Object.assign({},r),{docs:Object.assign(Object.assign({},r.docs),{url:o(e)})}),defaultOptions:s,create(e){const r=t.applyDefault(s,e.options);return a(e,r)}}});var o,a=s({name:"contextual-decorator",meta:{type:"suggestion",docs:{description:"Ensures that classes use contextual decorators in its body",recommended:!1},schema:[],messages:{contextualDecorator:'Decorator out of context for "@{{classDecoratorName}}()"'}},defaultOptions:[],create:t=>({"MethodDefinition[kind=/^(get|set|method)$/], PropertyDefinition, TSParameterProperty"(r){!function(t,r){var s;if(null==(s=r.decorators)||!s.length)return;const o=e.ASTUtils.getNearestNodeFrom(r,e.ASTUtils.isClassDeclaration);if(!o)return;const a=e.ASTUtils.getAngularClassDecorator(o);if(a)for(const e of r.decorators)n(t,e,a)}(t,r)}})});function n(t,r,s){const o=e.ASTUtils.getDecoratorName(r);if(!o||!e.ASTUtils.isAngularInnerClassDecorator(o))return;const a=e.ASTUtils.ANGULAR_CLASS_DECORATOR_MAPPER.get(s);null!=a&&a.has(o)||t.report({node:r,messageId:"contextualDecorator",data:{classDecoratorName:s}})}var i=s({name:"component-class-suffix",meta:{type:"suggestion",docs:{description:'Classes decorated with @Component must have suffix "Component" (or custom) in their name. See more at https://angular.io/styleguide#style-02-03',recommended:"error"},schema:[{type:"object",properties:{suffixes:{type:"array",items:{type:"string"}}},additionalProperties:!1}],messages:{componentClassSuffix:"Component class names should end with one of these suffixes: {{suffixes}} (https://angular.io/styleguide#style-02-03)"}},defaultOptions:[{suffixes:["Component"]}],create:(t,[{suffixes:r}])=>({[e.Selectors.COMPONENT_CLASS_DECORATOR](s){const o=s.parent,a=e.ASTUtils.getClassName(o);a&&r.some(e=>a.endsWith(e))||t.report({node:o.id?o.id:o,messageId:"componentClassSuffix",data:{suffixes:e.toHumanReadableText(r)}})}})});const l=/\r\n|\r|\n/;function c(t){return e.ASTUtils.isTemplateLiteral(t)?t.quasis[0].value.raw.trim().split(l).length:e.ASTUtils.isLiteral(t)?t.raw.trim().split(l).length:0}var p=s({name:"component-max-inline-declarations",meta:{type:"suggestion",docs:{description:"Enforces a maximum number of lines in inline template, styles and animations. See more at https://angular.io/guide/styleguide#style-05-04",recommended:!1},schema:[{type:"object",properties:{template:{minimum:0,type:"number"},styles:{minimum:0,type:"number"},animations:{minimum:0,type:"number"}},additionalProperties:!1}],messages:{componentMaxInlineDeclarations:"`{{propertyType}}` has too many lines ({{lineCount}}). Maximum allowed is {{max}} (https://angular.io/guide/styleguide#style-05-04)"}},defaultOptions:[{template:3,styles:3,animations:15}],create:(t,[{template:r=3,styles:s=3,animations:o=15}])=>({[`${e.Selectors.COMPONENT_CLASS_DECORATOR} Property[key.name='template']`]({value:e}){const s=c(e);s<=r||t.report({node:e,messageId:"componentMaxInlineDeclarations",data:{lineCount:s,max:r,propertyType:"template"}})},[`${e.Selectors.COMPONENT_CLASS_DECORATOR} Property[key.name='styles']`]({value:r}){if(!e.ASTUtils.isArrayExpression(r))return;const o=r.elements.reduce((e,t)=>e+c(t),0);o<=s||t.report({node:r,messageId:"componentMaxInlineDeclarations",data:{lineCount:o,max:s,propertyType:"styles"}})},[`${e.Selectors.COMPONENT_CLASS_DECORATOR} Property[key.name='animations']`]({value:r}){if(!e.ASTUtils.isArrayExpression(r)||0===r.elements.length)return;const s=Math.max(r.loc.end.line-r.loc.start.line-2,1);s<=o||t.report({node:r,messageId:"componentMaxInlineDeclarations",data:{lineCount:s,max:o,propertyType:"animations"}})}})}),u=s({name:"component-selector",meta:{type:"suggestion",docs:{description:"Component selectors should follow given naming rules. See more at https://angular.io/guide/styleguide#style-02-07, https://angular.io/guide/styleguide#style-05-02\n      and https://angular.io/guide/styleguide#style-05-03.",recommended:!1},schema:[{type:"object",properties:{type:{oneOf:[{type:"string"},{type:"array",items:{enum:[e.SelectorUtils.OPTION_TYPE_ELEMENT,e.SelectorUtils.OPTION_TYPE_ATTRIBUTE]}}]},prefix:{oneOf:[{type:"string"},{type:"array"}]},style:{type:"string",enum:[e.ASTUtils.OPTION_STYLE_CAMEL_CASE,e.ASTUtils.OPTION_STYLE_KEBAB_CASE]}},additionalProperties:!1}],messages:{prefixFailure:"The selector should start with one of these prefixes: {{prefix}} (https://angular.io/guide/styleguide#style-02-07)",styleFailure:"The selector should be {{style}} (https://angular.io/guide/styleguide#style-05-02)",typeFailure:"The selector should be used as an {{type}} (https://angular.io/guide/styleguide#style-05-03)",shadowDomEncapsulatedStyleFailure:`The selector of a ShadowDom-encapsulated component should be \`${e.ASTUtils.OPTION_STYLE_KEBAB_CASE}\` (https://github.com/angular-eslint/angular-eslint/issues/534)`}},defaultOptions:[{type:"",prefix:"",style:""}],create:(t,[{type:s,prefix:o,style:a}])=>({[e.Selectors.COMPONENT_CLASS_DECORATOR](n){const i=e.ASTUtils.getDecoratorPropertyValue(n,"selector");if(!i)return;if(!e.SelectorUtils.checkValidOptions(s,o,a))return;const l=a!==e.ASTUtils.OPTION_STYLE_KEBAB_CASE&&function(t){const s=e.ASTUtils.getDecoratorPropertyValue(t,"encapsulation");return s&&e.ASTUtils.isMemberExpression(s)&&r.ASTUtils.isIdentifier(s.object)&&"ViewEncapsulation"===s.object.name&&r.ASTUtils.isIdentifier(s.property)&&"ShadowDom"===s.property.name}(n)?e.ASTUtils.OPTION_STYLE_KEBAB_CASE:a,c=e.SelectorUtils.checkSelector(i,s,e.arrayify(o),l);null!==c&&(c.hasExpectedType?c.hasExpectedStyle?c.hasExpectedPrefix||e.SelectorUtils.reportPrefixError(i,o,t):a===l?e.SelectorUtils.reportStyleError(i,a,t):t.report({node:i,messageId:"shadowDomEncapsulatedStyleFailure"}):e.SelectorUtils.reportTypeError(i,s,t))}})}),d=s({name:"contextual-lifecycle",meta:{type:"problem",docs:{description:"Ensures that lifecycle methods are used in a correct context",recommended:"error"},schema:[],messages:{contextualLifecycle:"Angular will not invoke the `{{methodName}}` lifecycle method within `@{{classDecoratorName}}()` classes"}},defaultOptions:[],create(t){function r({parent:r},s){const o=r,a=e.ASTUtils.ANGULAR_CLASS_DECORATOR_LIFECYCLE_METHOD_MAPPER.get(s),n=e.ASTUtils.getDeclaredMethods(o);for(const r of n){const o=e.ASTUtils.getMethodName(r);!o||!e.ASTUtils.isAngularLifecycleMethod(o)||null!=a&&a.has(o)||t.report({node:r.key,messageId:"contextualLifecycle",data:{classDecoratorName:s,methodName:o}})}}return{[e.Selectors.COMPONENT_CLASS_DECORATOR](t){r(t,e.ASTUtils.AngularClassDecorators.Component)},[e.Selectors.DIRECTIVE_CLASS_DECORATOR](t){r(t,e.ASTUtils.AngularClassDecorators.Directive)},[e.Selectors.INJECTABLE_CLASS_DECORATOR](t){r(t,e.ASTUtils.AngularClassDecorators.Injectable)},[e.Selectors.MODULE_CLASS_DECORATOR](t){r(t,e.ASTUtils.AngularClassDecorators.NgModule)},[e.Selectors.PIPE_CLASS_DECORATOR](t){r(t,e.ASTUtils.AngularClassDecorators.Pipe)}}}}),m=s({name:"directive-class-suffix",meta:{type:"suggestion",docs:{description:'Classes decorated with @Directive must have suffix "Directive" (or custom) in their name. See more at https://angular.io/styleguide#style-02-03',recommended:"error"},schema:[{type:"object",properties:{suffixes:{type:"array",items:{type:"string"}}},additionalProperties:!1}],messages:{directiveClassSuffix:"Directive class names should end with one of these suffixes: {{suffixes}} (https://angular.io/styleguide#style-02-03)"}},defaultOptions:[{suffixes:["Directive"]}],create:(t,[{suffixes:r}])=>({[e.Selectors.DIRECTIVE_CLASS_DECORATOR](s){if(!e.ASTUtils.getDecoratorPropertyValue(s,"selector"))return;const o=s.parent,a=e.ASTUtils.getClassName(o),n=e.ASTUtils.getDeclaredInterfaceNames(o).some(e=>e.endsWith("Validator")),i=r.concat(n?"Validator":[]);var l;a&&i.some(e=>a.endsWith(e))||t.report({node:null!=(l=o.id)?l:o,messageId:"directiveClassSuffix",data:{suffixes:e.toHumanReadableText(i)}})}})}),g=s({name:"directive-selector",meta:{type:"suggestion",docs:{description:"Directive selectors should follow given naming rules. See more at https://angular.io/guide/styleguide#style-02-06 and https://angular.io/guide/styleguide#style-02-08.",recommended:!1},schema:[{type:"object",properties:{type:{oneOf:[{type:"string"},{type:"array",items:{enum:[e.SelectorUtils.OPTION_TYPE_ELEMENT,e.SelectorUtils.OPTION_TYPE_ATTRIBUTE]}}]},prefix:{oneOf:[{type:"string"},{type:"array"}]},style:{type:"string",enum:[e.ASTUtils.OPTION_STYLE_CAMEL_CASE,e.ASTUtils.OPTION_STYLE_KEBAB_CASE]}},additionalProperties:!1}],messages:{prefixFailure:"The selector should start with one of these prefixes: {{prefix}} (https://angular.io/guide/styleguide#style-02-08)",styleFailure:"The selector should be {{style}} (https://angular.io/guide/styleguide#style-02-06)",typeFailure:"The selector should be used as an {{type}} (https://angular.io/guide/styleguide#style-02-06)"}},defaultOptions:[{type:"",prefix:"",style:""}],create:(t,[{type:r,prefix:s,style:o}])=>({[e.Selectors.DIRECTIVE_CLASS_DECORATOR](a){const n=e.ASTUtils.getDecoratorPropertyValue(a,"selector");if(!n)return;if(!e.SelectorUtils.checkValidOptions(r,s,o))return;const i=e.SelectorUtils.checkSelector(n,r,e.arrayify(s),o);null!==i&&(i.hasExpectedType?i.hasExpectedStyle?i.hasExpectedPrefix||e.SelectorUtils.reportPrefixError(n,s,t):e.SelectorUtils.reportStyleError(n,o,t):e.SelectorUtils.reportTypeError(n,r,t))}})}),f=s({name:"no-attribute-decorator",meta:{type:"problem",docs:{description:"The @Attribute decorator is used to obtain a single value for an attribute. This is a much less common use-case than getting a stream of values (using @Input), so often the @Attribute decorator is mistakenly used when @Input was what was intended. This rule disallows usage of @Attribute decorator altogether in order to prevent these mistakes.",recommended:!1},schema:[],messages:{noAttributeDecorator:"@Attribute can only obtain a single value and is rarely what is required. Use @Input instead to retrieve a stream of values."}},defaultOptions:[],create:e=>({'ClassDeclaration MethodDefinition[key.name="constructor"] Decorator[expression.callee.name="Attribute"]'(t){e.report({node:t,messageId:"noAttributeDecorator"})}})});const y=[e.ASTUtils.AngularLifecycleInterfaces.DoCheck,e.ASTUtils.AngularLifecycleInterfaces.OnChanges],h=[e.ASTUtils.AngularLifecycleMethods.ngDoCheck,e.ASTUtils.AngularLifecycleMethods.ngOnChanges];var T=s({name:"no-conflicting-lifecycle",meta:{type:"suggestion",docs:{description:"Ensures that directives not implement conflicting lifecycle interfaces.",recommended:"error"},schema:[],messages:{noConflictingLifecycleInterface:`Implementing ${e.ASTUtils.AngularLifecycleInterfaces.DoCheck} and ${e.ASTUtils.AngularLifecycleInterfaces.OnChanges} in a class is not recommended`,noConflictingLifecycleMethod:`Declaring ${e.ASTUtils.AngularLifecycleMethods.ngDoCheck} and ${e.ASTUtils.AngularLifecycleMethods.ngOnChanges} method in a class is not recommended`}},defaultOptions:[],create:t=>({ClassDeclaration(s){(r=>{const s=e.ASTUtils.getDeclaredAngularLifecycleInterfaces(r);if(!y.every(e=>s.includes(e)))return;const o=e.ASTUtils.getInterfaces(r).filter(t=>{const r=e.ASTUtils.getInterfaceName(t);return r&&e.ASTUtils.isAngularLifecycleInterface(r)});for(const e of o)t.report({node:e,messageId:"noConflictingLifecycleInterface"})})(s),(s=>{const o=e.ASTUtils.getDeclaredAngularLifecycleMethods(s);if(!h.every(e=>o.includes(e)))return;const a=e.ASTUtils.getDeclaredMethods(s).filter(t=>r.ASTUtils.isIdentifier(t.key)&&e.ASTUtils.isAngularLifecycleMethod(t.key.name));for(const e of a)t.report({node:e,messageId:"noConflictingLifecycleMethod"})})(s)}})}),S=s({name:"no-forward-ref",meta:{type:"suggestion",docs:{description:"Disallows usage of `forwardRef` references for DI",recommended:!1},schema:[],messages:{noForwardRef:"Avoid using `forwardRef`"}},defaultOptions:[],create:e=>({'CallExpression[callee.type="Identifier"][callee.name="forwardRef"]'(t){e.report({node:t,messageId:"noForwardRef"})}})});const A={allowStatic:!1};var x=s({name:"no-host-metadata-property",meta:{type:"suggestion",docs:{description:"Disallows usage of the `host` metadata property. See more at https://angular.io/styleguide#style-06-03",recommended:"error"},schema:[{type:"object",properties:{allowStatic:{type:"boolean",default:A.allowStatic}},additionalProperties:!1}],messages:{noHostMetadataProperty:`Use @${e.ASTUtils.AngularInnerClassDecorators.HostBinding} or @${e.ASTUtils.AngularInnerClassDecorators.HostListener} rather than the \`host\` metadata property (https://angular.io/styleguide#style-06-03)`}},defaultOptions:[A],create:(t,[{allowStatic:r}])=>({[`${e.Selectors.COMPONENT_OR_DIRECTIVE_CLASS_DECORATOR} Property[key.name="host"]`](s){(r&&e.ASTUtils.isObjectExpression(s.value)?s.value.properties.filter(O):[s]).forEach(e=>{t.report({node:e,messageId:"noHostMetadataProperty"})})}})});function O(t){return e.ASTUtils.isProperty(t)&&!function(t){return!t.computed&&(r.ASTUtils.isIdentifier(t.key)||e.ASTUtils.isStringLiteral(t.key)&&function({0:e}){return e.toLowerCase()!==e.toUpperCase()}(t.key.value))}(t)&&!function(t){return e.ASTUtils.isStringLiteral(t.value)&&""===t.value.value}(t)}var E=s({name:"no-input-prefix",meta:{type:"suggestion",docs:{description:"Ensures that input bindings, including aliases, are not named or prefixed by the configured disallowed prefixes",recommended:!1},schema:[{type:"object",properties:{prefixes:{type:"array",items:{type:"string"}}},additionalProperties:!1}],messages:{noInputPrefix:"Input bindings, including aliases, should not be named, nor prefixed by {{prefixes}}"}},defaultOptions:[{prefixes:[]}],create:(t,[{prefixes:r}])=>({[[e.Selectors.INPUTS_METADATA_PROPERTY_LITERAL,e.Selectors.INPUT_ALIAS,e.Selectors.INPUT_PROPERTY_OR_SETTER].join(",")](s){const[o,a]=e.ASTUtils.getRawText(s).replace(/\s/g,"").split(":");r.some(e=>function(e,t,r){const s=RegExp(`^${e}(([^a-z])|(?=$))`);return s.test(t)||s.test(r)}(e,o,a))&&t.report({node:s,messageId:"noInputPrefix",data:{prefixes:e.toHumanReadableText(r)}})}})}),I=s({name:"no-input-rename",meta:{type:"suggestion",docs:{description:"Ensures that input bindings are not aliased",recommended:"error"},fixable:"code",hasSuggestions:!0,schema:[{type:"object",properties:{allowedNames:{type:"array",items:{type:"string"},description:"A list with allowed input names",uniqueItems:!0}},additionalProperties:!1}],messages:{noInputRename:"Input bindings should not be aliased (https://angular.io/guide/styleguide#style-05-13)",suggestRemoveAliasName:"Remove alias name",suggestReplaceOriginalNameWithAliasName:"Remove alias name and use it as the original name"}},defaultOptions:[{allowedNames:[]}],create(t,[{allowedNames:s=[]}]){let o=new Set;const a=e.getAriaAttributeKeys();return{[e.Selectors.COMPONENT_OR_DIRECTIVE_SELECTOR_LITERAL](t){o=new Set(e.withoutBracketsAndWhitespaces(e.ASTUtils.getRawText(t)).split(","))},[e.Selectors.INPUT_ALIAS](n){const i=e.ASTUtils.getNearestNodeFrom(n,e.ASTUtils.isPropertyOrMethodDefinition);if(!i||!r.ASTUtils.isIdentifier(i.key))return;const l=e.ASTUtils.getRawText(n),c=e.ASTUtils.getRawText(i.key);s.includes(l)||a.has(l)&&c===e.kebabToCamelCase(l)||(l===c?t.report({node:n,messageId:"noInputRename",fix:e=>e.remove(n)}):C(o,c,l)||t.report({node:n,messageId:"noInputRename",suggest:[{messageId:"suggestRemoveAliasName",fix:e=>e.remove(n)},{messageId:"suggestReplaceOriginalNameWithAliasName",fix:e=>[e.remove(n),e.replaceText(i.key,l.includes("-")?`'${l}'`:l)]}]}))},[e.Selectors.INPUTS_METADATA_PROPERTY_LITERAL](r){const[n,i]=e.withoutBracketsAndWhitespaces(e.ASTUtils.getRawText(r)).split(":");!i||s.includes(i)||a.has(i)&&n===e.kebabToCamelCase(i)||(i===n?t.report({node:r,messageId:"noInputRename",fix:t=>t.replaceText(r,e.ASTUtils.getReplacementText(r,n))}):C(o,n,i)||t.report({node:r,messageId:"noInputRename",suggest:[["suggestRemoveAliasName",n],["suggestReplaceOriginalNameWithAliasName",i]].map(([t,s])=>({messageId:t,fix:t=>t.replaceText(r,e.ASTUtils.getReplacementText(r,s))}))}))},"ClassDeclaration:exit"(){o=new Set}}}});function C(t,r,s){return[...t].some(t=>t===s||function(t,r){return`${t}${e.capitalize(r)}`}(t,r)===s)}var R=s({name:"no-inputs-metadata-property",meta:{type:"suggestion",docs:{description:"Disallows usage of the `inputs` metadata property. See more at https://angular.io/styleguide#style-05-12",recommended:"error"},schema:[],messages:{noInputsMetadataProperty:"Use `@Input` rather than the `inputs` metadata property (https://angular.io/styleguide#style-05-12)"}},defaultOptions:[],create:t=>({[`${e.Selectors.COMPONENT_OR_DIRECTIVE_CLASS_DECORATOR} ${e.Selectors.metadataProperty("inputs")}`](e){t.report({node:e,messageId:"noInputsMetadataProperty"})}})}),U=s({name:"no-lifecycle-call",meta:{type:"suggestion",docs:{description:"Disallows explicit calls to lifecycle methods",recommended:!1},schema:[],messages:{noLifecycleCall:"Avoid explicit calls to lifecycle methods"}},defaultOptions:[],create:t=>({[`ClassDeclaration CallExpression > MemberExpression[property.name=${e.toPattern([...e.ASTUtils.ANGULAR_LIFECYCLE_METHODS])}]`]:s=>{const o=e.ASTUtils.getNearestNodeFrom(s,e.ASTUtils.isClassDeclaration);!o||!e.ASTUtils.getAngularClassDecorator(o)||e.ASTUtils.isSuper(s.object)&&function(t){const s=e.ASTUtils.getNearestNodeFrom(t,e.ASTUtils.isMethodDefinition);return Boolean(s&&function({property:e},{key:t}){return r.ASTUtils.isIdentifier(e)&&r.ASTUtils.isIdentifier(t)&&e.name===t.name}(t,s))}(s)||t.report({node:s.parent,messageId:"noLifecycleCall"})}})}),v=s({name:"no-output-native",meta:{type:"suggestion",docs:{description:"Ensures that output bindings, including aliases, are not named as standard DOM events",recommended:"error"},schema:[],messages:{noOutputNative:"Output bindings, including aliases, should not be named as standard DOM events"}},defaultOptions:[],create(t){const r=e.getNativeEventNames();return{[[e.Selectors.OUTPUTS_METADATA_PROPERTY_LITERAL,e.Selectors.OUTPUT_ALIAS,e.Selectors.OUTPUT_PROPERTY_OR_GETTER].join(",")](s){const[o,a]=e.ASTUtils.getRawText(s).replace(/\s/g,"").split(":");(r.has(o)||r.has(a))&&t.report({node:s,messageId:"noOutputNative"})}}}}),P=s({name:"no-output-on-prefix",meta:{type:"suggestion",docs:{description:'Ensures that output bindings, including aliases, are not named "on", nor prefixed with it. See more at https://angular.io/guide/styleguide#style-05-16',recommended:"error"},schema:[],messages:{noOutputOnPrefix:'Output bindings, including aliases, should not be named "on", nor prefixed with it (https://angular.io/guide/styleguide#style-05-16)'}},defaultOptions:[],create(t){const r=/^on(([^a-z])|(?=$))/;return{[[e.Selectors.OUTPUTS_METADATA_PROPERTY_LITERAL,e.Selectors.OUTPUT_ALIAS,e.Selectors.OUTPUT_PROPERTY_OR_GETTER].join(",")](s){const[o,a]=e.ASTUtils.getRawText(s).replace(/\s/g,"").split(":");(r.test(o)||r.test(a))&&t.report({node:s,messageId:"noOutputOnPrefix"})}}}}),b=s({name:"no-output-rename",meta:{type:"suggestion",docs:{description:"Ensures that output bindings are not aliased",recommended:"error"},fixable:"code",hasSuggestions:!0,schema:[],messages:{noOutputRename:"Output bindings should not be aliased (https://angular.io/guide/styleguide#style-05-13)",suggestRemoveAliasName:"Remove alias name",suggestReplaceOriginalNameWithAliasName:"Remove alias name and use it as the original name"}},defaultOptions:[],create(t){let s=new Set;return{[e.Selectors.COMPONENT_OR_DIRECTIVE_SELECTOR_LITERAL](t){s=new Set(e.withoutBracketsAndWhitespaces(e.ASTUtils.getRawText(t)).split(","))},[e.Selectors.OUTPUT_ALIAS](o){const a=e.ASTUtils.getNearestNodeFrom(o,e.ASTUtils.isPropertyOrMethodDefinition);if(!a||!r.ASTUtils.isIdentifier(a.key))return;const n=e.ASTUtils.getRawText(o),i=e.ASTUtils.getRawText(a.key);n===i?t.report({node:o,messageId:"noOutputRename",fix:e=>e.remove(o)}):D(s,i,n)||t.report({node:o,messageId:"noOutputRename",suggest:[{messageId:"suggestRemoveAliasName",fix:e=>e.remove(o)},{messageId:"suggestReplaceOriginalNameWithAliasName",fix:e=>[e.remove(o),e.replaceText(a.key,n.includes("-")?`'${n}'`:n)]}]})},[e.Selectors.OUTPUTS_METADATA_PROPERTY_LITERAL](r){const[o,a]=e.withoutBracketsAndWhitespaces(e.ASTUtils.getRawText(r)).split(":");a&&(a===o?t.report({node:r,messageId:"noOutputRename",fix:t=>t.replaceText(r,e.ASTUtils.getReplacementText(r,o))}):D(s,o,a)||t.report({node:r,messageId:"noOutputRename",suggest:[["suggestRemoveAliasName",o],["suggestReplaceOriginalNameWithAliasName",a]].map(([t,s])=>({messageId:t,fix:t=>t.replaceText(r,e.ASTUtils.getReplacementText(r,s))}))}))},"ClassDeclaration:exit"(){s=new Set}}}});function D(t,r,s){return[...t].some(t=>t===s||function(t,r){return`${t}${e.capitalize(r)}`}(t,r)===s)}var N=s({name:"no-outputs-metadata-property",meta:{type:"suggestion",docs:{description:"Disallows usage of the `outputs` metadata property. See more at https://angular.io/styleguide#style-05-12",recommended:"error"},schema:[],messages:{noOutputsMetadataProperty:"Use `@Output` rather than the `outputs` metadata property (https://angular.io/styleguide#style-05-12)"}},defaultOptions:[],create:t=>({[`${e.Selectors.COMPONENT_OR_DIRECTIVE_CLASS_DECORATOR} ${e.Selectors.metadataProperty("outputs")}`](e){t.report({node:e,messageId:"noOutputsMetadataProperty"})}})}),_=s({name:"no-pipe-impure",meta:{type:"suggestion",docs:{description:"Disallows the declaration of impure pipes",recommended:!1},hasSuggestions:!0,schema:[],messages:{noPipeImpure:"Impure pipes should be avoided because they are invoked on each change-detection cycle",suggestRemovePipeImpure:"Remove `pure` property"}},defaultOptions:[],create(t){const r=t.getSourceCode();return{[`${e.Selectors.PIPE_CLASS_DECORATOR} ${e.Selectors.metadataProperty("pure")}:matches([value.value=false], [value.operator='!'][value.argument.value=true])`](s){t.report({node:s,messageId:"noPipeImpure",suggest:[{messageId:"suggestRemovePipeImpure",fix:t=>e.RuleFixes.getNodeToCommaRemoveFix(r,s,t)}]})}}}}),L=s({name:"no-queries-metadata-property",meta:{type:"suggestion",docs:{description:"Disallows usage of the `queries` metadata property. See more at https://angular.io/styleguide#style-05-12.",recommended:!1},schema:[],messages:{noQueriesMetadataProperty:`Use @${e.ASTUtils.AngularInnerClassDecorators.Output} rather than the \`queries\` metadata property (https://angular.io/styleguide#style-05-12)`}},defaultOptions:[],create:t=>({[e.Selectors.COMPONENT_OR_DIRECTIVE_CLASS_DECORATOR](r){const s=e.ASTUtils.getDecoratorPropertyValue(r,"queries");s&&t.report({node:s.parent,messageId:"noQueriesMetadataProperty"})}})}),w=s({name:"no-empty-lifecycle-method",meta:{type:"suggestion",docs:{description:"Disallows declaring empty lifecycle methods",recommended:"error"},hasSuggestions:!0,schema:[],messages:{noEmptyLifecycleMethod:"Lifecycle methods should not be empty",suggestRemoveLifecycleMethod:"Remove lifecycle method"}},defaultOptions:[],create(t){const r=t.getSourceCode(),s=e.toPattern([...e.ASTUtils.ANGULAR_LIFECYCLE_METHODS]);return{[`ClassDeclaration:has(Decorator[expression.callee.name=/^(Component|Directive|Injectable|NgModule|Pipe)$/]) > ClassBody > ${e.Selectors.methodDefinition(s)}[value.body.body.length=0]`](s){t.report({node:s,messageId:"noEmptyLifecycleMethod",suggest:[{messageId:"suggestRemoveLifecycleMethod",fix:t=>{var o;const a=null!=(o=e.ASTUtils.getImportDeclarations(s,"@angular/core"))?o:[],n=e.ASTUtils.getRawText(s).replace(/^ng+/,""),i=function(e,t){return e.split(" ").filter(e=>function(e){return e.replace(/[\W]/g,"")}(e)===t).length}(r.getText(),n);return[t.remove(s),e.RuleFixes.getImplementsRemoveFix(r,s.parent.parent,n,t),i<=2?e.RuleFixes.getImportRemoveFix(r,a,n,t):null].filter(e.isNotNullOrUndefined)}}]})}}}});const M="prefer-on-push-component-change-detection",j="ChangeDetectionStrategy.OnPush";var $=s({name:M,meta:{type:"suggestion",docs:{description:`Ensures component's \`changeDetection\` is set to \`${j}\``,recommended:!1},hasSuggestions:!0,schema:[],messages:{preferOnPushComponentChangeDetection:`The component's \`changeDetection\` value should be set to \`${j}\``,suggestAddChangeDetectionOnPush:`Add \`${j}\``}},defaultOptions:[],create(t){const r=e.Selectors.metadataProperty("changeDetection");return{[[`${e.Selectors.COMPONENT_CLASS_DECORATOR}:matches([expression.arguments.length=0], [expression.arguments.0.type='ObjectExpression']:not(:has(${r})))`,`${e.Selectors.COMPONENT_CLASS_DECORATOR} > CallExpression > ObjectExpression > ${r}:matches([value.type='Identifier'][value.name='undefined'], [value.object.name='ChangeDetectionStrategy'][value.property.name!='OnPush'])`].join(",")](r){t.report({node:k(r),messageId:"preferOnPushComponentChangeDetection",suggest:[{messageId:"suggestAddChangeDetectionOnPush",fix:t=>e.ASTUtils.isProperty(r)?[e.RuleFixes.getImportAddFix({fixer:t,importName:"ChangeDetectionStrategy",moduleName:"@angular/core",node:r.parent.parent.parent.parent}),e.ASTUtils.isMemberExpression(r.value)?t.replaceText(r.value.property,"OnPush"):t.replaceText(r.value,j)].filter(e.isNotNullOrUndefined):[e.RuleFixes.getImportAddFix({fixer:t,importName:"ChangeDetectionStrategy",moduleName:"@angular/core",node:r.parent}),e.RuleFixes.getDecoratorPropertyAddFix(r,t,`changeDetection: ${j}`)].filter(e.isNotNullOrUndefined)}]})}}}});function k(t){return e.ASTUtils.isProperty(t)?e.ASTUtils.isMemberExpression(t.value)?t.value.property:t.value:t}var F=s({name:"prefer-output-readonly",meta:{type:"suggestion",docs:{description:"Prefer to declare `@Output` as `readonly` since they are not supposed to be reassigned",recommended:!1},hasSuggestions:!0,schema:[],messages:{preferOutputReadonly:"Prefer to declare `@Output` as `readonly` since they are not supposed to be reassigned",suggestAddReadonlyModifier:"Add `readonly` modifier"}},defaultOptions:[],create:t=>({[`PropertyDefinition:not([readonly]) > ${e.Selectors.OUTPUT_DECORATOR}`]({parent:{key:e}}){t.report({node:e,messageId:"preferOutputReadonly",suggest:[{messageId:"suggestAddReadonlyModifier",fix:t=>t.insertTextBefore(e,"readonly ")}]})}})});const V=/^\.\.?\/.+/;var B=s({name:"relative-url-prefix",meta:{type:"suggestion",docs:{description:"The ./ and ../ prefix is standard syntax for relative URLs; don't depend on Angular's current ability to do without that prefix. See more at https://angular.io/styleguide#style-05-04",recommended:!1},schema:[],messages:{relativeUrlPrefix:"The ./ and ../ prefix is standard syntax for relative URLs. (https://angular.io/styleguide#style-05-04)"}},defaultOptions:[],create:t=>({[`${e.Selectors.COMPONENT_CLASS_DECORATOR} Property[key.name='templateUrl']`]({value:e}){q(e)&&t.report({node:e,messageId:"relativeUrlPrefix"})},[`${e.Selectors.COMPONENT_CLASS_DECORATOR} Property[key.name='styleUrls']`]({value:r}){e.ASTUtils.isArrayExpression(r)&&r.elements.filter(q).forEach(e=>{t.report({node:e,messageId:"relativeUrlPrefix"})})}})});function q(t){return!e.ASTUtils.isStringLiteral(t)||!V.test(t.value)}var Y=s({name:"sort-ngmodule-metadata-arrays",meta:{type:"suggestion",docs:{description:"Ensures ASC alphabetical order for `NgModule` metadata arrays for easy visual scanning",recommended:!1},fixable:"code",schema:[],messages:{sortNgmoduleMetadataArrays:"`NgModule` metadata arrays should be sorted in ASC alphabetical order"}},defaultOptions:[],create:t=>({[`${e.Selectors.MODULE_CLASS_DECORATOR} Property ArrayExpression`]({elements:e}){const s=e.filter(r.ASTUtils.isIdentifier).map((e,t,r)=>[e,r[t+1]]).find(([e,t])=>t&&1===e.name.localeCompare(t.name));if(!s)return;const[o,a]=s;t.report({node:a,messageId:"sortNgmoduleMetadataArrays",fix:e=>[e.replaceText(o,a.name),e.replaceText(a,o.name)]})}})}),W=s({name:"use-component-selector",meta:{type:"suggestion",docs:{description:"Component selector must be declared",recommended:!1},schema:[],messages:{useComponentSelector:"The selector of the component is mandatory"}},defaultOptions:[],create:t=>({[e.Selectors.COMPONENT_CLASS_DECORATOR](r){const s=e.ASTUtils.getDecoratorPropertyValue(r,"selector");s&&e.ASTUtils.isStringLiteral(s)&&s.value.length||t.report({node:r,messageId:"useComponentSelector"})}})}),H=s({name:"use-component-view-encapsulation",meta:{type:"suggestion",docs:{description:"Disallows using `ViewEncapsulation.None`",recommended:!1},hasSuggestions:!0,schema:[],messages:{useComponentViewEncapsulation:"Using `ViewEncapsulation.None` makes your styles global, which may have an unintended effect",suggestRemoveViewEncapsulationNone:"Remove `ViewEncapsulation.None`"}},defaultOptions:[],create(t){const r=t.getSourceCode();return{[`${e.Selectors.COMPONENT_CLASS_DECORATOR} ${e.Selectors.metadataProperty("encapsulation")} > MemberExpression[object.name='ViewEncapsulation'] > Identifier[name='None']`](s){t.report({node:s,messageId:"useComponentViewEncapsulation",suggest:[{messageId:"suggestRemoveViewEncapsulationNone",fix:t=>{var o;const a=null!=(o=e.ASTUtils.getImportDeclarations(s,"@angular/core"))?o:[];return[e.RuleFixes.getNodeToCommaRemoveFix(r,s.parent.parent,t),e.RuleFixes.getImportRemoveFix(r,a,"ViewEncapsulation",t)].filter(e.isNotNullOrUndefined)}}]})}}}}),G=s({name:"use-injectable-provided-in",meta:{type:"suggestion",docs:{description:"Using the `providedIn` property makes `Injectables` tree-shakable",recommended:!1},hasSuggestions:!0,schema:[{type:"object",properties:{ignoreClassNamePattern:{type:"string"}},additionalProperties:!1}],messages:{useInjectableProvidedIn:"The `providedIn` property is mandatory for `Injectables`",suggestInjector:"Use `providedIn: '{{injector}}'`"}},defaultOptions:[{}],create(t,[{ignoreClassNamePattern:r}]){const s=`ClassDeclaration:not([id.name=${r}]):not(:has(TSClassImplements:matches([expression.property.name='HttpInterceptor'], [expression.name='HttpInterceptor']))) > Decorator[expression.callee.name="Injectable"]`,o=e.Selectors.metadataProperty("providedIn");return{[[`${s}:matches([expression.arguments.length=0], [expression.arguments.0.type='ObjectExpression']:not(:has(${o})))`,`${s} ${o}:matches([value.type='Identifier'][value.name='undefined'], [value.type='Literal'][value.raw='null'])`].join(",")](r){t.report({node:e.ASTUtils.isProperty(r)?r.value:r,messageId:"useInjectableProvidedIn",suggest:["any","platform","root"].map(t=>({messageId:"suggestInjector",fix:s=>{var o;return e.ASTUtils.isProperty(r)?s.replaceText(r.value,`'${t}'`):null!=(o=e.RuleFixes.getDecoratorPropertyAddFix(r,s,`providedIn: '${t}'`))?o:[]},data:{injector:t}}))})}}}}),K=s({name:"use-lifecycle-interface",meta:{type:"suggestion",docs:{description:"Ensures that classes implement lifecycle interfaces corresponding to the declared lifecycle methods. See more at https://angular.io/styleguide#style-09-01",recommended:"warn"},schema:[],messages:{useLifecycleInterface:"Lifecycle interface '{{interfaceName}}' should be implemented for method '{{methodName}}'. (https://angular.io/styleguide#style-09-01)"}},defaultOptions:[],create:t=>({[`MethodDefinition[key.name=${e.toPattern([...e.ASTUtils.ANGULAR_LIFECYCLE_METHODS])}]`]({key:r,parent:{parent:s}}){if(!e.ASTUtils.getAngularClassDecorator(s))return;const o=e.ASTUtils.getDeclaredAngularLifecycleInterfaces(s),a=r.name,n=e.ASTUtils.getLifecycleInterfaceByMethodName(a);o.includes(e.ASTUtils.AngularLifecycleInterfaces[n])||t.report({node:r,messageId:"useLifecycleInterface",data:{interfaceName:n,methodName:a}})}})}),z=s({name:"use-pipe-transform-interface",meta:{type:"suggestion",docs:{description:"Ensures that `Pipes` implement `PipeTransform` interface",recommended:"error"},fixable:"code",schema:[],messages:{usePipeTransformInterface:"Pipes should implement `PipeTransform` interface"}},defaultOptions:[],create:t=>({"ClassDeclaration:not(:has(TSClassImplements:matches([expression.name='PipeTransform'], [expression.property.name='PipeTransform']))) > Decorator[expression.callee.name='Pipe']"({parent:r}){var s;t.report({node:null!=(s=r.id)?s:r,messageId:"usePipeTransformInterface",fix:t=>{const{implementsNodeReplace:s,implementsTextReplace:o}=e.RuleFixes.getImplementsSchemaFixer(r,"PipeTransform");return[e.RuleFixes.getImportAddFix({compatibleWithTypeOnlyImport:!0,fixer:t,importName:"PipeTransform",moduleName:"@angular/core",node:r}),t.insertTextAfter(s,o)].filter(e.isNotNullOrUndefined)}})}})}),Q=s({name:"pipe-prefix",meta:{type:"suggestion",docs:{description:"Enforce consistent prefix for pipes.",recommended:!1},schema:[{type:"object",properties:{prefixes:{type:"array",items:{type:"string"},minimum:1,uniqueItems:!0}},additionalProperties:!1}],messages:{pipePrefix:"@Pipes should be prefixed by {{prefixes}}"}},defaultOptions:[{prefixes:[]}],create:(t,[{prefixes:r}])=>({[e.Selectors.PIPE_CLASS_DECORATOR](s){const o=e.ASTUtils.getDecoratorPropertyValue(s,"name");if(!o)return;if(!function(e){return Array.isArray(e)&&e.length>0}(r))return;const a=r.join("|"),n=e.SelectorUtils.SelectorValidator.prefix(a,"camelCase");let i;e.ASTUtils.isStringLiteral(o)?i=o.value:e.ASTUtils.isTemplateLiteral(o)&&o.quasis[0]&&(i=o.quasis[0].value.raw),i&&(n.apply(this,[i])||t.report({node:o,messageId:"pipePrefix",data:{prefixes:e.toHumanReadableText(r)}}))}})});module.exports={configs:{all:{extends:"./configs/base.json",rules:{"@angular-eslint/component-class-suffix":"error","@angular-eslint/component-max-inline-declarations":"error","@angular-eslint/component-selector":"error","@angular-eslint/contextual-decorator":"error","@angular-eslint/contextual-lifecycle":"error","@angular-eslint/directive-class-suffix":"error","@angular-eslint/directive-selector":"error","@angular-eslint/no-attribute-decorator":"error","@angular-eslint/no-conflicting-lifecycle":"error","@angular-eslint/no-empty-lifecycle-method":"error","@angular-eslint/no-forward-ref":"error","@angular-eslint/no-host-metadata-property":"error","@angular-eslint/no-input-prefix":"error","@angular-eslint/no-input-rename":"error","@angular-eslint/no-inputs-metadata-property":"error","@angular-eslint/no-lifecycle-call":"error","@angular-eslint/no-output-native":"error","@angular-eslint/no-output-on-prefix":"error","@angular-eslint/no-output-rename":"error","@angular-eslint/no-outputs-metadata-property":"error","@angular-eslint/no-pipe-impure":"error","@angular-eslint/no-queries-metadata-property":"error","@angular-eslint/pipe-prefix":"error","@angular-eslint/prefer-on-push-component-change-detection":"error","@angular-eslint/prefer-output-readonly":"error","@angular-eslint/relative-url-prefix":"error","@angular-eslint/sort-ngmodule-metadata-arrays":"error","@angular-eslint/use-component-selector":"error","@angular-eslint/use-component-view-encapsulation":"error","@angular-eslint/use-injectable-provided-in":"error","@angular-eslint/use-lifecycle-interface":"error","@angular-eslint/use-pipe-transform-interface":"error"}},base:{parser:"@typescript-eslint/parser",parserOptions:{ecmaVersion:2020,sourceType:"module",project:"./tsconfig.json"},plugins:["@typescript-eslint","@angular-eslint"]},recommended:{extends:"./configs/base.json",rules:{"@angular-eslint/component-class-suffix":"error","@angular-eslint/contextual-lifecycle":"error","@angular-eslint/directive-class-suffix":"error","@angular-eslint/no-conflicting-lifecycle":"error","@angular-eslint/no-empty-lifecycle-method":"error","@angular-eslint/no-host-metadata-property":"error","@angular-eslint/no-input-rename":"error","@angular-eslint/no-inputs-metadata-property":"error","@angular-eslint/no-output-native":"error","@angular-eslint/no-output-on-prefix":"error","@angular-eslint/no-output-rename":"error","@angular-eslint/no-outputs-metadata-property":"error","@angular-eslint/use-lifecycle-interface":"warn","@angular-eslint/use-pipe-transform-interface":"error"}},"recommended--extra":{extends:"./configs/base.json",rules:{"no-restricted-imports":["error",{paths:[{name:"rxjs/Rx",message:"Please import directly from 'rxjs' instead"}]}],"@typescript-eslint/member-ordering":["error",{default:["static-field","instance-field","static-method","instance-method"]}],"no-restricted-syntax":["error",{selector:'CallExpression[callee.object.name="console"][callee.property.name=/^(debug|info|time|timeEnd|trace)$/]',message:"Unexpected property on console object was called"}],"@typescript-eslint/no-inferrable-types":["error",{ignoreParameters:!0}],"@typescript-eslint/no-non-null-assertion":"error","no-fallthrough":"error"}},"ng-cli-compat":{extends:["./configs/base.json"],env:{browser:!0,es6:!0,node:!0},plugins:["eslint-plugin-import","eslint-plugin-jsdoc","eslint-plugin-prefer-arrow"],rules:{"@typescript-eslint/interface-name-prefix":"off","@typescript-eslint/explicit-member-accessibility":"off","sort-keys":"off","@angular-eslint/component-class-suffix":"error","@angular-eslint/component-selector":["error",{type:"element",prefix:"app",style:"kebab-case"}],"@angular-eslint/contextual-lifecycle":"error","@angular-eslint/directive-class-suffix":"error","@angular-eslint/directive-selector":["error",{type:"attribute",prefix:"app",style:"camelCase"}],"@angular-eslint/no-conflicting-lifecycle":"error","@angular-eslint/no-host-metadata-property":"error","@angular-eslint/no-input-rename":"error","@angular-eslint/no-inputs-metadata-property":"error","@angular-eslint/no-output-native":"error","@angular-eslint/no-output-on-prefix":"error","@angular-eslint/no-output-rename":"error","@angular-eslint/no-outputs-metadata-property":"error","@angular-eslint/use-lifecycle-interface":"error","@angular-eslint/use-pipe-transform-interface":"error","@typescript-eslint/adjacent-overload-signatures":"error","@typescript-eslint/array-type":"off","@typescript-eslint/ban-types":["error",{types:{Object:{message:"Avoid using the `Object` type. Did you mean `object`?"},Function:{message:"Avoid using the `Function` type. Prefer a specific function type, like `() => void`."},Boolean:{message:"Avoid using the `Boolean` type. Did you mean `boolean`?"},Number:{message:"Avoid using the `Number` type. Did you mean `number`?"},String:{message:"Avoid using the `String` type. Did you mean `string`?"},Symbol:{message:"Avoid using the `Symbol` type. Did you mean `symbol`?"}}}],"@typescript-eslint/consistent-type-assertions":"error","@typescript-eslint/dot-notation":"error","@typescript-eslint/member-ordering":"error","@typescript-eslint/naming-convention":"error","@typescript-eslint/no-empty-function":"off","@typescript-eslint/no-empty-interface":"error","@typescript-eslint/no-explicit-any":"off","@typescript-eslint/no-inferrable-types":["error",{ignoreParameters:!0}],"@typescript-eslint/no-misused-new":"error","@typescript-eslint/no-namespace":"error","@typescript-eslint/no-non-null-assertion":"error","@typescript-eslint/no-parameter-properties":"off","@typescript-eslint/no-unused-expressions":"error","@typescript-eslint/no-use-before-define":"off","@typescript-eslint/no-var-requires":"off","@typescript-eslint/prefer-for-of":"error","@typescript-eslint/prefer-function-type":"error","@typescript-eslint/prefer-namespace-keyword":"error","@typescript-eslint/triple-slash-reference":["error",{path:"always",types:"prefer-import",lib:"always"}],"@typescript-eslint/unified-signatures":"error",complexity:"off","constructor-super":"error",eqeqeq:["error","smart"],"guard-for-in":"error","id-blacklist":["error","any","Number","number","String","string","Boolean","boolean","Undefined","undefined"],"id-match":"error","import/no-deprecated":"warn","jsdoc/newline-after-description":"error","jsdoc/no-types":"error","max-classes-per-file":"off","no-bitwise":"error","no-caller":"error","no-cond-assign":"error","no-console":["error",{allow:["log","warn","dir","timeLog","assert","clear","count","countReset","group","groupEnd","table","dirxml","error","groupCollapsed","Console","profile","profileEnd","timeStamp","context"]}],"no-debugger":"error","no-empty":"off","no-eval":"error","no-fallthrough":"error","no-invalid-this":"off","no-new-wrappers":"error","no-restricted-imports":["error",{name:"rxjs/Rx",message:"Please import directly from 'rxjs' instead"}],"@typescript-eslint/no-shadow":["error",{hoist:"all"}],"no-throw-literal":"error","no-undef-init":"error","no-underscore-dangle":"error","no-unsafe-finally":"error","no-unused-labels":"error","no-var":"error","object-shorthand":"error","one-var":["error","never"],"prefer-arrow/prefer-arrow-functions":"error","prefer-const":"error",radix:"error","use-isnan":"error","valid-typeof":"off"}},"ng-cli-compat--formatting-add-on":{plugins:["eslint-plugin-jsdoc"],rules:{"arrow-body-style":"error","arrow-parens":"off","comma-dangle":"off",curly:"error","eol-last":"error","jsdoc/check-alignment":"error","max-len":["error",{code:140}],"new-parens":"error","no-multiple-empty-lines":"off","no-trailing-spaces":"error","quote-props":["error","as-needed"],"space-before-function-paren":["error",{anonymous:"never",asyncArrow:"always",named:"never"}],"@typescript-eslint/member-delimiter-style":["error",{multiline:{delimiter:"semi",requireLast:!0},singleline:{delimiter:"semi",requireLast:!1}}],quotes:"off","@typescript-eslint/quotes":["error","single",{allowTemplateLiterals:!0}],"@typescript-eslint/semi":["error","always"],"@typescript-eslint/type-annotation-spacing":"error"}}},rules:{"contextual-decorator":a,"component-class-suffix":i,"component-max-inline-declarations":p,"component-selector":u,"contextual-lifecycle":d,"directive-class-suffix":m,"directive-selector":g,"no-attribute-decorator":f,"no-conflicting-lifecycle":T,"no-forward-ref":S,"no-host-metadata-property":x,"no-input-prefix":E,"no-input-rename":I,"no-inputs-metadata-property":R,"no-lifecycle-call":U,"no-output-native":v,"no-output-on-prefix":P,"no-output-rename":b,"no-outputs-metadata-property":N,"no-pipe-impure":_,"no-queries-metadata-property":L,"no-empty-lifecycle-method":w,[M]:$,"prefer-output-readonly":F,"relative-url-prefix":B,"sort-ngmodule-metadata-arrays":Y,"use-component-selector":W,"use-component-view-encapsulation":H,"use-injectable-provided-in":G,"use-lifecycle-interface":K,"use-pipe-transform-interface":z,"pipe-prefix":Q}};
