"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestProjectHost = void 0;
const core_1 = require("@angular-devkit/core");
const node_1 = require("@angular-devkit/core/node");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
/**
 * @deprecated
 */
class TestProjectHost extends node_1.NodeJsSyncHost {
    constructor(_templateRoot) {
        super();
        this._templateRoot = _templateRoot;
        this._currentRoot = null;
        this._scopedSyncHost = null;
    }
    root() {
        if (this._currentRoot === null) {
            throw new Error('TestProjectHost must be initialized before being used.');
        }
        return this._currentRoot;
    }
    scopedSync() {
        if (this._currentRoot === null || this._scopedSyncHost === null) {
            throw new Error('TestProjectHost must be initialized before being used.');
        }
        return this._scopedSyncHost;
    }
    initialize() {
        const recursiveList = (path) => this.list(path).pipe(
        // Emit each fragment individually.
        (0, operators_1.concatMap)((fragments) => (0, rxjs_1.from)(fragments)), 
        // Join the path with fragment.
        (0, operators_1.map)((fragment) => (0, core_1.join)(path, fragment)), 
        // Emit directory content paths instead of the directory path.
        (0, operators_1.mergeMap)((path) => this.isDirectory(path).pipe((0, operators_1.concatMap)((isDir) => (isDir ? recursiveList(path) : (0, rxjs_1.of)(path))))));
        // Find a unique folder that we can write to to use as current root.
        return this.findUniqueFolderPath().pipe(
        // Save the path and create a scoped host for it.
        (0, operators_1.tap)((newFolderPath) => {
            this._currentRoot = newFolderPath;
            this._scopedSyncHost = new core_1.virtualFs.SyncDelegateHost(new core_1.virtualFs.ScopedHost(this, this.root()));
        }), 
        // List all files in root.
        (0, operators_1.concatMap)(() => recursiveList(this._templateRoot)), 
        // Copy them over to the current root.
        (0, operators_1.concatMap)((from) => {
            const to = (0, core_1.join)(this.root(), (0, core_1.relative)(this._templateRoot, from));
            return this.read(from).pipe((0, operators_1.concatMap)((buffer) => this.write(to, buffer)));
        }), (0, operators_1.map)(() => { }));
    }
    restore() {
        if (this._currentRoot === null) {
            return rxjs_1.EMPTY;
        }
        // Delete the current root and clear the variables.
        // Wait 50ms and retry up to 10 times, to give time for file locks to clear.
        return this.exists(this.root()).pipe((0, operators_1.delay)(50), (0, operators_1.concatMap)((exists) => (exists ? this.delete(this.root()) : rxjs_1.EMPTY)), (0, operators_1.retry)(10), (0, operators_1.finalize)(() => {
            this._currentRoot = null;
            this._scopedSyncHost = null;
        }));
    }
    writeMultipleFiles(files) {
        Object.keys(files).forEach((fileName) => {
            let content = files[fileName];
            if (typeof content == 'string') {
                content = core_1.virtualFs.stringToFileBuffer(content);
            }
            else if (content instanceof Buffer) {
                content = content.buffer.slice(content.byteOffset, content.byteOffset + content.byteLength);
            }
            this.scopedSync().write((0, core_1.normalize)(fileName), content);
        });
    }
    replaceInFile(path, match, replacement) {
        const content = core_1.virtualFs.fileBufferToString(this.scopedSync().read((0, core_1.normalize)(path)));
        this.scopedSync().write((0, core_1.normalize)(path), core_1.virtualFs.stringToFileBuffer(content.replace(match, replacement)));
    }
    appendToFile(path, str) {
        const content = core_1.virtualFs.fileBufferToString(this.scopedSync().read((0, core_1.normalize)(path)));
        this.scopedSync().write((0, core_1.normalize)(path), core_1.virtualFs.stringToFileBuffer(content.concat(str)));
    }
    fileMatchExists(dir, regex) {
        const [fileName] = this.scopedSync()
            .list((0, core_1.normalize)(dir))
            .filter((name) => name.match(regex));
        return fileName || undefined;
    }
    copyFile(from, to) {
        const content = this.scopedSync().read((0, core_1.normalize)(from));
        this.scopedSync().write((0, core_1.normalize)(to), content);
    }
    findUniqueFolderPath() {
        // 11 character alphanumeric string.
        const randomString = Math.random().toString(36).slice(2);
        const newFolderName = `test-project-host-${(0, core_1.basename)(this._templateRoot)}-${randomString}`;
        const newFolderPath = (0, core_1.join)((0, core_1.dirname)(this._templateRoot), newFolderName);
        return this.exists(newFolderPath).pipe((0, operators_1.concatMap)((exists) => (exists ? this.findUniqueFolderPath() : (0, rxjs_1.of)(newFolderPath))));
    }
}
exports.TestProjectHost = TestProjectHost;
//# sourceMappingURL=data:application/json;base64,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