"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BuilderVersionSymbol = exports.BuilderSymbol = void 0;
// Internal types that should not be exported directly. These are used by the host and architect
// itself. Host implementations should import the host.ts file.
/**
 * BuilderSymbol used for knowing if a function was created using createBuilder(). This is a
 * property set on the function that should be `true`.
 * Using Symbol.for() as it's a global registry that's the same for all installations of
 * Architect (if some libraries depends directly on architect instead of sharing the files).
 */
exports.BuilderSymbol = Symbol.for('@angular-devkit/architect:builder');
/**
 * BuilderVersionSymbol used for knowing which version of the library createBuilder() came from.
 * This is to make sure we don't try to use an incompatible builder.
 * Using Symbol.for() as it's a global registry that's the same for all installations of
 * Architect (if some libraries depends directly on architect instead of sharing the files).
 */
exports.BuilderVersionSymbol = Symbol.for('@angular-devkit/architect:version');
//# sourceMappingURL=data:application/json;base64,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