(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_collections_collections_module_ts"],{

/***/ 206:
/*!*****************************************************************!*\
  !*** ./src/app/pages/collections/collections-routing.module.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CollectionsPageRoutingModule": () => (/* binding */ CollectionsPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 60124);
/* harmony import */ var _collections_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./collections.page */ 50012);




const routes = [{
  path: '',
  component: _collections_page__WEBPACK_IMPORTED_MODULE_0__.CollectionsPage
}];
let CollectionsPageRoutingModule = class CollectionsPageRoutingModule {};
CollectionsPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], CollectionsPageRoutingModule);


/***/ }),

/***/ 45997:
/*!*********************************************************!*\
  !*** ./src/app/pages/collections/collections.module.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CollectionsPageModule": () => (/* binding */ CollectionsPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 94666);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 2508);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _collections_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./collections-routing.module */ 206);
/* harmony import */ var _collections_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./collections.page */ 50012);
/* harmony import */ var src_app_pipes_pipes_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/pipes/pipes.module */ 35503);
/* harmony import */ var src_app_components_components_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/components/components.module */ 45642);









let CollectionsPageModule = class CollectionsPageModule {};
CollectionsPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_8__.IonicModule, _collections_routing_module__WEBPACK_IMPORTED_MODULE_0__.CollectionsPageRoutingModule, src_app_pipes_pipes_module__WEBPACK_IMPORTED_MODULE_2__.PipesModule, src_app_components_components_module__WEBPACK_IMPORTED_MODULE_3__.ComponentsModule],
  declarations: [_collections_page__WEBPACK_IMPORTED_MODULE_1__.CollectionsPage]
})], CollectionsPageModule);


/***/ }),

/***/ 50012:
/*!*******************************************************!*\
  !*** ./src/app/pages/collections/collections.page.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CollectionsPage": () => (/* binding */ CollectionsPage)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _collections_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./collections.page.html?ngResource */ 15712);
/* harmony import */ var _collections_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./collections.page.scss?ngResource */ 77657);
/* harmony import */ var _collections_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_collections_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var src_app_components_add_collection_add_collection_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/components/add-collection/add-collection.component */ 78555);
/* harmony import */ var src_app_components_collection_feeds_modal_collection_feeds_modal_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/components/collection-feeds-modal/collection-feeds-modal.component */ 97014);
/* harmony import */ var src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/services/storage/storage.service */ 86578);

var _class;








let CollectionsPage = (_class = class CollectionsPage {
  constructor(storageService, modalCtrl, alertCtrl) {
    this.storageService = storageService;
    this.modalCtrl = modalCtrl;
    this.alertCtrl = alertCtrl;
    this.reorder = false;
  }
  ionViewWillEnter() {
    this.loadCollections();
  }
  loadCollections() {
    var _this = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.collections = yield _this.storageService.getCollections();
    })();
  }
  createCollection() {
    var _this2 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const modal = yield _this2.modalCtrl.create({
        component: src_app_components_add_collection_add_collection_component__WEBPACK_IMPORTED_MODULE_3__.AddCollectionComponent,
        cssClass: 'add-collection-modal'
      });
      modal.onDidDismiss().then(data => {
        if (data.data?.collection) {
          _this2.collections.push(data.data.collection);
        }
      });
      yield modal.present();
    })();
  }
  editCollection(collection) {
    var _this3 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const modal = yield _this3.modalCtrl.create({
        component: src_app_components_add_collection_add_collection_component__WEBPACK_IMPORTED_MODULE_3__.AddCollectionComponent,
        cssClass: 'add-collection-modal',
        componentProps: {
          collection
        }
      });
      modal.onDidDismiss().then(data => {
        if (data.data?.collection) {
          _this3.collections = _this3.collections.map(collection => {
            if (collection.id === data.data.collection.id) {
              return data.data.collection;
            }
            return collection;
          });
        }
      });
      yield modal.present();
    })();
  }
  confirmDeleteCollection(collection) {
    var _this4 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const alert = yield _this4.alertCtrl.create({
        header: 'Delete collection',
        message: `Are you sure you want to delete the collection "${collection.name}"?`,
        buttons: [{
          text: 'Cancel',
          role: 'cancel'
        }, {
          text: 'Delete',
          cssClass: 'alert-danger-button',
          handler: () => {
            _this4.deleteCollection(collection);
          }
        }]
      });
      yield alert.present();
    })();
  }
  deleteCollection(collection) {
    var _this5 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Cleanup collection feed cache
      const feedIds = collection.feedList.map(feedId => feedId.feedId);
      feedIds.forEach( /*#__PURE__*/function () {
        var _ref = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (feedId) {
          yield _this5.storageService.deleteCacheByFeedId(feedId);
        });
        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
      // Remove collection from storage
      _this5.collections = _this5.collections.filter(currentCollection => {
        if (currentCollection.id !== collection.id) return currentCollection;
      });
      yield _this5.storageService.deleteCollection(collection);
      // Fix collection indexes
      _this5.collections.forEach((collection, index) => {
        collection.index = index;
      });
      _this5.storageService.setCollections(_this5.collections);
    })();
  }
  openCollectionFeeds(collection) {
    var _this6 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const modal = yield _this6.modalCtrl.create({
        component: src_app_components_collection_feeds_modal_collection_feeds_modal_component__WEBPACK_IMPORTED_MODULE_4__.CollectionFeedsModalComponent,
        componentProps: {
          collection
        }
      });
      yield modal.present();
    })();
  }
  startReorder() {
    this.reorder = true;
  }
  endReorder() {
    this.reorder = false;
    this.collections = this.collections.map((collection, index) => {
      collection.index = index;
      return collection;
    });
    this.storageService.setCollections(this.collections);
  }
  drop(event) {
    const itemMove = this.collections.splice(event.detail.from, 1)[0];
    this.collections.splice(event.detail.to, 0, itemMove);
    event.target.complete();
  }
}, _class.ctorParameters = () => [{
  type: src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_5__.StorageService
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.ModalController
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.AlertController
}], _class);
CollectionsPage = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
  selector: 'app-collections',
  template: _collections_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_collections_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], CollectionsPage);


/***/ }),

/***/ 77657:
/*!********************************************************************!*\
  !*** ./src/app/pages/collections/collections.page.scss?ngResource ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 49579);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 60931);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".main-toolbar {\n  --background: var(--main-toolbar-background);\n}\n.main-toolbar ion-button {\n  color: var(--fixed-light);\n}\n.main-toolbar ion-back-button {\n  color: var(--fixed-light);\n}", "",{"version":3,"sources":["webpack://./src/app/pages/collections/collections.page.scss"],"names":[],"mappings":"AAAA;EACE,4CAAA;AACF;AAAE;EACE,yBAAA;AAEJ;AAAE;EACE,yBAAA;AAEJ","sourcesContent":[".main-toolbar {\n  --background: var(--main-toolbar-background);\n  ion-button {\n    color: var(--fixed-light)\n  }\n  ion-back-button {\n    color: var(--fixed-light)\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 15712:
/*!********************************************************************!*\
  !*** ./src/app/pages/collections/collections.page.html?ngResource ***!
  \********************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar class=\"main-toolbar\">\n    <ion-buttons slot=\"start\">\n      <ion-back-button defaultHref=\"/\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>\n      <span class=\"font-bold text-white drop-shadow-sm\">Manage collections</span>\n    </ion-title>\n    <ion-buttons slot=\"end\">\n      <ion-button (click)=\"createCollection()\">\n        <ion-label>Add</ion-label>\n        <ion-icon slot=\"end\" name=\"add-circle-outline\"></ion-icon>\n      </ion-button>\n    </ion-buttons>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n\n  <ion-list-header mode=\"ios\" class=\"mt-1\">\n    <ion-label>\n      Collections\n    </ion-label>\n    <ion-button (click)=\"startReorder()\" *ngIf=\"!reorder && collections && collections.length > 1\">\n      Reorder\n    </ion-button>\n    <ion-button (click)=\"endReorder()\" *ngIf=\"reorder && collections && collections.length > 1\">\n      Save order\n    </ion-button>\n  </ion-list-header>\n\n  <div class=\"pt-1 mb-20\" *ngIf=\"collections && collections.length > 0\">\n    <ion-reorder-group [disabled]=\"!reorder\" (ionItemReorder)=\"drop($event)\">\n      <ion-item *ngFor=\"let collection of (collections | orderByIndex)\" lines=\"full\">\n        <ion-icon name=\"file-tray-full\" slot=\"start\" *ngIf=\"!reorder\"></ion-icon>\n        <ion-reorder slot=\"start\"></ion-reorder>\n        <ion-label>\n          <h2>{{ collection.name }}</h2>\n          <p>\n            {{ collection.description }}\n            <span class=\"italic font-light opacity-70\" *ngIf=\"!collection.description\">No description</span>\n          </p>\n        </ion-label>\n        <ion-button slot=\"end\" color=\"dark\" fill=\"clear\" (click)=\"openCollectionFeeds(collection)\">\n          <ion-icon class=\"py-1\" slot=\"icon-only\" name=\"cog-outline\"></ion-icon>\n        </ion-button>\n        <ion-button slot=\"end\" color=\"dark\" fill=\"clear\" (click)=\"editCollection(collection)\">\n          <ion-icon class=\"py-1\" slot=\"icon-only\" name=\"create-outline\"></ion-icon>\n        </ion-button>\n        <ion-button slot=\"end\" color=\"danger\" fill=\"clear\" (click)=\"confirmDeleteCollection(collection)\">\n          <ion-icon class=\"py-1\" slot=\"icon-only\" name=\"trash\"></ion-icon>\n        </ion-button>\n      </ion-item>\n    </ion-reorder-group>\n  </div>\n\n  <!-- Empty state -->\n  <div class=\"w-full\"\n    *ngIf=\"collections && collections?.length === 0\">\n    <div class=\"mt-20 px-6 w-full flex items-center justify-center\">\n      <div class=\"w-fit h-fit\">\n        <img src=\"assets/images/undraw_list.svg\" class=\"w-1/2 m-auto\">\n        <div class=\"text-center mt-10\">\n          <p class=\"text-2xl font-semibold\">You don’t have any collections</p>\n          <p>¿Why don’t you add one?</p>\n          <ion-button fill=\"outline\" color=\"primary\" class=\"mt-6\" (click)=\"createCollection()\">\n            Add collection\n            <ion-icon slot=\"end\" name=\"add-circle-outline\"></ion-icon>\n          </ion-button>\n        </div>\n      </div>\n    </div>\n  </div>\n\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_collections_collections_module_ts.js.map