package com.DartChecker;

import android.app.AlertDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.Toast;
import java.util.ArrayList;


public class playerlist extends AppCompatActivity implements viewadapter.ItemClickListener {

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(dc_modules.updateBaseContextLocale(base));
    }

    private viewadapter adapter;
    private int actualPosition = -1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (MainActivity.themeSelected && MainActivity.subDesignChoice) setTheme(R.style.AppThemeBlack);
        else if (MainActivity.themeSelected) setTheme(R.style.AppThemeDark);
        else setTheme(R.style.Theme_AppCompat_Light_NoActionBar);
        setContentView(R.layout.activity_playerlist);
        SharedPreferences settings = getSharedPreferences("preferences",0);
        ConstraintLayout main = findViewById(R.id.cl);
        if (settings.contains("keepscreenonmenu")) main.setKeepScreenOn(settings.getBoolean("keepscreenonmenu",false));
        final ArrayList<String> playernames = new ArrayList<>();
        // load playernames
        MainActivity.player nextPlayer;
        for (int i = 0; i < MainActivity.allPlayers.size(); i++) {
            nextPlayer = MainActivity.allPlayers.get(i);
            playernames.add(nextPlayer.playerName);
        }
        RecyclerView recyclerView = findViewById(R.id.rvAnimals);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        adapter = new viewadapter(this, playernames);
        adapter.setClickListener(this);
        recyclerView.setAdapter(adapter);
        final ImageButton playerAddButton = findViewById(R.id.addbutton);
        final EditText input = findViewById(R.id.eingab);
        // refresh list with userinput
        input.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_DONE) {
                input.setVisibility(View.INVISIBLE);
                // hide keyboard
                InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                assert imm != null;
                imm.hideSoftInputFromWindow(input.getWindowToken(), 0);
                // overwrite playername
                String newName = input.getText().toString();
                if (actualPosition != -1) {
                    if (playernames.contains(newName) && playernames.get(actualPosition).equals(newName)) {
                        Toast.makeText(playerlist.this, String.format(getResources().getString(R.string.remainsUnchanged), newName), Toast.LENGTH_SHORT).show();
                        actualPosition = -1;
                        return false;
                    } else {
                        if (playernames.contains(newName)) {
                            Toast.makeText(playerlist.this, String.format(getResources().getString(R.string.exists), newName), Toast.LENGTH_SHORT).show();
                            actualPosition = -1;
                            return false;
                        }

                    }
                    if (newName.isEmpty())
                    {
                        String dummy2 = MainActivity.allPlayers.get(actualPosition).playerName;
                        AlertDialog alertDialog = new AlertDialog.Builder(playerlist.this).create();
                        alertDialog.setTitle(getResources().getString(R.string.caution));
                        alertDialog.setMessage(String.format(getResources().getString(R.string.reallyDelete), dummy2));
                        alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.ok),
                                (dialog, which) -> {
                                    // delete player completly
                                    MainActivity.allPlayers.remove(actualPosition);
                                    playernames.remove(actualPosition);
                                    adapter.notifyItemRemoved(actualPosition);
                                    dialog.dismiss();
                                    actualPosition = -1;
                                });
                        alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.cancel), (dialog, which) -> {
                            dialog.dismiss();
                            actualPosition = -1;
                        });
                        alertDialog.show();
                    } else {
                        // refresh memory
                        MainActivity.allPlayers.get(actualPosition).playerName = newName;
                        // refresh display of playerlist
                        playernames.set(actualPosition, newName);
                        adapter.notifyItemChanged(actualPosition);
                        actualPosition = -1;
                    }
                }
                else if (newName.isEmpty()) {
                    Toast.makeText(playerlist.this, getResources().getString(R.string.noPlayerAdded), Toast.LENGTH_SHORT).show();
                    return false;
                }
                // add new player
                else {
                    if (playernames.contains(newName)) {
                        Toast.makeText(playerlist.this, String.format(getResources().getString(R.string.exists), newName), Toast.LENGTH_SHORT).show();
                        actualPosition = -1;
                        return false;
                    }
                    MainActivity.player dummyPlayer = new MainActivity.player();
                    dummyPlayer.playerName = newName;
                    MainActivity.allPlayers.add(dummyPlayer);
                    playernames.add(newName);
                    //adapter.notifyItemInserted(playernames.lastIndexOf(newName));
                }
                adapter.notifyDataSetChanged();
                return true;
            }
            return false;
        });
        // playername-edit-mode/-add-mode
        playerAddButton.setOnClickListener(v -> {
            if (input.getVisibility() == View.INVISIBLE) {
                input.setText("");
                input.setVisibility(View.VISIBLE);
                // display keyboard
                if (input.requestFocus()) {
                    InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                    assert imm != null;
                    imm.showSoftInput(input, InputMethodManager.SHOW_FORCED);
                }
            }
        });
        final Button ok = findViewById(R.id.okb2);
        ok.setOnClickListener(v -> onBackPressed());
    }


    @Override
    public void onItemClick(int position) {
        final EditText input = findViewById(R.id.eingab);
        if (input.getVisibility() == View.INVISIBLE) {
            actualPosition = position;
            input.setText(adapter.getItem(position));
            input.setVisibility(View.VISIBLE);
            if (input.requestFocus()) {
                InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                assert imm != null;
                imm.showSoftInput(input, InputMethodManager.SHOW_FORCED);
            }
        } else {
            InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            assert imm != null;
            imm.showSoftInput(input, InputMethodManager.SHOW_FORCED);
        }
    }


    public void onBackPressed() {
        final EditText input = findViewById(R.id.eingab);
        if (input.getVisibility() == View.VISIBLE) {
            input.setVisibility(View.INVISIBLE);
            actualPosition = -1;
        } else {
            MainActivity.saveAllDataToDisk(this,false);
            finish();
        }
    }
}