package com.DartChecker;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;

public class dc_modules {

    public static final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
    public static final DecimalFormat formater = new DecimalFormat("###.##", symbols);

    public static Context updateBaseContextLocale(Context context) {
        final SharedPreferences settings = context.getSharedPreferences("preferences", 0);
        String language = Locale.getDefault().getLanguage();
        if (settings.contains("language")) {
            language = settings.getString("language", "en");
        }
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        return updateResourcesLocale(context, locale);
    }

    @TargetApi(Build.VERSION_CODES.N_MR1)
    public static Context updateResourcesLocale(Context context, Locale locale) {
        Configuration configuration = new Configuration(context.getResources().getConfiguration());
        configuration.setLocale(locale);
        return context.createConfigurationContext(configuration);
    }

    public static Context updateResourcesLocaleLegacy(Context context, Locale locale) {
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale;
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
        return context;
    }


    // this models a single dart throw
    public static class dart implements Serializable {
        int
                segment,
                factor,
                scoreToAdd,
                playerIndex;
    }

    public static ArrayList<MainActivity.player> migrateSavedData(ArrayList<MainActivity.spieler> oldList) {
        ArrayList<MainActivity.player> returnList = new ArrayList<>();
        MainActivity.spieler oldPlayer;
        for (int i=0; i < oldList.size(); i++) {
            oldPlayer = oldList.get(i);
            MainActivity.player player = new MainActivity.player();
            player.playerName = oldPlayer.spielerName;
            player.average = oldPlayer.durchschnitt;
            player.bestHit = oldPlayer.besterWurf;
            player.secondBestHit = oldPlayer.zweitbesterWurf;
            player.checkoutMax = oldPlayer.checkoutmax;
            player.above60 = oldPlayer.anzahluber60;
            player.above100 = oldPlayer.anzahluber100;
            player.above140 = oldPlayer.anzahluber140;
            player.amount180 = oldPlayer.anzahl180;
            player.dartsThrown = oldPlayer.geworfenePfeile;
            player.matchesLost = oldPlayer.matcheslost;
            player.matchesWon = oldPlayer.matcheswon;
            player.matchVictories = oldPlayer.anzahlSiege;
            player.overallMatches = oldPlayer.AnzahlSpiele;
            player.singleMatches = oldPlayer.AnzahlEinzelspiele;
            returnList.add(player);
        }
        return returnList;
    }

    // saves player data to statistic
    public static void savePlayerData(Context ctx, int playerCount, MainActivity.player player, boolean winner) {
        MainActivity.player rdummy;
        // find position(index) from player
        int i, z, y = -1;
        z = MainActivity.allPlayers.size();
        for (i = 0; i < z; i++) {
            if (MainActivity.allPlayers.get(i).playerName.equals(player.playerName)) y = i;
        }
        if (y == -1) {
            Toast.makeText(ctx, ctx.getResources().getString(R.string.errorSaving) + player.playerName + ctx.getResources().getString(R.string.errorNameNotFound), Toast.LENGTH_LONG).show();
            return;
        }
        rdummy = MainActivity.allPlayers.get(y);
        rdummy.overallMatches++;
        if (playerCount == 1) rdummy.singleMatches++;
        rdummy.dartsThrown += player.dartsThrown;
        if (rdummy.overallMatches > 1)   // don't divide by zero
            rdummy.average = (((rdummy.average * (rdummy.overallMatches - 1)) + player.average) / rdummy.overallMatches);
        else
            rdummy.average = player.average;
        rdummy.amount180 += player.amount180;
        rdummy.above60 += player.above60;
        rdummy.above100 += player.above100;
        rdummy.above140 += player.above140;
        if (rdummy.bestHit < player.bestHit) rdummy.bestHit = player.bestHit;
        if (winner && (playerCount > 1)) rdummy.matchVictories++;
        if (rdummy.checkoutMax < player.checkoutMax) rdummy.checkoutMax = player.checkoutMax;
        rdummy.matchesLost += player.matchesLost;
        rdummy.matchesWon += player.matchesWon;
        MainActivity.allPlayers.set(y, rdummy);
    }

    // saves leg results for the end of match statistic in another player object
    public static void transferPlayerData(MainActivity.player sourcePlayer, MainActivity.player destinationPlayer, int legsPlayed) {
        destinationPlayer.overallMatches += sourcePlayer.overallMatches;
        destinationPlayer.amount180 += sourcePlayer.amount180;
        destinationPlayer.above60 += sourcePlayer.above60;
        destinationPlayer.above100 += sourcePlayer.above100;
        destinationPlayer.above140 += sourcePlayer.above140;
        destinationPlayer.dartsThrown += sourcePlayer.dartsThrown;
        if (legsPlayed > 1)
            destinationPlayer.average = (((destinationPlayer.average * (legsPlayed - 1)) + sourcePlayer.average) / legsPlayed);
        else destinationPlayer.average = sourcePlayer.average;
        if (destinationPlayer.bestHit < sourcePlayer.bestHit) destinationPlayer.bestHit = sourcePlayer.bestHit;
        if (destinationPlayer.sets != sourcePlayer.sets) destinationPlayer.sets = sourcePlayer.sets;
        if (sourcePlayer.checkoutMax > destinationPlayer.checkoutMax) destinationPlayer.checkoutMax = sourcePlayer.checkoutMax;
        destinationPlayer.matchesLost = sourcePlayer.matchesLost;
        destinationPlayer.matchesWon = sourcePlayer.matchesWon;
        destinationPlayer.legswon = sourcePlayer.legswon;
    }

    // argument player1 must be the winner, player2 may not
    public static void Finish_LegFinished(Activity activity,  int playerCount, long startTime, MainActivity.player player1, MainActivity.player player2, MainActivity.player s11, MainActivity.player s22, Boolean suddenDeath){
        Intent intent = new Intent(activity, endofgame.class);
        intent.putExtra("playercount", playerCount);
        intent.putExtra("match", true);
        long gameDuration = (System.currentTimeMillis()-startTime)/1000;
        intent.putExtra("first", s11.playerName);
        intent.putExtra("firstAverage", s11.average);
        intent.putExtra("firstdarts", s11.dartsThrown);
        intent.putExtra("first180", s11.amount180);
        intent.putExtra("first140", s11.above140);
        intent.putExtra("first100", s11.above100);
        intent.putExtra("first60", s11.above60);
        intent.putExtra("firstCheckout", s11.checkoutMax);
        intent.putExtra("firstBestHit", s11.bestHit);
        intent.putExtra("firstSets", s11.sets);
        intent.putExtra("firstLegs", s11.legswon);
        intent.putExtra("second", s22.playerName);
        intent.putExtra("secondAverage", s22.average);
        intent.putExtra("seconddarts", s22.dartsThrown);
        intent.putExtra("second180", s22.amount180);
        intent.putExtra("second140", s22.above140);
        intent.putExtra("second100", s22.above100);
        intent.putExtra("second60", s22.above60);
        intent.putExtra("secondCheckout", s22.checkoutMax);
        intent.putExtra("secondBestHit", s22.bestHit);
        intent.putExtra("secondSets", s22.sets);
        intent.putExtra("secondLegs", s22.legswon);
        intent.putExtra("gameDuration",gameDuration);
        // save lost and won matches
        MainActivity.player rdummy;
        // get player position (index)
        int i, z, y = -1;
        z = MainActivity.allPlayers.size();
        for (i = 0; i < z; i++) {
            if (MainActivity.allPlayers.get(i).playerName.equals(player1.playerName))
                y = i;
        }
        if (y == -1) {
            Toast.makeText(activity, activity.getResources().getString(R.string.errorSaving) + player1.playerName + activity.getResources().getString(R.string.errorNameNotFound), Toast.LENGTH_LONG).show();
            return;
        }
        rdummy = MainActivity.allPlayers.get(y);
        rdummy.matchesWon++;
        MainActivity.allPlayers.set(y, rdummy);
        y = -1;
        for (i = 0; i < z; i++) {
            if (MainActivity.allPlayers.get(i).playerName.equals(player2.playerName))
                y = i;
        }
        if (y == -1) {
            Toast.makeText(activity, activity.getResources().getString(R.string.errorSaving) + player2.playerName + activity.getResources().getString(R.string.errorNameNotFound), Toast.LENGTH_LONG).show();
            return;
        }
        rdummy = MainActivity.allPlayers.get(y);
        rdummy.matchesLost++;
        MainActivity.allPlayers.set(y, rdummy);
        MainActivity.saveAllDataToDisk(activity, suddenDeath);
        activity.startActivity(intent);
        activity.finish();
    }

    // get actual size from main score texview (set by autosize), calculate and set size for list entries
    public static void setListSize(TextView mainscore, TextView name, TextView score, TextView checkout) {
        mainscore.measure(0,0);
        int mainScoreSize =  mainscore.getMeasuredHeight();
        double suggsize = mainScoreSize*0.5;
        double namesize = mainScoreSize*0.5;
        double datasize = mainScoreSize*0.66;
        int playerNameHeight = (int) namesize;
        int playerDataHeight = (int) datasize;
        int playerSuggestionHeight = (int) suggsize;
        name.getLayoutParams().height = playerNameHeight;
        score.getLayoutParams().height = playerDataHeight;
        checkout.getLayoutParams().height = playerSuggestionHeight;
    }

    static Button buttonSelect(int buttonnumber, Activity activity) {
        String stt;
        switch (buttonnumber) {
            case 21:
                stt="bdx";
                break;
            case 22:
                stt="btx";
                break;
            case 23:
                stt="missedButton";
                break;
            case 24:
                stt="continueButton";
                break;
            case 25:
                stt="bull";
                break;
            case 26:
                stt="undoButton";
                break;
            case 27:
                stt="doubleButton";
                break;
            case 28:
                stt="tripleButton";
                break;
            default:
                stt = "b" + buttonnumber;
                break;
        }
        int idd = activity.getResources().getIdentifier(stt, "id", activity.getPackageName());
        return activity.findViewById(idd);
    }

    // returns wanted textview for corresponding player and segment
    static TextView textfield(int dart, int activPlayer, int typ, Activity activity)
    // return either textview of:
    // typ=1 -> segment
    // typ=2 -> score of player
    // typ=3 -> name of player
    {
        String elementName = "";
        switch (typ) {
            case 1:
                if (dart == 25) {
                    elementName = "tbull" + "p" + activPlayer;
                } else {
                    elementName = "t" + dart + "p" + activPlayer;
                }
                break;
            case 2:
                elementName = "p" + activPlayer + "score";
                break;
            case 3:
                elementName = "p" + activPlayer + "name";
                break;
        }
        int elementID = activity.getResources().getIdentifier(elementName, "id", activity.getPackageName());
        return activity.findViewById(elementID);
    }

     static void buttonfreeze(boolean freeze, Activity activity) {
        freeze = !freeze;       // a matter of logic ;-)
        activity.findViewById(R.id.b1).setEnabled(freeze);
        activity.findViewById(R.id.b2).setEnabled(freeze);
        activity.findViewById(R.id.b3).setEnabled(freeze);
        activity.findViewById(R.id.b4).setEnabled(freeze);
        activity.findViewById(R.id.b5).setEnabled(freeze);
        activity.findViewById(R.id.b6).setEnabled(freeze);
        activity.findViewById(R.id.b7).setEnabled(freeze);
        activity.findViewById(R.id.b8).setEnabled(freeze);
        activity.findViewById(R.id.b9).setEnabled(freeze);
        activity.findViewById(R.id.b10).setEnabled(freeze);
        activity.findViewById(R.id.b11).setEnabled(freeze);
        activity.findViewById(R.id.b12).setEnabled(freeze);
        activity.findViewById(R.id.b13).setEnabled(freeze);
        activity.findViewById(R.id.b14).setEnabled(freeze);
        activity.findViewById(R.id.b15).setEnabled(freeze);
        activity.findViewById(R.id.b16).setEnabled(freeze);
        activity.findViewById(R.id.b17).setEnabled(freeze);
        activity.findViewById(R.id.b18).setEnabled(freeze);
        activity.findViewById(R.id.b19).setEnabled(freeze);
        activity.findViewById(R.id.b20).setEnabled(freeze);
        activity.findViewById(R.id.bull).setEnabled(freeze);
        activity.findViewById(R.id.doubleButton).setEnabled(freeze);
        activity.findViewById(R.id.tripleButton).setEnabled(freeze);
        activity.findViewById(R.id.missedButton).setEnabled(freeze);
        activity.findViewById(R.id.undoButton).setEnabled(freeze);
        activity.findViewById(R.id.continueButton).setEnabled(freeze);
    }

    static MediaPlayer mediaplayer = new MediaPlayer() {
    @Override
        public void setOnCompletionListener(OnCompletionListener listener) {
            super.setOnCompletionListener(listener);
            this.release();
        }
    };

    static void playAudio(Context ctx, String TextToPlay) {
        SharedPreferences sharedp = ctx.getSharedPreferences("preferences",0);
        boolean play = true;
        if (sharedp.contains("playaudio")) {
            play = sharedp.getBoolean("playaudio", true);
        }
        if (!play) return;

        int resourceId=0;
        // select soundfile resource
        if (TextToPlay.length() <= 3) { // scores are that short only
            resourceId = ctx.getResources().getIdentifier("s" + TextToPlay, "raw", ctx.getPackageName());
        }
        else {
            ArrayList<String> sounds = new ArrayList<>();

            for (int i=1;i<=20;i++) {
                sounds.add("n".concat(Integer.toString(i).concat("closed")));
                sounds.add("n".concat(Integer.toString(i).concat("open")));
            }
            sounds.add("bullopen");
            sounds.add("bullclosed");
            sounds.add("busted");
            sounds.add("madhouse");
            sounds.add("split");
            sounds.add("eliminated");
            sounds.add("closed");
            sounds.add("open");
            sounds.add("matchwinner");
            sounds.add("setwinner");
            sounds.add("winner");
            sounds.add("legwinner");
            sounds.add("requires");
            sounds.add("bull");
            sounds.add("bullseye");
            if (sounds.contains(TextToPlay.toLowerCase()))
                resourceId = ctx.getResources().getIdentifier(TextToPlay.toLowerCase(), "raw", ctx.getPackageName());
        }
        if (resourceId != 0) {
            Uri uri = Uri.parse("android.resource://"+ ctx.getPackageName()+"/"+resourceId);
            new Handler().post(() -> {
                // wait until other sound output has finished
                while (dc_modules.mediaplayer.isPlaying()) {
                }
                mediaplayer.reset();
                mediaplayer.setAudioAttributes(
                        new AudioAttributes.Builder()
                                .setContentType(AudioAttributes.CONTENT_TYPE_MUSIC)
                                .setUsage(AudioAttributes.USAGE_MEDIA)
                                .build()
                );
                try {
                    mediaplayer.setDataSource(ctx, uri);
                    mediaplayer.prepare();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
                mediaplayer.start();
                });
        }
    }


    // calculated suggestions and sort them
    static ArrayList<String> suggestions(int scoreRemaining, int finishSegmentWanted, int DoubleoutOrTripleoutFactor) {
        ArrayList<String> resultList = new ArrayList<>();
        if (scoreRemaining < 0 || scoreRemaining > 180) {
            return resultList;
        }
        // scoreRemaining = 1.dart + 2.dart + 3.dart = (factorDart1 * segmentDart1) + (factorDart2 * segmentDart2) + (factorDart3 * segmentDart3)
        // DoubleoutOrTripleoutFactor means, if it's double out, then == 2, or if it's master out then == 3
        // finishSegmentWanted==0 means no filter -> calculated all finishes
        //
        // scoreRemaining = factorDart1*segmentDart1 + factorDart2*segmentDart2 + DoubleoutOrTripleoutFactor*segmentDart3
        // this is a mathematical equation with 5 unknowns, so there is no algorithm to solve it, we have to calculate/test all possibilities...

        class checkoutPossibility {
            int
                    rest,
                    factorDart1,
                    segmentDart1,
                    factorDart2,
                    segmentDart2,
                    factorDart3,
                    segmentDart3;
        }

        int factorDart1, factorDart2, segmentDart1, segmentDart2, segmentDart3, checkoutCounter, i2, i;
        checkoutPossibility[] checkoutsFound = new checkoutPossibility[3000];
        checkoutPossibility[] wanted = new checkoutPossibility[3000];
        checkoutPossibility[] unwanted = new checkoutPossibility[3000];
        boolean twoDartFinishExists, change;
        checkoutPossibility memory;
        checkoutCounter = 0;
        // get all checkout possibilities
        for (factorDart1 = 3; factorDart1 >= 0; factorDart1--) {
            for (segmentDart1 = 25; segmentDart1 >= 1; segmentDart1--) {
                // 3 times bull is impossible to hit, and segments between 20 and 25 don't exist
                if (!(((segmentDart1 > 20) && (segmentDart1 < 25)) || ((segmentDart1 == 25) && (factorDart1 == 3)))) {
                    for (factorDart2 = 3; factorDart2 >= 0; factorDart2--) {
                        for (segmentDart2 = 25; segmentDart2 >= 1; segmentDart2--) {
                            // 3 times bull is impossible to hit, and segments between 20 and 25 don't exist
                            if (!(((segmentDart2 > 20) && (segmentDart2 < 25)) || ((segmentDart2 == 25) && (factorDart2 == 3)))) {
                                if ((scoreRemaining - (factorDart1 * segmentDart1) - (factorDart2 * segmentDart2)) <= 60) {
                                    // is a double checkout theoretically possible?
                                    for (segmentDart3 = 25; segmentDart3 >= 1; segmentDart3--) {
                                        // there are no segments between 20 and 25
                                        if (!((segmentDart3 > 20) && (segmentDart3 < 25))) {
                                            int actualRemainingScore = (factorDart1 * segmentDart1) + (factorDart2 * segmentDart2) + (DoubleoutOrTripleoutFactor * segmentDart3);
                                            if (((scoreRemaining == actualRemainingScore) && (segmentDart3 != 0))) {
                                                checkoutCounter++;
                                                // save finding in array
                                                checkoutsFound[checkoutCounter] = new checkoutPossibility();
                                                checkoutsFound[checkoutCounter].rest = actualRemainingScore;
                                                if (factorDart1 * segmentDart1 <= 20) {
                                                    checkoutsFound[checkoutCounter].factorDart1 = 1;
                                                    checkoutsFound[checkoutCounter].segmentDart1 = factorDart1 * segmentDart1;
                                                } else {
                                                    checkoutsFound[checkoutCounter].factorDart1 = factorDart1;
                                                    checkoutsFound[checkoutCounter].segmentDart1 = segmentDart1;
                                                }
                                                if ((factorDart2 * segmentDart2) <= 20) {
                                                    checkoutsFound[checkoutCounter].factorDart2 = 1;
                                                    checkoutsFound[checkoutCounter].segmentDart2 = factorDart2 * segmentDart2;
                                                } else {
                                                    checkoutsFound[checkoutCounter].factorDart2 = factorDart2;
                                                    checkoutsFound[checkoutCounter].segmentDart2 = segmentDart2;
                                                }
                                                checkoutsFound[checkoutCounter].factorDart3 = DoubleoutOrTripleoutFactor;
                                                checkoutsFound[checkoutCounter].segmentDart3 = segmentDart3;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        // delete redundant possibilities:
        // delete if 2 possibilities are the same and only differs in:
        //                                 - exchange of first two darts
        //                                 - exchange of last two darts
        //                                 - ...
        //
        // (scoreRemaining = factorDart1*segmentDart1 + factorDart2*segmentDart2 + DoubleoutOrTripleoutFactor*segmentDart3 = (1.pfeil + 2.pfeil + 3.pfeil) )

        for (i = 1; i <= checkoutCounter; i++) {
            if (checkoutsFound[i].rest != 0) { // scoreRemaining=0 means deleted possibilities
                for (i2 = i + 1; i2 <= checkoutCounter; i2++) {
                    if (checkoutsFound[i2].rest != 0) {
                        if ((checkoutsFound[i].factorDart1 == checkoutsFound[i2].factorDart2) && (checkoutsFound[i].segmentDart1 == checkoutsFound[i2].segmentDart2) && (checkoutsFound[i].factorDart2 == checkoutsFound[i2].factorDart1) && (checkoutsFound[i].segmentDart2 == checkoutsFound[i2].segmentDart1))
                            checkoutsFound[i2].rest = 0;
                        if ((checkoutsFound[i].factorDart1 == 0) && (checkoutsFound[i].factorDart2 == checkoutsFound[i2].factorDart2) && (checkoutsFound[i].segmentDart2 == checkoutsFound[i2].segmentDart2))
                            checkoutsFound[i2].rest = 0;
                        if ((checkoutsFound[i].factorDart2 == 0) && (checkoutsFound[i].factorDart1 == checkoutsFound[i2].factorDart1) && (checkoutsFound[i].segmentDart1 == checkoutsFound[i2].segmentDart1))
                            checkoutsFound[i2].rest = 0;
                        // if two darts are enough, check if just the order of them differs
                        if ((checkoutsFound[i].factorDart1 == 0) && (checkoutsFound[i].factorDart2 == checkoutsFound[i2].factorDart3) && (checkoutsFound[i].segmentDart2 == checkoutsFound[i2].segmentDart3))
                            checkoutsFound[i2].rest = 0;
                        if ((checkoutsFound[i].factorDart2 == 0) && (checkoutsFound[i].factorDart1 == checkoutsFound[i2].factorDart3) && (checkoutsFound[i].segmentDart1 == checkoutsFound[i2].segmentDart3))
                            checkoutsFound[i2].rest = 0;
                        if (((checkoutsFound[i].factorDart1 == 0) && (checkoutsFound[i2].factorDart2 == 0)) && ((checkoutsFound[i].factorDart2 == checkoutsFound[i2].factorDart1) && (checkoutsFound[i].segmentDart2 == checkoutsFound[i2].segmentDart1)))
                            checkoutsFound[i2].rest = 0;
                        if (((checkoutsFound[i].factorDart2 == 0) && (checkoutsFound[i2].factorDart1 == 0)) && ((checkoutsFound[i].factorDart1 == checkoutsFound[i2].factorDart2) && (checkoutsFound[i].segmentDart1 == checkoutsFound[i2].segmentDart2)))
                            checkoutsFound[i2].rest = 0;
                        // delete, if first and second dart == 0 and if it is the same double
                        if ((checkoutsFound[i].segmentDart3 == checkoutsFound[i2].segmentDart3) && (checkoutsFound[i].factorDart1 == 0) && (checkoutsFound[i2].factorDart1 == 0) && (checkoutsFound[i].factorDart2 == 0) && (checkoutsFound[i2].factorDart2 == 0))
                            checkoutsFound[i2].rest = 0;
                        // delet if all darts are equal
                        if ((checkoutsFound[i].factorDart1 == checkoutsFound[i2].factorDart1) && (checkoutsFound[i].segmentDart1 == checkoutsFound[i2].segmentDart1) && (checkoutsFound[i].factorDart2 == checkoutsFound[i2].factorDart2) && (checkoutsFound[i].segmentDart2 == checkoutsFound[i2].segmentDart2))
                            checkoutsFound[i2].rest = 0;
                    }
                }
            }
        }
        // search checkouts for two-dart-finishes
        twoDartFinishExists = false;
        for (i = 1; i <= checkoutCounter; i++) {
            if ((checkoutsFound[i].factorDart1 == 0) || (checkoutsFound[i].factorDart2 == 0) || (checkoutsFound[i].segmentDart1 == 0) || (checkoutsFound[i].segmentDart2 == 0)) {
                twoDartFinishExists = true;
                break;
            }
        }
        // copy wanted possibilities into a new to be sorted array
        i2 = 0;
        for (i = 1; i <= checkoutCounter; i++) {
            if ((checkoutsFound[i].rest != 0) && ((checkoutsFound[i].segmentDart3 == finishSegmentWanted) || (finishSegmentWanted == 0) || (finishSegmentWanted != 0 && (checkoutsFound[i].rest < (finishSegmentWanted * DoubleoutOrTripleoutFactor))))) {
                if ((!twoDartFinishExists)
                        || (twoDartFinishExists && (finishSegmentWanted == 0 && ((checkoutsFound[i].factorDart1 == 0) || (checkoutsFound[i].factorDart2 == 0) || (checkoutsFound[i].segmentDart1 == 0) || (checkoutsFound[i].segmentDart2 == 0))))
                        || (finishSegmentWanted != 0 && (checkoutsFound[i].rest >= (finishSegmentWanted * DoubleoutOrTripleoutFactor)))
                        || (finishSegmentWanted != 0 && twoDartFinishExists && ((checkoutsFound[i].factorDart1 == 0) || (checkoutsFound[i].factorDart2 == 0) || (checkoutsFound[i].segmentDart1 == 0) || (checkoutsFound[i].segmentDart2 == 0)) && (checkoutsFound[i].rest < (finishSegmentWanted * DoubleoutOrTripleoutFactor)))) {
                    i2++;
                    wanted[i2] = checkoutsFound[i];
                }
            }
        }
        int zsafe = checkoutCounter;
        checkoutCounter = i2;
        // sort wanted list
        change = true;
        while (change) {
            change = false;
            for (i = 1; i <= checkoutCounter - 1; i++) {
                // if next possibility has got a single, push it to the top, i.e. exchange the rank
                if ((wanted[i].factorDart1 != 1) && (wanted[i].factorDart2 != 1)) {
                    if ((wanted[i + 1].factorDart1 == 1) || (wanted[i + 1].factorDart2 == 1)) {
                        change = true;
                        memory = wanted[i];
                        wanted[i] = wanted[i + 1];
                        wanted[i + 1] = memory;
                    }
                }
            }
        }
        // push possibilies including doubles to top
        change = true;
        while (change) {
            change = false;
            for (i = 1; i <= checkoutCounter - 1; i++) {
                // if next possibility has got a single, push it to the top, i.e. exchange the rank
                if ((wanted[i].factorDart1 == 3) && (wanted[i].factorDart2 == 3)) {
                    if (((wanted[i + 1].factorDart1 == 2) && (wanted[i + 1].factorDart2 == 3))
                            || ((wanted[i + 1].factorDart1 == 3) && (wanted[i + 1].factorDart2 == 2))) {
                        change = true;
                        memory = wanted[i];
                        wanted[i] = wanted[i + 1];
                        wanted[i + 1] = memory;
                    }
                }
            }
        }
        // if favorite checkout selected, search and add other checkouts to list
        int unwantedCounter = 0;
        if (finishSegmentWanted != 0) {
            for (i = 1; i <= zsafe; i++) {
                if (checkoutsFound[i].rest != 0) {
                    if (!twoDartFinishExists || checkoutsFound[i].factorDart1 == 0 || checkoutsFound[i].factorDart2 == 0 || checkoutsFound[i].segmentDart1 == 0 || checkoutsFound[i].segmentDart2 == 0) {
                        unwantedCounter++;
                        unwanted[unwantedCounter] = checkoutsFound[i];
                    }
                }
            }
            zsafe = unwantedCounter;
            // sort unwanted list
            change = true;
            while (change) {
                change = false;
                for (i = 1; i <= zsafe - 1; i++) {
                    // if next possibility has got a single, push it to the top, i.e. exchange the rank
                    if ((unwanted[i].factorDart1 != 1) && (unwanted[i].factorDart2 != 1)) {
                        if ((unwanted[i + 1].factorDart1 == 1) || (unwanted[i + 1].factorDart2 == 1)) {
                            change = true;
                            memory = unwanted[i];
                            unwanted[i] = unwanted[i + 1];
                            unwanted[i + 1] = memory;
                        }
                    }
                }
            }
            // push possibilies including doubles to top
            change = true;
            while (change) {
                change = false;
                for (i = 1; i <= zsafe - 1; i++) {
                    // if next possibility has got a single, push it to the top, i.e. exchange the rank
                    if ((unwanted[i].factorDart1 == 3) && (unwanted[i].factorDart2 == 3)) {
                        if (((unwanted[i + 1].factorDart1 == 2) && (unwanted[i + 1].factorDart2 == 3))
                                || ((unwanted[i + 1].factorDart1 == 3) && (unwanted[i + 1].factorDart2 == 2))) {
                            change = true;
                            memory = unwanted[i];
                            unwanted[i] = unwanted[i + 1];
                            unwanted[i + 1] = memory;
                        }
                    }
                }
            }
        }
        ArrayList<checkoutPossibility> finalSuggestions = new ArrayList<>();
        for (i = 1; i <= checkoutCounter; i++) {
            finalSuggestions.add(wanted[i]);
        }
        // add unwanted list, if finishSegmentWanted is selected
        if (finishSegmentWanted != 0) {
            for (i = 1; i <= unwantedCounter; i++) {
                if (!finalSuggestions.contains(unwanted[i])) {
                    finalSuggestions.add(unwanted[i]);
                }
            }
        }
        // set nice formatting of selected possibilities
        // scoreRemaining:= factorDart1*segmentDart1 + factorDart2*segmentDart2 + DoubleoutOrTripleoutFactor*segmentDart3 = (1.pfeil + 2.pfeil + 3.pfeil)
        String dt, str;
        dt = "";
        if (DoubleoutOrTripleoutFactor == 2) dt = "D";
        if (DoubleoutOrTripleoutFactor == 3) dt = "T";
        i2 = 0;
        resultList.add("...");
        for (checkoutPossibility ergebnis : finalSuggestions) {
            i2++;
            str = "";
            if ((ergebnis.factorDart1 * ergebnis.segmentDart1) > 0)
                switch (ergebnis.factorDart1) {
                    case 1:
                        str = str + ergebnis.segmentDart1;
                        break;
                    case 2:
                        str = str + "D" + ergebnis.segmentDart1;
                        break;
                    case 3:
                        str = str + "T" + ergebnis.segmentDart1;
                        break;
                }
            if ((ergebnis.factorDart2 * ergebnis.segmentDart2) > 0)
                switch (ergebnis.factorDart2) {
                    case 1:
                        str = str + " " + ergebnis.segmentDart2;
                        break;
                    case 2:
                        str = str + " " + "D" + ergebnis.segmentDart2;
                        break;
                    case 3:
                        str = str + " " + "T" + ergebnis.segmentDart2;
                        break;
                }
            if (str.isEmpty())
                str = dt + ergebnis.segmentDart3;
            else str = str + " " + dt + ergebnis.segmentDart3;

            resultList.add(str);
        }
        if (scoreRemaining == 2) {
            resultList.remove(resultList.remove(resultList.size() - 1));
            resultList.add("MaDhOuSe");
        }
        return resultList;
    }
}