/*
 * Copyright 2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jsefa.common.util;

/**
 * Provides an object which is costly to create or to retrieve and which is needed only conditionally needed.
 * 
 * @author Norman Lahme-Huetig
 * 
 */
public interface OnDemandObjectProvider {
    /**
     * Returns the object in question.
     * 
     * @param <T> the expected type of the parameter value
     * @return the object
     */
    <T> T get();
}
