package com.DartChecker;

import static com.DartChecker.dc_modules.buttonSelect;
import static com.DartChecker.dc_modules.buttonfreeze;
import static com.DartChecker.dc_modules.playAudio;
import static com.DartChecker.dc_modules.textfield;
import static com.DartChecker.dc_modules.dart;
import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Paint;
import android.os.Bundle;
import android.os.Handler;
import android.util.TypedValue;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import java.util.ArrayList;
import java.util.Objects;

public class roundtclock extends AppCompatActivity {
    private final player[] player = new player[9];
    private final ArrayList<dart> dartsThrown = new ArrayList<>();
    private long startTime = 0;
    private float
            textSizeActive,
            textSizePassive;
    private int
            textColorActive,
            textColorPassive,
            playerCount,
            activePlayerIndex = 1,
            dartsThrownInRound = 0,
            scoreInRound,
            changeTime = 1500,
            undoIndex = -1,
            bcolor,
            bcolorn,
            gameVariantAsInt;
    private String s = "";
    private CharSequence gameMode,
            gameVariant;
    private boolean undoabQuestion = true,
            doubleSelected = false,
            tripleSelected = false;

    // undo
    private final View.OnClickListener undoclick = new View.OnClickListener() {
        @Override
        public void onClick(View v) {

            // safty question
            if (undoabQuestion) {
                AlertDialog alertDialog = new AlertDialog.Builder(roundtclock.this).create();
                alertDialog.setTitle(getResources().getString(R.string.caution));
                alertDialog.setMessage(getResources().getString(R.string.wantToUndo));
                alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yesIDo),
                        (dialog, which) -> {
                            dialog.dismiss();
                            undo();
                        });
                alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.no), (dialog, which) -> dialog.dismiss());
                alertDialog.show();
                final SharedPreferences settings = getApplicationContext().getSharedPreferences("preferences", 0);
                if (settings.contains("undoSafetyQuestion")) {
                    if (!settings.getBoolean("undoSafetyQuestion", false)) {
                        alertDialog.hide();
                        alertDialog.getButton(AlertDialog.BUTTON_POSITIVE).performClick();
                    }
                }
            } else {
                undoabQuestion = true;
                undo();
            }
        }

        private void undo() {
            if (doubleSelected) // if double or triple pressed, reset buttoncolor and do nothing else
            {
                doubleSelected = false;
                Button doubleb = findViewById(R.id.doubleButton);
                doubleb.setBackgroundColor(bcolorn);
                return;
            } else if (tripleSelected) {
                tripleSelected = false;
                Button tripleb = findViewById(R.id.tripleButton);
                tripleb.setBackgroundColor(bcolorn);
                return;
            }
            int segment;
            TextView darts = findViewById(R.id.darts);
            if (undoIndex >= 0) {
                if (dartsThrownInRound == 0) {
                    //player change
                    dartsThrownInRound = 2;
                    s = "..";
                    textfield(1, activePlayerIndex, 3, roundtclock.this).setTextColor(textColorPassive);
                    textfield(1, activePlayerIndex, 2, roundtclock.this).setTextColor(textColorPassive);
                    textfield(1, activePlayerIndex, 3, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizePassive);
                    textfield(1, activePlayerIndex, 2, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizePassive);
                    activePlayerIndex = dartsThrown.get(undoIndex).playerIndex;   // last player
                    textfield(1, activePlayerIndex, 3, roundtclock.this).setTextColor(textColorActive);
                    textfield(1, activePlayerIndex, 2, roundtclock.this).setTextColor(textColorActive);
                    textfield(1, activePlayerIndex, 3, roundtclock.this).setPaintFlags(textfield(1, activePlayerIndex, 3, roundtclock.this).getPaintFlags() & (~Paint.STRIKE_THRU_TEXT_FLAG));
                    textfield(1, activePlayerIndex, 2, roundtclock.this).setPaintFlags(textfield(1, activePlayerIndex, 2, roundtclock.this).getPaintFlags() & (~Paint.STRIKE_THRU_TEXT_FLAG));
                    textfield(1, activePlayerIndex, 3, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeActive);
                    textfield(1, activePlayerIndex, 2, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeActive);
                    ConstraintLayout cl = findViewById(R.id.matchbereich);
                    ConstraintSet csdart = new ConstraintSet();
                    csdart.clone(cl);
                    csdart.connect(darts.getId(), ConstraintSet.END, textfield(1, activePlayerIndex, 3, roundtclock.this).getId(), ConstraintSet.END);
                    csdart.connect(darts.getId(), ConstraintSet.START, textfield(1, activePlayerIndex, 3, roundtclock.this).getId(), ConstraintSet.START);
                    csdart.applyTo(cl);
                    if (player[activePlayerIndex].ranking != 0)
                        player[activePlayerIndex].ranking = 0;
                } else dartsThrownInRound--;
                if (dartsThrownInRound == 1) s = ".";
                else if (dartsThrownInRound == 0) s = "";
                darts.setText(s);
                segment = dartsThrown.get(undoIndex).segment;
                int factor = dartsThrown.get(undoIndex).factor;
                String factorAsString = "";
                switch (factor) {
                    case 2:
                        factorAsString = "D";
                        break;
                    case 3:
                        factorAsString = "T";

                }
                String undoMessage;
                switch (segment) {
                    case 0:
                        undoMessage = "undo: " + getResources().getString(R.string.missed);
                        break;
                    case 25:
                        undoMessage = "undo: " + factorAsString + "Bull";
                        break;
                    default:
                        undoMessage = "undo: " + factorAsString + segment;
                        break;
                }
                undoMessage = undoMessage + " " + getResources().getString(R.string.from) + " " + player[dartsThrown.get(undoIndex).playerIndex].playerName;
                Toast.makeText(roundtclock.this, undoMessage, Toast.LENGTH_SHORT).show();
                // hide (all) buttons
                for (int b = 1; b <= 20; b++) {
                    buttonSelect(b, roundtclock.this).setVisibility(View.GONE);
                }
                buttonSelect(25, roundtclock.this).setVisibility(View.GONE);
                // undo() a missed throw: get score from actual player and get/show next segment to hit
                if (segment == 0) {
                    segment = player[activePlayerIndex].score;
                    if (gameMode.equals("1-20") && segment < 20) {
                        buttonSelect(segment + 1, roundtclock.this).setVisibility(View.VISIBLE);
                    }
                    if (gameMode.equals("20-1")) {
                        if (segment > 0) {
                            buttonSelect(segment - 1, roundtclock.this).setVisibility(View.VISIBLE);
                        } else {
                            buttonSelect(20, roundtclock.this).setVisibility(View.VISIBLE);
                        }
                    }
                    if (gameMode.equals("1-Bull") && segment < 25) {
                        if (segment == 20) {
                            buttonSelect(25, roundtclock.this).setVisibility(View.VISIBLE);
                        } else {
                            buttonSelect(segment + 1, roundtclock.this).setVisibility(View.VISIBLE);
                        }
                    }
                    if (gameMode.equals("Bull-1")) {
                        switch (segment) {
                            case 0:
                                buttonSelect(25, roundtclock.this).setVisibility(View.VISIBLE);
                                break;
                            case 25:
                                buttonSelect(20, roundtclock.this).setVisibility(View.VISIBLE);
                                break;
                            default:
                                buttonSelect(segment - 1, roundtclock.this).setVisibility(View.VISIBLE);
                                break;
                        }
                    }
                }
                // regular undo(): get/show last segment to hit
                else {
                    switch (factor) {
                        case 3:
                            if (player[activePlayerIndex].hits[segment] > 0) {
                                player[activePlayerIndex].hits[segment]--;
                            }
                        case 2:
                            if (player[activePlayerIndex].hits[segment] > 0) {
                                player[activePlayerIndex].hits[segment]--;
                            }
                        case 1:
                            if (player[activePlayerIndex].hits[segment] > 0) {
                                player[activePlayerIndex].hits[segment]--;
                            }
                    }
                    buttonSelect(segment, roundtclock.this).setVisibility(View.VISIBLE);
                    boolean changed = false;
                    if (player[activePlayerIndex].hits[segment] == 0) {
                        if (gameMode.equals("1-20")) {
                            if (segment > 0) {
                                segment--;
                            }
                        }
                        if (gameMode.equals("20-1")) {
                            if (segment <= 20) {
                                segment++;
                            }
                        }
                        if (gameMode.equals("1-Bull")) {
                            if (segment == 25) {
                                segment = 20;
                            } else if (segment > 0) {
                                segment--;
                            }
                        }
                        if (gameMode.equals("Bull-1")) {
                            if (segment == 20) {
                                segment = 25;
                                changed = true;
                            } else if (segment < 25) {
                                segment++;
                            }
                        }
                    }
                    player[activePlayerIndex].score = segment;
                    //update score textviews
                    switch (segment) {
                        case 25:
                            if (!changed)
                                textfield(1, activePlayerIndex, 2, roundtclock.this).setText("0");
                            else
                                textfield(1, activePlayerIndex, 2, roundtclock.this).setText("Bull");
                            break;
                        case 21:
                            if (gameMode.equals("20-1"))
                                textfield(1, activePlayerIndex, 2, roundtclock.this).setText("0");
                            break;
                        default:
                            textfield(1, activePlayerIndex, 2, roundtclock.this).setText(Integer.toString(segment));
                    }
                }
                player[activePlayerIndex].dartsThrown--;
                undoIndex--;
            } else Toast.makeText(roundtclock.this, R.string.noUndo, Toast.LENGTH_LONG).show();
        }
    };

    private final View.OnClickListener doubletripleClick = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            Button tripleb = findViewById(R.id.tripleButton);
            Button doubleb = findViewById(R.id.doubleButton);
            if (v.getId() == R.id.doubleButton) {
                if (tripleSelected) {
                    tripleSelected = false;
                    tripleb.setBackgroundColor(bcolorn);
                }
                if (!doubleSelected) {
                    doubleSelected = true;
                    doubleb.setBackgroundColor(bcolor);
                } else {
                    doubleSelected = false;
                    doubleb.setBackgroundColor(bcolorn);
                }
            } else {
                if (doubleSelected) {
                    doubleSelected = false;
                    doubleb.setBackgroundColor(bcolorn);
                }
                if (!tripleSelected) {
                    tripleSelected = true;
                    tripleb.setBackgroundColor(bcolor);
                } else {
                    tripleSelected = false;
                    tripleb.setBackgroundColor(bcolorn);
                }
            }
        }
    };

    private final View.OnClickListener continueClick = v -> {
        Button missed = findViewById(R.id.missedButton);
        switch (dartsThrownInRound) {
            case 0:
                missed.performClick();
            case 1:
                missed.performClick();
            case 2:
                missed.performClick();
        }
    };

    private final View.OnClickListener buttonclick = new View.OnClickListener() {
        @SuppressLint("NonConstantResourceId")
        @Override
        public void onClick(View v) {
            int buttonIdClicked = v.getId();
            Button eingabe = findViewById(buttonIdClicked);
            int segment,
                    scoreToAdd = 0;
            // which button was clicked?
            switch (buttonIdClicked) {
                case R.id.bull:
                    segment = 25;
                    break;
                case R.id.missedButton:
                    segment = 0;
                    break;
                default:
                    try {
                        segment = Integer.parseInt(eingabe.getText().toString());
                    } catch (Exception e) {
                        segment = 255;         // error value - should never happen
                    }
                    break;
            }

            int factor;
            if (doubleSelected) {
                factor = 2;
                //  dot = "D";
                doubleSelected = false;
                findViewById(R.id.doubleButton).setBackgroundColor(bcolorn);
            } else if (tripleSelected) {
                factor = 3;
                // dot = "T";
                tripleSelected = false;
                findViewById(R.id.tripleButton).setBackgroundColor(bcolorn);
                if (segment == 25) {
                    Toast.makeText(getApplicationContext(), getResources().getString(R.string.tripleBull), Toast.LENGTH_LONG).show();
                    return;
                }
            } else // single!
            {
                factor = 1;
                // dot = "";
            }

            dart actualHit;
            if (segment != 0) {
                // save data for undo()
                actualHit = new dart();
                undoIndex++;
                actualHit.scoreToAdd = scoreToAdd;
                actualHit.playerIndex = activePlayerIndex;
                actualHit.segment = segment;
                actualHit.factor = factor;
                dartsThrown.add(undoIndex, actualHit);
                int maxHitsToAdd = gameVariantAsInt;

                // add segment hit(s)
                switch (factor) {
                    case 3:
                        if (player[activePlayerIndex].hits[segment] < maxHitsToAdd) {
                            player[activePlayerIndex].hits[segment]++;
                        }
                    case 2:
                        if (player[activePlayerIndex].hits[segment] < maxHitsToAdd) {
                            player[activePlayerIndex].hits[segment]++;
                        }
                    case 1:
                        if (player[activePlayerIndex].hits[segment] < maxHitsToAdd) {
                            player[activePlayerIndex].hits[segment]++;
                        }
                }

                // hide actual button, display next button, if needed
                if (player[activePlayerIndex].hits[segment] == maxHitsToAdd) {
                    buttonSelect(segment, roundtclock.this).setVisibility(View.GONE);
                    if (gameMode.equals("1-20") && segment < 20) {
                        buttonSelect(segment + 1, roundtclock.this).setVisibility(View.VISIBLE);
                    }
                    if (gameMode.equals("20-1") && segment > 1) {
                        if (player[activePlayerIndex].hits[segment] == maxHitsToAdd) {
                            buttonSelect(segment - 1, roundtclock.this).setVisibility(View.VISIBLE);
                        }
                    }
                    if (gameMode.equals("1-Bull") && segment < 25) {
                        if (segment == 20) {
                            buttonSelect(25, roundtclock.this).setVisibility(View.VISIBLE);
                        } else {
                            buttonSelect(segment + 1, roundtclock.this).setVisibility(View.VISIBLE);
                        }
                    }
                    if (gameMode.equals("Bull-1") && segment > 1) {
                        if (segment == 25) {
                            buttonSelect(20, roundtclock.this).setVisibility(View.VISIBLE);
                        } else {
                            buttonSelect(segment - 1, roundtclock.this).setVisibility(View.VISIBLE);
                        }
                    }
                }
                // update player score and corresponding textview
                player[activePlayerIndex].dartsThrown++;
                if (player[activePlayerIndex].hits[segment] == maxHitsToAdd)
                    player[activePlayerIndex].score = segment;

                if (player[activePlayerIndex].hits[segment] == maxHitsToAdd) {
                    if (segment == 25) {
                        textfield(1, activePlayerIndex, 2, roundtclock.this).setText("Bull");
                    } else {
                        textfield(1, activePlayerIndex, 2, roundtclock.this).setText(Integer.toString(segment));
                    }
                }


                // game over?
                if (winner(activePlayerIndex)) {
                    AlertDialog alertDialog = new AlertDialog.Builder(roundtclock.this).create();
                    alertDialog.setTitle(getResources().getString(R.string.caution));
                    alertDialog.setMessage(getResources().getString(R.string.lastInputCorrect));
                    alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yes),
                            (dialog, which) -> {
                                dialog.dismiss();
                                if (winner(activePlayerIndex)) {
                                    // init end of game
                                    playAudio(roundtclock.this, "winner");
                                    long gameDuration = (System.currentTimeMillis() - startTime) / 1000;
                                    Intent intent = new Intent(roundtclock.this, endofgame.class);
                                    intent.putExtra("playercount", playerCount);
                                    intent.putExtra("roundtclock", true);
                                    intent.putExtra("gameDuration", gameDuration);
                                    intent.putExtra("first", player[activePlayerIndex].playerName);
                                    intent.putExtra("firstscore", player[activePlayerIndex].score);
                                    for (int i=1; i<8; i++) player[i].dartsThrown=0;
                                    for (int i2 = 0; i2 < dartsThrown.size(); i2++) {
                                        switch (playerCount) {
                                            case 8:
                                                if (dartsThrown.get(i2).playerIndex == 8)
                                                    player[8].dartsThrown++;
                                            case 7:
                                                if (dartsThrown.get(i2).playerIndex == 7)
                                                    player[7].dartsThrown++;
                                            case 6:
                                                if (dartsThrown.get(i2).playerIndex == 6)
                                                    player[6].dartsThrown++;
                                            case 5:
                                                if (dartsThrown.get(i2).playerIndex == 5)
                                                    player[5].dartsThrown++;
                                            case 4:
                                                if (dartsThrown.get(i2).playerIndex == 4)
                                                    player[4].dartsThrown++;
                                            case 3:
                                                if (dartsThrown.get(i2).playerIndex == 3)
                                                    player[3].dartsThrown++;
                                            case 2:
                                                if (dartsThrown.get(i2).playerIndex == 2)
                                                    player[2].dartsThrown++;
                                            case 1:
                                                if (dartsThrown.get(i2).playerIndex == 1)
                                                    player[1].dartsThrown++;
                                        }
                                    }

                                    intent.putExtra("firstdarts", player[1].dartsThrown);
                                    switch (playerCount) {
                                        case 2:
                                            switch (activePlayerIndex) {
                                                case 1:
                                                    intent.putExtra("second", player[2].playerName);
                                                    intent.putExtra("secondscore", player[2].score);
                                                    intent.putExtra("seconddarts", player[2].dartsThrown);
                                                    intent.putExtra("firstdarts", player[1].dartsThrown);
                                                    break;
                                                case 2:
                                                    intent.putExtra("second", player[1].playerName);
                                                    intent.putExtra("secondscore", player[1].score);
                                                    intent.putExtra("seconddarts", player[1].dartsThrown);
                                                    intent.putExtra("firstdarts", player[2].dartsThrown);
                                                    break;
                                            }
                                            break;
                                        case 3: {
                                            player s2 = new player(), s3 = new player();
                                            switch (activePlayerIndex) {
                                                case 1:
                                                    s2 = player[2];
                                                    s3 = player[3];
                                                    break;
                                                case 2:
                                                    s2 = player[1];
                                                    s3 = player[3];
                                                    break;
                                                case 3:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    break;
                                            }
                                            intent.putExtra("second", s2.playerName);
                                            intent.putExtra("secondscore", s2.score);
                                            intent.putExtra("third", s3.playerName);
                                            intent.putExtra("thirdscore", s3.score);
                                            intent.putExtra("seconddarts", s2.dartsThrown);
                                            intent.putExtra("thirddarts", s3.dartsThrown);
                                            break;
                                        }
                                        case 4: {
                                            player s2 = new player(), s3 = new player(), s4 = new player();
                                            switch (activePlayerIndex) {
                                                case 1:
                                                    s2 = player[2];
                                                    s3 = player[3];
                                                    s4 = player[4];
                                                    break;
                                                case 2:
                                                    s2 = player[1];
                                                    s3 = player[3];
                                                    s4 = player[4];
                                                    break;
                                                case 3:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[4];
                                                    break;
                                                case 4:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    break;
                                            }
                                            intent.putExtra("second", s2.playerName);
                                            intent.putExtra("secondscore", s2.score);
                                            intent.putExtra("third", s3.playerName);
                                            intent.putExtra("thirdscore", s3.score);
                                            intent.putExtra("fourth", s4.playerName);
                                            intent.putExtra("fourthscore", s4.score);
                                            intent.putExtra("seconddarts", s2.dartsThrown);
                                            intent.putExtra("thirddarts", s3.dartsThrown);
                                            intent.putExtra("fourthdarts", s4.dartsThrown);
                                            break;
                                        }
                                        case 5: {
                                            player s2 = new player(), s3 = new player(), s4 = new player(), s5 = new player();
                                            switch (activePlayerIndex) {
                                                case 1:
                                                    s2 = player[2];
                                                    s3 = player[3];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    break;
                                                case 2:
                                                    s2 = player[1];
                                                    s3 = player[3];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    break;
                                                case 3:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    break;
                                                case 4:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[5];
                                                    break;
                                                case 5:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[4];
                                                    break;
                                            }
                                            intent.putExtra("second", s2.playerName);
                                            intent.putExtra("secondscore", s2.score);
                                            intent.putExtra("third", s3.playerName);
                                            intent.putExtra("thirdscore", s3.score);
                                            intent.putExtra("fourth", s4.playerName);
                                            intent.putExtra("fourthscore", s4.score);
                                            intent.putExtra("fifth", s5.playerName);
                                            intent.putExtra("fifthscore", s5.score);
                                            intent.putExtra("seconddarts", s2.dartsThrown);
                                            intent.putExtra("thirddarts", s3.dartsThrown);
                                            intent.putExtra("fourthdarts", s4.dartsThrown);
                                            intent.putExtra("fifthdarts", s5.dartsThrown);
                                            break;
                                        }
                                        case 6: {
                                            player s2 = new player(), s3 = new player(), s4 = new player(), s5 = new player(), s6 = new player();
                                            switch (activePlayerIndex) {
                                                case 1:
                                                    s2 = player[2];
                                                    s3 = player[3];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    break;
                                                case 2:
                                                    s2 = player[1];
                                                    s3 = player[3];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    break;
                                                case 3:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    break;
                                                case 4:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    break;
                                                case 5:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[4];
                                                    s6 = player[6];
                                                    break;
                                                case 6:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[4];
                                                    s6 = player[5];
                                                    break;
                                            }
                                            intent.putExtra("second", s2.playerName);
                                            intent.putExtra("secondscore", s2.score);
                                            intent.putExtra("third", s3.playerName);
                                            intent.putExtra("thirdscore", s3.score);
                                            intent.putExtra("fourth", s4.playerName);
                                            intent.putExtra("fourthscore", s4.score);
                                            intent.putExtra("fifth", s5.playerName);
                                            intent.putExtra("fifthscore", s5.score);
                                            intent.putExtra("sixth", s6.playerName);
                                            intent.putExtra("sixthscore", s6.score);
                                            intent.putExtra("seconddarts", s2.dartsThrown);
                                            intent.putExtra("thirddarts", s3.dartsThrown);
                                            intent.putExtra("fourthdarts", s4.dartsThrown);
                                            intent.putExtra("fifthdarts", s5.dartsThrown);
                                            intent.putExtra("sixthdarts", s6.dartsThrown);
                                            break;
                                        }
                                        case 7: {
                                            player s2 = new player(), s3 = new player(), s4 = new player(), s5 = new player(), s6 = new player(), s7 = new player();
                                            switch (activePlayerIndex) {
                                                case 1:
                                                    s2 = player[2];
                                                    s3 = player[3];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    s7 = player[7];
                                                    break;
                                                case 2:
                                                    s2 = player[1];
                                                    s3 = player[3];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    s7 = player[7];
                                                    break;
                                                case 3:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    s7 = player[7];
                                                    break;
                                                case 4:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    s7 = player[7];
                                                    break;
                                                case 5:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[4];
                                                    s6 = player[6];
                                                    s7 = player[7];
                                                    break;
                                                case 6:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[4];
                                                    s7 = player[7];
                                                    s6 = player[5];
                                                    break;
                                                case 7:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[4];
                                                    s7 = player[6];
                                                    s6 = player[5];
                                                    break;
                                            }
                                            intent.putExtra("second", s2.playerName);
                                            intent.putExtra("secondscore", s2.score);
                                            intent.putExtra("third", s3.playerName);
                                            intent.putExtra("thirdscore", s3.score);
                                            intent.putExtra("fourth", s4.playerName);
                                            intent.putExtra("fourthscore", s4.score);
                                            intent.putExtra("fifth", s5.playerName);
                                            intent.putExtra("fifthscore", s5.score);
                                            intent.putExtra("sixth", s6.playerName);
                                            intent.putExtra("sixthscore", s6.score);
                                            intent.putExtra("seventh", s7.playerName);
                                            intent.putExtra("seventhscore", s7.score);
                                            intent.putExtra("seconddarts", s2.dartsThrown);
                                            intent.putExtra("thirddarts", s3.dartsThrown);
                                            intent.putExtra("fourthdarts", s4.dartsThrown);
                                            intent.putExtra("fifthdarts", s5.dartsThrown);
                                            intent.putExtra("sixthdarts", s6.dartsThrown);
                                            intent.putExtra("seventhdarts", s7.dartsThrown);
                                            break;
                                        }
                                        case 8: {
                                            player s2 = new player(), s3 = new player(), s4 = new player(), s5 = new player(), s6 = new player(), s7 = new player(), s8 = new player();
                                            switch (activePlayerIndex) {
                                                case 1:
                                                    s2 = player[2];
                                                    s3 = player[3];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    s7 = player[7];
                                                    s8 = player[8];
                                                    break;
                                                case 2:
                                                    s2 = player[1];
                                                    s3 = player[3];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    s7 = player[7];
                                                    s8 = player[8];
                                                    break;
                                                case 3:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[4];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    s7 = player[7];
                                                    s8 = player[8];
                                                    break;
                                                case 4:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[5];
                                                    s6 = player[6];
                                                    s7 = player[7];
                                                    s8 = player[8];
                                                    break;
                                                case 5:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[4];
                                                    s6 = player[6];
                                                    s7 = player[7];
                                                    s8 = player[8];
                                                    break;
                                                case 6:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[4];
                                                    s7 = player[7];
                                                    s6 = player[5];
                                                    s8 = player[8];
                                                    break;
                                                case 7:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[4];
                                                    s7 = player[6];
                                                    s6 = player[5];
                                                    s8 = player[8];
                                                    break;
                                                case 8:
                                                    s2 = player[1];
                                                    s3 = player[2];
                                                    s4 = player[3];
                                                    s5 = player[4];
                                                    s7 = player[6];
                                                    s6 = player[5];
                                                    s8 = player[7];
                                                    break;
                                            }
                                            intent.putExtra("second", s2.playerName);
                                            intent.putExtra("secondscore", s2.score);
                                            intent.putExtra("third", s3.playerName);
                                            intent.putExtra("thirdscore", s3.score);
                                            intent.putExtra("fourth", s4.playerName);
                                            intent.putExtra("fourthscore", s4.score);
                                            intent.putExtra("fifth", s5.playerName);
                                            intent.putExtra("fifthscore", s5.score);
                                            intent.putExtra("sixth", s6.playerName);
                                            intent.putExtra("sixthscore", s6.score);
                                            intent.putExtra("seventh", s7.playerName);
                                            intent.putExtra("seventhscore", s7.score);
                                            intent.putExtra("eight", s8.playerName);
                                            intent.putExtra("eightscore", s8.score);
                                            intent.putExtra("seconddarts", s2.dartsThrown);
                                            intent.putExtra("thirddarts", s3.dartsThrown);
                                            intent.putExtra("fourthdarts", s4.dartsThrown);
                                            intent.putExtra("fifthdarts", s5.dartsThrown);
                                            intent.putExtra("sixthdarts", s6.dartsThrown);
                                            intent.putExtra("seventhdarts", s7.dartsThrown);
                                            intent.putExtra("eighthdarts", s8.dartsThrown);
                                            break;
                                        }
                                    }
                                    startActivity(intent);
                                    finish();
                                    return;
                                }
                                TextView darts = findViewById(R.id.darts);
                                if (dartsThrownInRound < 2) {
                                    dartsThrownInRound++;
                                    s = s + (".");
                                } else {  //player change
                                    dartsThrownInRound = 0;
                                    s = "";
                                    if (player[activePlayerIndex].ranking != 0) {
                                        // get next player name
                                        int nextPlayerID = activePlayerIndex;
                                        do {
                                            if (activePlayerIndex < playerCount) nextPlayerID++;
                                            else nextPlayerID = 1;
                                        } while (player[nextPlayerID].ranking != 0);
                                        buttonfreeze(true, roundtclock.this);
                                        final TextView scoreThrownTV = findViewById(R.id.scoreThrown);
                                        if (player[activePlayerIndex].ranking != 0) {
                                            scoreThrownTV.setText(player[activePlayerIndex].ranking + ".");
                                            playAudio(getApplicationContext(), "winner");
                                        } else {
                                            scoreThrownTV.setText(getResources().getString(R.string.nextPlayer) + "\n" + player[activePlayerIndex].playerName);
                                            playAudio(getApplicationContext(), Integer.toString(scoreInRound));
                                        }
                                        scoreThrownTV.setVisibility(View.VISIBLE);
                                        new Handler().postDelayed(() -> {
                                            buttonfreeze(false, roundtclock.this);
                                            scoreThrownTV.setVisibility(View.INVISIBLE);
                                        }, changeTime);
                                        scoreInRound = 0;
                                    }
                                    if (player[activePlayerIndex].ranking == 0) {
                                        textfield(1, activePlayerIndex, 3, roundtclock.this).setTextColor(textColorPassive);
                                        textfield(1, activePlayerIndex, 2, roundtclock.this).setTextColor(textColorPassive);
                                    }
                                    textfield(1, activePlayerIndex, 3, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizePassive);
                                    textfield(1, activePlayerIndex, 2, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizePassive);
                                    do {
                                        if (activePlayerIndex < playerCount) activePlayerIndex++;
                                        else activePlayerIndex = 1;
                                    } while (player[activePlayerIndex].ranking != 0);
                                    textfield(1, activePlayerIndex, 3, roundtclock.this).setTextColor(textColorActive);
                                    textfield(1, activePlayerIndex, 2, roundtclock.this).setTextColor(textColorActive);
                                    textfield(1, activePlayerIndex, 3, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeActive);
                                    textfield(1, activePlayerIndex, 2, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeActive);
                                }
                                darts.setText(s);
                                ConstraintLayout cl = findViewById(R.id.matchbereich);
                                ConstraintSet csdart = new ConstraintSet();
                                csdart.clone(cl);
                                csdart.connect(darts.getId(), ConstraintSet.END, textfield(1, activePlayerIndex, 3, roundtclock.this).getId(), ConstraintSet.END);
                                csdart.connect(darts.getId(), ConstraintSet.START, textfield(1, activePlayerIndex, 3, roundtclock.this).getId(), ConstraintSet.START);
                                csdart.applyTo(cl);
                            });

                    alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.no), (dialog, which) -> {
                        dialog.dismiss();
                        // last hit was a failure -> don't end game and undo()
                        TextView darts = findViewById(R.id.darts);
                        if (dartsThrownInRound < 2) {
                            dartsThrownInRound++;
                            s = s + (".");
                        } else {  //player change
                            dartsThrownInRound = 0;
                            s = "";
                        }
                        darts.setText(s);
                        undoabQuestion = false;
                        findViewById(R.id.undoButton).performClick();
                    });
                    alertDialog.show();
                    return;
                }

            }
            // no hit - busted
            else if (!winner(activePlayerIndex)) {
                undoIndex++;
                actualHit = new dart();
                actualHit.scoreToAdd = 0;
                actualHit.segment = segment;
                actualHit.factor = factor;
                actualHit.playerIndex = activePlayerIndex;
                dartsThrown.add(undoIndex, actualHit);
            }
            // game continues
            TextView darts = findViewById(R.id.darts);
            if (dartsThrownInRound < 2) {
                dartsThrownInRound++;
                s = s + (".");
            } else {
                //player change
                dartsThrownInRound = 0;
                s = "";
                int nextPlayerID = activePlayerIndex;
                do {
                    if (activePlayerIndex < playerCount) nextPlayerID++;
                    else nextPlayerID = 1;
                } while (player[nextPlayerID].ranking != 0);
                buttonfreeze(true, roundtclock.this);
                final TextView scoreThrownTV = findViewById(R.id.scoreThrown);
                if (player[activePlayerIndex].ranking != 0)
                    scoreThrownTV.setText(player[activePlayerIndex].ranking + ".");
                else {
                    scoreThrownTV.setText(getResources().getString(R.string.nextPlayer) + "\n" + player[nextPlayerID].playerName);
                }
                scoreThrownTV.setVisibility(View.VISIBLE);
                new Handler().postDelayed(() -> {
                    buttonfreeze(false, roundtclock.this);
                    scoreThrownTV.setVisibility(View.INVISIBLE);
                }, changeTime);
                scoreInRound = 0;
                if (player[activePlayerIndex].ranking == 0) {
                    textfield(1, activePlayerIndex, 3, roundtclock.this).setTextColor(textColorPassive);
                    textfield(1, activePlayerIndex, 2, roundtclock.this).setTextColor(textColorPassive);
                }
                textfield(1, activePlayerIndex, 3, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizePassive);
                textfield(1, activePlayerIndex, 2, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizePassive);
                // hide button from last/actual player
                for (int buttonNumber = 1; buttonNumber <= 20; buttonNumber++) {
                    if (buttonSelect(buttonNumber, roundtclock.this).getVisibility() == View.VISIBLE) {
                        buttonSelect(buttonNumber, roundtclock.this).setVisibility(View.GONE);
                        break;
                    }
                }
                if (buttonSelect(25, roundtclock.this).getVisibility() == View.VISIBLE) {
                    buttonSelect(25, roundtclock.this).setVisibility(View.GONE);
                }
                playAudio(getApplicationContext(), textfield(1, activePlayerIndex, 2, roundtclock.this).getText().toString());
                if (activePlayerIndex < playerCount) activePlayerIndex++;
                else activePlayerIndex = 1;
                textfield(1, activePlayerIndex, 3, roundtclock.this).setTextColor(textColorActive);
                textfield(1, activePlayerIndex, 2, roundtclock.this).setTextColor(textColorActive);
                textfield(1, activePlayerIndex, 3, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeActive);
                textfield(1, activePlayerIndex, 2, roundtclock.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeActive);
                segment = player[activePlayerIndex].score;
                if (gameMode.equals("1-20") && segment < 20) {
                    buttonSelect(segment + 1, roundtclock.this).setVisibility(View.VISIBLE);
                }
                if (gameMode.equals("20-1")) {
                    if (segment > 0) {
                        buttonSelect(segment - 1, roundtclock.this).setVisibility(View.VISIBLE);
                    } else {
                        buttonSelect(20, roundtclock.this).setVisibility(View.VISIBLE);
                    }
                }
                if (gameMode.equals("1-Bull") && segment < 25) {
                    if (segment == 20) {
                        buttonSelect(25, roundtclock.this).setVisibility(View.VISIBLE);
                    } else {
                        buttonSelect(segment + 1, roundtclock.this).setVisibility(View.VISIBLE);
                    }
                }
                if (gameMode.equals("Bull-1")) {
                    switch (segment) {
                        case 0:
                            buttonSelect(25, roundtclock.this).setVisibility(View.VISIBLE);
                            break;
                        case 25:
                            buttonSelect(20, roundtclock.this).setVisibility(View.VISIBLE);
                            break;
                        default:
                            buttonSelect(segment - 1, roundtclock.this).setVisibility(View.VISIBLE);
                            break;
                    }
                }

            }
            darts.setText(s);
            ConstraintLayout cl = findViewById(R.id.matchbereich);
            ConstraintSet csdart = new ConstraintSet();
            csdart.clone(cl);
            csdart.connect(darts.getId(), ConstraintSet.END, textfield(1, activePlayerIndex, 3, roundtclock.this).getId(), ConstraintSet.END);
            csdart.connect(darts.getId(), ConstraintSet.START, textfield(1, activePlayerIndex, 3, roundtclock.this).getId(), ConstraintSet.START);
            csdart.applyTo(cl);
        }
    };


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (MainActivity.themeSelected && MainActivity.subDesignChoice)
            setTheme(R.style.AppThemeBlack);
        else if (MainActivity.themeSelected) setTheme(R.style.AppThemeDark);
        else setTheme(R.style.Theme_AppCompat_Light_NoActionBar);
        setContentView(R.layout.activity_roundtclock);
        TypedValue outValue = new TypedValue();
        roundtclock.this.getTheme().resolveAttribute(R.attr.colorButtonNormal, outValue, true);
        bcolor = outValue.data;
        roundtclock.this.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        bcolorn = outValue.data;
        Button doubleb = findViewById(R.id.doubleButton);
        Button tripleb = findViewById(R.id.tripleButton);
        doubleb.setBackgroundColor(bcolorn);        // workaround for low api version (15)
        tripleb.setBackgroundColor(bcolorn);        // workaround for low api version (15)
        SharedPreferences settings = getApplicationContext().getSharedPreferences("preferences", 0);
        if (settings.contains("changetime")) changeTime = settings.getInt("changetime", 1500);
        ConstraintLayout main = findViewById(R.id.matchbereich);
        if (settings.contains("keepscreenongame"))
            main.setKeepScreenOn(settings.getBoolean("keepscreenongame", true));
        TextView p1name = findViewById(R.id.p1name);
        TextView p2name = findViewById(R.id.p2name);
        textColorActive = p1name.getCurrentTextColor();
        textColorPassive = p2name.getCurrentTextColor();
        textSizePassive = p2name.getTextSize();
        textSizeActive = textSizePassive + 4;
        textfield(1, 1, 3, this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeActive);
        textfield(1, 1, 2, this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeActive);
        TextView darts = findViewById(R.id.darts);
        ConstraintSet csdart = new ConstraintSet();
        csdart.clone(main);
        csdart.connect(darts.getId(), ConstraintSet.END, R.id.p1name, ConstraintSet.END);
        csdart.connect(darts.getId(), ConstraintSet.START, R.id.p1name, ConstraintSet.START);
        csdart.applyTo(main);
        Intent intent = getIntent();
        playerCount = Integer.parseInt(Objects.requireNonNull(intent.getStringExtra("playerCount")));
        gameMode = intent.getCharSequenceExtra("gameMode");
        gameVariant = intent.getCharSequenceExtra("gameVariant");
        if (gameVariant != null)
            if (gameVariant.equals(getResources().getString(R.string.once))) {
                gameVariantAsInt = 1;
            } else if (gameVariant.equals(getResources().getString(R.string.twice))) {
                gameVariantAsInt = 2;
            } else if (gameVariant.equals(getResources().getString(R.string.threeTimes))) {
                gameVariantAsInt = 3;
            }
        CharSequence player1n = intent.getCharSequenceExtra("player1");
        CharSequence player2n = intent.getCharSequenceExtra("player2");
        CharSequence player3n = intent.getCharSequenceExtra("player3");
        CharSequence player4n = intent.getCharSequenceExtra("player4");
        CharSequence player5n = intent.getCharSequenceExtra("player5");
        CharSequence player6n = intent.getCharSequenceExtra("player6");
        CharSequence player7n = intent.getCharSequenceExtra("player7");
        CharSequence player8n = intent.getCharSequenceExtra("player8");
        player s1 = new player();
        player s2 = new player();
        player s3 = new player();
        player s4 = new player();
        player s5 = new player();
        player s6 = new player();
        player s7 = new player();
        player s8 = new player();
        player[1] = s1;
        player[2] = s2;
        player[3] = s3;
        player[4] = s4;
        player[5] = s5;
        player[6] = s6;
        player[7] = s7;
        player[8] = s8;
        for (int i = 1; i <= playerCount; i++) player[i].score = 0;
        assert player1n != null;
        player[1].playerName = player1n.toString();
        assert player2n != null;
        player[2].playerName = player2n.toString();
        assert player3n != null;
        player[3].playerName = player3n.toString();
        assert player4n != null;
        player[4].playerName = player4n.toString();
        assert player5n != null;
        player[5].playerName = player5n.toString();
        assert player6n != null;
        player[6].playerName = player6n.toString();
        assert player7n != null;
        player[7].playerName = player7n.toString();
        assert player8n != null;
        player[8].playerName = player8n.toString();
        TextView p3name = findViewById(R.id.p3name);
        TextView p4name = findViewById(R.id.p4name);
        TextView p5name = findViewById(R.id.p5name);
        TextView p6name = findViewById(R.id.p6name);
        TextView p7name = findViewById(R.id.p7name);
        TextView p8name = findViewById(R.id.p8name);
        TextView p2score = findViewById(R.id.p2score);
        TextView p3score = findViewById(R.id.p3score);
        TextView p4score = findViewById(R.id.p4score);
        TextView p5score = findViewById(R.id.p5score);
        TextView p6score = findViewById(R.id.p6score);
        TextView p7score = findViewById(R.id.p7score);
        TextView p8score = findViewById(R.id.p8score);

        p1name.setText(player[1].playerName);
        p2name.setVisibility(View.GONE);
        p3name.setVisibility(View.GONE);
        p4name.setVisibility(View.GONE);
        p5name.setVisibility(View.GONE);
        p6name.setVisibility(View.GONE);
        p7name.setVisibility(View.GONE);
        p8name.setVisibility(View.GONE);
        p2score.setVisibility(View.GONE);
        p3score.setVisibility(View.GONE);
        p4score.setVisibility(View.GONE);
        p5score.setVisibility(View.GONE);
        p6score.setVisibility(View.GONE);
        p7score.setVisibility(View.GONE);
        p8score.setVisibility(View.GONE);
        switch (playerCount) {
            case 8:
                p8score.setVisibility(View.VISIBLE);
                p8name.setVisibility(View.VISIBLE);
                p8name.setText(player[8].playerName);
            case 7:
                p7score.setVisibility(View.VISIBLE);
                p7name.setVisibility(View.VISIBLE);
                p7name.setText(player[7].playerName);
            case 6:
                p6score.setVisibility(View.VISIBLE);
                p6name.setVisibility(View.VISIBLE);
                p6name.setText(player[6].playerName);
            case 5:
                p5score.setVisibility(View.VISIBLE);
                p5name.setVisibility(View.VISIBLE);
                p5name.setText(player[5].playerName);
            case 4:
                p4score.setVisibility(View.VISIBLE);
                p4name.setVisibility(View.VISIBLE);
                p4name.setText(player[4].playerName);
            case 3:
                p3name.setVisibility(View.VISIBLE);
                p3score.setVisibility(View.VISIBLE);
                p3name.setText(player[3].playerName);
            case 2:
                p2name.setVisibility(View.VISIBLE);
                p2score.setVisibility(View.VISIBLE);
                p2name.setText(player[2].playerName);
        }
        Button b1 = findViewById(R.id.b1);
        Button b2 = findViewById(R.id.b2);
        Button b3 = findViewById(R.id.b3);
        Button b4 = findViewById(R.id.b4);
        Button b5 = findViewById(R.id.b5);
        Button b6 = findViewById(R.id.b6);
        Button b7 = findViewById(R.id.b7);
        Button b8 = findViewById(R.id.b8);
        Button b9 = findViewById(R.id.b9);
        Button b10 = findViewById(R.id.b10);
        Button b11 = findViewById(R.id.b11);
        Button b12 = findViewById(R.id.b12);
        Button b13 = findViewById(R.id.b13);
        Button b14 = findViewById(R.id.b14);
        Button b15 = findViewById(R.id.b15);
        Button b16 = findViewById(R.id.b16);
        Button b17 = findViewById(R.id.b17);
        Button b18 = findViewById(R.id.b18);
        Button b19 = findViewById(R.id.b19);
        Button b20 = findViewById(R.id.b20);
        Button bull = findViewById(R.id.bull);
        Button bmissed = findViewById(R.id.missedButton);
        Button bcontinue = findViewById(R.id.continueButton);
        Button bundo = findViewById(R.id.undoButton);
        b1.setOnClickListener(buttonclick);
        b2.setOnClickListener(buttonclick);
        b3.setOnClickListener(buttonclick);
        b4.setOnClickListener(buttonclick);
        b5.setOnClickListener(buttonclick);
        b6.setOnClickListener(buttonclick);
        b7.setOnClickListener(buttonclick);
        b8.setOnClickListener(buttonclick);
        b9.setOnClickListener(buttonclick);
        b10.setOnClickListener(buttonclick);
        b11.setOnClickListener(buttonclick);
        b12.setOnClickListener(buttonclick);
        b13.setOnClickListener(buttonclick);
        b14.setOnClickListener(buttonclick);
        b15.setOnClickListener(buttonclick);
        b16.setOnClickListener(buttonclick);
        b17.setOnClickListener(buttonclick);
        b18.setOnClickListener(buttonclick);
        b19.setOnClickListener(buttonclick);
        b20.setOnClickListener(buttonclick);
        bmissed.setOnClickListener(buttonclick);
        bcontinue.setOnClickListener(continueClick);
        bull.setOnClickListener(buttonclick);
        bundo.setOnClickListener(undoclick);
        tripleb.setOnClickListener(doubletripleClick);
        doubleb.setOnClickListener(doubletripleClick);
        b1.setVisibility(View.GONE);
        b2.setVisibility(View.GONE);
        b3.setVisibility(View.GONE);
        b4.setVisibility(View.GONE);
        b5.setVisibility(View.GONE);
        b6.setVisibility(View.GONE);
        b7.setVisibility(View.GONE);
        b8.setVisibility(View.GONE);
        b9.setVisibility(View.GONE);
        b10.setVisibility(View.GONE);
        b11.setVisibility(View.GONE);
        b12.setVisibility(View.GONE);
        b13.setVisibility(View.GONE);
        b14.setVisibility(View.GONE);
        b15.setVisibility(View.GONE);
        b16.setVisibility(View.GONE);
        b17.setVisibility(View.GONE);
        b18.setVisibility(View.GONE);
        b19.setVisibility(View.GONE);
        b20.setVisibility(View.GONE);
        bull.setVisibility(View.GONE);
        if (gameMode.equals("1-20") || gameMode.equals("1-Bull")) {
            b1.setVisibility(View.VISIBLE);
        }
        if (gameMode.equals("20-1")) {
            b20.setVisibility(View.VISIBLE);
        }
        if (gameMode.equals("Bull-1")) {
            bull.setVisibility(View.VISIBLE);
        }
        findViewById(android.R.id.content).invalidate();
        startTime = System.currentTimeMillis();
        findViewById(R.id.scoreThrown).setOnClickListener(scoreThrownTVClick);
    }


    private boolean winner(int activePlayer) {
        int finishSegment = 0;
        if (gameMode.equals("Bull-1") || gameMode.equals("20-1")) {
            finishSegment = 1;
        }
        if  (gameMode.equals("1-20")) {
            finishSegment = 20;
        }
        if (gameMode.equals("1-Bull")) {
            finishSegment = 25;
        }
        return player[activePlayer].hits[finishSegment] == gameVariantAsInt;
    }

    public void onBackPressed() {
        AlertDialog alertDialog = new AlertDialog.Builder(roundtclock.this).create();
        alertDialog.setTitle(getResources().getString(R.string.caution));
        alertDialog.setMessage(getResources().getString(R.string.quitMatch));
        alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yesIDo),
                (dialog, which) -> {
                    dialog.dismiss();
                    finish();
                });
        alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.returnToMatch), (dialog, which) -> dialog.dismiss());
        alertDialog.show();
    }

    private static class player {
        final int[] hits = new int[26]; // index 25 means count of bull hits, otherwise 10-20, at crazy cricket probably more
        String playerName;
        int score;
        int dartsThrown;
        int ranking;
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(dc_modules.updateBaseContextLocale(base));
    }

    private final View.OnClickListener scoreThrownTVClick = v -> {
        findViewById(R.id.scoreThrown).setVisibility(View.INVISIBLE);
        buttonfreeze(false, this);
    };
}

