package com.DartChecker;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SwitchCompat;
import androidx.constraintlayout.widget.ConstraintLayout;
import android.os.Bundle;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Locale;

public class preferences extends AppCompatActivity {

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(dc_modules.updateBaseContextLocale(base));
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        final SharedPreferences settings = getSharedPreferences("preferences", 0);
        SharedPreferences.Editor editor = settings.edit();
        boolean darktheme = true,
                stylecolor = true,
                setlegMode = true,
                inputmode = false,
                suddendeathmode = false,
                gameContinues = false;
        if (settings.contains("Theme")) darktheme = settings.getBoolean("Theme", true);
        if (settings.contains("Style")) stylecolor = settings.getBoolean("Style", true);
        if (darktheme && stylecolor) setTheme(R.style.AppThemeBlack);
            else if (darktheme) setTheme(R.style.AppThemeDark);
                else setTheme(R.style.Theme_AppCompat_Light_NoActionBar);
        setContentView(R.layout.activity_preferences);
        ConstraintLayout main = findViewById(R.id.mainlayoutContent);
        if (settings.contains("keepscreenonmenu")) main.setKeepScreenOn(settings.getBoolean("keepscreenonmenu",true));
        final SwitchCompat setmode = findViewById(R.id.slmode);
        final SwitchCompat themes = findViewById(R.id.themeswitch);
        final SwitchCompat style = findViewById(R.id.themeswitchsubcolor);
        TextView changetime = findViewById(R.id.milliseconds);
        final TextView dartcount = findViewById(R.id.dartCount);
        TextView crazyStart = findViewById(R.id.crazystartsegment);
        final SwitchCompat inputmethod = findViewById(R.id.inputmethode);
        final SwitchCompat suddendeath = findViewById(R.id.suddendeath);
        final SwitchCompat gameContinuesSwitch = findViewById(R.id.cricketNoStop);
        final SwitchCompat undoSafetyQuestion = findViewById(R.id.undoSafety);
        final SwitchCompat keepScreenOnGame = findViewById(R.id.keepscreenongame);
        final SwitchCompat keepScreenOnMenu = findViewById(R.id.keepscreenonmenu);
        final SwitchCompat playaudio = findViewById(R.id.playaudio);
        int dartCount = 0;
        if (settings.contains("crazystart"))
            crazyStart.setText(String.format(Integer.toString(settings.getInt("crazystart", 6))));
        if (settings.contains("changetime"))
            changetime.setText(String.format(Integer.toString(settings.getInt("changetime", 1500))));
        if (settings.contains("setlegmode")) setlegMode = settings.getBoolean("setlegmode", true);
        setmode.setChecked(setlegMode);
        if (setlegMode) {
            setmode.setText(getResources().getString(R.string.setlegmodefirstto));
        } else {
            setmode.setText(getResources().getString(R.string.setlegmodebestof));
        }
        themes.setChecked(darktheme);
        if (darktheme) {
            themes.setText(getResources().getString(R.string.designDark));
            style.setEnabled(true);
        } else {
            themes.setText(getResources().getString(R.string.designLight));
            style.setEnabled(false);
        }
        style.setChecked(stylecolor);
        if (stylecolor) {
            style.setText(getResources().getString(R.string.subdesignBlack));
        }
        else {
            style.setText(getResources().getString(R.string.subdesignGrey));
        }
        if (settings.contains("inputmethode"))
            inputmode = settings.getBoolean("inputmethode", false);
        inputmethod.setChecked(inputmode);
        if (inputmode) {
            inputmethod.setText(getResources().getString(R.string.inputmode3dart));
        } else {
            inputmethod.setText(getResources().getString(R.string.inputmode1dart));
        }
        if (settings.contains("suddendeath"))
            suddendeathmode = settings.getBoolean("suddendeath", false);
        suddendeath.setChecked(suddendeathmode);
        if (settings.contains("sddarts")) dartCount = settings.getInt("sddarts", 20);
        dartcount.setText(String.format(Integer.toString(dartCount)));
        dartcount.setEnabled(suddendeath.isChecked());
        if (settings.contains("gameContinues"))
            gameContinues = settings.getBoolean("gameContinues", false);
        gameContinuesSwitch.setChecked(gameContinues);
        ArrayList<String> languages = new ArrayList<>();
        languages.add(getResources().getString(R.string.system));
        languages.add("Deutsch");
        languages.add("English");
        languages.add("Español");
        languages.add("Français");
        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<>(
                preferences.this,
                R.layout.spinner_item_head, languages);
        arrayAdapter.setDropDownViewResource(R.layout.support_simple_spinner_dropdown_item);
        final Spinner languageSpinner = findViewById(R.id.language);
        languageSpinner.setAdapter(arrayAdapter);
        ArrayList<String> segments = new ArrayList<>();
        for (int i = 0; i <= 20; i++) {
            segments.add(String.valueOf(i));
        }
        segments.add("25");
        ArrayAdapter<String> arrayAdapterseg = new ArrayAdapter<>(
                preferences.this,
                R.layout.spinner_item_head, segments);
        arrayAdapterseg.setDropDownViewResource(R.layout.support_simple_spinner_dropdown_item);
        final Spinner favoriteCheckout = findViewById(R.id.finishNumber);
        favoriteCheckout.setAdapter(arrayAdapterseg);
        int favoriteCheckoutSegment = 0;
        if (settings.contains("Checkoutzahl"))  favoriteCheckoutSegment = settings.getInt("Checkoutzahl",0);
        if (favoriteCheckoutSegment == 25) favoriteCheckout.setSelection(21); else favoriteCheckout.setSelection(favoriteCheckoutSegment);  //index!=checkoutwunsch
        if (settings.contains("languageNumber")) languageSpinner.setSelection(settings.getInt("languageNumber", 0));
        if (settings.contains("undoSafetyQuestion"))
            undoSafetyQuestion.setChecked(settings.getBoolean("undoSafetyQuestion", false));
        if (settings.contains("keepscreenongame"))
            keepScreenOnGame.setChecked(settings.getBoolean("keepscreenongame",true));
        if (settings.contains("keepscreenonmenu"))
            keepScreenOnMenu.setChecked(settings.getBoolean("keepscreenonmenu", false));
        if (settings.contains("playaudio")) playaudio.setChecked(settings.getBoolean("playaudio",true));
        favoriteCheckout.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int position, long l) {
                editor.putInt("Checkoutzahl", Integer.parseInt(favoriteCheckout.getSelectedItem().toString()));
                editor.apply();
            }
            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });

        languageSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View v, int position, long id) {
                String language_code = "en";
                switch (position) {
                    case 0:
                        language_code = settings.getString("SystemSprache", language_code);
                        break;
                    case 1:
                        language_code = "de";
                        break;
                    case 2:
                        language_code = "en";
                        break;
                    case 3:
                        language_code = "es";
                        break;
                    case 4:
                        language_code = "fr";
                        break;
                }
                editor.putString("language", language_code);
                editor.putInt("languageNumber", position);
                editor.apply();
                if (settings.contains("language")) {
                    if (!(language_code.equals(Locale.getDefault().getLanguage()))) {
                        // Sprache aktualisieren durch Neustart der activity
                        Intent intent = getIntent();
                        finish();
                        startActivity(intent);
                    }
                }

            }

            @Override
            public void onNothingSelected(AdapterView<?> AdapterView) {
            }

        });

        keepScreenOnMenu.setOnCheckedChangeListener((compoundButton, b) -> {
            editor.putBoolean("keepscreenonmenu", keepScreenOnMenu.isChecked());
            editor.apply();
        });

        keepScreenOnGame.setOnCheckedChangeListener((compoundButton, b) -> {
            editor.putBoolean("keepscreenongame", keepScreenOnGame.isChecked());
            editor.apply();
        });

        undoSafetyQuestion.setOnCheckedChangeListener((buttonView, isChecked) -> {
            editor.putBoolean("undoSafetyQuestion", undoSafetyQuestion.isChecked());
            editor.apply();
        });

        themes.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                themes.setText(getResources().getString(R.string.designDark));
                style.setEnabled(true);
            } else {
                themes.setText(getResources().getString(R.string.designLight));
                style.setEnabled(false);
            }
            editor.putBoolean("Theme", themes.isChecked());
            editor.apply();
            // restart preferences activity
            Intent intent = getIntent();
            finish();
            startActivity(intent);
        });
        findViewById(R.id.appBarLayout).requestFocus();

        style.setOnCheckedChangeListener((compoundButton, b) -> {
            if (style.isChecked()) {
                style.setText(getResources().getString(R.string.subdesignBlack));
            } else {
                style.setText(getResources().getString(R.string.subdesignGrey));
            }
            editor.putBoolean("Style", style.isChecked());
            editor.apply();
            Intent intent = getIntent();
            finish();
            startActivity(intent);
        });

        playaudio.setOnCheckedChangeListener((compoundButton, b) -> {
            editor.putBoolean("playaudio", playaudio.isChecked());
            editor.apply();
        });

        setmode.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                setmode.setText(getResources().getString(R.string.setlegmodefirstto));
            } else setmode.setText(getResources().getString(R.string.setlegmodebestof));

            editor.putBoolean("setlegmode", setmode.isChecked());
            editor.apply();
        });

        inputmethod.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                inputmethod.setText(getResources().getString(R.string.inputmode3dart));
            } else inputmethod.setText(getResources().getString(R.string.inputmode1dart));

            editor.putBoolean("inputmethode", inputmethod.isChecked());
            editor.apply();
        });

        suddendeath.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                dartcount.setEnabled(true);
                Toast.makeText(getApplicationContext(), getResources().getString(R.string.suddenDeathHint), Toast.LENGTH_LONG).show();
            } else dartcount.setEnabled(false);
            editor.putBoolean("suddendeath", suddendeath.isChecked());
            editor.apply();
        });

        gameContinuesSwitch.setOnCheckedChangeListener((buttonView, isChecked) -> {
            editor.putBoolean("gameContinues", gameContinuesSwitch.isChecked());
            editor.apply();
        });

        final Button ok = findViewById(R.id.okb2);
        ok.setOnClickListener(v -> onBackPressed());


        crazyStart.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_DONE) {
                // input beetwen 1 and 13?
                try {
                    if ((crazyStart.getText().toString().isEmpty()) || (Integer.parseInt(crazyStart.getText().toString()) < 1) || (Integer.parseInt(crazyStart.getText().toString()) > 13) ) {
                        Toast.makeText(preferences.this, getResources().getString(R.string.range), Toast.LENGTH_LONG).show();
                        return true;
                    }
                } catch (Exception e) {
                }
            }
            return false;
        });
    }

    public void onBackPressed() {
        //safe number inputs
        TextView milliseconds = findViewById(R.id.milliseconds);
        TextView dartCount = findViewById(R.id.dartCount);
        TextView crazystart = findViewById(R.id.crazystartsegment);
        Spinner finishNumber = findViewById(R.id.finishNumber);
        SharedPreferences settings = getSharedPreferences("preferences", 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt("changetime", Integer.parseInt(milliseconds.getText().toString()));
        editor.putInt("sddarts", Integer.parseInt(dartCount.getText().toString()));
        editor.putInt("crazystart", Integer.parseInt(crazystart.getText().toString()));
        editor.putInt("Checkoutzahl",Integer.parseInt(finishNumber.getSelectedItem().toString()));
        editor.apply();
        finish();
    }
}
