package com.DartChecker;

import static android.widget.Toast.LENGTH_LONG;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SwitchCompat;
import androidx.constraintlayout.widget.ConstraintLayout;
import org.jsefa.csv.annotation.CsvDataType;
import org.jsefa.csv.annotation.CsvField;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;


public class MainActivity extends AppCompatActivity {
    public static ArrayList<player> allPlayers;
    public String LanguageAtStart;
    public static boolean themeSelected = true,
                          firstTo = true,
                          subDesignChoice = true;
    private ArrayAdapter<player> arrayAdapter;
    private static int maxNumberOfPlayer = 8;
    private static final String saveFileName = "spieler.dat";
    private int maxlegs = 5,
                maxsets = 13;

    public static void saveAllDataToDisk(Context ctx, Boolean doNotSave) {
        if (doNotSave) return;
        try {
            FileOutputStream fout = ctx.openFileOutput(saveFileName, Context.MODE_PRIVATE);
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(allPlayers);
            oos.flush();
            oos.close();  // fileoutputstream is closed automatically
        } catch (FileNotFoundException e) {
            Toast.makeText(ctx, e + "Error saving: file not found", LENGTH_LONG).show();
        } catch (IOException i) {
            Toast.makeText(ctx, i + "Error saving: Input/Output", LENGTH_LONG).show();
        }
    }

    private void loadDataFromDisk() {
        try {
            FileInputStream fis = openFileInput(saveFileName);
            byte[] firstBytes = new byte[100];
            fis.read(firstBytes);
            fis.close(); //reset stream
            fis = openFileInput(saveFileName);
            ObjectInputStream is = new ObjectInputStream(fis);
            if (new String(firstBytes, StandardCharsets.UTF_8).contains("MainActivity$spieler")) {
                // import old data format and migrate to new one
                ArrayList<MainActivity.spieler> oldList = new ArrayList<>();
                try {
                    for (Object object : (Collection<?>) is.readObject())
                        if (object instanceof MainActivity.spieler) {
                            oldList.add((MainActivity.spieler) object);
                        }
                    is.close();
                    assert fis != null;
                    fis.close();
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!oldList.isEmpty()) {
                    allPlayers = dc_modules.migrateSavedData(oldList);
                    saveAllDataToDisk(this, false);
                }
            }
            else {
                // import standart/new data format
                ArrayList<player> returnlist = new ArrayList<>();
                for (Object object: (Collection<?>) is.readObject())
                    if (object instanceof player) {
                        returnlist.add((player) object);
                    }
                is.close();
                fis.close();
                allPlayers = returnlist;
            }
        } catch (FileNotFoundException e) {
            Toast.makeText(this, e + "Error loading: file not found", LENGTH_LONG).show();
        } catch (ClassNotFoundException b) {
            Toast.makeText(this, b + "Error loading: class not found", LENGTH_LONG).show();
        } catch (IOException i) {
            Toast.makeText(this, i + "Error loading: Input/Output", LENGTH_LONG).show();
        }
    }


    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(dc_modules.updateBaseContextLocale(base));
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        final SharedPreferences settings = getSharedPreferences("preferences", 0);
        if (settings.contains("language")) {
            LanguageAtStart = settings.getString("language", "en");
        } else {
            SharedPreferences.Editor editor = settings.edit();
            editor.putString("SystemSprache", Locale.getDefault().getLanguage());
            editor.apply();
        }
        if (settings.contains("Theme")) themeSelected = settings.getBoolean("Theme", true);
        if (settings.contains("Style")) subDesignChoice = settings.getBoolean("Style", true);
        if (themeSelected && subDesignChoice) setTheme(R.style.AppThemeBlack);
        else if (themeSelected) setTheme(R.style.AppThemeDark);
        else setTheme(R.style.Theme_AppCompat_Light_NoActionBar);
        setContentView(R.layout.activity_main);
        ConstraintLayout main = findViewById(R.id.layer1);
        if (settings.contains("keepscreenonmenu")) main.setKeepScreenOn(settings.getBoolean("keepscreenonmenu",true));

        List<String> gameTypesTexts = Arrays.asList("X01", "FREE", "SET/LEG", "CRICKET","ELIMINATION", "HALVE IT", "ROUNDtCLOCK");
        List<String> gameModesCricket = Arrays.asList("15-Bull", "14-Bull", "13-Bull", "12-Bull", "11-Bull", "10-Bull", "Crazy");
        List<String> gameModesRoundtclock = Arrays.asList("1-Bull", "1-20", "Bull-1", "20-1");
        List<String> gamesModesHalveit = Arrays.asList("15-Bull", "Random", "Crazy");
        final CharSequence[] cricketVariants = {"Classic", "Cut Throat"};
        final CharSequence[] roundtclockVariants = {getResources().getString(R.string.once), getResources().getString(R.string.twice), getResources().getString(R.string.threeTimes)};
        final CharSequence[] x01GameModes = {"301", "501"};
        final CharSequence[] cricketModes = gameModesCricket.toArray(new CharSequence[gameModesCricket.size()]);
        final CharSequence[] roundtclockModes = gameModesRoundtclock.toArray(new CharSequence[gameModesRoundtclock.size()]);
        final CharSequence[] halveitModes = gamesModesHalveit.toArray((new CharSequence[gamesModesHalveit.size()]));

        if (settings.contains("setlegmode"))
            firstTo = settings.getBoolean("setlegmode", true);
        if (firstTo) {
            maxlegs = 3;
            maxsets = 7;
        }

        allPlayers = new ArrayList<>();
        // if player data already exists, load it, else create 8 new player and save them
        File saveFile = getBaseContext().getFileStreamPath(saveFileName);
        if (saveFile.exists()) {
            loadDataFromDisk();
        } else {
            player guest1 = new player();
            player guest2 = new player();
            player guest3 = new player();
            player guest4 = new player();
            player guest5 = new player();
            player guest6 = new player();
            player guest7 = new player();
            player guest8 = new player();
            guest1.playerName = getResources().getString(R.string.guest1);
            guest2.playerName = getResources().getString(R.string.guest2);
            guest3.playerName = getResources().getString(R.string.guest3);
            guest4.playerName = getResources().getString(R.string.guest4);
            guest5.playerName = getResources().getString(R.string.guest5);
            guest6.playerName = getResources().getString(R.string.guest6);
            guest7.playerName = getResources().getString(R.string.guest7);
            guest8.playerName = getResources().getString(R.string.guest8);
            allPlayers.add(guest1);
            allPlayers.add(guest2);
            allPlayers.add(guest3);
            allPlayers.add(guest4);
            allPlayers.add(guest5);
            allPlayers.add(guest6);
            allPlayers.add(guest7);
            allPlayers.add(guest8);
            // todo: is "true" a bug? if not -> delete following line
            saveAllDataToDisk(this,true);
        }
        // deploy playerlists
        arrayAdapter = new ArrayAdapter<>(MainActivity.this, R.layout.spinner_item_head, allPlayers);
        arrayAdapter.setDropDownViewResource(R.layout.support_simple_spinner_dropdown_item);
        final Spinner player1spinner = findViewById(R.id.player1spinner);
        final Spinner player2spinner = findViewById(R.id.player2spinner);
        final Spinner player3spinner = findViewById(R.id.player3spinner);
        final Spinner player4spinner = findViewById(R.id.player4spinner);
        final Spinner player5spinner = findViewById(R.id.player5spinner);
        final Spinner player6spinner = findViewById(R.id.player6spinner);
        final Spinner player7spinner = findViewById(R.id.player7spinner);
        final Spinner player8spinner = findViewById(R.id.player8spinner);
        player1spinner.setAdapter(arrayAdapter);
        player2spinner.setAdapter(arrayAdapter);
        player3spinner.setAdapter(arrayAdapter);
        player4spinner.setAdapter(arrayAdapter);
        player5spinner.setAdapter(arrayAdapter);
        player6spinner.setAdapter(arrayAdapter);
        player7spinner.setAdapter(arrayAdapter);
        player8spinner.setAdapter(arrayAdapter);

        // populate spinner with adapter
        ArrayList<Integer> numberOfPlayerArrayList = new ArrayList<>();
        for (int icount = 1; icount <= maxNumberOfPlayer; icount++) {
            numberOfPlayerArrayList.add(icount);
        }
        ArrayAdapter<Integer> numberOfPlayerArrayAdapter = new ArrayAdapter<>(MainActivity.this,R.layout.spinner_item_head_playercount,numberOfPlayerArrayList);
        final Spinner numberOfPlayerSpinner = findViewById(R.id.playerCountSpinner);
        numberOfPlayerSpinner.setAdapter(numberOfPlayerArrayAdapter);

        ArrayList<String> gametypArraylist = new ArrayList<>(gameTypesTexts);
        ArrayAdapter<String> gametypArrayAdapter = new ArrayAdapter<>(MainActivity.this, R.layout.spinner_item_head_playercount,gametypArraylist);
        final Spinner gametypSpinner = findViewById(R.id.gameTypSpinner);
        gametypSpinner.setAdapter(gametypArrayAdapter);

        ArrayList<String> gamemodeArraylist = new ArrayList<>(gameModesCricket);
        ArrayAdapter<String> gamemodeArray = new ArrayAdapter<>(MainActivity.this, R.layout.spinner_item_head_playercount,gamemodeArraylist);
        final Spinner gamemodeSpinner = findViewById(R.id.gameModeSpinner);
        gamemodeSpinner.setAdapter(gamemodeArray);

        final Button playerlist = findViewById(R.id.playerListMenuButton);
        final Button gamemodeButton = findViewById(R.id.gamemode);
        final int x01variants = x01GameModes.length;
        final Button gametypButton = findViewById(R.id.gameTyp);
        final SwitchCompat doubleout = findViewById(R.id.doubleout);
        final SwitchCompat masterout = findViewById(R.id.masterout);
        final SwitchCompat doublein = findViewById(R.id.doublein);
        final SwitchCompat masterin = findViewById(R.id.masterin);
        final EditText input = findViewById(R.id.inputFREE);
        final Button numberOfPlayer = findViewById(R.id.playerCountButton);
        final Button startButton = findViewById(R.id.startButton);
        final Button exchangeButton = findViewById(R.id.exchangeButton);
        final Button exchangeAllButton = findViewById(R.id.exchangeAllButton);
        final ImageButton statisticButton = findViewById(R.id.statisticButton);
        final ImageButton preferencesButton = findViewById(R.id.settingsButton);
        final TextView settext = findViewById(R.id.setText);
        final TextView legtext = findViewById(R.id.legCaption);
        final Button sets = findViewById(R.id.sets);
        final Button legs = findViewById(R.id.legs);
        final TextView player2text = findViewById(R.id.player2text);
        final TextView player3text = findViewById(R.id.player3text);
        final TextView player4text = findViewById(R.id.player4text);
        final TextView player5text = findViewById(R.id.player5text);
        final TextView player6text = findViewById(R.id.player6text);
        final TextView player7text = findViewById(R.id.player7text);
        final TextView player8text = findViewById(R.id.player8text);
        final Button cricketVariantButton = findViewById(R.id.cricketVariantButton);
        final TextView cricketmodetext = findViewById(R.id.cricketModeCaption);
        final Button randomButtom = findViewById(R.id.randomGame);
        final ConstraintLayout touchlayout = findViewById(R.id.touchlayer);

        //setanzahl wechseln bei touch
        sets.setOnClickListener(v -> {
            int setCountSelection = Integer.parseInt(sets.getText().toString());
            if (setCountSelection == maxsets)
                setCountSelection = 1;
            else {
                setCountSelection++;
                if (!firstTo && setCountSelection % 2 == 0) setCountSelection++;
                if (setCountSelection > maxsets) setCountSelection = 1;
            }
            sets.setText(String.valueOf(setCountSelection));
        });


        // change leg count on touch
        legs.setOnClickListener(v -> {
            int legCountSelection = Integer.parseInt(legs.getText().toString());
            if (legCountSelection == maxlegs)
                legCountSelection = 1;
            else {
                legCountSelection++;
                if (!firstTo && legCountSelection % 2 == 0) legCountSelection++;
                if (legCountSelection > maxlegs) legCountSelection = 1;
            }
            legs.setText(String.valueOf(legCountSelection));
        });


        // change suitable gamemode on touch
        gamemodeButton.setOnClickListener(v -> {
            String gametyp = gametypButton.getText().toString();
            switch (gametyp) {
                case "FREE":
                    if (input.getVisibility() == View.INVISIBLE) {
                        input.setText(gamemodeButton.getText());
                        numberOfPlayer.setEnabled(false);
                        gamemodeButton.setEnabled(false);
                        gametypButton.setEnabled(false);
                        player1spinner.setEnabled(false);
                        player2spinner.setEnabled(false);
                        player3spinner.setEnabled(false);
                        player4spinner.setEnabled(false);
                        player5spinner.setEnabled(false);
                        player6spinner.setEnabled(false);
                        player7spinner.setEnabled(false);
                        player8spinner.setEnabled(false);
                        startButton.setEnabled(false);
                        statisticButton.setEnabled(false);
                        exchangeButton.setEnabled(false);
                        exchangeAllButton.setEnabled(false);
                        doubleout.setVisibility(View.INVISIBLE);
                        masterout.setVisibility(View.INVISIBLE);
                        doublein.setVisibility(View.INVISIBLE);
                        masterin.setVisibility(View.INVISIBLE);
                        preferencesButton.setEnabled(false);
                        randomButtom.setVisibility(View.INVISIBLE);
                        touchlayout.setVisibility(View.VISIBLE);
                        input.setVisibility(View.VISIBLE);
                        input.selectAll();
                        // make number-keyboard visible
                        if (input.requestFocus()) {
                            InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                            assert imm != null;
                            imm.showSoftInput(input, InputMethodManager.SHOW_IMPLICIT);
                        }
                    }
                    break;
                case "HALVE IT":
                    gamemodeArraylist.clear();
                    gamemodeArraylist.addAll(gamesModesHalveit);
                    gamemodeSpinner.performClick();
                    break;
                case "CRICKET":
                    gamemodeArraylist.clear();
                    gamemodeArraylist.addAll(gameModesCricket);
                    gamemodeSpinner.performClick();
                    break;
                case "ROUNDtCLOCK":
                    gamemodeArraylist.clear();
                    gamemodeArraylist.addAll(gameModesRoundtclock);
                    gamemodeSpinner.performClick();
                    break;
                default: // X01, ELIMINATION or SET/LEG
                    if (gamemodeButton.getText().equals(x01GameModes[x01variants - 1]))
                        gamemodeButton.setText(x01GameModes[0]);
                    else
                        for (int i = 0; i < x01variants - 1; i++) {
                            if (gamemodeButton.getText().equals(x01GameModes[i])) {
                                gamemodeButton.setText(x01GameModes[i + 1]);
                                break;
                            }
                        }
            }
        });

        // HINT: number of player, game mode and game typ are mostly selected via spinner elements BUT selection is visualised on button elements!


        // change playercount on touch
        numberOfPlayerSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                int selected = Integer.parseInt(numberOfPlayerSpinner.getSelectedItem().toString());
                if (allPlayers.size() < selected) {
                    Toast.makeText(getApplicationContext(), getResources().getString(R.string.notEnoughPlayer), LENGTH_LONG).show();
                    return;
                }
                numberOfPlayer.setText(numberOfPlayerSpinner.getSelectedItem().toString());

                player2text.setVisibility(View.GONE);
                player2spinner.setVisibility(View.GONE);
                player3text.setVisibility(View.GONE);
                player3spinner.setVisibility(View.GONE);
                player4text.setVisibility(View.GONE);
                player4spinner.setVisibility(View.GONE);
                player5text.setVisibility(View.GONE);
                player5spinner.setVisibility(View.GONE);
                player6text.setVisibility(View.GONE);
                player6spinner.setVisibility(View.GONE);
                player7text.setVisibility(View.GONE);
                player7spinner.setVisibility(View.GONE);
                player8text.setVisibility(View.GONE);
                player8spinner.setVisibility(View.GONE);
                exchangeButton.setVisibility(View.INVISIBLE);
                exchangeAllButton.setVisibility(View.INVISIBLE);

                switch (selected){
                    case 8:
                        player8text.setVisibility(View.VISIBLE);
                        player8spinner.setVisibility(View.VISIBLE);
                        if (player8spinner.getSelectedItemPosition()==0) player8spinner.setSelection(7);
                    case 7:
                        player7text.setVisibility(View.VISIBLE);
                        player7spinner.setVisibility(View.VISIBLE);
                        if (player7spinner.getSelectedItemPosition()==0) player7spinner.setSelection(6);
                    case 6:
                        player6text.setVisibility(View.VISIBLE);
                        player6spinner.setVisibility(View.VISIBLE);
                        if (player6spinner.getSelectedItemPosition()==0) player6spinner.setSelection(5);
                    case 5:
                        player5text.setVisibility(View.VISIBLE);
                        player5spinner.setVisibility(View.VISIBLE);
                        if (player5spinner.getSelectedItemPosition()==0) player5spinner.setSelection(4);
                    case 4:
                        player4text.setVisibility(View.VISIBLE);
                        player4spinner.setVisibility(View.VISIBLE);
                        if (player4spinner.getSelectedItemPosition()==0) player4spinner.setSelection(3);
                    case 3:
                        player3text.setVisibility(View.VISIBLE);
                        player3spinner.setVisibility(View.VISIBLE);
                        if (player3spinner.getSelectedItemPosition()==0) player3spinner.setSelection(2);
                        exchangeAllButton.setVisibility(View.VISIBLE);
                    case 2:
                        player2text.setVisibility(View.VISIBLE);
                        player2spinner.setVisibility(View.VISIBLE);
                        if (player2spinner.getSelectedItemPosition()==0) player2spinner.setSelection(1);
                        exchangeButton.setVisibility(View.VISIBLE);
                }

            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });

        // preserve of wrong selection on create
        gamemodeSpinner.setSelection(0,false);
        // change game mode on touch
        gamemodeSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                String selection = gamemodeSpinner.getSelectedItem().toString();
                gamemodeButton.setText(selection);
            }
            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });

        // change depending visual elements on gametyp selection
        gametypSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                int lastPlayersCount = numberOfPlayerSpinner.getLastVisiblePosition()+1;
                numberOfPlayer.setText(Integer.toString(lastPlayersCount));
                numberOfPlayer.setEnabled(true);
                exchangeAllButton.setVisibility(View.VISIBLE);
                // secure correct visual elements if last game typ was set/leg
                switch (lastPlayersCount) {
                    case 8:
                        player8spinner.setVisibility(View.VISIBLE);
                        player8text.setVisibility(View.VISIBLE);
                    case 7:
                        player7spinner.setVisibility(View.VISIBLE);
                        player7text.setVisibility(View.VISIBLE);
                    case 6:
                        player6spinner.setVisibility(View.VISIBLE);
                        player6text.setVisibility(View.VISIBLE);
                    case 5:
                        player5spinner.setVisibility(View.VISIBLE);
                        player5text.setVisibility(View.VISIBLE);
                    case 4:
                        player4spinner.setVisibility(View.VISIBLE);
                        player4text.setVisibility(View.VISIBLE);
                    case 3:
                        player3spinner.setVisibility(View.VISIBLE);
                        player3text.setVisibility(View.VISIBLE);
                        break;
                    case 2:
                        player2spinner.setVisibility(View.VISIBLE);
                        player2text.setVisibility(View.VISIBLE);
                        exchangeButton.setVisibility(View.VISIBLE);
                        exchangeAllButton.setVisibility(View.GONE);
                        break;
                    case 1:
                        exchangeButton.setVisibility(View.GONE);
                        exchangeAllButton.setVisibility(View.GONE);
                        player2spinner.setVisibility(View.GONE);
                        player2text.setVisibility(View.GONE);
                        break;
                }

                settext.setVisibility(View.VISIBLE);
                sets.setVisibility(View.VISIBLE);
                legtext.setVisibility(View.VISIBLE);
                legs.setVisibility(View.VISIBLE);
                settext.setVisibility(View.GONE);
                sets.setVisibility(View.GONE);
                legtext.setVisibility(View.GONE);
                legs.setVisibility(View.GONE);
                doubleout.setEnabled(true);
                masterout.setEnabled(true);
                doublein.setEnabled(true);
                masterin.setEnabled(true);
                cricketVariantButton.setVisibility(View.GONE);
                cricketmodetext.setVisibility(View.GONE);
                String selection = gametypSpinner.getSelectedItem().toString();
                gametypButton.setText(selection);

                switch (selection) {
                    case "FREE":
                        gamemodeButton.setText("170");
                        break;
                    case "SET/LEG":
                        numberOfPlayer.setText("2"); // ignore spinner selection and force 2 player
                        numberOfPlayer.setEnabled(false);
                        exchangeButton.setVisibility(View.VISIBLE);
                        exchangeAllButton.setVisibility(View.GONE);
                        settext.setVisibility(View.VISIBLE);
                        sets.setVisibility(View.VISIBLE);
                        legtext.setVisibility(View.VISIBLE);
                        legs.setVisibility(View.VISIBLE);
                        player2spinner.setVisibility(View.VISIBLE);
                        player2text.setVisibility(View.VISIBLE);
                        player3text.setVisibility(View.GONE);
                        player4text.setVisibility(View.GONE);
                        player5text.setVisibility(View.GONE);
                        player6text.setVisibility(View.GONE);
                        player7text.setVisibility(View.GONE);
                        player8text.setVisibility(View.GONE);
                        player3spinner.setVisibility(View.GONE);
                        player4spinner.setVisibility(View.GONE);
                        player5spinner.setVisibility(View.GONE);
                        player6spinner.setVisibility(View.GONE);
                        player7spinner.setVisibility(View.GONE);
                        player8spinner.setVisibility(View.GONE);
                        gamemodeButton.setText(x01GameModes[0]);
                        break;
                    case "CRICKET":
                        doubleout.setEnabled(false);
                        masterout.setEnabled(false);
                        doublein.setEnabled(false);
                        masterin.setEnabled(false);
                        gamemodeButton.setText(cricketModes[0]);
                        cricketVariantButton.setVisibility(View.VISIBLE);
                        cricketVariantButton.setText(cricketVariants[0]);
                        cricketmodetext.setVisibility(View.VISIBLE);
                        break;
                    case "HALVE IT":
                        doubleout.setEnabled(false);
                        masterout.setEnabled(false);
                        doublein.setEnabled(false);
                        masterin.setEnabled(false);
                        gamemodeButton.setText(halveitModes[0]);
                        break;
                    case "ROUNDtCLOCK":
                        doubleout.setEnabled(false);
                        masterout.setEnabled(false);
                        doublein.setEnabled(false);
                        masterin.setEnabled(false);
                        gamemodeButton.setText(roundtclockModes[0]);
                        cricketVariantButton.setVisibility(View.VISIBLE);
                        cricketVariantButton.setText(roundtclockVariants[0]);
                        cricketmodetext.setVisibility(View.VISIBLE);
                        break;
                    default: // X01, ELIMINATION
                        gamemodeButton.setText(x01GameModes[0]);
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });


        gametypButton.setOnClickListener(v -> gametypSpinner.performClick());

        // cricketvarianten wechseln bei touch
        final int cricketmodevariants = cricketVariants.length;
        final int roundtClockModeVariants = roundtclockVariants.length;
        cricketVariantButton.setOnClickListener(v -> {
            CharSequence aktuell = cricketVariantButton.getText();
            switch (gametypButton.getText().toString()) {
                case "CRICKET":
                    if (aktuell.equals(cricketVariants[cricketmodevariants - 1])) cricketVariantButton.setText(cricketVariants[0]);
                    else
                        for (int i = 0; i < cricketmodevariants - 1; i++) {
                            if (aktuell.equals(cricketVariants[i])) {
                                cricketVariantButton.setText(cricketVariants[i + 1]);
                                break;
                            }
                        }
                    break;
                case "ROUNDtCLOCK":
                    if (aktuell.equals(roundtclockVariants[roundtClockModeVariants - 1])) cricketVariantButton.setText(roundtclockVariants[0]);
                    else
                        for (int i = 0; i < roundtClockModeVariants - 1; i++) {
                            if (aktuell.equals(roundtclockVariants[i])) {
                                cricketVariantButton.setText(roundtclockVariants[i + 1]);
                                break;
                            }
                        }
                    break;
            }
        });


        numberOfPlayer.setOnClickListener(v -> numberOfPlayerSpinner.performClick());


        //exhange button action = switch selected player 1 and player 2
        exchangeButton.setOnClickListener(view -> {
            int tmp = player1spinner.getSelectedItemPosition();
            player1spinner.setSelection(player2spinner.getSelectedItemPosition());
            player2spinner.setSelection(tmp);
        });

        exchangeAllButton.setOnClickListener(view -> {
            int playercount = Integer.parseInt(numberOfPlayer.getText().toString());
            ArrayList<Integer> spinnerpositions = new ArrayList<>();
            Spinner[] playerspinner = {player1spinner, player2spinner, player3spinner, player4spinner, player5spinner, player6spinner, player7spinner, player8spinner};
            // collect selected player
            for (int i = 0; i < playercount; i++) {
                spinnerpositions.add(playerspinner[i].getSelectedItemPosition());
            }
            // reset selected player randomly
            Random rand = new Random();
            int nextrandomposition;
            for (int i = 0; i < playercount; i++) {
                nextrandomposition = rand.nextInt(spinnerpositions.size());
                playerspinner[i].setSelection(spinnerpositions.get(nextrandomposition));
                spinnerpositions.remove(nextrandomposition);
            }

        });

        // startbutton-action
        startButton.setOnClickListener(v -> {
            // same player choosen more than once?
            ArrayList<String> choosen_player = new ArrayList<>();
            choosen_player.add(player1spinner.getSelectedItem().toString());
            choosen_player.add(player2spinner.getSelectedItem().toString());
            choosen_player.add(player3spinner.getSelectedItem().toString());
            choosen_player.add(player4spinner.getSelectedItem().toString());
            choosen_player.add(player5spinner.getSelectedItem().toString());
            choosen_player.add(player6spinner.getSelectedItem().toString());
            choosen_player.add(player7spinner.getSelectedItem().toString());
            choosen_player.add(player8spinner.getSelectedItem().toString());
            int player_for_match = Integer.parseInt(numberOfPlayer.getText().toString())-1;
            for (int choosen = 0; choosen <= player_for_match; choosen++) {
                String cp = choosen_player.get(choosen);
                int indi = choosen_player.indexOf(cp);
                int last = choosen_player.lastIndexOf(cp);
                while (last > player_for_match) {
                    choosen_player.remove(last);
                    last = choosen_player.lastIndexOf(cp);
                }
                if (indi != last && indi <= player_for_match && last <= player_for_match)
                {
                    Toast.makeText(getApplicationContext(), getResources().getString(R.string.playernameTwice), LENGTH_LONG).show();
                    return;
                }
            }

            Intent intent;

            if (gametypButton.getText().equals("CRICKET")) {
                intent = new Intent(MainActivity.this, cricket.class);
                intent.putExtra("gameVariant",cricketVariantButton.getText());

            } else if (gametypButton.getText().equals("ELIMINATION")) {
                intent = new Intent(MainActivity.this, elimination.class);
                intent.putExtra("doubleout", doubleout.isChecked());
                intent.putExtra("masterout", masterout.isChecked());
                intent.putExtra("doublein", doublein.isChecked());
                intent.putExtra("masterin", masterin.isChecked());
            } else  if (gametypButton.getText().equals("HALVE IT")) {
                intent = new Intent(MainActivity.this, halve.class);
            } else if (gametypButton.getText().equals("ROUNDtCLOCK")) {
                intent = new Intent(MainActivity.this, roundtclock.class);
                intent.putExtra("gameVariant",cricketVariantButton.getText());
            }

            else {
                boolean inputmode=false;
                if (settings.contains("inputmethode")) inputmode=settings.getBoolean("inputmethode",false);
                if (inputmode) { intent = new Intent(MainActivity.this, matchcalc.class);  }
                else { intent = new Intent(MainActivity.this, match.class);}
                intent.putExtra("doubleout", doubleout.isChecked());
                intent.putExtra("masterout", masterout.isChecked());
                intent.putExtra("doublein", doublein.isChecked());
                intent.putExtra("masterin", masterin.isChecked());
                if (gametypButton.getText().equals("SET/LEG")) {
                    intent.putExtra("sets", Integer.parseInt(sets.getText().toString()));
                    intent.putExtra("legs", Integer.parseInt(legs.getText().toString()));
                } else {
                    intent.putExtra("sets", 0);
                    intent.putExtra("legs", 0);
                }

            }
            intent.putExtra("gameMode", gamemodeButton.getText());
            intent.putExtra("player1", player1spinner.getSelectedItem().toString());
            intent.putExtra("player2", player2spinner.getSelectedItem().toString());
            intent.putExtra("player3", player3spinner.getSelectedItem().toString());
            intent.putExtra("player4", player4spinner.getSelectedItem().toString());
            intent.putExtra("player5", player5spinner.getSelectedItem().toString());
            intent.putExtra("player6", player6spinner.getSelectedItem().toString());
            intent.putExtra("player7", player7spinner.getSelectedItem().toString());
            intent.putExtra("player8", player8spinner.getSelectedItem().toString());
            intent.putExtra("playerCount", numberOfPlayer.getText());
            startActivity(intent);
        });


        // freemodeeingabe übernehmen
        input.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_DONE) {
                // eingabe kleiner 2?
                try {
                    if ((input.getText().toString().isEmpty()) || (Integer.parseInt(input.getText().toString()) <= 1)) {
                        Toast.makeText(MainActivity.this, getResources().getString(R.string.minimum), LENGTH_LONG).show();
                        return true;
                    }
                } catch (Exception e)   //größere eingabe als integer erlaubt
                {
                    Toast.makeText(MainActivity.this, getResources().getString(R.string.maximum), LENGTH_LONG).show();
                    return true;
                }
                //willkürliche eingabegrenze überschritten?
                if (Integer.parseInt(input.getText().toString()) > 1000000) {
                    Toast.makeText(MainActivity.this, getResources().getString(R.string.maximum), LENGTH_LONG).show();
                    return true;
                }

                // edittext und touchlayer ausblenden
                input.setVisibility(View.INVISIBLE);
                touchlayout.setVisibility(View.GONE);
                // doubleout und co wieder einblenden
                doubleout.setVisibility(View.VISIBLE);
                masterout.setVisibility(View.VISIBLE);
                doublein.setVisibility(View.VISIBLE);
                masterin.setVisibility(View.VISIBLE);
                numberOfPlayer.setEnabled(true);
                gamemodeButton.setEnabled(true);
                gametypButton.setEnabled(true);
                player1spinner.setEnabled(true);
                player2spinner.setEnabled(true);
                player3spinner.setEnabled(true);
                player4spinner.setEnabled(true);
                player5spinner.setEnabled(true);
                player6spinner.setEnabled(true);
                player7spinner.setEnabled(true);
                player8spinner.setEnabled(true);
                startButton.setEnabled(true);
                statisticButton.setEnabled(true);
                preferencesButton.setEnabled(true);
                exchangeButton.setEnabled(true);
                exchangeAllButton.setEnabled(true);
                randomButtom.setVisibility(View.VISIBLE);

                // keyboard ausblenden
                InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                assert imm != null;
                imm.hideSoftInputFromWindow(input.getWindowToken(), 0);
                gamemodeButton.setText(input.getText());
                return true;
            }
            return false;
        });


        final ScrollView sv = findViewById(R.id.menu);

        //menü einblenden bei klick auf einstellungsbutton und Rest deaktivieren
        preferencesButton.setOnClickListener(v -> GUIan(false));


        // menü ausblenden, wenn click ausserhalb desselben liegt
        // oder bei free_mode_eingabe tastatur einblenden

        touchlayout.setOnClickListener(view -> {
            if (sv.getVisibility() == View.VISIBLE) {
                GUIan(true);
            }

            if (input.getVisibility() == View.VISIBLE) {
                input.onEditorAction(EditorInfo.IME_ACTION_DONE);
            }
        });

        statisticButton.setOnClickListener(v -> startActivity(new Intent(MainActivity.this, statistic.class)));

        final Button einstellungen = findViewById(R.id.settingsMenuButton);

        einstellungen.setOnClickListener(v -> {
            startActivity(new Intent(MainActivity.this, preferences.class));
            GUIan(true);
        });

        final Button infob = findViewById(R.id.aboutMenuButton);
        infob.setOnClickListener(v -> {
            startActivity(new Intent(MainActivity.this, info.class));
            GUIan(true);
        });

        playerlist.setOnClickListener(v -> {
            startActivity(new Intent(MainActivity.this, playerlist.class));
            GUIan(true);
        });

        final Button hilfe = findViewById(R.id.helpMenuButton);
        hilfe.setOnClickListener(v -> {
            startActivity(new Intent(MainActivity.this, help.class));
            GUIan(true);
        });

        doubleout.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (!isChecked) {
                masterout.setChecked(false);
            }
        });

        masterout.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                doubleout.setChecked(true);
            }
        });

        doublein.setOnCheckedChangeListener((compoundButton, isChecked) -> {
            if (!isChecked) {
                masterin.setChecked(false);
            }
        });

        masterin.setOnCheckedChangeListener((compoundButton, isChecked) -> {
            if (isChecked) {
                doublein.setChecked(true);
            }
        });


        randomButtom.setOnClickListener(view -> {
            // zufällige spieltypwahl
            int i;
            Random rand = new Random();
            int gameTypeSelectionPositon = rand.nextInt(gametypArraylist.size());

            // setze zufällige spielmodewahl in abhängikeit vom spieltyp

            int i2;
            String gameTypeSelection = gametypArraylist.get(gameTypeSelectionPositon);
            // vorauswahl für alle spieltypen, wird ggf. abgeändert im folgenden
            gametypButton.setText(gameTypeSelection);
            numberOfPlayer.setEnabled(true);
            settext.setVisibility(View.GONE);
            sets.setVisibility(View.GONE);
            legtext.setVisibility(View.GONE);
            legs.setVisibility(View.GONE);
            doubleout.setEnabled(true);
            masterout.setEnabled(true);
            doublein.setEnabled(true);
            masterin.setEnabled(true);
            cricketVariantButton.setVisibility(View.GONE);
            cricketmodetext.setVisibility(View.GONE);
            gamemodeButton.setText(x01GameModes[rand.nextInt(x01GameModes.length)]);

            // zufall sagt "cricket"
            switch (gameTypeSelection) {
                case "CRICKET":
                    doubleout.setEnabled(false);
                    masterout.setEnabled(false);
                    doublein.setEnabled(false);
                    masterin.setEnabled(false);
                    cricketVariantButton.setVisibility(View.VISIBLE);
                    cricketmodetext.setVisibility(View.VISIBLE);
                    gamemodeButton.setText(cricketModes[rand.nextInt(cricketModes.length)]);
                    // choose classic or cut throat
                    for (i = 0; i <= rand.nextInt(cricketVariants.length); i++) {
                        cricketVariantButton.performClick();
                    }
                    break;
                // zufall sagt "HALVE IT"
                case "HALVE IT":
                    doubleout.setEnabled(false);
                    masterout.setEnabled(false);
                    doublein.setEnabled(false);
                    masterin.setEnabled(false);
                    gamemodeButton.setText(halveitModes[rand.nextInt(halveitModes.length)]);
                    break;
                // zufall sagt "ROUNDtCLOCK"
                case "ROUNDtCLOCK":
                    doubleout.setEnabled(false);
                    masterout.setEnabled(false);
                    doublein.setEnabled(false);
                    masterin.setEnabled(false);
                    gamemodeButton.setText(roundtclockModes[rand.nextInt(roundtclockModes.length)]);
                    break;
                default:   // zufall sagt "x01" oder "elimination" oder "set/leg" oder "free"

                    // zufall sagt "FREE"
                    if (gameTypeSelection.equals("FREE")) {
                        gamemodeButton.setText(Integer.toString(rand.nextInt(501) + 1));
                    }

                    // setze single, double oder master out/in
                    i2 = rand.nextInt(3);
                    switch (i2) {
                        case 0:
                            doubleout.setChecked(false);
                            masterout.setChecked(false);
                            break;
                        case 1:
                            doubleout.setChecked(true);
                            masterout.setChecked(false);
                            break;
                        case 2:
                            masterout.setChecked(true);
                            break;
                    }
                    i2 = rand.nextInt(3);
                    switch (i2) {
                        case 0:
                            doublein.setChecked(false);
                            masterin.setChecked(false);
                            break;
                        case 1:
                            doublein.setChecked(true);
                            masterin.setChecked(false);
                            break;
                        case 2:
                            masterin.setChecked(true);
                            break;
                    }
                    // zufall sagt "set/leg"
                    if (gameTypeSelection.equals("SET/LEG")) {
                        numberOfPlayerSpinner.setSelection(1);
                        numberOfPlayer.setEnabled(false);
                        settext.setVisibility(View.VISIBLE);
                        sets.setVisibility(View.VISIBLE);
                        legtext.setVisibility(View.VISIBLE);
                        legs.setVisibility(View.VISIBLE);
                        player2spinner.setVisibility(View.VISIBLE);
                        player2text.setVisibility(View.VISIBLE);
                        player3text.setVisibility(View.GONE);
                        player4text.setVisibility(View.GONE);
                        player5text.setVisibility(View.GONE);
                        player6text.setVisibility(View.GONE);
                        player7text.setVisibility(View.GONE);
                        player8text.setVisibility(View.GONE);
                        player3spinner.setVisibility(View.GONE);
                        player4spinner.setVisibility(View.GONE);
                        player5spinner.setVisibility(View.GONE);
                        player6spinner.setVisibility(View.GONE);
                        player7spinner.setVisibility(View.GONE);
                        player8spinner.setVisibility(View.GONE);
                        for (i = 0; i <= rand.nextInt(maxsets); i++) sets.performClick();
                        for (i = 0; i <= rand.nextInt(maxlegs); i++) legs.performClick();
                    }
                    break;
            }
        });
    }


    public void GUIan(boolean anaus) {
        final SwitchCompat doubleout = findViewById(R.id.doubleout);
        final SwitchCompat masterout = findViewById(R.id.masterout);
        final SwitchCompat doublein = findViewById(R.id.doublein);
        final SwitchCompat masterin = findViewById(R.id.masterin);
        final Button crkmode = findViewById(R.id.cricketVariantButton);
        final Button gametypButton = findViewById(R.id.gameTyp);
        final ScrollView sv = findViewById(R.id.menu);
        final ConstraintLayout touchlayer = findViewById(R.id.touchlayer);

        if (anaus) {
            sv.setVisibility(View.INVISIBLE);
            touchlayer.setVisibility(View.GONE);
        }
        else {
            sv.setVisibility(View.VISIBLE);
            touchlayer.setVisibility(View.VISIBLE);
        }

        if (crkmode.getVisibility()==View.VISIBLE || gametypButton.getText().toString().equals("HALVE IT")) {
            doubleout.setEnabled(false);
            masterout.setEnabled(false);
            doublein.setEnabled(false);
            masterin.setEnabled(false);
        }
        else {
            doubleout.setEnabled(anaus);
            masterout.setEnabled(anaus);
            doublein.setEnabled(anaus);
            masterin.setEnabled(anaus);
        }
        crkmode.setEnabled(anaus);
        gametypButton.setEnabled(anaus);
        findViewById(R.id.playerCountButton).setEnabled(anaus);
        findViewById(R.id.gamemode).setEnabled(anaus);
        findViewById(R.id.player1spinner).setEnabled(anaus);
        findViewById(R.id.player2spinner).setEnabled(anaus);
        findViewById(R.id.player3spinner).setEnabled(anaus);
        findViewById(R.id.player4spinner).setEnabled(anaus);
        findViewById(R.id.player5spinner).setEnabled(anaus);
        findViewById(R.id.player6spinner).setEnabled(anaus);
        findViewById(R.id.player7spinner).setEnabled(anaus);
        findViewById(R.id.player8spinner).setEnabled(anaus);
        findViewById(R.id.startButton).setEnabled(anaus);
        findViewById(R.id.statisticButton).setEnabled(anaus);
        findViewById(R.id.sets).setEnabled(anaus);
        findViewById(R.id.legs).setEnabled(anaus);
        findViewById(R.id.randomGame).setEnabled(anaus);
        findViewById(R.id.exchangeButton).setEnabled(anaus);
        findViewById(R.id.exchangeAllButton).setEnabled(anaus);
    }


    @Override
    public void onResume() {
        super.onResume();
        arrayAdapter.notifyDataSetChanged();
        SharedPreferences settings = getSharedPreferences("preferences", 0);

        //  if language was changed in preferences, restart activity!
        if (settings.contains("language")) {
           if (!(settings.getString("language", "en").equals(LanguageAtStart))) {
               Intent intent = getIntent();
               finish();
               startActivity(intent);
           }
        }
        // if theme was changed in preferences, restart activity!
        if (settings.contains("Theme")) {
            if (!(settings.getBoolean("Theme", true) == themeSelected)) {
                Intent intent = getIntent();
                finish();
                startActivity(intent);
            }
        }
        // if theme style was changed in preferences, restart activity!
        if (settings.contains("Style")) {
            if  (!(settings.getBoolean("Style",true) == subDesignChoice)) {
                Intent intent = getIntent();
                finish();
                startActivity(intent);
            }
        }

        if (settings.contains("setlegmode")) {
            if (!settings.getBoolean("setlegmode", true)) {
                maxlegs = 5;
                maxsets = 13;
                firstTo = false;
            } else {
                maxlegs = 3;
                maxsets = 7;
                firstTo = true;
                Button legsb = findViewById(R.id.legs);
                Button setsb = findViewById(R.id.sets);
                if (Integer.parseInt(setsb.getText().toString()) > maxsets)
                    setsb.setText(String.valueOf(maxsets));
                if (Integer.parseInt(legsb.getText().toString()) > maxlegs)
                    legsb.setText(String.valueOf(maxlegs));
            }
        }
    }

    public void onBackPressed() {
        final EditText eingabe = findViewById(R.id.inputFREE);
        if (eingabe.getVisibility() == View.VISIBLE) {
            findViewById(R.id.doubleout).setVisibility(View.VISIBLE);
            findViewById(R.id.masterout).setVisibility(View.VISIBLE);
            findViewById(R.id.doublein).setVisibility(View.VISIBLE);
            findViewById(R.id.masterin).setVisibility(View.VISIBLE);
            findViewById(R.id.playerCountButton).setEnabled(true);
            findViewById(R.id.gameTyp).setEnabled(true);
            findViewById(R.id.gamemode).setEnabled(true);
            findViewById(R.id.startButton).setEnabled(true);
            findViewById(R.id.sets).setEnabled(true);
            findViewById(R.id.legs).setEnabled(true);
            findViewById(R.id.randomGame).setVisibility(View.VISIBLE);
            findViewById(R.id.exchangeButton).setEnabled(true);
            findViewById(R.id.exchangeAllButton).setEnabled(true);
            findViewById(R.id.statisticButton).setEnabled(true);
            findViewById(R.id.settingsButton).setEnabled(true);
            findViewById(R.id.player1spinner).setEnabled(true);
            findViewById(R.id.player2spinner).setEnabled(true);
            findViewById(R.id.player3spinner).setEnabled(true);
            findViewById(R.id.player4spinner).setEnabled(true);
            findViewById(R.id.player5spinner).setEnabled(true);
            findViewById(R.id.player6spinner).setEnabled(true);
            findViewById(R.id.player7spinner).setEnabled(true);
            findViewById(R.id.player8spinner).setEnabled(true);
            findViewById(R.id.touchlayer).setVisibility(View.GONE);
            eingabe.setVisibility(View.INVISIBLE);
        } else {
            finish();
        }
    }

    //@CsvDataType()
    public static class spieler implements Serializable {
        private static final long serialVersionUID = 19L;
      //  @CsvField(pos = 1)
        String spielerName;
        //@CsvField(pos = 2)
        int AnzahlSpiele;
        //@CsvField(pos = 3)
        int AnzahlEinzelspiele;
        //@CsvField(pos = 4)
        int anzahlSiege;
        //@CsvField(pos = 13)
        int besterWurf;
        int zweitbesterWurf;
        //@CsvField(pos = 8)
        float durchschnitt;
        //@CsvField(pos = 7)
        int geworfenePfeile;
        //@CsvField(pos = 9)
        int anzahluber60;
        //@CsvField(pos = 10)
        int anzahluber100;
        //@CsvField(pos = 11)
        int anzahluber140;
        //@CsvField(pos = 12)
        int anzahl180;
        int score;
        int legs;
        int sets = 0;
        //@CsvField(pos = 5)
        int matcheswon;
        //@CsvField(pos = 6)
        int matcheslost;
        //@CsvField(pos = 14)
        int checkoutmax;
        int legswon;

        @Override
        public String toString() {
            return this.spielerName;
        }

    }

    @CsvDataType()
    public static class player implements Serializable {
        private static final long serialVersionUID = 19L;
        @CsvField(pos = 1)
        String playerName;
        @CsvField(pos = 2)
        int overallMatches;
        @CsvField(pos = 3)
        int singleMatches;
        @CsvField(pos = 4)
        int matchVictories;
        @CsvField(pos = 13)
        int bestHit;
        int secondBestHit;
        @CsvField(pos = 8)
        float average;
        @CsvField(pos = 7)
        int dartsThrown;
        @CsvField(pos = 9)
        int above60;
        @CsvField(pos = 10)
        int above100;
        @CsvField(pos = 11)
        int above140;
        @CsvField(pos = 12)
        int amount180;
        int score;
        int legs;
        int sets = 0;
        @CsvField(pos = 5)
        int matchesWon;
        @CsvField(pos = 6)
        int matchesLost;
        @CsvField(pos = 14)
        int checkoutMax;
        int legswon;

        @NonNull
        @Override
        public String toString() {
            return this.playerName;
        }

    }

    @CsvDataType()
   public static class heading implements Serializable {
        private static final long serialVersionUID = 19L;
        @CsvField(pos = 1)
        String playerName;
        @CsvField(pos = 2)
        String overallMatches;
        @CsvField(pos = 3)
        String singleMatches;
        @CsvField(pos = 4)
        String matchVictories;
        @CsvField(pos = 5)
        String matcheswon;
        @CsvField(pos = 6)
        String matcheslost;
        @CsvField(pos = 7)
        String dartsThrown;
        @CsvField(pos = 8)
        String average;
        @CsvField(pos = 9)
        String above60;
        @CsvField(pos = 10)
        String above100;
        @CsvField(pos = 11)
        String above140;
        @CsvField(pos = 12)
        String amount180;
        @CsvField(pos = 13)
        String bestHit;
        @CsvField(pos = 14)
        String checkoutmax;
    }


}
