package com.DartChecker;

import static com.DartChecker.dc_modules.formater;
import static com.DartChecker.dc_modules.updateBaseContextLocale;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;

import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;

import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.OpenableColumns;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;
import org.jsefa.Serializer;
import org.jsefa.csv.CsvIOFactory;
import org.jsefa.csv.config.CsvConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class statistic extends AppCompatActivity {

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(updateBaseContextLocale(base));
    }

    private String getNameOfExportFile(Uri filename) {
        // get filename
        String nameOfFile = "";
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            Cursor cursor = null;
            assert filename != null;
            cursor = getContentResolver().query(filename, null, null, null);
            assert cursor != null;
            cursor.moveToFirst();
            int index = cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME);
            if (index >= 0) {
                nameOfFile = cursor.getString(index);
            }
            cursor.close();
        }
        return nameOfFile;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (MainActivity.themeSelected && MainActivity.subDesignChoice) setTheme(R.style.AppThemeBlack);
        else if (MainActivity.themeSelected) setTheme(R.style.AppThemeDark);
        else setTheme(R.style.Theme_AppCompat_Light_NoActionBar);
        setContentView(R.layout.activity_statistic);
        ArrayAdapter<MainActivity.player> arrayAdapter = new ArrayAdapter<>(
                statistic.this, R.layout.spinner_item_head, MainActivity.allPlayers);
        arrayAdapter.setDropDownViewResource(R.layout.support_simple_spinner_dropdown_item);
        SharedPreferences settings = getSharedPreferences("preferences",0);
        ConstraintLayout main = findViewById(R.id.mainlayoutContent);
        if (settings.contains("keepscreenonmenu")) main.setKeepScreenOn(settings.getBoolean("keepscreenonmenu",false));
        final Spinner player1 = findViewById(R.id.player1);
        final Spinner player2 = findViewById(R.id.player2);
        final TextView pf1 = findViewById(R.id.dartsPlayer1);
        final TextView pf2 = findViewById(R.id.dartsPlayer2);
        final TextView ds1 = findViewById(R.id.averagePlayer1);
        final TextView ds2 = findViewById(R.id.averagePlayer2);
        final TextView spg1 = findViewById(R.id.spielegesamt1);
        final TextView spg2 = findViewById(R.id.spielegesamt2);
        final TextView spe1 = findViewById(R.id.einzel1);
        final TextView spe2 = findViewById(R.id.einzel2);
        final TextView siege1 = findViewById(R.id.siege1);
        final TextView siege2 = findViewById(R.id.siege2);
        final TextView u1801 = findViewById(R.id.over180Player1);
        final TextView u1802 = findViewById(R.id.over180Player2);
        final TextView u1401 = findViewById(R.id.over140Player1);
        final TextView u1402 = findViewById(R.id.over140Player2);
        final TextView u1001 = findViewById(R.id.over100Player1);
        final TextView u1002 = findViewById(R.id.over100Player2);
        final TextView u601 = findViewById(R.id.over60Player1);
        final TextView u602 = findViewById(R.id.over60Player2);
        final TextView besthit1 = findViewById(R.id.bestHitPlayer1);
        final TextView besthit2 = findViewById(R.id.bestHitPlayer2);
        final Button player1Button = findViewById(R.id.buttonspielera);
        final Button player2Button = findViewById(R.id.buttonspielerb);
        final Button allButton = findViewById(R.id.alle);
        final Button exportcsv = findViewById(R.id.exportcsv);
        final Button exportdat = findViewById(R.id.exportdat);
        final Button exporttxt = findViewById(R.id.exporttxt);
        final Button importdat = findViewById(R.id.importdat);
        final TextView setlegs1 = findViewById(R.id.setlegs1);
        final TextView setlegs2 = findViewById(R.id.setlegs2);
        final TextView check1 = findViewById(R.id.checkoutPlayer1);
        final TextView check2 = findViewById(R.id.checkoutPlayer2);
        final TextView setlegs1lost = findViewById(R.id.setlegs1lost);
        final TextView setlegs2lost = findViewById(R.id.setlegs2lost);
        final TextView quote1 = findViewById(R.id.quote1);
        final TextView quote2 = findViewById(R.id.quote2);
        player1.setAdapter(arrayAdapter);
        player2.setAdapter(arrayAdapter);
        if (arrayAdapter.getCount() > 0) player1.setSelection(0);
        if (arrayAdapter.getCount() > 1) player2.setSelection(1);

        player1Button.setOnClickListener(v -> {
            AlertDialog alertDialog = new AlertDialog.Builder(statistic.this).create();
            alertDialog.setTitle(getResources().getString(R.string.caution));
            alertDialog.setMessage(String.format(getResources().getString(R.string.shouldStatisticDeleted), player1.getSelectedItem().toString()));
            alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yesDel),
                    (dialog, which) -> {
                        // delete complete player data
                        int index = player1.getSelectedItemPosition();
                        MainActivity.player dummyspieler = MainActivity.allPlayers.get(index);
                        dummyspieler.average = 0;
                        dummyspieler.dartsThrown = 0;
                        dummyspieler.overallMatches = 0;
                        dummyspieler.matchVictories = 0;
                        dummyspieler.singleMatches = 0;
                        dummyspieler.amount180 = 0;
                        dummyspieler.above140 = 0;
                        dummyspieler.above100 = 0;
                        dummyspieler.above60 = 0;
                        dummyspieler.bestHit = 0;
                        dummyspieler.checkoutMax = 0;
                        dummyspieler.matchesWon = 0;
                        dummyspieler.matchesLost = 0;
                        MainActivity.allPlayers.set(index, dummyspieler);
                        MainActivity.saveAllDataToDisk(statistic.this, false);
                        // refresh display
                        ds1.setText(formater.format(dummyspieler.average));
                        pf1.setText(String.format(Integer.toString(dummyspieler.dartsThrown)));
                        spg1.setText(String.format(Integer.toString(dummyspieler.overallMatches)));
                        siege1.setText(String.format(Integer.toString(dummyspieler.matchVictories)));
                        spe1.setText(String.format(Integer.toString(dummyspieler.singleMatches)));
                        u1801.setText(String.format(Integer.toString(dummyspieler.amount180)));
                        u1401.setText(String.format(Integer.toString(dummyspieler.above140)));
                        u1001.setText(String.format(Integer.toString(dummyspieler.above100)));
                        u601.setText(String.format(Integer.toString(dummyspieler.above60)));
                        besthit1.setText(String.format(Integer.toString(dummyspieler.bestHit)));
                        check1.setText(String.format(Integer.toString(dummyspieler.checkoutMax)));
                        setlegs1.setText(String.format(Integer.toString(dummyspieler.matchesWon)));
                        setlegs1lost.setText(String.format(Integer.toString(dummyspieler.matchesLost)));
                        quote1.setText("0 %");
                    });
            alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.cancel), (dialog, which) -> dialog.dismiss());
            alertDialog.show();
        });

        player2Button.setOnClickListener(v -> {
            AlertDialog alertDialog = new AlertDialog.Builder(statistic.this).create();
            alertDialog.setTitle(getResources().getString(R.string.caution));
            alertDialog.setMessage(String.format(getResources().getString(R.string.shouldStatisticDeleted), player2.getSelectedItem().toString()));
            alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yesDel),
                    (dialog, which) -> {
                        // delete complete playerdata
                        int index = player2.getSelectedItemPosition();
                        MainActivity.player dummyspieler = MainActivity.allPlayers.get(index);
                        dummyspieler.average = 0;
                        dummyspieler.dartsThrown = 0;
                        dummyspieler.overallMatches = 0;
                        dummyspieler.matchVictories = 0;
                        dummyspieler.singleMatches = 0;
                        dummyspieler.amount180 = 0;
                        dummyspieler.above140 = 0;
                        dummyspieler.above100 = 0;
                        dummyspieler.above60 = 0;
                        dummyspieler.bestHit = 0;
                        dummyspieler.checkoutMax = 0;
                        dummyspieler.matchesWon = 0;
                        dummyspieler.matchesLost = 0;
                        MainActivity.allPlayers.set(index, dummyspieler);
                        MainActivity.saveAllDataToDisk(statistic.this, false);
                        // refresh display
                        ds2.setText(formater.format(dummyspieler.average));
                        pf2.setText(String.format(Integer.toString(dummyspieler.dartsThrown)));
                        spg2.setText(String.format(Integer.toString(dummyspieler.overallMatches)));
                        siege2.setText(String.format(Integer.toString(dummyspieler.matchVictories)));
                        spe2.setText(String.format(Integer.toString(dummyspieler.singleMatches)));
                        u1802.setText(String.format(Integer.toString(dummyspieler.amount180)));
                        u1402.setText(String.format(Integer.toString(dummyspieler.above140)));
                        u1002.setText(String.format(Integer.toString(dummyspieler.above100)));
                        u602.setText(String.format(Integer.toString(dummyspieler.above60)));
                        besthit2.setText(String.format(Integer.toString(dummyspieler.bestHit)));
                        check2.setText(String.format(Integer.toString(dummyspieler.checkoutMax)));
                        setlegs2.setText(String.format(Integer.toString(dummyspieler.matchesWon)));
                        setlegs2lost.setText(String.format(Integer.toString(dummyspieler.matchesLost)));
                        quote2.setText("0 %");
                    });
            alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.cancel), (dialog, which) -> dialog.dismiss());
            alertDialog.show();
        });

        allButton.setOnClickListener(v -> {
            AlertDialog alertDialog = new AlertDialog.Builder(statistic.this).create();
            alertDialog.setTitle(getResources().getString(R.string.caution));
            alertDialog.setMessage(getResources().getString(R.string.deleteAbsolutlyAll));
            alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yesDel),
                    (dialog, which) -> {
                        // delete all data of every player
                        MainActivity.player dummyspieler;
                        for (int index = 0; index < MainActivity.allPlayers.size(); index++) {
                            dummyspieler = MainActivity.allPlayers.get(index);
                            dummyspieler.average = 0;
                            dummyspieler.dartsThrown = 0;
                            dummyspieler.overallMatches = 0;
                            dummyspieler.matchVictories = 0;
                            dummyspieler.singleMatches = 0;
                            dummyspieler.amount180 = 0;
                            dummyspieler.above140 = 0;
                            dummyspieler.above100 = 0;
                            dummyspieler.above60 = 0;
                            dummyspieler.bestHit = 0;
                            dummyspieler.checkoutMax = 0;
                            dummyspieler.matchesWon = 0;
                            dummyspieler.matchesLost = 0;
                            MainActivity.allPlayers.set(index, dummyspieler);
                        }

                        MainActivity.saveAllDataToDisk(statistic.this, false);
                        // refresh display
                        ds1.setText("0");
                        pf1.setText("0");
                        spg1.setText("0");
                        siege1.setText("0");
                        spe1.setText("0");
                        u1801.setText("0");
                        u1401.setText("0");
                        u1001.setText("0");
                        u601.setText("0");
                        besthit1.setText("0");
                        check1.setText("0");
                        setlegs1.setText("0");
                        setlegs1lost.setText("0");
                        quote1.setText("0 %");
                        ds2.setText("0");
                        pf2.setText("0");
                        spg2.setText("0");
                        siege2.setText("0");
                        spe2.setText("0");
                        u1802.setText("0");
                        u1402.setText("0");
                        u1002.setText("0");
                        u602.setText("0");
                        besthit2.setText("0");
                        check2.setText("0");
                        setlegs2.setText("0");
                        setlegs2lost.setText("0");
                        quote2.setText("0 %");
                    });
            alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.cancel), (dialog, which) -> dialog.dismiss());
            alertDialog.show();
        });


        player1.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parentView, View selectedItemView, int position, long id) {
                MainActivity.player dummyspieler = MainActivity.allPlayers.get(position);
                ds1.setText(formater.format(dummyspieler.average));
                pf1.setText(String.format(Integer.toString(dummyspieler.dartsThrown)));
                spg1.setText(String.format(Integer.toString(dummyspieler.overallMatches)));
                siege1.setText(String.format(Integer.toString(dummyspieler.matchVictories)));
                spe1.setText(String.format(Integer.toString(dummyspieler.singleMatches)));
                u1801.setText(String.format(Integer.toString(dummyspieler.amount180)));
                u1401.setText(String.format(Integer.toString(dummyspieler.above140)));
                u1001.setText(String.format(Integer.toString(dummyspieler.above100)));
                u601.setText(String.format(Integer.toString(dummyspieler.above60)));
                besthit1.setText(String.format(Integer.toString(dummyspieler.bestHit)));
                check1.setText(String.format(Integer.toString(dummyspieler.checkoutMax)));
                setlegs1.setText(String.format(Integer.toString(dummyspieler.matchesWon)));
                setlegs1lost.setText(String.format(Integer.toString(dummyspieler.matchesLost)));
                if (!(dummyspieler.overallMatches == 0) && !(dummyspieler.overallMatches <= dummyspieler.singleMatches)) {
                    float q11 = dummyspieler.overallMatches - dummyspieler.singleMatches;
                    q11 = q11 / 100;
                    q11 = dummyspieler.matchVictories / q11;
                    quote1.setText(formater.format(q11).concat(" %"));
                } else quote1.setText("0 %");
            }
            @Override
            public void onNothingSelected(AdapterView<?> parentView) {
            }

        });

        player2.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parentView, View selectedItemView, int position, long id) {
                MainActivity.player dummyspieler2 = MainActivity.allPlayers.get(position);
                ds2.setText(formater.format(dummyspieler2.average));
                pf2.setText(String.format(Integer.toString(dummyspieler2.dartsThrown)));
                spg2.setText(String.format(Integer.toString(dummyspieler2.overallMatches)));
                siege2.setText(String.format(Integer.toString(dummyspieler2.matchVictories)));
                spe2.setText(String.format(Integer.toString(dummyspieler2.singleMatches)));
                u1802.setText(String.format(Integer.toString(dummyspieler2.amount180)));
                u1402.setText(String.format(Integer.toString(dummyspieler2.above140)));
                u1002.setText(String.format(Integer.toString(dummyspieler2.above100)));
                u602.setText(String.format(Integer.toString(dummyspieler2.above60)));
                besthit2.setText(String.format(Integer.toString(dummyspieler2.bestHit)));
                check2.setText(String.format(Integer.toString(dummyspieler2.checkoutMax)));
                setlegs2.setText(String.format(Integer.toString(dummyspieler2.matchesWon)));
                setlegs2lost.setText(String.format(Integer.toString(dummyspieler2.matchesLost)));
                if (!(dummyspieler2.overallMatches == 0) && !(dummyspieler2.overallMatches <= dummyspieler2.singleMatches)) {
                    float q2 = dummyspieler2.overallMatches - dummyspieler2.singleMatches;
                    q2 = q2 / 100;
                    q2 = dummyspieler2.matchVictories / q2;
                    quote2.setText(formater.format(q2).concat(" %"));
                } else quote2.setText("0 %");

            }

            @Override
            public void onNothingSelected(AdapterView<?> parentView) {
            }
        });

        // export statistics as csv file
        ActivityResultLauncher<Intent> csvFileSaveLauncher =
                registerForActivityResult(new ActivityResultContracts.StartActivityForResult(),
                        (result) -> {
                            Context ctx = getApplicationContext();
                            if (result.getData() != null) {
                                Uri fname = result.getData().getData();
                                String filename = getNameOfExportFile(fname);
                                try {
                                    assert fname != null;
                                    OutputStream fout = getContentResolver().openOutputStream(fname);
                                    OutputStreamWriter csvout = new OutputStreamWriter(fout);
                                    CsvConfiguration conf = new CsvConfiguration();
                                    String delim = ";";
                                    conf.setFieldDelimiter(delim.charAt(0));
                                    Serializer csvheadserial = CsvIOFactory.createFactory(conf, MainActivity.heading.class).createSerializer();
                                    csvheadserial.open(csvout);
                                    MainActivity.heading heading = new MainActivity.heading();
                                    heading.singleMatches = getResources().getString(R.string.singleMatches);
                                    heading.matchVictories = getResources().getString(R.string.victories);
                                    heading.overallMatches = getResources().getString(R.string.matchesOverall);
                                    heading.playerName = getResources().getString(R.string.player);
                                    heading.matcheswon = getResources().getString(R.string.matches_won);
                                    heading.matcheslost = getResources().getString(R.string.matches_lost);
                                    heading.dartsThrown = getResources().getString(R.string.dartsThrown);
                                    heading.above60 = getResources().getString(R.string._60);
                                    heading.above100 = getResources().getString(R.string._100);
                                    heading.above140 = getResources().getString(R.string._140);
                                    heading.amount180 = getResources().getString(R.string._180);
                                    heading.bestHit = getResources().getString(R.string.bestHit);
                                    heading.checkoutmax = getResources().getString(R.string.checkout);
                                    heading.average = getResources().getString(R.string.average3Dart);
                                    csvheadserial.write(heading);
                                    csvheadserial.close(false);
                                    Serializer csvdataserial = CsvIOFactory.createFactory(conf, MainActivity.player.class).createSerializer();
                                    csvdataserial.open(csvout);
                                    for (MainActivity.player spieler : MainActivity.allPlayers) {
                                        csvdataserial.write(spieler);
                                    }
                                    csvdataserial.close(true);
                                    Toast.makeText(ctx, "Exported to " + filename, Toast.LENGTH_LONG).show();
                                } catch (FileNotFoundException e) {
                                    Toast.makeText(ctx, "Error saving: file not found", Toast.LENGTH_LONG).show();
                                    e.printStackTrace();
                                } catch (Exception ee) {
                                    Toast.makeText(ctx, "Error: " + ee, Toast.LENGTH_LONG).show();
                                }
                            }
                        }
                );

        exportcsv.setOnClickListener(view -> {
            Intent intent = new Intent(Intent.ACTION_CREATE_DOCUMENT);
            intent.addCategory(Intent.CATEGORY_OPENABLE);
            intent.setType("text/csv");
            intent.putExtra(Intent.EXTRA_TITLE, "dartchecker_statistics.csv");
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                intent.putExtra(DocumentsContract.EXTRA_INITIAL_URI, Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS).toString());
            }
            csvFileSaveLauncher.launch(intent);
        });

        // export as dat file (for import)
        ActivityResultLauncher<Intent> datFileSaveLauncher =
                registerForActivityResult(new ActivityResultContracts.StartActivityForResult(),
                        (result -> {
                            Context ctx = getApplicationContext();
                            if (result.getData() != null) {
                                Uri filename = result.getData().getData();
                                String nameOfFile = getNameOfExportFile(filename);
                                try {
                                    assert filename != null;
                                    OutputStream fout = getContentResolver().openOutputStream(filename);
                                    ObjectOutputStream oos = new ObjectOutputStream(fout);
                                    oos.writeObject(MainActivity.allPlayers);
                                    oos.flush();
                                    oos.close();  // fileoutputstream will be closed too
                                    Toast.makeText(ctx, "Exported to " + nameOfFile, Toast.LENGTH_LONG).show();
                                } catch (FileNotFoundException e) {
                                    Toast.makeText(ctx, "Error saving: file not found", Toast.LENGTH_LONG).show();
                                    e.printStackTrace();
                                } catch (IOException i) {
                                    Toast.makeText(ctx, "Error saving: Input/Output error", Toast.LENGTH_LONG).show();
                                    i.printStackTrace();
                                } catch (Exception ee) {
                                    Toast.makeText(ctx, "Error: " + ee, Toast.LENGTH_LONG).show();
                                }
                            }
                        })
                );

        exportdat.setOnClickListener(view -> {
            Intent intent = new Intent(Intent.ACTION_CREATE_DOCUMENT);
            intent.addCategory(Intent.CATEGORY_OPENABLE);
            intent.setType("text/dat");
            String fn = getFreeFileName(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS).toString(), "dartchecker_statistics_export.dat");
            intent.putExtra(Intent.EXTRA_TITLE, fn);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                intent.putExtra(DocumentsContract.EXTRA_INITIAL_URI, Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS).toString());
            }
            datFileSaveLauncher.launch(intent);
        });

        // export as txt file (for import)
        ActivityResultLauncher<Intent> txtFileSaveLauncher =
                registerForActivityResult(new ActivityResultContracts.StartActivityForResult(),
                        (result -> {
                            Context ctx = getApplicationContext();
                            if (result.getData() != null) {
                                Uri filename = result.getData().getData();
                                String nameOfFile = getNameOfExportFile(filename);
                                try {
                                    OutputStream fout = getContentResolver().openOutputStream(filename);
                                    OutputStreamWriter osw = new OutputStreamWriter(fout);
                                    Date now = new Date();
                                    osw.write(getResources().getString(R.string.textfileHeading) + " " + now + "\n");
                                    for (MainActivity.player player : MainActivity.allPlayers) {
                                        String winRate = "0 %";
                                        if (!(player.overallMatches == 0) && !(player.overallMatches <= player.singleMatches)) {
                                            float rateTemp = player.overallMatches - player.singleMatches;
                                            rateTemp = rateTemp / 100;
                                            rateTemp = player.matchVictories / rateTemp;
                                            winRate = formater.format(rateTemp) + " %";
                                        }
                                        osw.write("\n" + getResources().getString(R.string.player) + ": " + player.playerName + "\n");
                                        osw.write(getResources().getString(R.string.matchesOverall) + ": " + player.overallMatches + "\n");
                                        osw.write(getResources().getString(R.string.singleMatches) + ": " + player.singleMatches + "\n");
                                        osw.write(getResources().getString(R.string.victories) + ": " + player.matchVictories + "\n");
                                        osw.write(getResources().getString(R.string.winrate) + ": " + winRate + "\n");
                                        osw.write(getResources().getString(R.string.matches_won) + ": " + player.matchesWon + "\n");
                                        osw.write(getResources().getString(R.string.matches_lost) + ": " + player.matchesLost + "\n");
                                        osw.write(getResources().getString(R.string.dartsThrown) + ": " + player.dartsThrown + "\n");
                                        osw.write(getResources().getString(R.string.average3Dart) + ": " + player.average + "\n");
                                        osw.write(getResources().getString(R.string._60) + ": " + player.above60 + "\n");
                                        osw.write(getResources().getString(R.string._100) + ": " + player.above100 + "\n");
                                        osw.write(getResources().getString(R.string._140) + ": " + player.above140 + "\n");
                                        osw.write(getResources().getString(R.string._180) + ": " + player.amount180 + "\n");
                                        osw.write(getResources().getString(R.string.bestHit) + ": " + player.bestHit + "\n");
                                        osw.write(getResources().getString(R.string.checkout) + ": " + player.checkoutMax + "\n");
                                    }
                                    osw.close();  //fileoutputstream will be closed too
                                    Toast.makeText(ctx, "Exported to " + nameOfFile, Toast.LENGTH_LONG).show();
                                } catch (FileNotFoundException e) {
                                    Toast.makeText(ctx, "Error saving: file not found", Toast.LENGTH_LONG).show();
                                    e.printStackTrace();
                                } catch (IOException i) {
                                    Toast.makeText(ctx, "Error saving: Input/Output error", Toast.LENGTH_LONG).show();
                                    i.printStackTrace();
                                } catch (Exception ee) {
                                    Toast.makeText(ctx, "Error: " + ee, Toast.LENGTH_LONG).show();
                                }
                            }
                        })
                );

        exporttxt.setOnClickListener(view -> {
            Intent intent = new Intent(Intent.ACTION_CREATE_DOCUMENT);
            intent.addCategory(Intent.CATEGORY_OPENABLE);
            intent.setType("text/txt");
            intent.putExtra(Intent.EXTRA_TITLE, "dartchecker_statistics.txt");
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                intent.putExtra(DocumentsContract.EXTRA_INITIAL_URI, Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS).toString());
            }
            txtFileSaveLauncher.launch(intent);
        });


        // import dat file
        ActivityResultLauncher<Intent> importDatFileLauncher =
                registerForActivityResult(new ActivityResultContracts.StartActivityForResult(),
                        (result -> {
                            if (result.getData() != null) {
                                Uri selectedfile = result.getData().getData();
                                String nameOfFile = getNameOfExportFile(selectedfile);
                                if (!nameOfFile.isEmpty()) {
                                    String fileextension = nameOfFile.substring(nameOfFile.length() - 4).toLowerCase();
                                    if (!fileextension.equals(".dat")) {
                                        Toast.makeText(getApplicationContext(), getResources().getString(R.string.noDatFile), Toast.LENGTH_LONG).show();
                                        return;
                                    }
                                }
                                AlertDialog alertDialog = new AlertDialog.Builder(statistic.this).create();
                                alertDialog.setTitle(getResources().getString(R.string.caution));
                                alertDialog.setMessage(getResources().getString(R.string.wantToImport));
                                alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yes),
                                        (dialog, which) -> {
                                            // import player data
                                            try {
                                                ContentResolver cr = getContentResolver();
                                                assert selectedfile != null;
                                                InputStream in = cr.openInputStream(selectedfile);
                                                ObjectInputStream is = new ObjectInputStream(in);
                                                ArrayList<MainActivity.player> returnlist = new ArrayList<>();
                                                for (Object object : (Collection<?>) is.readObject())
                                                    if (object instanceof MainActivity.player) {
                                                        returnlist.add((MainActivity.player) object);
                                                    }
                                                is.close();
                                                assert in != null;
                                                in.close();
                                                MainActivity.allPlayers = returnlist;
                                                MainActivity.saveAllDataToDisk(statistic.this, false);
                                                finish();
                                                overridePendingTransition(0, 0);
                                                startActivity(getIntent());
                                                overridePendingTransition(0, 0);
                                                Toast.makeText(getApplicationContext(), getResources().getString(R.string.importSuccessful), Toast.LENGTH_LONG).show();
                                            } catch (FileNotFoundException e) {
                                                Toast.makeText(getApplicationContext(), "Error loading: file not found", Toast.LENGTH_LONG).show();
                                                e.printStackTrace();
                                            } catch (ClassNotFoundException b) {
                                                Toast.makeText(getApplicationContext(), "Error loading: class not found", Toast.LENGTH_LONG).show();
                                                b.printStackTrace();
                                            } catch (StreamCorruptedException sce) {
                                                Toast.makeText(getApplicationContext(), "This is not a DartChecker export file, intended for import. Try a file ending on .dat", Toast.LENGTH_LONG).show();
                                            } catch (IOException i) {
                                                Toast.makeText(getApplicationContext(), "Error loading: Input/Output " + i, Toast.LENGTH_LONG).show();
                                                i.printStackTrace();
                                            } //catch (StreamCorruptedException sce) {

                                            // }
                                        });
                                alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.no), (dialog, which) -> dialog.dismiss());
                                alertDialog.show();
                            }
                        })
                );

        importdat.setOnClickListener(view -> {
            Intent intent = new Intent()
                    .setType("*/*")
                    .setAction(Intent.ACTION_GET_CONTENT);
            importDatFileLauncher.launch(intent);
            Toast.makeText(getApplicationContext(), getResources().getString(R.string.selectFile), Toast.LENGTH_LONG).show();
        });

        final Button ok = findViewById(R.id.okb2);
        ok.setOnClickListener(v -> finish());
    }


    private String getFreeFileName(String filepath, String fname ){
        boolean exists = true;
        int count = 0;
        File fileName;
        String fileextension = fname.substring(fname.length()-4);
        String name = fname.substring(0, fname.length()-4);
        while (exists) {
            fileName = new File(filepath, fname);
            if (fileName.exists()) {
                count++;
                fname = name+count+fileextension;
            }
            else exists = false;
        }
        return fname;
    }
}
