package com.DartChecker;

import static com.DartChecker.dc_modules.buttonSelect;
import static com.DartChecker.dc_modules.playAudio;
import static com.DartChecker.dc_modules.textfield;
import static com.DartChecker.dc_modules.dart;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Handler;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Random;

public class cricket extends AppCompatActivity {
    private final int crazyCricketSegmentCount = 7;      // (exclusive bull)
    private int crazyCricketRangeMinimum = 6;
    private final player[] players = new player[9];
    private final ArrayList<dart> dartsThrown = new ArrayList<>();
    private final ArrayList<crazySegments> crazySegments = new ArrayList<>();
    private long startTime = 0;
    private int bcolor,
                bcolorn,
                textcolorActiv,
                textcolorPassiv,
                playerCount,
                activePlayer = 1,            // index for names array
                dartsThrownInRound = 0,      // counter for thrown dart (0, 1 or 2) per round
                scoreInRound,
                changetime = 1500,
                roundsThrown = -1;          //index for undo-memory
    private float textsizeActiv,
                  textsizePassiv;
    private boolean tripleSelected = false,
                    doubleSelected = false,
                    gameContinues = false,
                    undoQuestion = true;
    private String s = "";
    private CharSequence
            gameMode,
            gameVariation;

    // set double and triple button color including flags to visual "hold"-style
    private final View.OnClickListener doubletriple = new View.OnClickListener() {
        @Override
        public void onClick(View buttonClicked) {
            Button doubleButton = findViewById(R.id.doubleButton);
            Button tripleButton = findViewById(R.id.tripleButton);
            doubleButton.setBackgroundColor(bcolorn);        // workaround for low api version (15)
            tripleButton.setBackgroundColor(bcolorn);        // workaround for low api version (15);
            if (buttonClicked.getId() == R.id.doubleButton) {
                if (tripleSelected) {
                    tripleSelected = false;
                    tripleButton.setBackgroundColor(bcolorn);
                }
                if (!doubleSelected) {
                    doubleSelected = true;
                    doubleButton.setBackgroundColor(bcolor);
                } else {
                    doubleSelected = false;
                    doubleButton.setBackgroundColor(bcolorn);
                }
            } else {
                if (doubleSelected) {
                    doubleSelected = false;
                    doubleButton.setBackgroundColor(bcolorn);
                }
                if (!tripleSelected) {
                    tripleSelected = true;
                    tripleButton.setBackgroundColor(bcolor);
                } else {
                    tripleSelected = false;
                    tripleButton.setBackgroundColor(bcolorn);
                }
            }
        }
    };


    // undo
    private final View.OnClickListener undoclick = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            // security question
             if (undoQuestion) {
                AlertDialog alertDialog = new AlertDialog.Builder(cricket.this).create();
                alertDialog.setTitle(getResources().getString(R.string.caution));
                alertDialog.setMessage(getResources().getString(R.string.wantToUndo));
                alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yesIDo),
                        (dialog, which) -> {
                            dialog.dismiss();
                            undo();
                        });
                alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.no), (dialog, which) -> dialog.dismiss());
                alertDialog.show();
                 final SharedPreferences settings = getApplicationContext().getSharedPreferences("preferences", 0);
                 if (settings.contains("undoSafetyQuestion")) {
                     if (!settings.getBoolean("undoSafetyQuestion",false)) {
                         alertDialog.hide();
                         alertDialog.getButton(AlertDialog.BUTTON_POSITIVE).performClick();
                     }
                 }
            } else {
                undoQuestion = true;
                undo();
            }
        }

        private void undo() {
            int segment, factor, possibleScore, scoreToAdd, hitCountToSubstract;
            TextView darts = findViewById(R.id.darts);
            if (roundsThrown >= 0) {
                if (dartsThrownInRound == 0) {
                    // player changes
                    dartsThrownInRound = 2;
                    s = "..";
                    textfield(1, activePlayer, 3, cricket.this).setTextColor(textcolorPassiv);
                    textfield(1, activePlayer, 2, cricket.this).setTextColor(textcolorPassiv);
                    textfield(1, activePlayer, 3, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizePassiv);
                    textfield(1, activePlayer, 2, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizePassiv);
                    activePlayer = dartsThrown.get(roundsThrown).playerIndex;   // the last player, who did throw
                    textfield(1, activePlayer, 3, cricket.this).setTextColor(textcolorActiv);
                    textfield(1, activePlayer, 2, cricket.this).setTextColor(textcolorActiv);
                    textfield(1, activePlayer, 3, cricket.this).setPaintFlags(textfield(1, activePlayer, 3, cricket.this).getPaintFlags() & (~Paint.STRIKE_THRU_TEXT_FLAG));
                    textfield(1, activePlayer, 2, cricket.this).setPaintFlags(textfield(1, activePlayer, 2, cricket.this).getPaintFlags() & (~Paint.STRIKE_THRU_TEXT_FLAG));
                    textfield(1, activePlayer, 3, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActiv);
                    textfield(1, activePlayer, 2, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActiv);
                    if (gameMode.equals("Crazy")) {
                        loadSegments(crazySegments.get(crazySegments.size() - 1)); // load last saved segments
                        crazySegments.remove(crazySegments.size() - 1);
                    }
                    if (players[activePlayer].rankingPosition != 0)
                        players[activePlayer].rankingPosition = 0;
                } else dartsThrownInRound--;
                if (dartsThrownInRound == 1) s = ".";
                else if (dartsThrownInRound == 0) s = "";
                darts.setText(s);
                segment = dartsThrown.get(roundsThrown).segment;
                factor = dartsThrown.get(roundsThrown).factor;
                scoreToAdd = dartsThrown.get(roundsThrown).scoreToAdd;
                possibleScore = segment * factor;
                //scoreToAdd could consist of 1x,2x oder 3x dart -> substract accordingly
                if (gameVariation.equals("Classic")) {
                    players[activePlayer].score -= scoreToAdd;
                }
                else if (gameVariation.equals("Cut Throat")) {
                    for (int i = 1; i <= playerCount; i++) {
                        if ((i != activePlayer) && !(segmentClosedForPlayer(i, segment)))
                            players[i].score -= scoreToAdd;
                    }
                }
                if ((factor > 0) && (segment > 0))
                    hitCountToSubstract = (possibleScore - scoreToAdd) / segment;
                else hitCountToSubstract = 0;
                if (closed(segment) && (hitCountToSubstract > 0)) {
                    for (int i = 1; i <= playerCount; i++) {
                        textfield(segment, i, 1, cricket.this).setTextColor(textcolorPassiv);
                    }
                    buttonSelect(segment, cricket.this).setEnabled(true);
                }
                players[activePlayer].hits[segment] -= hitCountToSubstract;
                if (segment != 0) {
                    switch (players[activePlayer].hits[segment]) {
                        case 0:
                            textfield(segment, activePlayer, 1, cricket.this).setText("");
                            break;
                        case 1:
                            textfield(segment, activePlayer, 1, cricket.this).setText("/");
                            break;
                        case 2:
                            textfield(segment, activePlayer, 1, cricket.this).setText("X");
                            break;
                        case 3:
                            textfield(segment, activePlayer, 1, cricket.this).setText("O");
                            break;
                    }
                }
                String undoMessage = "";
                switch (factor) {
                    case 0:
                        undoMessage = "undo: " + getResources().getString(R.string.missed);
                        break;
                    case 1:
                        undoMessage = "undo: " + segment;
                        break;
                    case 2:
                        undoMessage = "undo: Double " + segment;
                        break;
                    case 3:
                        undoMessage = "undo: Triple " + segment;
                        break;
                }
                undoMessage = undoMessage + " " + getResources().getString(R.string.from) + " " + players[dartsThrown.get(roundsThrown).playerIndex].playerName;
                Toast.makeText(cricket.this, undoMessage, Toast.LENGTH_SHORT).show();
                //update score textview
                if (gameVariation.equals("Classic")) {
                    textfield(1, activePlayer, 2, cricket.this).setText(String.format(Integer.toString(players[activePlayer].score)));
                }
                else if (gameVariation.equals("Cut Throat")) {
                    for (int i = 1; i <= playerCount; i++) {
                        if (i != activePlayer)
                            textfield(1, i, 2, cricket.this).setText(String.format(Integer.toString(players[i].score)));
                    }
                }
                roundsThrown--;
            } else Toast.makeText(cricket.this, R.string.noUndo, Toast.LENGTH_LONG).show();
        }
    };

    private boolean gameOver() {
        // assumption: "game continues" is activated
        int rankingPosition = 1;
        int[] playersRankingPositions = new int[playerCount + 1]; //+1 beacuse of index0
        // read ranking and create a working copy of it
        for (int index = 1; index <= playerCount; index++) {
            if (index == activePlayer) continue;
            playersRankingPositions[index] = players[index].rankingPosition;
            // set correct position of actual player
            if (playersRankingPositions[index] != 0)
                rankingPosition++;
        }
        playersRankingPositions[activePlayer] = rankingPosition;
        players[activePlayer].rankingPosition = 99; // fake value to fool winner function
        boolean gotAWinner = true;
        while (gotAWinner) {
            gotAWinner=false;
            for (int index = 1; index <= playerCount; index++) {
                if (index == activePlayer) continue;
                if ((playersRankingPositions[index] == 0) && winner(index)) {
                    playersRankingPositions[index] = 99;
                    players[index].rankingPosition = 99; // to fool winner function
                    gotAWinner = true;
                }
            }
        }
        // set ranking positions to original values
        for (int index = 1; index <= playerCount; index++) if (players[index].rankingPosition == 99) players[index].rankingPosition = 0;
        // main check: is there a player without a position?
        for (int index = 1; index <= playerCount; index++) if (playersRankingPositions[index] == 0) return false;
        return true;
    }

    private final View.OnClickListener continueWithNextPlayer = v -> {
        Button missed=findViewById(R.id.missedButton);
        switch (dartsThrownInRound) {
            case 0:
                missed.performClick();
            case 1:
                missed.performClick();
            case 2:
                missed.performClick();
        }
    };

    private final View.OnClickListener buttonclick = new View.OnClickListener() {
        private void onClick(DialogInterface dialog, int which) {
            dialog.dismiss();
            if (winner(activePlayer) && gameContinues) {
                playAudio(cricket.this, "winner");
                textfield(0, activePlayer, 2, cricket.this).setPaintFlags(textfield(0, activePlayer, 2, cricket.this).getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                textfield(0, activePlayer, 2, cricket.this).setTextColor(Color.RED);
                textfield(0, activePlayer, 3, cricket.this).setPaintFlags(textfield(0, activePlayer, 3, cricket.this).getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                textfield(0, activePlayer, 3, cricket.this).setTextColor(Color.RED);
                dartsThrownInRound = 2;
                players[activePlayer].rankingPosition = 1;
                // set correct ranking position
                for (int playerIndex = 1; playerIndex <= playerCount; playerIndex++) {
                    if ((players[playerIndex].rankingPosition != 0) && (playerIndex != activePlayer))
                        players[activePlayer].rankingPosition++;
                }
                // check special case: if all player got all segments open (hit 3x) but score is to less, they are perhaps finished too
                for (int count = 1; count <= playerCount; count++) {
                    for (int playerIndex = 1; playerIndex <= playerCount; playerIndex++) {
                        if ((players[playerIndex].rankingPosition == 0) && (winner(playerIndex))) {
                            textfield(0, playerIndex, 2, cricket.this).setTextColor(Color.RED);
                            textfield(0, activePlayer, 2, cricket.this).setPaintFlags(textfield(0, activePlayer, 2, cricket.this).getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                            textfield(0, playerIndex, 3, cricket.this).setTextColor(Color.RED);
                            textfield(0, activePlayer, 3, cricket.this).setPaintFlags(textfield(0, activePlayer, 3, cricket.this).getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                            players[playerIndex].rankingPosition = 1;
                            // set correct position
                            for (int playerIndex2 = 1; playerIndex2 <= playerCount; playerIndex2++) {
                                if ((players[playerIndex2].rankingPosition != 0) && (playerIndex2 != playerIndex))
                                    players[playerIndex].rankingPosition++;
                            }
                            // just 2 or 1 player left?
                            if (players[playerIndex].rankingPosition >= playerCount - 1) {
                                gameContinues = false;
                                // set last player to his position
                                for (int playerIndex3 = 1; playerIndex3 <= playerCount; playerIndex3++) {
                                    if (players[playerIndex3].rankingPosition == 0) {
                                        players[playerIndex3].rankingPosition = playerCount; //(playercount==last position)
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            }

            if ((winner(activePlayer) || allSegementsClosed()) && (!(gameContinues) || playerCount == 1)) {
            // init end of game
                playAudio(cricket.this, "winner");
                long gameDuration = (System.currentTimeMillis() - startTime) / 1000;
                Intent intent = new Intent(cricket.this, endofgame.class);
                intent.putExtra("playercount", playerCount);
                intent.putExtra("cricket", true);
                intent.putExtra("gameDuration", gameDuration);
                SharedPreferences sp = getSharedPreferences("preferences", 0);
                if (sp.contains("gameContinues"))
                    gameContinues = sp.getBoolean("gameContinues", false);
                intent.putExtra("gameContinues", gameContinues);
                // count darts
                for (int throwIndex = 0; throwIndex<= dartsThrown.size()-1; throwIndex++) {
                    players[dartsThrown.get(throwIndex).playerIndex].dartsThrown++;
                }
                if (gameContinues) {
                    for (int playerIndex = 1; playerIndex <= playerCount; playerIndex++) {
                        switch (players[playerIndex].rankingPosition) {
                            case 1:
                                intent.putExtra("first", players[playerIndex].playerName);
                                intent.putExtra("firstscore", players[playerIndex].score);
                                intent.putExtra("firstdarts", players[playerIndex].dartsThrown);
                                break;
                            case 2:
                                intent.putExtra("second", players[playerIndex].playerName);
                                intent.putExtra("secondscore", players[playerIndex].score);
                                intent.putExtra("seconddarts", players[playerIndex].dartsThrown);
                                break;
                            case 3:
                                intent.putExtra("third", players[playerIndex].playerName);
                                intent.putExtra("thirdscore", players[playerIndex].score);
                                intent.putExtra("thirddarts", players[playerIndex].dartsThrown);
                                break;
                            case 4:
                                intent.putExtra("fourth", players[playerIndex].playerName);
                                intent.putExtra("fourthscore", players[playerIndex].score);
                                intent.putExtra("fourthdarts", players[playerIndex].dartsThrown);
                                break;
                            case 5:
                                intent.putExtra("fifth", players[playerIndex].playerName);
                                intent.putExtra("fifthscore", players[playerIndex].score);
                                intent.putExtra("fifthdarts", players[playerIndex].dartsThrown);
                                break;
                            case 6:
                                intent.putExtra("sixth", players[playerIndex].playerName);
                                intent.putExtra("sixthscore", players[playerIndex].score);
                                intent.putExtra("sixthdarts", players[playerIndex].dartsThrown);
                                break;
                            case 7:
                                intent.putExtra("seventh", players[playerIndex].playerName);
                                intent.putExtra("seventhscore", players[playerIndex].score);
                                intent.putExtra("seventhdarts", players[playerIndex].dartsThrown);
                                break;
                            case 8:
                                intent.putExtra("eight", players[playerIndex].playerName);
                                intent.putExtra("eightscore", players[playerIndex].score);
                                intent.putExtra("eightdarts", players[playerIndex].dartsThrown);
                                break;
                        }
                    }
                } else {
                    intent.putExtra("first", players[activePlayer].playerName);
                    intent.putExtra("firstscore", players[activePlayer].score);
                    intent.putExtra("firstdarts", players[activePlayer].dartsThrown);
                    if (playerCount == 2) {
                        switch (activePlayer) {
                            case 1:
                                intent.putExtra("second", players[2].playerName);
                                intent.putExtra("secondscore", players[2].score);
                                intent.putExtra("seconddarts", players[2].dartsThrown);
                                break;
                            case 2:
                                intent.putExtra("second", players[1].playerName);
                                intent.putExtra("secondscore", players[1].score);
                                intent.putExtra("seconddarts", players[1].dartsThrown);
                                break;
                        }
                    } else if (playerCount == 3) {
                        player s2 = new player(), s3 = new player();
                        switch (activePlayer) {
                            case 1:
                                s2 = players[2];
                                s3 = players[3];
                                break;
                            case 2:
                                s2 = players[1];
                                s3 = players[3];
                                break;
                            case 3:
                                s2 = players[1];
                                s3 = players[2];
                                break;
                        }
                        intent.putExtra("second", s2.playerName);
                        intent.putExtra("secondscore", s2.score);
                        intent.putExtra("seconddarts", s2.dartsThrown);
                        intent.putExtra("third", s3.playerName);
                        intent.putExtra("thirdscore", s3.score);
                        intent.putExtra("thirddarts", s3.dartsThrown);
                    } else if (playerCount == 4) {
                        player s2 = new player(), s3 = new player(), s4 = new player();
                        switch (activePlayer) {
                            case 1:
                                s2 = players[2];
                                s3 = players[3];
                                s4 = players[4];
                                break;
                            case 2:
                                s2 = players[1];
                                s3 = players[3];
                                s4 = players[4];
                                break;
                            case 3:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[4];
                                break;
                            case 4:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                break;
                        }
                        intent.putExtra("second", s2.playerName);
                        intent.putExtra("secondscore", s2.score);
                        intent.putExtra("seconddarts", s2.dartsThrown);
                        intent.putExtra("third", s3.playerName);
                        intent.putExtra("thirdscore", s3.score);
                        intent.putExtra("thirddarts", s3.dartsThrown);
                        intent.putExtra("fourth", s4.playerName);
                        intent.putExtra("fourthscore", s4.score);
                        intent.putExtra("fourthdarts", s4.dartsThrown);
                    } else if (playerCount == 5) {
                        player s2 = new player(), s3 = new player(), s4 = new player(), s5 = new player();
                        switch (activePlayer) {
                            case 1:
                                s2 = players[2];
                                s3 = players[3];
                                s4 = players[4];
                                s5 = players[5];
                                break;
                            case 2:
                                s2 = players[1];
                                s3 = players[3];
                                s4 = players[4];
                                s5 = players[5];
                                break;
                            case 3:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[4];
                                s5 = players[5];
                                break;
                            case 4:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[5];
                                break;
                            case 5:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[4];
                                break;
                        }
                        intent.putExtra("second", s2.playerName);
                        intent.putExtra("secondscore", s2.score);
                        intent.putExtra("seconddarts", s2.dartsThrown);
                        intent.putExtra("third", s3.playerName);
                        intent.putExtra("thirdscore", s3.score);
                        intent.putExtra("thirddarts", s3.dartsThrown);
                        intent.putExtra("fourth", s4.playerName);
                        intent.putExtra("fourthscore", s4.score);
                        intent.putExtra("fourthdarts", s4.dartsThrown);
                        intent.putExtra("fifth", s5.playerName);
                        intent.putExtra("fifthscore", s5.score);
                        intent.putExtra("fifthdarts", s5.dartsThrown);
                    } else if (playerCount == 6) {
                        player s2 = new player(), s3 = new player(), s4 = new player(), s5 = new player(), s6 = new player();
                        switch (activePlayer) {
                            case 1:
                                s2 = players[2];
                                s3 = players[3];
                                s4 = players[4];
                                s5 = players[5];
                                s6 = players[6];
                                break;
                            case 2:
                                s2 = players[1];
                                s3 = players[3];
                                s4 = players[4];
                                s5 = players[5];
                                s6 = players[6];
                                break;
                            case 3:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[4];
                                s5 = players[5];
                                s6 = players[6];
                                break;
                            case 4:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[5];
                                s6 = players[6];
                                break;
                            case 5:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[4];
                                s6 = players[6];
                                break;
                            case 6:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[4];
                                s6 = players[5];
                                break;
                        }
                        intent.putExtra("second", s2.playerName);
                        intent.putExtra("secondscore", s2.score);
                        intent.putExtra("seconddarts", s2.dartsThrown);
                        intent.putExtra("third", s3.playerName);
                        intent.putExtra("thirdscore", s3.score);
                        intent.putExtra("thirddarts", s3.dartsThrown);
                        intent.putExtra("fourth", s4.playerName);
                        intent.putExtra("fourthscore", s4.score);
                        intent.putExtra("fourthdarts", s4.dartsThrown);
                        intent.putExtra("fifth", s5.playerName);
                        intent.putExtra("fifthscore", s5.score);
                        intent.putExtra("fifthdarts", s5.dartsThrown);
                        intent.putExtra("sixth", s6.playerName);
                        intent.putExtra("sixthscore", s6.score);
                        intent.putExtra("sixthdarts", s6.dartsThrown);
                    } else if (playerCount == 7) {
                        player s2 = new player(), s3 = new player(), s4 = new player(), s5 = new player(), s6 = new player(), s7 = new player();
                        switch (activePlayer) {
                            case 1:
                                s2 = players[2];
                                s3 = players[3];
                                s4 = players[4];
                                s5 = players[5];
                                s6 = players[6];
                                s7 = players[7];
                                break;
                            case 2:
                                s2 = players[1];
                                s3 = players[3];
                                s4 = players[4];
                                s5 = players[5];
                                s6 = players[6];
                                s7 = players[7];
                                break;
                            case 3:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[4];
                                s5 = players[5];
                                s6 = players[6];
                                s7 = players[7];
                                break;
                            case 4:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[5];
                                s6 = players[6];
                                s7 = players[7];
                                break;
                            case 5:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[4];
                                s6 = players[6];
                                s7 = players[7];
                                break;
                            case 6:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[4];
                                s7 = players[7];
                                s6 = players[5];
                                break;
                            case 7:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[4];
                                s7 = players[6];
                                s6 = players[5];
                                break;
                        }
                        intent.putExtra("second", s2.playerName);
                        intent.putExtra("secondscore", s2.score);
                        intent.putExtra("seconddarts", s2.dartsThrown);
                        intent.putExtra("third", s3.playerName);
                        intent.putExtra("thirdscore", s3.score);
                        intent.putExtra("thirddarts", s3.dartsThrown);
                        intent.putExtra("fourth", s4.playerName);
                        intent.putExtra("fourthscore", s4.score);
                        intent.putExtra("fourthdarts", s4.dartsThrown);
                        intent.putExtra("fifth", s5.playerName);
                        intent.putExtra("fifthscore", s5.score);
                        intent.putExtra("fifthdarts", s5.dartsThrown);
                        intent.putExtra("sixth", s6.playerName);
                        intent.putExtra("sixthscore", s6.score);
                        intent.putExtra("sixthdarts", s6.dartsThrown);
                        intent.putExtra("seventh", s7.playerName);
                        intent.putExtra("seventhscore", s7.score);
                        intent.putExtra("seventhdarts", s7.dartsThrown);
                    } else if (playerCount == 8) {
                        player s2 = new player(), s3 = new player(), s4 = new player(), s5 = new player(), s6 = new player(), s7 = new player(), s8 = new player();
                        switch (activePlayer) {
                            case 1:
                                s2 = players[2];
                                s3 = players[3];
                                s4 = players[4];
                                s5 = players[5];
                                s6 = players[6];
                                s7 = players[7];
                                s8 = players[8];
                                break;
                            case 2:
                                s2 = players[1];
                                s3 = players[3];
                                s4 = players[4];
                                s5 = players[5];
                                s6 = players[6];
                                s7 = players[7];
                                s8 = players[8];
                                break;
                            case 3:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[4];
                                s5 = players[5];
                                s6 = players[6];
                                s7 = players[7];
                                s8 = players[8];
                                break;
                            case 4:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[5];
                                s6 = players[6];
                                s7 = players[7];
                                s8 = players[8];
                                break;
                            case 5:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[4];
                                s6 = players[6];
                                s7 = players[7];
                                s8 = players[8];
                                break;
                            case 6:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[4];
                                s7 = players[7];
                                s6 = players[5];
                                s8 = players[8];
                                break;
                            case 7:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[4];
                                s7 = players[6];
                                s6 = players[5];
                                s8 = players[8];
                                break;
                            case 8:
                                s2 = players[1];
                                s3 = players[2];
                                s4 = players[3];
                                s5 = players[4];
                                s7 = players[6];
                                s6 = players[5];
                                s8 = players[7];
                                break;
                        }
                        intent.putExtra("second", s2.playerName);
                        intent.putExtra("secondscore", s2.score);
                        intent.putExtra("seconddarts", s2.dartsThrown);
                        intent.putExtra("third", s3.playerName);
                        intent.putExtra("thirdscore", s3.score);
                        intent.putExtra("thirddarts", s3.dartsThrown);
                        intent.putExtra("fourth", s4.playerName);
                        intent.putExtra("fourthscore", s4.score);
                        intent.putExtra("fourthdarts", s4.dartsThrown);
                        intent.putExtra("fifth", s5.playerName);
                        intent.putExtra("fifthscore", s5.score);
                        intent.putExtra("fifthdarts", s5.dartsThrown);
                        intent.putExtra("sixth", s6.playerName);
                        intent.putExtra("sixthscore", s6.score);
                        intent.putExtra("sixthdarts", s6.dartsThrown);
                        intent.putExtra("seventh", s7.playerName);
                        intent.putExtra("seventhscore", s7.score);
                        intent.putExtra("seventhdarts", s7.dartsThrown);
                        intent.putExtra("eight", s8.playerName);
                        intent.putExtra("eightscore", s8.score);
                        intent.putExtra("eightdarts", s8.dartsThrown);
                    }
                }
                startActivity(intent);
                finish();
                return;
            }
            TextView darts = findViewById(R.id.darts);
            if (dartsThrownInRound < 2) {
                dartsThrownInRound++;
                s = s + (".");
            } else {  // player change
                dartsThrownInRound = 0;
                s = "";
                if ((scoreInRound > 0) || (players[activePlayer].rankingPosition != 0)) {
                    buttonfreeze(true);
                    final TextView scoresThrownTextview = findViewById(R.id.scoreThrown);
                    if (players[activePlayer].rankingPosition != 0)
                        scoresThrownTextview.setText(String.valueOf(players[activePlayer].rankingPosition).concat("."));
                    else {
                        String score = Integer.toString(scoreInRound);
                        scoresThrownTextview.setText(score);
                        playAudio(cricket.this, score);
                    }
                    scoresThrownTextview.setVisibility(View.VISIBLE);
                    new Handler().postDelayed(() -> {
                        buttonfreeze(false);
                        scoresThrownTextview.setVisibility(View.INVISIBLE);
                    }, changetime);
                    scoreInRound = 0;
                }
                if (players[activePlayer].rankingPosition == 0) {
                    textfield(1, activePlayer, 3, cricket.this).setTextColor(textcolorPassiv);
                    textfield(1, activePlayer, 2, cricket.this).setTextColor(textcolorPassiv);
                }
                textfield(1, activePlayer, 3, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizePassiv);
                textfield(1, activePlayer, 2, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizePassiv);
                do {
                    if (activePlayer < playerCount) activePlayer++;
                    else activePlayer = 1;
                } while (players[activePlayer].rankingPosition != 0);
                textfield(1, activePlayer, 3, cricket.this).setTextColor(textcolorActiv);
                textfield(1, activePlayer, 2, cricket.this).setTextColor(textcolorActiv);
                textfield(1, activePlayer, 3, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActiv);
                textfield(1, activePlayer, 2, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActiv);
                if (gameMode.equals("Crazy")) {
                    crazySegments segment = new crazySegments();
                    saveSegments(segment);
                    crazySegments.add(segment);
                    randomfieldselect();
                }
            }
            darts.setText(s);
        }

        @SuppressLint("NonConstantResourceId")
        @Override
        public void onClick(View v) {
            int buttonIdClicked = v.getId();
            Button input = findViewById(buttonIdClicked);
            int     segment,
                    scoreToAdd = 0;
            // which button was touched?
            switch (buttonIdClicked) {
                case R.id.bull:
                    segment = 25;
                    break;
                case R.id.missedButton:
                    segment = 0;
                    break;
                default:
                    try {
                        segment = Integer.parseInt(input.getText().toString());
                    } catch (Exception e) {
                        segment = 255;         //error number - should never happen
                    }
                    break;
            }
            int factor;
            if (doubleSelected)
            {
                factor = 2;
                doubleSelected = false;
                Button doubleb = findViewById(R.id.doubleButton);
                doubleb.setBackgroundColor(bcolorn);
            } else if (tripleSelected)
            {
                factor = 3;
                tripleSelected = false;
                Button tripleb = findViewById(R.id.tripleButton);
                tripleb.setBackgroundColor(bcolorn);
                if (segment == 25) {
                    Toast.makeText(getApplicationContext(), getResources().getString(R.string.tripleBull), Toast.LENGTH_LONG).show();
                    return;
                }
            } else //single!
                {
                factor = 1;
                }
            dart actualThrow;
            if (segment != 0) {
                int i;
                // following 3 lines for undo-savings
                actualThrow = new dart();
                if (!closed(segment)) actualThrow.factor = factor;
                else actualThrow.factor = 0;
                for (i = factor; i > 0; i--) {
                    if (players[activePlayer].hits[segment] < 3) {
                        players[activePlayer].hits[segment]++;
                    } else scoreToAdd += segment;
                }
                if (!closed(segment)) {
                    scoreInRound += scoreToAdd;
                    // classic Cricket?
                    if (gameVariation.equals("Classic")) {
                        players[activePlayer].score += scoreToAdd;
                    }
                    // Cut Throat Cricket?
                    else if (gameVariation.equals("Cut Throat")) {
                        for (i = 1; i <= playerCount; i++) {
                            if ((i != activePlayer) && !(segmentClosedForPlayer(i, segment)))
                                players[i].score += scoreToAdd;
                        }
                    }
                } else {
                    for (i = 1; i <= playerCount; i++) {
                        textfield(segment, i, 1, cricket.this).setTextColor(Color.RED);
                    }
                    buttonSelect(segment, cricket.this).setEnabled(false);
                    Toast.makeText(cricket.this, segment + " " + getResources().getString(R.string.closed), Toast.LENGTH_SHORT).show();
                    if (segment==25)
                        playAudio(cricket.this, "bull".concat("closed"));
                    else
                        playAudio(cricket.this, "n".concat(Integer.toString(segment).concat("closed")));
                }
                //save pending undo data
                roundsThrown++;
                if (!closed(segment)) {
                    //actualThrow.multplier=faktor;
                    actualThrow.scoreToAdd = scoreToAdd;
                } else {
                    actualThrow.scoreToAdd = 0;
                    if (scoreToAdd > 0)
                        actualThrow.factor = factor - (scoreToAdd / segment); // in case it's closed by factor
                }
                actualThrow.playerIndex = activePlayer;
                actualThrow.segment = segment;
                dartsThrown.add(roundsThrown, actualThrow);
                switch (players[activePlayer].hits[segment]) {
                    case 1:
                        textfield(segment, activePlayer, 1, cricket.this).setText("/");
                        break;
                    case 2:
                        textfield(segment, activePlayer, 1, cricket.this).setText("X");
                        break;
                    case 3:
                        if (!textfield(segment, activePlayer, 1, cricket.this).getText().equals("O")) {
                            textfield(segment, activePlayer, 1, cricket.this).setText("O");
                            if (!closed(segment)) {
                                if (segment==25)
                                    playAudio(cricket.this, "bull".concat("open"));
                                else
                                    playAudio(cricket.this, "n".concat(Integer.toString(segment).concat("open")));
                            }
                        }
                        break;
                }
                if (gameVariation.equals("Classic")) {
                    textfield(1, activePlayer, 2, cricket.this).setText(String.format(Integer.toString(players[activePlayer].score)));
                } else if (gameVariation.equals("Cut Throat")) {
                    for (i = 1; i <= playerCount; i++) {
                        if (i != activePlayer)
                            textfield(1, i, 2, cricket.this).setText(String.format(Integer.toString(players[i].score)));
                    }
                }

                //game over?
                if (winner(activePlayer)) {
                    AlertDialog alertDialog = new AlertDialog.Builder(cricket.this).create();
                    alertDialog.setTitle(getResources().getString(R.string.caution));
                    alertDialog.setMessage(getResources().getString(R.string.lastInputCorrect));
                    alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yes),
                            this::onClick);
                    alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.no), (dialog, which) -> {
                        dialog.dismiss();
                        // last hit was an error -> don't end game and undo last hit without asking
                        TextView darts = findViewById(R.id.darts);
                        if (dartsThrownInRound < 2) {
                            dartsThrownInRound++;
                            s = s + (".");

                        } else {  // player change
                            dartsThrownInRound = 0;
                            s = "";
                        }
                        darts.setText(s);
                        undoQuestion = false;
                        Button undo = findViewById(R.id.undoButton);
                        undo.performClick();
                    });
                    if (gameOver() || !gameContinues) {
                        alertDialog.show();
                    }
                    else {
                        alertDialog.show();
                        alertDialog.getButton(AlertDialog.BUTTON_POSITIVE).performClick();
                    }
                    return;
                }
            }   // not a single hit
                else if (!winner(activePlayer)) {
                    roundsThrown++;
                    actualThrow = new dart();
                    actualThrow.factor = 0;
                    actualThrow.scoreToAdd = 0;
                    actualThrow.segment = segment;
                    actualThrow.playerIndex = activePlayer;
                    dartsThrown.add(roundsThrown, actualThrow);
                }
                // game continues
                TextView darts = findViewById(R.id.darts);
                if (dartsThrownInRound < 2) {
                    dartsThrownInRound++;
                    s = s + (".");
                } else {  // player change
                    dartsThrownInRound = 0;
                    s = "";
                    if ((scoreInRound > 0) || (players[activePlayer].rankingPosition != 0)) {
                        buttonfreeze(true);
                        final TextView messageOutputTextviev = findViewById(R.id.scoreThrown);
                        if (players[activePlayer].rankingPosition != 0)
                            messageOutputTextviev.setText(String.valueOf(players[activePlayer].rankingPosition).concat("."));
                        else {
                            String score = Integer.toString(scoreInRound);
                            messageOutputTextviev.setText(score);
                            playAudio(getApplicationContext(), score);
                        }
                        messageOutputTextviev.setVisibility(View.VISIBLE);
                        new Handler().postDelayed(() -> {
                            buttonfreeze(false);
                            messageOutputTextviev.setVisibility(View.INVISIBLE);
                        }, changetime);
                        scoreInRound = 0;
                    }
                    if (players[activePlayer].rankingPosition == 0) {
                        textfield(1, activePlayer, 3, cricket.this).setTextColor(textcolorPassiv);
                        textfield(1, activePlayer, 2, cricket.this).setTextColor(textcolorPassiv);
                    }
                    textfield(1, activePlayer, 3, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizePassiv);
                    textfield(1, activePlayer, 2, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizePassiv);
                    do {
                        if (activePlayer < playerCount) activePlayer++;
                        else activePlayer = 1;
                    } while (players[activePlayer].rankingPosition != 0);
                    textfield(1, activePlayer, 3, cricket.this).setTextColor(textcolorActiv);
                    textfield(1, activePlayer, 2, cricket.this).setTextColor(textcolorActiv);
                    textfield(1, activePlayer, 3, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActiv);
                    textfield(1, activePlayer, 2, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActiv);
                    if (gameMode.equals("Crazy")) {
                        crazySegments crazySegment = new crazySegments();
                        saveSegments(crazySegment);
                        crazySegments.add(crazySegment);
                        randomfieldselect();
                    }
                }
                darts.setText(s);
        }
    };


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (MainActivity.themeSelected && MainActivity.subDesignChoice) setTheme(R.style.AppThemeBlack);
        else if (MainActivity.themeSelected) setTheme(R.style.AppThemeDark);
        else setTheme(R.style.Theme_AppCompat_Light_NoActionBar);
        setContentView(R.layout.activity_cricket);
        TypedValue outValue = new TypedValue();
        cricket.this.getTheme().resolveAttribute(R.attr.colorButtonNormal, outValue, true);
        bcolor = outValue.data;
        cricket.this.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        bcolorn = outValue.data;
        SharedPreferences settings = getSharedPreferences("preferences", 0);
        ConstraintLayout main = findViewById(R.id.matchbereich);
        if (settings.contains("keepscreenongame")) main.setKeepScreenOn(settings.getBoolean("keepscreenongame",true));
        TextView p1name = findViewById(R.id.p1name);
        TextView p2name = findViewById(R.id.p2name);
        textcolorActiv = p1name.getCurrentTextColor();
        textcolorPassiv = p2name.getCurrentTextColor();
        textsizePassiv = p2name.getTextSize();
        textsizeActiv = textsizePassiv + 4;
        textfield(1, 1, 3, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActiv);
        textfield(1, 1, 2, cricket.this).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActiv);
        Intent intent = getIntent();
        String plcount = intent.getStringExtra("playerCount");
        assert plcount != null;
        playerCount = Integer.parseInt(plcount);
        gameMode = intent.getCharSequenceExtra("gameMode");
        CharSequence player1n = intent.getCharSequenceExtra("player1");
        CharSequence player2n = intent.getCharSequenceExtra("player2");
        CharSequence player3n = intent.getCharSequenceExtra("player3");
        CharSequence player4n = intent.getCharSequenceExtra("player4");
        CharSequence player5n = intent.getCharSequenceExtra("player5");
        CharSequence player6n = intent.getCharSequenceExtra("player6");
        CharSequence player7n = intent.getCharSequenceExtra("player7");
        CharSequence player8n = intent.getCharSequenceExtra("player8");
        gameVariation = intent.getCharSequenceExtra("gameVariant");
        player s1 = new player();
        player s2 = new player();
        player s3 = new player();
        player s4 = new player();
        player s5 = new player();
        player s6 = new player();
        player s7 = new player();
        player s8 = new player();
        players[1] = s1;
        players[2] = s2;
        players[3] = s3;
        players[4] = s4;
        players[5] = s5;
        players[6] = s6;
        players[7] = s7;
        players[8] = s8;
        for (int playerIndex = 1; playerIndex <= playerCount; playerIndex++) players[playerIndex].score = 0;
        assert player1n != null;
        players[1].playerName = player1n.toString();
        assert player2n != null;
        players[2].playerName = player2n.toString();
        assert player3n != null;
        players[3].playerName = player3n.toString();
        assert player4n != null;
        players[4].playerName = player4n.toString();
        assert player5n != null;
        players[5].playerName = player5n.toString();
        assert player6n != null;
        players[6].playerName = player6n.toString();
        assert player7n != null;
        players[7].playerName = player7n.toString();
        assert player8n != null;
        players[8].playerName = player8n.toString();
        TextView p3name = findViewById(R.id.p3name);
        TextView p4name = findViewById(R.id.p4name);
        TextView p5name = findViewById(R.id.p5name);
        TextView p6name = findViewById(R.id.p6name);
        TextView p7name = findViewById(R.id.p7name);
        TextView p8name = findViewById(R.id.p8name);
        TextView p2score = findViewById(R.id.p2score);
        TextView p3score = findViewById(R.id.p3score);
        TextView p4score = findViewById(R.id.p4score);
        TextView p5score = findViewById(R.id.p5score);
        TextView p6score = findViewById(R.id.p6score);
        TextView p7score = findViewById(R.id.p7score);
        TextView p8score = findViewById(R.id.p8score);
        // set player names and layout of names according to selected player count
        p1name.setText(players[1].playerName);
        switch (playerCount) {
            case 2:
                ConstraintSet cs = new ConstraintSet();
                cs.clone(main);
                cs.connect(p2name.getId(), ConstraintSet.END, ConstraintSet.PARENT_ID, ConstraintSet.END);
                cs.applyTo(main);
                p3name.setVisibility(View.GONE);
                p4name.setVisibility(View.GONE);
                p5name.setVisibility(View.GONE);
                p6name.setVisibility(View.GONE);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p3score.setVisibility(View.GONE);
                p4score.setVisibility(View.GONE);
                p5score.setVisibility(View.GONE);
                p6score.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                break;
            case 1:
                p2name.setVisibility(View.GONE);
                p3name.setVisibility(View.GONE);
                p4name.setVisibility(View.GONE);
                p5name.setVisibility(View.GONE);
                p6name.setVisibility(View.GONE);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p2score.setVisibility(View.GONE);
                p3score.setVisibility(View.GONE);
                p4score.setVisibility(View.GONE);
                p5score.setVisibility(View.GONE);
                p6score.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                break;
            case 3:
                ConstraintSet cs3 = new ConstraintSet();
                cs3.clone(main);
                cs3.connect(p2name.getId(), ConstraintSet.END, R.id.mittelinks, ConstraintSet.END);
                cs3.connect(p3name.getId(), ConstraintSet.START, R.id.middle, ConstraintSet.END);
                cs3.connect(p3name.getId(), ConstraintSet.END, ConstraintSet.PARENT_ID, ConstraintSet.END);
                cs3.applyTo(main);
                p4name.setVisibility(View.GONE);
                p5name.setVisibility(View.GONE);
                p6name.setVisibility(View.GONE);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p4score.setVisibility(View.GONE);
                p5score.setVisibility(View.GONE);
                p6score.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                break;
            case 4:
                ConstraintSet cs4 = new ConstraintSet();
                cs4.clone(main);
                cs4.connect(p2name.getId(), ConstraintSet.END, R.id.mittelinks, ConstraintSet.END);
                cs4.connect(p3name.getId(), ConstraintSet.START, R.id.middle, ConstraintSet.START);
                cs4.connect(p3name.getId(), ConstraintSet.END, R.id.p4name, ConstraintSet.START);
                cs4.connect(p4name.getId(), ConstraintSet.START, R.id.p3name, ConstraintSet.END);
                cs4.connect(p4name.getId(), ConstraintSet.END, ConstraintSet.PARENT_ID, ConstraintSet.END);
                cs4.applyTo(main);
                p5name.setVisibility(View.GONE);
                p6name.setVisibility(View.GONE);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p5score.setVisibility(View.GONE);
                p6score.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                p4name.setText(players[4].playerName);
                break;
            case 5:
                ConstraintSet cs5 = new ConstraintSet();
                cs5.clone(main);
                cs5.connect(p3name.getId(), ConstraintSet.END, R.id.mittelinks, ConstraintSet.END);
                cs5.connect(p4name.getId(), ConstraintSet.START, R.id.middle, ConstraintSet.START);
                cs5.connect(p4name.getId(), ConstraintSet.END, R.id.p5name, ConstraintSet.START);
                cs5.connect(p5name.getId(), ConstraintSet.START, R.id.p4name, ConstraintSet.END);
                cs5.applyTo(main);
                p6name.setVisibility(View.GONE);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p6score.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                p4name.setText(players[4].playerName);
                p5name.setText(players[5].playerName);
                break;
            case 6:
                ConstraintSet cs6 = new ConstraintSet();
                cs6.clone(main);
                cs6.connect(p3name.getId(), ConstraintSet.END, R.id.mittelinks, ConstraintSet.END);
                cs6.connect(p4name.getId(), ConstraintSet.START, R.id.middle, ConstraintSet.START);
                cs6.connect(p4name.getId(), ConstraintSet.END, R.id.p5name, ConstraintSet.START);
                cs6.connect(p5name.getId(), ConstraintSet.START, R.id.p4name, ConstraintSet.END);
                cs6.applyTo(main);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                p4name.setText(players[4].playerName);
                p5name.setText(players[5].playerName);
                p6name.setText(players[6].playerName);
                break;
            case 7:
                p8name.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                p4name.setText(players[4].playerName);
                p5name.setText(players[5].playerName);
                p6name.setText(players[6].playerName);
                p7name.setText(players[7].playerName);
                break;
            case 8:
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                p4name.setText(players[4].playerName);
                p5name.setText(players[5].playerName);
                p6name.setText(players[6].playerName);
                p7name.setText(players[7].playerName);
                p8name.setText(players[8].playerName);
                break;
        }
        Button b1 = findViewById(R.id.b1);
        Button b2 = findViewById(R.id.b2);
        Button b3 = findViewById(R.id.b3);
        Button b4 = findViewById(R.id.b4);
        Button b5 = findViewById(R.id.b5);
        Button b6 = findViewById(R.id.b6);
        Button b7 = findViewById(R.id.b7);
        Button b8 = findViewById(R.id.b8);
        Button b9 = findViewById(R.id.b9);
        Button b10 = findViewById(R.id.b10);
        Button b11 = findViewById(R.id.b11);
        Button b12 = findViewById(R.id.b12);
        Button b13 = findViewById(R.id.b13);
        Button b14 = findViewById(R.id.b14);
        Button b15 = findViewById(R.id.b15);
        Button b16 = findViewById(R.id.b16);
        Button b17 = findViewById(R.id.b17);
        Button b18 = findViewById(R.id.b18);
        Button b19 = findViewById(R.id.b19);
        Button b20 = findViewById(R.id.b20);
        Button bull = findViewById(R.id.bull);
        Button bdouble = findViewById(R.id.doubleButton);
        Button btripel = findViewById(R.id.tripleButton);
        Button bmissed = findViewById(R.id.missedButton);
        Button bnext = findViewById(R.id.continueButton);
        Button bundo = findViewById(R.id.undoButton);
        b1.setOnClickListener(buttonclick);
        b2.setOnClickListener(buttonclick);
        b3.setOnClickListener(buttonclick);
        b4.setOnClickListener(buttonclick);
        b5.setOnClickListener(buttonclick);
        b6.setOnClickListener(buttonclick);
        b7.setOnClickListener(buttonclick);
        b8.setOnClickListener(buttonclick);
        b9.setOnClickListener(buttonclick);
        b10.setOnClickListener(buttonclick);
        b11.setOnClickListener(buttonclick);
        b12.setOnClickListener(buttonclick);
        b13.setOnClickListener(buttonclick);
        b14.setOnClickListener(buttonclick);
        b15.setOnClickListener(buttonclick);
        b16.setOnClickListener(buttonclick);
        b17.setOnClickListener(buttonclick);
        b18.setOnClickListener(buttonclick);
        b19.setOnClickListener(buttonclick);
        b20.setOnClickListener(buttonclick);
        bmissed.setOnClickListener(buttonclick);
        bnext.setOnClickListener(continueWithNextPlayer);
        bull.setOnClickListener(buttonclick);
        bdouble.setOnClickListener(doubletriple);
        btripel.setOnClickListener(doubletriple);
        bundo.setOnClickListener(undoclick);
        if (settings.contains("changetime")) changetime = settings.getInt("changetime", 1500);
        if (settings.contains("gameContinues"))
            gameContinues = settings.getBoolean("gameContinues", false);
        if (settings.contains("crazystart"))
            crazyCricketRangeMinimum = settings.getInt("crazystart",6);
        // rearange layout for selected game mode
        switch (String.valueOf(gameMode)) {
            case "15-Bull":
                b14.setVisibility(View.GONE);
            case "14-Bull":
                b13.setVisibility(View.GONE);
            case "13-Bull":
                b12.setVisibility(View.GONE);
            case "12-Bull":
                b11.setVisibility(View.GONE);
            case "11-Bull":
                b10.setVisibility(View.GONE);
                b9.setVisibility(View.GONE);
                b8.setVisibility(View.GONE);
                b7.setVisibility(View.GONE);
                b6.setVisibility(View.GONE);
                b5.setVisibility(View.GONE);
                b4.setVisibility(View.GONE);
                b3.setVisibility(View.GONE);
                b2.setVisibility(View.GONE);
                b1.setVisibility(View.GONE);
                break;
            case "Crazy":
                initial_randomfieldselect(crazyCricketSegmentCount);
        }
        findViewById(android.R.id.content).invalidate();
        startTime = System.currentTimeMillis();
    }

    private void loadSegments(crazySegments seg) {
        for (int button = crazyCricketRangeMinimum; button <= 20; button++) {
            if (seg.segments[button]) showSegment(button);
            else hideSegment(button);
        }
    }

    private void saveSegments(crazySegments seg) {
        for (int button = crazyCricketRangeMinimum; button <= 20; button++) {
            seg.segments[button] = buttonSelect(button, this).getVisibility() == View.VISIBLE;
        }
    }

    private void randomfieldselect() {
        boolean emptySegments = false;
        int neededNewSegments = 0;
        // count and hide segments, that are not hit 3x yet
        for (int segment = 1; segment <= 20; segment++) {
            if ((buttonSelect(segment, this).getVisibility() == View.VISIBLE) && (!open(segment))) {
                emptySegments = true;
                hideSegment(segment);
                neededNewSegments++;
            }
        }
        // if there are no exchangeable segments, there ist nothing to do anymore
        if (!emptySegments) return;
        // show new, random selected segments
        Random rand = new Random();
        int newSegment;
        boolean unfinished;
        for (int count = neededNewSegments; count > 0; count--) {
            unfinished = true;
            while (unfinished) {
                newSegment = rand.nextInt(21 - crazyCricketRangeMinimum) + crazyCricketRangeMinimum;
                if (buttonSelect(newSegment, this).getVisibility() == View.GONE) {
                    showSegment(newSegment);
                    unfinished = false;
                }
            }
        }
    }

    // selects random segments and hides unneeded segments
    private void initial_randomfieldselect(int segmentCount) {
        if (segmentCount > 20) return;
        for (int i = 1; i < crazyCricketRangeMinimum; i++) {
            hideSegment(i);
        }
        Random rand = new Random();
        boolean notReady;
        int segmentNumber;
        for (int i = crazyCricketRangeMinimum; i <= (20 - segmentCount + 1); i++) {
            notReady = true;
            while (notReady) {
                segmentNumber = rand.nextInt(21 - crazyCricketRangeMinimum) + crazyCricketRangeMinimum;
                if (buttonSelect(segmentNumber, this).getVisibility() == View.VISIBLE) {
                    hideSegment(segmentNumber);
                    notReady = false;
                }
            }
        }
    }

    private void hideSegment(int feld) {
        buttonSelect(feld, this).setVisibility(View.GONE);
        for (int playerIndex = 1; playerIndex <= playerCount; playerIndex++)
            textfield(feld, playerIndex, 1, cricket.this).setVisibility(View.GONE);
    }

    private void showSegment(int feld) {
        buttonSelect(feld, this).setVisibility(View.VISIBLE);
        for (int playerIndex = 1; playerIndex <= playerCount; playerIndex++)
            textfield(feld, playerIndex, 1, cricket.this).setVisibility(View.VISIBLE);
    }

    // has any player already hit a segment 3 times?
    private boolean open(int zahlenfeld) {
        for (int playerIndex = 1; playerIndex <= playerCount; playerIndex++) {
            if (players[playerIndex].hits[zahlenfeld] == 3) return true;
        }
        return false;
    }

    // did all player hit the segment 3 times?
    private boolean closed(int dart) {
        for (int j = 1; j <= playerCount; j++) {
            if (players[j].hits[dart] != 3) return false;
        }
        return true;
    }

    private boolean allSegementsClosed() {
        for (int segment = 1; segment <= 20; segment++) {
            if ((buttonSelect(segment, this).getVisibility() == View.VISIBLE) && !closed(segment)) {
                return false;
            }
        }
        return closed(25);
    }

    private boolean winner(int activePlayer) {
        // if there is only one player left, he is the last "winner"
        if ((playerCount > 1) && gameContinues) {
            int remainingPlayer = 0;
            for (int i = 1; i <= playerCount; i++) {
                if ((players[i].rankingPosition == 0) && (i != activePlayer)) {
                    remainingPlayer++;
                }
            }
            if (remainingPlayer == 0) return true;
        }

        if (gameVariation.equals("Classic")) {
            // winner has a) the most score...
            for (int i = 1; i <= playerCount; i++) {
                if ((players[activePlayer].score < players[i].score) && (activePlayer != i) && (players[i].rankingPosition == 0))
                    return false;
            }
        } else if (gameVariation.equals("Cut Throat")) {
            // ...or has a) the less score...
            for (int i = 1; i <= playerCount; i++) {
                if ((players[activePlayer].score > players[i].score) && (activePlayer != i) && (players[i].rankingPosition == 0))
                    return false;
            }
        }
        // ...and b) got all segments closed (hit 3x)...
        if (gameMode.equals("Crazy")) {
            for (int feld = 1; feld <= 20; feld++) {
                if ((buttonSelect(feld, this).getVisibility() == View.VISIBLE) && (players[activePlayer].hits[feld] != 3))
                    return false;
            }
        } else {
            for (int d = Integer.parseInt(gameMode.subSequence(0, 2).toString()); d <= 20; d++) {
                if (players[activePlayer].hits[d] != 3) return false;
            }
        }
        // ...including bull
        return players[activePlayer].hits[25] == 3;
    }

    private void buttonfreeze(boolean freeze) {
        Button b1 = findViewById(R.id.b1);
        Button b2 = findViewById(R.id.b2);
        Button b3 = findViewById(R.id.b3);
        Button b4 = findViewById(R.id.b4);
        Button b5 = findViewById(R.id.b5);
        Button b6 = findViewById(R.id.b6);
        Button b7 = findViewById(R.id.b7);
        Button b8 = findViewById(R.id.b8);
        Button b9 = findViewById(R.id.b9);
        Button b10 = findViewById(R.id.b10);
        Button b11 = findViewById(R.id.b11);
        Button b12 = findViewById(R.id.b12);
        Button b13 = findViewById(R.id.b13);
        Button b14 = findViewById(R.id.b14);
        Button b15 = findViewById(R.id.b15);
        Button b16 = findViewById(R.id.b16);
        Button b17 = findViewById(R.id.b17);
        Button b18 = findViewById(R.id.b18);
        Button b19 = findViewById(R.id.b19);
        Button b20 = findViewById(R.id.b20);
        Button bull = findViewById(R.id.bull);
        freeze = !freeze;       //a matter of logic ;-)
        findViewById(R.id.doubleButton).setEnabled(freeze);
        findViewById(R.id.tripleButton).setEnabled(freeze);
        findViewById(R.id.missedButton).setEnabled(freeze);
        findViewById(R.id.continueButton).setEnabled(freeze);
        findViewById(R.id.undoButton).setEnabled(freeze);
        if (!freeze) {
            b1.setEnabled(false);
            b2.setEnabled(false);
            b3.setEnabled(false);
            b4.setEnabled(false);
            b5.setEnabled(false);
            b6.setEnabled(false);
            b7.setEnabled(false);
            b8.setEnabled(false);
            b9.setEnabled(false);
            b10.setEnabled(false);
            b11.setEnabled(false);
            b12.setEnabled(false);
            b13.setEnabled(false);
            b14.setEnabled(false);
            b15.setEnabled(false);
            b16.setEnabled(false);
            b17.setEnabled(false);
            b18.setEnabled(false);
            b19.setEnabled(false);
            b20.setEnabled(false);
            bull.setEnabled(false);
        } else
            {
                if (!closed(1)) b1.setEnabled(true);
                if (!closed(2)) b2.setEnabled(true);
                if (!closed(3)) b3.setEnabled(true);
                if (!closed(4)) b4.setEnabled(true);
                if (!closed(5)) b5.setEnabled(true);
                if (!closed(6)) b6.setEnabled(true);
                if (!closed(7)) b7.setEnabled(true);
                if (!closed(8)) b8.setEnabled(true);
                if (!closed(9)) b9.setEnabled(true);
                if (!closed(10)) b10.setEnabled(true);
                if (!closed(11)) b11.setEnabled(true);
                if (!closed(12)) b12.setEnabled(true);
                if (!closed(13)) b13.setEnabled(true);
                if (!closed(14)) b14.setEnabled(true);
                if (!closed(15)) b15.setEnabled(true);
                if (!closed(16)) b16.setEnabled(true);
                if (!closed(17)) b17.setEnabled(true);
                if (!closed(18)) b18.setEnabled(true);
                if (!closed(19)) b19.setEnabled(true);
                if (!closed(20)) b20.setEnabled(true);
                if (!closed(25)) bull.setEnabled(true);
            }
    }

    public void onBackPressed() {
        AlertDialog alertDialog = new AlertDialog.Builder(cricket.this).create();
        alertDialog.setTitle(getResources().getString(R.string.caution));
        alertDialog.setMessage(getResources().getString(R.string.quitMatch));
        alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yesIDo),
                (dialog, which) -> {
                    dialog.dismiss();
                    finish();
                });
        alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.returnToMatch), (dialog, which) -> dialog.dismiss());
        alertDialog.show();
    }

    private static class player {
        final int[] hits = new int[26]; // index 25 is the bull counter, 10-20 are regular indices for segment counter or even more at crazy cricket
        String playerName;
        int
                score,
                dartsThrown,
                rankingPosition;
    }


    private static class crazySegments {
        final boolean[] segments = new boolean[26];
    }


    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(dc_modules.updateBaseContextLocale(base));
    }


    private boolean segmentClosedForPlayer(int playerIndex, int segment) {
        return players[playerIndex].hits[segment] == 3;
    }
}

