# Contributing

## Using the issue tracker
The [issue tracker](https://github.com/RetroMusicPlayer/RetroMusicPlayer/issues) is the preferred channel for bug reports, feature requests and submitting pull requests, but please follow these rules:

* Please **do not** derail or troll issues. Keep the discussion on topic and respect the opinions of others.

* Please **do not** post comments consisting solely of "+1" or "👍". Use [GitHub's "reactions" feature](https://github.com/blog/2119-add-reactions-to-pull-requests-issues-and-comments) instead.

* Please **do not** write [enhancement]/[bug]/[feature request] or similar stuff in the title of issues, as there are labels for that purpose that will be added by devs or collaborators.

## Bug reports
A bug is a _demonstrable problem_. Good bug reports are extremely helpful, so thanks!

Guidelines for bug reports:

* Use the GitHub issue search, check if the issue has already been reported both in the open issues and in the closed ones, if there are some missing details, add them in issue comments, without creating a new one
* Check if the issue has been fixed — try to reproduce it using the latest available build
* Isolate the problem — ideally create a reproducible scenario and a live example
* Do not report multiple bugs in a single ticket, otherwise it will be confusing.

A good bug report shouldn't leave others needing to chase you up for more information. Please try to be as detailed as possible in your report.


## Feature requests
Feature requests are welcome, please make sure to be as detailed as possible and use screenshots, videos, GIFs, to demonstrate it better, if possible.


## Pull requests
**Please ask first** before embarking on any significant pull request (e.g. implementing features, refactoring code), otherwise you risk spending a lot of time working on something that developers might not want to merge into the project. To avoid that, you can join the official [Telegram group](https://t.me/retromusicapp) or open an issue.

## License
By contributing your code, you agree to license your contribution under the [GNU General Public License](https://github.com/RetroMusicPlayer/RetroMusicPlayer/blob/master/LICENSE.md). 

Please note we have a code of conduct, please follow it in all your interactions with the project.
