{-# LANGUAGE OverloadedStrings #-}

module Simplex.Chat.ProfileGenerator where

import Data.Text (Text)
import Simplex.Chat.Types (Profile (..))
import System.Random (randomRIO)

generateRandomProfile :: IO Profile
generateRandomProfile = do
  adjective <- pick adjectives
  noun <- pickNoun adjective 2
  pure $ Profile {displayName = adjective <> noun, fullName = "", shortDescr = Nothing, image = Nothing, contactLink = Nothing, peerType = Nothing, preferences = Nothing}
  where
    pick :: [a] -> IO a
    pick xs = (xs !!) <$> randomRIO (0, length xs - 1)
    pickNoun :: Text -> Int -> IO Text
    pickNoun adjective n
      | n == 0 = pick nouns
      | otherwise = do
          noun <- pick nouns
          if noun == adjective
            then pickNoun adjective (n - 1)
            else pure noun

adjectives :: [Text]
adjectives =
  [ "Abatic",
    "Abducent",
    "Abecedarian",
    "Aberrant",
    "Abeyant",
    "Abject",
    "Ablative",
    "Ablaze",
    "Able",
    "Abloom",
    "Ablutionary",
    "Abolishable",
    "Abolitionary",
    "Aboriginal",
    "Aboulic",
    "Abounding",
    "About",
    "Aboveboard",
    "Aboveground",
    "Abranchial",
    "Abranchiate",
    "Abranchious",
    "Abrasive",
    "Abrupt",
    "Abscessed",
    "Absent",
    "Absolute",
    "Absolved",
    "Absorbable",
    "Absorbed",
    "Absorbing",
    "Absorptive",
    "Abstinent",
    "Abstracted",
    "Abstractionist",
    "Abundant",
    "Abysmal",
    "Abyssal",
    "Academic",
    "Acceptable",
    "Accessible",
    "Acclaimed",
    "Accommodating",
    "Accomplished",
    "Accordant",
    "Accurate",
    "Acknowledged",
    "Acrobatic",
    "Active",
    "Actual",
    "Adamant",
    "Adaptable",
    "Adept",
    "Adequate",
    "Adhesive",
    "Adhoc",
    "Adjusted",
    "Admirable",
    "Admired",
    "Admissible",
    "Adorable",
    "Adored",
    "Adroit",
    "Advantaged",
    "Adventuresome",
    "Adventurous",
    "Aesthetic",
    "Aesthetical",
    "Affable",
    "Affecting",
    "Affectionate",
    "Affiliated",
    "Affluent",
    "Aged",
    "Ageless",
    "Agile",
    "Agitated",
    "Agonizing",
    "Agreeable",
    "Ahead",
    "Aholic",
    "Alarmed",
    "Alarming",
    "Alert",
    "Alienated",
    "Alike",
    "Alive",
    "Alleged",
    "Allied",
    "Alright",
    "Amative",
    "Amatory",
    "Ambiguous",
    "Ambitious",
    "Amelioratory",
    "Amenable",
    "Amicable",
    "Ample",
    "Amused",
    "Amusing",
    "Anchored",
    "Ancient",
    "Angelic",
    "Animated",
    "Annual",
    "Antsy",
    "Appealing",
    "Appetent",
    "Apposite",
    "Apprehensible",
    "Apprehensive",
    "Approachable",
    "Apropos",
    "Apt",
    "Aquatic",
    "Arctic",
    "Arid",
    "Aromatic",
    "Arousing",
    "Arrogant",
    "Articulate",
    "Artistic",
    "Aspirant",
    "Assertive",
    "Assiduous",
    "Assistant",
    "Associate",
    "Associative",
    "Assured",
    "Assuring",
    "Astonishing",
    "Astounding",
    "Astute",
    "Athletic",
    "Attached",
    "Attainable",
    "Attendant",
    "Attentive",
    "Attractive",
    "August",
    "Auspicious",
    "Authentic",
    "Automatic",
    "Autonomous",
    "Available",
    "Awaited",
    "Awake",
    "Aware",
    "Awash",
    "Awesome",
    "Babyish",
    "Back",
    "Baggy",
    "Balanced",
    "Bare",
    "Barren",
    "Basic",
    "Beaming",
    "Beatific",
    "Beauteous",
    "Beautified",
    "Beautiful",
    "Becoming",
    "Beefy",
    "Belated",
    "Believable",
    "Beloved",
    "Benedictory",
    "Benefic",
    "Beneficent",
    "Beneficial",
    "Beneficiary",
    "Benevolent",
    "Benign",
    "Benignant",
    "Best",
    "Better",
    "Bewitched",
    "Big",
    "Biggest",
    "Bijou",
    "Bitter",
    "Blameless",
    "Bland",
    "Blank",
    "Blaring",
    "Blazing",
    "Blessed",
    "Blissful",
    "Blithe",
    "Blond",
    "Blooming",
    "Blue",
    "Blushing",
    "Bodacious",
    "Bogus",
    "Boiling",
    "Boisterous",
    "Bold",
    "Bonafide",
    "Bonny",
    "Bony",
    "Bonzer",
    "Boring",
    "Boss",
    "Bossy",
    "Both",
    "Bouncy",
    "Bound",
    "Bounteous",
    "Bountiful",
    "Bowed",
    "Brainy",
    "Brave",
    "Brawny",
    "Breakable",
    "Breezy",
    "Brief",
    "Bright",
    "Brill",
    "Brilliant",
    "Brimming",
    "Brisk",
    "Broadminded",
    "Broken",
    "Bronze",
    "Bruised",
    "Bubbly",
    "Budding",
    "Buff",
    "Bulky",
    "Bullish",
    "Bumpy",
    "Buoyant",
    "Burdensome",
    "Burly",
    "Bustling",
    "Busy",
    "Buttery",
    "Buzzing",
    "Calm",
    "Calmative",
    "Calming",
    "Candescent",
    "Canny",
    "Canty",
    "Capable",
    "Capital",
    "Captivating",
    "Carefree",
    "Careful",
    "Caring",
    "Casual",
    "Causative",
    "Celebrated",
    "Celestial",
    "Centered",
    "Central",
    "Cerebral",
    "Certain",
    "Champion",
    "Changeable",
    "Changeless",
    "Charismatic",
    "Charitable",
    "Charming",
    "Cheerful",
    "Cherished",
    "Cherry",
    "Chic",
    "Childlike",
    "Chipper",
    "Chirpy",
    "Chosen",
    "Chummy",
    "Civic",
    "Civil",
    "Civilized",
    "Clairvoyant",
    "Classic",
    "Classical",
    "Classy",
    "Clean",
    "Clear",
    "Clearheaded",
    "Clement",
    "Clever",
    "Close",
    "Clubby",
    "Coadjutant",
    "Coequal",
    "Cogent",
    "Cognizant",
    "Coherent",
    "Collected",
    "Comfortable",
    "Comforting",
    "Comic",
    "Comical",
    "Commanding",
    "Commendable",
    "Commendatory",
    "Commending",
    "Commiserative",
    "Committed",
    "Commodious",
    "Commonsensical",
    "Communicative",
    "Commutual",
    "Companionable",
    "Compassionate",
    "Compatible",
    "Compelling",
    "Competent",
    "Complete",
    "Completed",
    "Complimentary",
    "Composed",
    "Comprehensive",
    "Concentrated",
    "Concise",
    "Conclusive",
    "Concordant",
    "Concrete",
    "Condolatory",
    "Confederate",
    "Conferrable",
    "Confident",
    "Congenial",
    "Consentient",
    "Consequential",
    "Considerable",
    "Considerate",
    "Consistent",
    "Consonant",
    "Conspicuous",
    "Constant",
    "Constitutional",
    "Constructive",
    "Contemplative",
    "Contemporary",
    "Content",
    "Contributive",
    "Convenient",
    "Conversant",
    "Convictive",
    "Convincing",
    "Convivial",
    "Cool",
    "Cooperative",
    "Coordinated",
    "Copacetic",
    "Copious",
    "Cordial",
    "Correct",
    "Coruscant",
    "Cosmic",
    "Courageous",
    "Courteous",
    "Courtly",
    "Cozy",
    "Crackerjack",
    "Creative",
    "Credible",
    "Creditable",
    "Crisp",
    "Crucial",
    "Crystal",
    "Cuddly",
    "Cultivated",
    "Cultured",
    "Cunning",
    "Curious",
    "Current",
    "Cushy",
    "Cute",
    "Dainty",
    "Dandy",
    "Dapper",
    "Daring",
    "Dark",
    "Darling",
    "Dashing",
    "Dauntless",
    "Dazzling",
    "Dear",
    "Dearest",
    "Debonair",
    "Decent",
    "Deciding",
    "Decimal",
    "Decisive",
    "Decorous",
    "Dedicated",
    "Deep",
    "Defensive",
    "Definite",
    "Definitive",
    "Delectable",
    "Deliberate",
    "Delicate",
    "Delicious",
    "Delighted",
    "Delightful",
    "Deluxe",
    "Demanding",
    "Demonstrative",
    "Dental",
    "Dependable",
    "Dependent",
    "Descriptive",
    "Deserving",
    "Designer",
    "Desirable",
    "Desired",
    "Desirous",
    "Destined",
    "Detailed",
    "Determined",
    "Developed",
    "Developing",
    "Devoted",
    "Devotional",
    "Devout",
    "Dexterous",
    "Didactic",
    "Different",
    "Digital",
    "Dignified",
    "Diligent",
    "Dim",
    "Dimpled",
    "Diplomatic",
    "Direct",
    "Disarming",
    "Discerning",
    "Disciplined",
    "Discreet",
    "Discrete",
    "Disguised",
    "Distinct",
    "Distinctive",
    "Distinguished",
    "Distinguishing",
    "Diverse",
    "Diverting",
    "Divine",
    "Dominant",
    "Doting",
    "Doubtless",
    "Doughty",
    "Downright",
    "Drafty",
    "Dramatic",
    "Dreamy",
    "Driven",
    "Driving",
    "Dry",
    "Dual",
    "Durable",
    "Dutiful",
    "Dynamic",
    "Dynamite",
    "Eager",
    "Early",
    "Earnest",
    "Earthly",
    "Earthy",
    "Easy",
    "Easygoing",
    "Ebullient",
    "Eclectic",
    "Economic",
    "Economical",
    "Ecstatic",
    "Ecumenical",
    "Edible",
    "Edified",
    "Educated",
    "Educational",
    "Effective",
    "Effectual",
    "Effervescent",
    "Efficient",
    "Effortless",
    "Elaborate",
    "Elastic",
    "Elated",
    "Elating",
    "Elder",
    "Elderly",
    "Electric",
    "Electrifying",
    "Eleemosynary",
    "Elegant",
    "Elemental",
    "Elementary",
    "Eligible",
    "Elliptical",
    "Eloquent",
    "Embellished",
    "Emerging",
    "Eminent",
    "Emotional",
    "Empathetic",
    "Empowered",
    "Enamored",
    "Enchanted",
    "Enchanting",
    "Encouraged",
    "Encouraging",
    "Endearing",
    "Enduring",
    "Energetic",
    "Energizing",
    "Engaging",
    "Enhanced",
    "Enjoyable",
    "Enlightened",
    "Enlightening",
    "Enlivened",
    "Enlivening",
    "Enormous",
    "Enough",
    "Enriching",
    "Enterprising",
    "Entertaining",
    "Enthralling",
    "Enthusiastic",
    "Enticing",
    "Entire",
    "Entrancing",
    "Entrepreneurial",
    "Epicurean",
    "Epideictic",
    "Equable",
    "Equal",
    "Equatorial",
    "Equiponderant",
    "Equipped",
    "Equitable",
    "Equivalent",
    "Erudite",
    "Especial",
    "Essential",
    "Established",
    "Esteemed",
    "Esthetic",
    "Esthetical",
    "Eternal",
    "Ethical",
    "Euphoric",
    "Even",
    "Eventful",
    "Evergreen",
    "Everlasting",
    "Evident",
    "Evocative",
    "Exact",
    "Exalted",
    "Exceeding",
    "Excellent",
    "Exceptional",
    "Excitable",
    "Excited",
    "Exciting",
    "Executive",
    "Exemplary",
    "Exhilarating",
    "Exotic",
    "Expansive",
    "Expectant",
    "Expeditious",
    "Expeditive",
    "Expensive",
    "Experienced",
    "Expert",
    "Explorative",
    "Expressive",
    "Exquisite",
    "Extraneous",
    "Extraordinary",
    "Extroverted",
    "Exuberant",
    "Exultant",
    "Fab",
    "Fabulous",
    "Facile",
    "Factual",
    "Facultative",
    "Fain",
    "Faint",
    "Fair",
    "Faithful",
    "Famed",
    "Familial",
    "Familiar",
    "Family",
    "Famous",
    "Fancy",
    "Fantastic",
    "Far",
    "Faraway",
    "Fascinating",
    "Fashionable",
    "Fast",
    "Fatal",
    "Fatherly",
    "Faultless",
    "Favorable",
    "Favored",
    "Favorite",
    "Fearful",
    "Fearless",
    "Feasible",
    "Fecund",
    "Feisty",
    "Felicitous",
    "Feline",
    "Fervent",
    "Festal",
    "Festive",
    "Fetching",
    "Fickle",
    "Fiery",
    "Fine",
    "Finer",
    "Finest",
    "Finished",
    "Firm",
    "First",
    "Firsthand",
    "Fit",
    "Fitting",
    "Fixed",
    "Flamboyant",
    "Flash",
    "Flashy",
    "Flat",
    "Flavorful",
    "Flawed",
    "Flawless",
    "Fleet",
    "Flexible",
    "Flickering",
    "Flimsy",
    "Flippant",
    "Flourishing",
    "Flowery",
    "Fluent",
    "Fluffy",
    "Fluid",
    "Flustered",
    "Flying",
    "Focused",
    "Fond",
    "Foremost",
    "Foresighted",
    "Forgiving",
    "Forked",
    "Formal",
    "Formidable",
    "Forthcoming",
    "Forthright",
    "Fortified",
    "Fortuitous",
    "Fortunate",
    "Forward",
    "Foundational",
    "Foxy",
    "Fragrant",
    "Frail",
    "Frank",
    "Fraternal",
    "Frayed",
    "Freely",
    "Frequent",
    "Fresh",
    "Friendly",
    "Frilly",
    "Frisky",
    "Front",
    "Frosty",
    "Frozen",
    "Fruitful",
    "Fulfilled",
    "Fulfilling",
    "Full",
    "Fumbling",
    "Fun",
    "Functional",
    "Funny",
    "Fussy",
    "Futuristic",
    "Fuzzy",
    "Gabby",
    "Gainful",
    "Gallant",
    "Galore",
    "Game",
    "Gamesome",
    "Gamy",
    "Gaping",
    "Gaseous",
    "Gaudy",
    "General",
    "Generous",
    "Genial",
    "Genteel",
    "Gentle",
    "Genuine",
    "Germane",
    "Gettable",
    "Giant",
    "Giddy",
    "Gifted",
    "Gigantic",
    "Giving",
    "Glad",
    "Glamorous",
    "Glaring",
    "Glass",
    "Gleaming",
    "Gleeful",
    "Glib",
    "Glistening",
    "Glittering",
    "Glorious",
    "Glossy",
    "Glowing",
    "Glum",
    "Gnarly",
    "Godly",
    "Golden",
    "Good",
    "Goodhearted",
    "Goodly",
    "Goofy",
    "Gorgeous",
    "Graced",
    "Graceful",
    "Gracile",
    "Gracious",
    "Gradely",
    "Graithly",
    "Grand",
    "Grandiose",
    "Granular",
    "Grateful",
    "Gratified",
    "Gratifying",
    "Gray",
    "Greasy",
    "Great",
    "Greatest",
    "Greathearted",
    "Green",
    "Gregarious",
    "Grey",
    "Gripping",
    "Groovy",
    "Grounded",
    "Growing",
    "Grown",
    "Grubby",
    "Grumpy",
    "Guaranteed",
    "Guarded",
    "Gubernatorial",
    "Guided",
    "Guiding",
    "Guileless",
    "Guiltless",
    "Guilty",
    "Gullible",
    "Gummy",
    "Gumptious",
    "Gustatory",
    "Gusty",
    "Gutsy",
    "Gymnastic",
    "Hairy",
    "Halcyon",
    "Hale",
    "Half",
    "Hallowed",
    "Handmade",
    "Handsome",
    "Handy",
    "Happening",
    "Happy",
    "Hardy",
    "Harmless",
    "Harmonious",
    "Harsh",
    "Hasty",
    "Head",
    "Healing",
    "Healthful",
    "Healthy",
    "Heartfelt",
    "Hearty",
    "Heavenly",
    "Heavy",
    "Heedful",
    "Hefty",
    "Hegemonic",
    "Helpful",
    "Hep",
    "Heralded",
    "Heroic",
    "Heteroclite",
    "Heuristic",
    "High",
    "Highest",
    "Hilarious",
    "Hip",
    "Holy",
    "Homely",
    "Honest",
    "Honeyed",
    "Honorable",
    "Honorary",
    "Honored",
    "Hopeful",
    "Hortative",
    "Hospitable",
    "Hot",
    "Hotshot",
    "Huge",
    "Humane",
    "Humanitarian",
    "Humble",
    "Humming",
    "Humongous",
    "Humorous",
    "Hungry",
    "Husky",
    "Hygienic",
    "Icy",
    "Ideal",
    "Idealistic",
    "Identical",
    "Idiosyncratic",
    "Idolized",
    "Ignorant",
    "Illimitable",
    "Illuminated",
    "Illuminating",
    "Illustrious",
    "Imaginary",
    "Imaginative",
    "Imitable",
    "Immaculate",
    "Immaterial",
    "Immeasurable",
    "Immediate",
    "Immense",
    "Immortal",
    "Immune",
    "Impartial",
    "Impassioned",
    "Impeccable",
    "Impeccant",
    "Imperturbable",
    "Important",
    "Impossible",
    "Impractical",
    "Impressionable",
    "Impressive",
    "Improbable",
    "Improved",
    "Improving",
    "Improvisational",
    "Inborn",
    "Incisive",
    "Included",
    "Inclusive",
    "Incomparable",
    "Inconsequential",
    "Incontestable",
    "Incontrovertible",
    "Incredible",
    "Inculpable",
    "Indefatigable",
    "Indelible",
    "Independent",
    "Indestructible",
    "Indispensable",
    "Indisputable",
    "Individual",
    "Individualistic",
    "Indivisible",
    "Indomitable",
    "Indubitable",
    "Industrious",
    "Inerrant",
    "Inexhaustible",
    "Infallible",
    "Infamous",
    "Infant",
    "Infantile",
    "Infatuated",
    "Inferior",
    "Infinite",
    "Influential",
    "Informal",
    "Informative",
    "Informed",
    "Ingenious",
    "Inimitable",
    "Initiate",
    "Initiative",
    "Innocent",
    "Innovative",
    "Innoxious",
    "Inquisitive",
    "Insightful",
    "Insignificant",
    "Insistent",
    "Inspired",
    "Inspiring",
    "Inspiriting",
    "Instantaneous",
    "Instinctive",
    "Instructive",
    "Instrumental",
    "Integral",
    "Integrated",
    "Intellectual",
    "Intelligent",
    "Intense",
    "Intent",
    "Intentional",
    "Interactive",
    "Interconnected",
    "Interested",
    "Interesting",
    "Internal",
    "International",
    "Intertwined",
    "Intimate",
    "Intoxicating",
    "Intrepid",
    "Intriguing",
    "Introducer",
    "Inventive",
    "Invigorated",
    "Invigorating",
    "Invincible",
    "Inviolable",
    "Inviting",
    "Irrefragable",
    "Irrefutable",
    "Irreplaceable",
    "Irrepressible",
    "Irreproachable",
    "Irresistible",
    "Jaculable",
    "Jaded",
    "Jaunty",
    "Jazzed",
    "Jazzy",
    "Jessant",
    "Jestful",
    "Jesting",
    "Jeweled",
    "Jiggish",
    "Jigjog",
    "Jimp",
    "Jittery",
    "Jobbing",
    "Jocose",
    "Jocoserious",
    "Jocular",
    "Joculatory",
    "Jocund",
    "Joint",
    "Jointed",
    "Jolly",
    "Jovial",
    "Joyful",
    "Joyous",
    "Joysome",
    "Jubilant",
    "Judicious",
    "Juicy",
    "Julie",
    "Jumbled",
    "Jumbo",
    "Jump",
    "Jumpy",
    "Junior",
    "Just",
    "Justified",
    "Juvenile",
    "Kaleidoscopic",
    "Keen",
    "Kempt",
    "Key",
    "Kind",
    "Kindhearted",
    "Kindly",
    "Kindred",
    "Kinetic",
    "Kingly",
    "Knightly",
    "Knobby",
    "Knotty",
    "Knowable",
    "Knowing",
    "Knowledgeable",
    "Known",
    "Kooky",
    "Kosher",
    "Ladylike",
    "Large",
    "Last",
    "Lasting",
    "Latitudinarian",
    "Laudable",
    "Laureate",
    "Lavish",
    "Lawful",
    "Leading",
    "Leafy",
    "Learned",
    "Legal",
    "Legendary",
    "Legible",
    "Legit",
    "Legitimate",
    "Leisured",
    "Leisurely",
    "Lenien",
    "Leonine",
    "Lepid",
    "Lettered",
    "Liberal",
    "Liberated",
    "Liberating",
    "Light",
    "Lighthearted",
    "Lightly",
    "Likable",
    "Like",
    "Liked",
    "Likely",
    "Limber",
    "Limited",
    "Linear",
    "Lined",
    "Lionhearted",
    "Liquid",
    "Literary",
    "Literate",
    "Lithe",
    "Lithesome",
    "Little",
    "Live",
    "Lively",
    "Livid",
    "Logical",
    "Long",
    "Lordly",
    "Loud",
    "Lovable",
    "Loved",
    "Lovely",
    "Loving",
    "Low",
    "Loyal",
    "Lucent",
    "Lucid",
    "Lucky",
    "Lucrative",
    "Lumbering",
    "Luminous",
    "Luscious",
    "Lush",
    "Lustrous",
    "Luxuriant",
    "Luxurious",
    "Made",
    "Magical",
    "Magnanimous",
    "Magnetic",
    "Magnificent",
    "Main",
    "Majestic",
    "Major",
    "Malleable",
    "Manageable",
    "Managerial",
    "Manifest",
    "Mannerly",
    "Marked",
    "Marvelous",
    "Massive",
    "Master",
    "Masterful",
    "Masterly",
    "Matchless",
    "Maternal",
    "Mature",
    "Maturing",
    "Maximal",
    "Meager",
    "Mealy",
    "Meaningful",
    "Measly",
    "Mediate",
    "Medical",
    "Meditative",
    "Medium",
    "Mellow",
    "Melodic",
    "Melodious",
    "Memorable",
    "Merciful",
    "Meritable",
    "Meritorious",
    "Merry",
    "Mesmerizing",
    "Metallic",
    "Metaphysical",
    "Meteoric",
    "Methodical",
    "Meticulous",
    "Mettlesome",
    "Mighty",
    "Mild",
    "Milky",
    "Mindful",
    "Mindless",
    "Miniature",
    "Minikin",
    "Ministerial",
    "Mint",
    "Minty",
    "Miraculous",
    "Mirthful",
    "Misty",
    "Mitigative",
    "Mitigatory",
    "Mixed",
    "Model",
    "Modern",
    "Modernistic",
    "Modest",
    "Moist",
    "Momentous",
    "Moneyed",
    "Monthly",
    "Monumental",
    "Moral",
    "Mortified",
    "Motherly",
    "Motionless",
    "Motivated",
    "Motivating",
    "Motivational",
    "Motor",
    "Mountainous",
    "Moving",
    "Multicolored",
    "Multidimensional",
    "Multidisciplined",
    "Multifaceted",
    "Mundane",
    "Munificent",
    "Muscular",
    "Musical",
    "Mutual",
    "Mysterious",
    "Narrow",
    "National",
    "Nationwide",
    "Native",
    "Natty",
    "Natural",
    "Nautical",
    "Near",
    "Nearby",
    "Neat",
    "Necessary",
    "Needed",
    "Negligible",
    "Neighboring",
    "Neighborly",
    "Neoteric",
    "Nestling",
    "New",
    "Newborn",
    "Next",
    "Nice",
    "Nifty",
    "Nimble",
    "Nippy",
    "Noble",
    "Nocturnal",
    "Noetic",
    "Nonchalant",
    "Nonpareil",
    "Nonstop",
    "Normal",
    "Notable",
    "Noted",
    "Noteworthy",
    "Noticeable",
    "Nourished",
    "Nourishing",
    "Novel",
    "Nubile",
    "Nutrimental",
    "Nutritious",
    "Obedient",
    "Objective",
    "Obliging",
    "Oblong",
    "Observant",
    "Obtainable",
    "Obvious",
    "Occasional",
    "Oecumenical",
    "Official",
    "Okay",
    "Olympian",
    "Onward",
    "Open",
    "Operative",
    "Opportune",
    "Optimal",
    "Optimistic",
    "Optimum",
    "Opulent",
    "Orange",
    "Orderly",
    "Ordinary",
    "Organic",
    "Organized",
    "Oriented",
    "Original",
    "Ornamental",
    "Ornate",
    "Ornery",
    "Outgoing",
    "Outlandish",
    "Outlying",
    "Outrageous",
    "Outstanding",
    "Oval",
    "Overflowing",
    "Overjoyed",
    "Overriding",
    "Overt",
    "Palatable",
    "Pally",
    "Palpable",
    "Paradisiac",
    "Paradisiacal",
    "Parallel",
    "Paramount",
    "Parched",
    "Parental",
    "Parnassian",
    "Partial",
    "Participant",
    "Participative",
    "Particular",
    "Partisan",
    "Passionate",
    "Pastel",
    "Paternal",
    "Patient",
    "Peaceable",
    "Peaceful",
    "Peachy",
    "Peerless",
    "Penetrating",
    "Peppery",
    "Peppy",
    "Perceptive",
    "Perfect",
    "Perfumed",
    "Periodic",
    "Perky",
    "Permanent",
    "Permissive",
    "Perseverant",
    "Persevering",
    "Persistent",
    "Personable",
    "Personal",
    "Perspective",
    "Perspicacious",
    "Perspicuous",
    "Persuasive",
    "Pert",
    "Pertinent",
    "Petite",
    "Phenomenal",
    "Philanthropic",
    "Philoprogenitive",
    "Philosophical",
    "Physical",
    "Picked",
    "Picturesque",
    "Piercing",
    "Pierian",
    "Pilot",
    "Pink",
    "Pioneering",
    "Pious",
    "Piquant",
    "Pithy",
    "Pivotal",
    "Placid",
    "Plain",
    "Plaintive",
    "Plastic",
    "Plausible",
    "Playful",
    "Pleasant",
    "Pleased",
    "Pleasing",
    "Pleasurable",
    "Plenary",
    "Plenteous",
    "Plentiful",
    "Pliable",
    "Plucky",
    "Plummy",
    "Plump",
    "Plush",
    "Poetic",
    "Poignant",
    "Pointed",
    "Poised",
    "Polished",
    "Polite",
    "Political",
    "Popular",
    "Portly",
    "Posh",
    "Positive",
    "Possible",
    "Potable",
    "Potent",
    "Potential",
    "Powerful",
    "Practicable",
    "Practical",
    "Practised",
    "Pragmatic",
    "Praiseworthy",
    "Prayerful",
    "Precious",
    "Precise",
    "Predominant",
    "Preeminent",
    "Preferable",
    "Preferred",
    "Premier",
    "Premium",
    "Prepared",
    "Preponderant",
    "Prepotent",
    "Present",
    "Prestigious",
    "Pretty",
    "Prevailing",
    "Prevalent",
    "Prevenient",
    "Previous",
    "Primal",
    "Primary",
    "Prime",
    "Primed",
    "Primo",
    "Princely",
    "Principled",
    "Pristine",
    "Private",
    "Privileged",
    "Prize",
    "Prized",
    "Prizewinning",
    "Pro",
    "Proactive",
    "Probable",
    "Probative",
    "Procurable",
    "Prodigious",
    "Productive",
    "Professional",
    "Proficient",
    "Profitable",
    "Profound",
    "Profuse",
    "Progressive",
    "Prolific",
    "Prominent",
    "Promising",
    "Prompt",
    "Proper",
    "Propertied",
    "Prophetic",
    "Propitious",
    "Prospective",
    "Prosperous",
    "Protean",
    "Protective",
    "Proud",
    "Provocative",
    "Prudent",
    "Puissant",
    "Pulchritudinous",
    "Punchy",
    "Punctilious",
    "Punctual",
    "Pungent",
    "Pure",
    "Purple",
    "Purposeful",
    "Quaint",
    "Qualified",
    "Qualitative",
    "Quality",
    "Quantifiable",
    "Quarterly",
    "Queenly",
    "Questionable",
    "Quick",
    "Quiet",
    "Quietsome",
    "Quintessential",
    "Quirky",
    "Quiver",
    "Quixotic",
    "Quizzical",
    "Quotable",
    "Racy",
    "Rad",
    "Radiant",
    "Rapid",
    "Rapturous",
    "Rare",
    "Rational",
    "Raw",
    "Reachable",
    "Ready",
    "Real",
    "Realistic",
    "Realizable",
    "Reasonable",
    "Reassuring",
    "Recent",
    "Receptive",
    "Recherche",
    "Recipient",
    "Reciprocal",
    "Recognizable",
    "Recognized",
    "Recommendable",
    "Rectangular",
    "Recuperative",
    "Refined",
    "Reflecting",
    "Reflective",
    "Refreshing",
    "Refulgent",
    "Regal",
    "Regnant",
    "Regular",
    "Rejuvenescent",
    "Relaxed",
    "Relevant",
    "Reliable",
    "Relieved",
    "Remarkable",
    "Remissive",
    "Remote",
    "Renowned",
    "Repentant",
    "Reputable",
    "Required",
    "Resilient",
    "Resolute",
    "Resolved",
    "Resounding",
    "Resourceful",
    "Respectable",
    "Respectful",
    "Resplendent",
    "Responsible",
    "Responsive",
    "Restful",
    "Restorative",
    "Retentive",
    "Revealing",
    "Revered",
    "Reverent",
    "Revitalizing",
    "Revolutionary",
    "Revolving",
    "Rewardable",
    "Rewarding",
    "Rhapsodic",
    "Rich",
    "Right",
    "Righteous",
    "Rightful",
    "Ringed",
    "Ripe",
    "Risible",
    "Robust",
    "Rollicking",
    "Romantic",
    "Rooted",
    "Rosy",
    "Rotating",
    "Round",
    "Rounded",
    "Rousing",
    "Royal",
    "Rugged",
    "Ruling",
    "Runny",
    "Rural",
    "Saccharine",
    "Sacred",
    "Sacrosanct",
    "Safe",
    "Sagacious",
    "Sage",
    "Saintly",
    "Salient",
    "Salubrious",
    "Salutary",
    "Salutiferous",
    "Sanctified",
    "Sanctimonious",
    "Sanctioned",
    "Sandy",
    "Sane",
    "Sanguine",
    "Sapid",
    "Sapient",
    "Sapoforic",
    "Sassy",
    "Satisfactory",
    "Satisfied",
    "Satisfying",
    "Saucy",
    "Saving",
    "Savory",
    "Savvy",
    "Scenic",
    "Scented",
    "Scholarly",
    "Scientific",
    "Scintillating",
    "Scrumptious",
    "Scrupulous",
    "Seamless",
    "Seasonal",
    "Seasoned",
    "Second",
    "Secondary",
    "Secret",
    "Secure",
    "Sedulous",
    "Seemly",
    "Select",
    "Selfless",
    "Sensational",
    "Sensible",
    "Sensitive",
    "Sensuous",
    "Sentimental",
    "Separate",
    "Sequacious",
    "Serendipitous",
    "Serene",
    "Serious",
    "Service",
    "Settled",
    "Several",
    "Severe",
    "Shabby",
    "Shadowy",
    "Shapely",
    "Sharp",
    "Shatterproof",
    "Sheen",
    "Shimmering",
    "Shining",
    "Shiny",
    "Shipshape",
    "Shocked",
    "Short",
    "Showy",
    "Shrewd",
    "Sightly",
    "Significant",
    "Silent",
    "Silken",
    "Silky",
    "Silver",
    "Silvery",
    "Similar",
    "Simple",
    "Simplistic",
    "Sincere",
    "Sinewy",
    "Single",
    "Singular",
    "Sisterly",
    "Sizable",
    "Sizzling",
    "Skeletal",
    "Skilled",
    "Skillful",
    "Sleek",
    "Slick",
    "Slight",
    "Slim",
    "Slinky",
    "Slippery",
    "Slow",
    "Smacking",
    "Small",
    "Smart",
    "Smashing",
    "Smiley",
    "Smooth",
    "Snap",
    "Snappy",
    "Snazzy",
    "Snod",
    "Snoopy",
    "Snug",
    "Soaring",
    "Sociable",
    "Social",
    "Societal",
    "Soft",
    "Soigne",
    "Solicitous",
    "Solid",
    "Sonsy",
    "Sooth",
    "Soothing",
    "Sophisticated",
    "Soulful",
    "Sound",
    "Soupy",
    "Sour",
    "Sovereign",
    "Spacious",
    "Spangly",
    "Spanking",
    "Sparkling",
    "Sparkly",
    "Special",
    "Specific",
    "Spectacular",
    "Specular",
    "Speedy",
    "Spellbinding",
    "Spherical",
    "Spicy",
    "Spiffy",
    "Spirited",
    "Spiritual",
    "Splendid",
    "Splendiferous",
    "Spontaneous",
    "Sport",
    "Sporting",
    "Sportive",
    "Sporty",
    "Spotless",
    "Sprightly",
    "Spruce",
    "Spry",
    "Spunky",
    "Square",
    "Stable",
    "Stacked",
    "Stainless",
    "Stalwart",
    "Staminal",
    "Standard",
    "Standing",
    "Star",
    "Starchy",
    "Stark",
    "Starry",
    "State",
    "Stately",
    "Statuesque",
    "Staunch",
    "Steadfast",
    "Steady",
    "Steamy",
    "Steel",
    "Stellar",
    "Sterling",
    "Sthenic",
    "Stimulant",
    "Stimulating",
    "Stimulative",
    "Stipendiary",
    "Stirred",
    "Stirring",
    "Stocky",
    "Stoical",
    "Storied",
    "Stout",
    "Stouthearted",
    "Straightforward",
    "Strange",
    "Strapping",
    "Strategic",
    "Streetwise",
    "Strenuous",
    "Strict",
    "Strident",
    "Striking",
    "Striped",
    "Strong",
    "Studious",
    "Stunning",
    "Stupendous",
    "Sturdy",
    "Stylish",
    "Suasive",
    "Suave",
    "Sublime",
    "Substant",
    "Substantial",
    "Substantive",
    "Subtle",
    "Suburban",
    "Successful",
    "Succinct",
    "Succulent",
    "Sufficient",
    "Sugary",
    "Suitable",
    "Sultry",
    "Summary",
    "Summery",
    "Sumptuous",
    "Sunny",
    "Super",
    "Superabundant",
    "Superb",
    "Supereminent",
    "Superethical",
    "Superexcellent",
    "Superficial",
    "Superfluous",
    "Superior",
    "Superlative",
    "Supernal",
    "Supersonic",
    "Supple",
    "Supportive",
    "Supreme",
    "Sure",
    "Surpassing",
    "Surprised",
    "Sustained",
    "Svelte",
    "Swank",
    "Swashbuckling",
    "Sweet",
    "Swell",
    "Swift",
    "Swish",
    "Sybaritic",
    "Sylvan",
    "Symmetrical",
    "Sympathetic",
    "Symphonious",
    "Synergistic",
    "Systematic",
    "Tactful",
    "Talented",
    "Tall",
    "Tame",
    "Tan",
    "Tangible",
    "Tart",
    "Tasteful",
    "Tasty",
    "Teachable",
    "Teeming",
    "Tempean",
    "Temperate",
    "Tenable",
    "Tenacious",
    "Tender",
    "Terrific",
    "Testimonial",
    "Thankful",
    "Thankworthy",
    "Therapeutic",
    "Thorough",
    "Those",
    "Thoughtful",
    "Thrifty",
    "Thrilled",
    "Thrilling",
    "Thriving",
    "Tidy",
    "Tight",
    "Timeless",
    "Timely",
    "Tinted",
    "Tiny",
    "Tiptop",
    "Tireless",
    "Titanic",
    "Titillating",
    "Today",
    "Together",
    "Tolerant",
    "Top",
    "Tops",
    "Total",
    "Touching",
    "Tough",
    "Trailblazing",
    "Trained",
    "Tranquil",
    "Transcendent",
    "Transcendental",
    "Transient",
    "Transparent",
    "Transpicuous",
    "Traveled",
    "Treasured",
    "Tremendous",
    "Triangular",
    "Trim",
    "Triumphant",
    "True",
    "Trustful",
    "Trusting",
    "Trustworthy",
    "Trusty",
    "Truthful",
    "Tubular",
    "Tuneful",
    "Turgent",
    "Twin",
    "Tympanic",
    "Uber",
    "Ultimate",
    "Ultra",
    "Ultraprecise",
    "Unabashed",
    "Unadulterated",
    "Unaffected",
    "Unafraid",
    "Unalloyed",
    "Unambiguous",
    "Unanimous",
    "Unarguable",
    "Unassuming",
    "Unattached",
    "Unbeaten",
    "Unbelievable",
    "Unbiased",
    "Unbigoted",
    "Unblemished",
    "Unbroken",
    "Uncommon",
    "Uncomplicated",
    "Unconditional",
    "Unconscious",
    "Uncontestable",
    "Unconventional",
    "Uncorrupted",
    "Uncritical",
    "Undamaged",
    "Undauntable",
    "Undaunted",
    "Undefeated",
    "Undefiled",
    "Undeniable",
    "Understandable",
    "Understanding",
    "Understated",
    "Understood",
    "Undesigning",
    "Undiminished",
    "Undisputed",
    "Undivided",
    "Undoubted",
    "Unencumbered",
    "Unequaled",
    "Unequalled",
    "Unequivocal",
    "Unerring",
    "Unfailing",
    "Unfaltering",
    "Unfaultable",
    "Unfeigned",
    "Unfettered",
    "Unflagging",
    "Unflappable",
    "Ungrudging",
    "Unhampered",
    "Unharmed",
    "Unhesitating",
    "Unhurt",
    "Unified",
    "Uniform",
    "Unimpaired",
    "Unimpeachable",
    "Unimpeded",
    "Unique",
    "United",
    "Universal",
    "Unlimited",
    "Unmistakable",
    "Unmitigated",
    "Unobjectionable",
    "Unobstructed",
    "Unobtrusive",
    "Unopposed",
    "Unpretentious",
    "Unquestionable",
    "Unrefuted",
    "Unreserved",
    "Unrivalled",
    "Unruffled",
    "Unselfish",
    "Unshakable",
    "Unshaken",
    "Unspoiled",
    "Unspoilt",
    "Unstoppable",
    "Unsullied",
    "Unsurpassed",
    "Untarnished",
    "Untiring",
    "Untouched",
    "Untroubled",
    "Ununprejudiced",
    "Unusual",
    "Unwavering",
    "Upbeat",
    "Upcoming",
    "Uplifted",
    "Uplifting",
    "Uppermost",
    "Upright",
    "Upset",
    "Upstanding",
    "Upward",
    "Upwardly",
    "Urban",
    "Urbane",
    "Usable",
    "Useful",
    "Useless",
    "Utmost",
    "Vacant",
    "Vain",
    "Valiant",
    "Valid",
    "Validatory",
    "Valorous",
    "Valuable",
    "Valued",
    "Vapid",
    "Variable",
    "Vast",
    "Vaulting",
    "Vehement",
    "Velvety",
    "Venerable",
    "Venerated",
    "Venturesome",
    "Venue",
    "Veracious",
    "Verdurous",
    "Veridical",
    "Verifiable",
    "Verified",
    "Versatile",
    "Versed",
    "Vestal",
    "Veteran",
    "Viable",
    "Vibrant",
    "Vibratile",
    "Victor",
    "Victorious",
    "Vigilant",
    "Vigorous",
    "Violet",
    "Virile",
    "Virtual",
    "Virtuous",
    "Visible",
    "Visionary",
    "Vital",
    "Vivacious",
    "Vivid",
    "Vocal",
    "Volant",
    "Volitional",
    "Voluminous",
    "Voluptuous",
    "Vulnerary",
    "Wanted",
    "Warm",
    "Warmhearted",
    "Warranted",
    "Wasteful",
    "Watchful",
    "Waterlogged",
    "Watery",
    "Wavy",
    "Wealthy",
    "Weekly",
    "Weighty",
    "Welcome",
    "Welcomed",
    "Welcoming",
    "Weleful",
    "Welfaring",
    "Well",
    "Welsome",
    "Wet",
    "Whimsical",
    "Whole",
    "Wholehearted",
    "Wholesome",
    "Whopping",
    "Wide",
    "Wild",
    "Willed",
    "Willing",
    "Winding",
    "Windy",
    "Winged",
    "Winning",
    "Winsome",
    "Wired",
    "Wise",
    "Witty",
    "Wizard",
    "Wizardly",
    "Wobbly",
    "Wonderful",
    "Wondrous",
    "Wooden",
    "Wordy",
    "Workable",
    "Worldly",
    "Worshipful",
    "Worth",
    "Worthwhile",
    "Worthy",
    "Xenial",
    "Xenodochial",
    "Yearly",
    "Yern",
    "Young",
    "Youthful",
    "Yummy",
    "Zaftig",
    "Zany",
    "Zappy",
    "Zazzy",
    "Zealand",
    "Zealful",
    "Zealous",
    "Zestful",
    "Zesty",
    "Zigzag",
    "Zingy",
    "Zippy",
    "Zootrophic",
    "Zooty"
  ]

nouns :: [Text]
nouns =
  [ "Academician",
    "Acceptor",
    "Access",
    "Acclaim",
    "Accolade",
    "Account",
    "Accuracy",
    "Ace",
    "Achiever",
    "Acumen",
    "Addition",
    "Adherent",
    "Adjutant",
    "Administrator",
    "Admirer",
    "Adorer",
    "Advantage",
    "Aesthete",
    "Aficionada",
    "Aficionado",
    "Agent",
    "Aide",
    "Almsgiver",
    "Altruist",
    "Ambassador",
    "Amity",
    "Angel",
    "Apostle",
    "Appreciator",
    "Arbiter",
    "Archetype",
    "Architect",
    "Artisan",
    "Artist",
    "Artiste",
    "Asset",
    "Assignee",
    "Assigner",
    "Athlete",
    "Author",
    "Authority",
    "Avowal",
    "Awardee",
    "Aye",
    "Azure",
    "Baby",
    "Backer",
    "Backup",
    "Beatitude",
    "Beauty",
    "Begetter",
    "Being",
    "Believer",
    "Benchmark",
    "Benefaction",
    "Benefactor",
    "Benefactress",
    "Beneficiary",
    "Benefit",
    "Bestower",
    "Betterment",
    "Bigwig",
    "Blessing",
    "Bliss",
    "Bloom",
    "Blossom",
    "Blossoming",
    "Bodyguard",
    "Bonanza",
    "Bonus",
    "Boost",
    "Booster",
    "Boss",
    "Bound",
    "Bounty",
    "Brain",
    "Brass",
    "Brief",
    "Brother",
    "Buddy",
    "Builder",
    "Calm",
    "Campaigner",
    "Capital",
    "Captain",
    "Care",
    "Caretaker",
    "Catalyst",
    "Cause",
    "Celebrant",
    "Celebrator",
    "Celestial",
    "Chair",
    "Chairperson",
    "Chamberlain",
    "Champ",
    "Champion",
    "Charity",
    "Charmer",
    "Cheer",
    "Cheers",
    "Chief",
    "Chieftain",
    "Chirpy",
    "Choice",
    "Chortle",
    "Chosen",
    "Chuckle",
    "Chum",
    "Cinch",
    "Civility",
    "Clairvoyant",
    "Classic",
    "Clear",
    "Climb",
    "Climber",
    "Climbing",
    "Close",
    "Closing",
    "Coadjutant",
    "Coadjutor",
    "Coequal",
    "Coiner",
    "Collaborator",
    "Colleague",
    "Collector",
    "Comfort",
    "Comforter",
    "Comic",
    "Commander",
    "Commendatory",
    "Compassion",
    "Composer",
    "Comrade",
    "Concierge",
    "Condolence",
    "Conductor",
    "Confederate",
    "Confidant",
    "Confidence",
    "Connoisseur",
    "Consciousness",
    "Conservator",
    "Consoler",
    "Constant",
    "Constitutional",
    "Consul",
    "Consultant",
    "Contemporary",
    "Content",
    "Contributor",
    "Controller",
    "Conversant",
    "Cooperator",
    "Cope",
    "Cornerstone",
    "Councillor",
    "Counselor",
    "Courage",
    "Crack",
    "Crackerjack",
    "Craftsperson",
    "Creator",
    "Credential",
    "Credit",
    "Curator",
    "Custodian",
    "Dainty",
    "Dancer",
    "Daring",
    "Darling",
    "Dean",
    "Dear",
    "Decency",
    "Deep",
    "Defender",
    "Definite",
    "Delight",
    "Demulcent",
    "Deserving",
    "Designer",
    "Devisee",
    "Devisor",
    "Devotee",
    "Devotional",
    "Devout",
    "Didactic",
    "Director",
    "Disciple",
    "Discoverer",
    "Distributor",
    "Doer",
    "Doll",
    "Donee",
    "Donor",
    "Doting",
    "Doyen",
    "Doyenne",
    "Dreamboat",
    "Dynamic",
    "Dynamite",
    "Dynamo",
    "Earnest",
    "Ease",
    "Effect",
    "Efficiency",
    "Efficient",
    "Einstein",
    "Elder",
    "Eligible",
    "Employer",
    "Enchanter",
    "Enchantress",
    "Encourager",
    "Endorser",
    "Enlivening",
    "Enough",
    "Entertainer",
    "Enthusiast",
    "Entrepreneur",
    "Epicure",
    "Epicurean",
    "Epitome",
    "Equal",
    "Equity",
    "Equivalent",
    "Essence",
    "Essential",
    "Esteem",
    "Eternal",
    "Ethic",
    "Example",
    "Exclusive",
    "Executive",
    "Exemplar",
    "Exemplary",
    "Experimenter",
    "Expert",
    "Exponent",
    "Eyes",
    "Fair",
    "Faith",
    "Faithful",
    "Fame",
    "Familiar",
    "Fancier",
    "Fancy",
    "Fantastic",
    "Fare",
    "Fascinator",
    "Fashioner",
    "Favor",
    "Favorite",
    "Favour",
    "Felicity",
    "Fine",
    "Fireball",
    "Firm",
    "First",
    "Fleet",
    "Folks",
    "Foodie",
    "Forbear",
    "Force",
    "Forefather",
    "Foreman",
    "Forerunner",
    "Foresight",
    "Forever",
    "Forgiveness",
    "Fortunate",
    "Fortune",
    "Forward",
    "Foundation",
    "Founder",
    "Fountain",
    "Fountainhead",
    "Freedom",
    "Freethinking",
    "Fresh",
    "Friend",
    "Friendly",
    "Fulfilling",
    "Full",
    "Fun",
    "Funny",
    "Gag",
    "Gaiety",
    "Gain",
    "Gala",
    "Galahad",
    "Gale",
    "Gallant",
    "Gallantry",
    "Game",
    "Garb",
    "Garden",
    "Garland",
    "Garnish",
    "Gastronome",
    "Gastronomy",
    "Gather",
    "Gathering",
    "Geek",
    "Gem",
    "Generativity",
    "Generator",
    "Generosity",
    "Genius",
    "Gentle",
    "Gentlefolk",
    "Gentleman",
    "Gentlewoman",
    "Gift",
    "Gild",
    "Gilt",
    "Girlfriend",
    "Gist",
    "Giver",
    "Giving",
    "Glamour",
    "Glance",
    "Glare",
    "Glaze",
    "Gleam",
    "Gleaming",
    "Glimmer",
    "Glimmering",
    "Glint",
    "Glisten",
    "Glister",
    "Glitterati",
    "Glitz",
    "Glory",
    "Gloss",
    "Glossy",
    "Goal",
    "God",
    "Goddess",
    "Godparent",
    "Godsend",
    "Golconda",
    "Gold",
    "Good",
    "Goodness",
    "Goodwill",
    "Goody",
    "Gorgeousness",
    "Gourmet",
    "Governor",
    "Grace",
    "Gracility",
    "Graciousness",
    "Grade",
    "Graduate",
    "Grammy",
    "Grandee",
    "Grandeur",
    "Grandmaster",
    "Grant",
    "Grantee",
    "Grantor",
    "Grass",
    "Gratefulness",
    "Gratification",
    "Gratitude",
    "Great",
    "Greatness",
    "Greeting",
    "Grin",
    "Grit",
    "Groove",
    "Growing",
    "Growth",
    "Grubstake",
    "Guarantor",
    "Guard",
    "Guardian",
    "Guest",
    "Guffaw",
    "Guidance",
    "Guide",
    "Gumption",
    "Guru",
    "Gush",
    "Gusto",
    "Gut",
    "Gymnastic",
    "Hale",
    "Handler",
    "Happening",
    "Harmony",
    "Head",
    "Headman",
    "Heart",
    "Heartthrob",
    "Heaven",
    "Height",
    "Heir",
    "Heiress",
    "Hello",
    "Help",
    "Helper",
    "Helpmate",
    "Heritor",
    "Heritress",
    "Heritrix",
    "Hero",
    "Heroine",
    "Heuristic",
    "Highflier",
    "Hilarity",
    "Holy",
    "Honesty",
    "Honor",
    "Hooray",
    "Hope",
    "Hopeful",
    "Hotshot",
    "Humanitarian",
    "Humor",
    "Husband",
    "Icon",
    "Idea",
    "Ideal",
    "Idol",
    "Idolizer",
    "Improvement",
    "Inamorata",
    "Inamorato",
    "Increase",
    "Independent",
    "Indivisible",
    "Industrialist",
    "Infant",
    "Infinite",
    "Ingenuity",
    "Inheritor",
    "Initiative",
    "Initiator",
    "Innocent",
    "Innovator",
    "Inspiration",
    "Institutor",
    "Integral",
    "Intellect",
    "Intent",
    "Interest",
    "Intimate",
    "Inventor",
    "Invitation",
    "Invite",
    "Invitee",
    "Jest",
    "Jester",
    "Jingle",
    "Joker",
    "Josh",
    "Jubilation",
    "Juggler",
    "Justice",
    "Keeper",
    "Key",
    "Kindred",
    "Kingpin",
    "Kiss",
    "Knight",
    "Lady",
    "Lark",
    "Lasting",
    "Latitudinarian",
    "Laugh",
    "Laureate",
    "Lead",
    "Leader",
    "Learning",
    "Legatee",
    "Legator",
    "Legend",
    "Legislator",
    "Leisure",
    "Liberation",
    "Libertarian",
    "Lieutenant",
    "Life",
    "Light",
    "Like",
    "Liking",
    "Lionheart",
    "Literate",
    "Lord",
    "Love",
    "Lover",
    "Luck",
    "Lust",
    "Luster",
    "Lustre",
    "Luxury",
    "Maestro",
    "Magician",
    "Magistrate",
    "Magnitude",
    "Majesty",
    "Major",
    "Majority",
    "Make",
    "Maker",
    "Mana",
    "Manager",
    "Manner",
    "Marvel",
    "Massage",
    "Mastermind",
    "Mate",
    "Matriarch",
    "Matter",
    "Mentor",
    "Mercy",
    "Merit",
    "Method",
    "Might",
    "Minder",
    "Minikin",
    "Mint",
    "Miracle",
    "Mirth",
    "Model",
    "Modern",
    "Mom",
    "Moppet",
    "Morale",
    "Most",
    "Motivator",
    "Motor",
    "Mover",
    "Moving",
    "Much",
    "Multitude",
    "Music",
    "Nabit",
    "Narration",
    "Narrator",
    "Nascency",
    "Natation",
    "National",
    "Native",
    "Natural",
    "Negoce",
    "Neighbor",
    "Neonate",
    "Neoteric",
    "Nestling",
    "Newborn",
    "Nicety",
    "Nimblewit",
    "Nipper",
    "Nirvana",
    "Noble",
    "Nobleman",
    "Nod",
    "Nonpareil",
    "Noon",
    "Notable",
    "Note",
    "Notice",
    "Novel",
    "Nudge",
    "Nurse",
    "Nursling",
    "Nurture",
    "Objective",
    "Offer",
    "Officer",
    "Official",
    "Offspring",
    "Olympian",
    "One",
    "Oodles",
    "Oomph",
    "Ooze",
    "Operator",
    "Opportunity",
    "Optimist",
    "Optimum",
    "Orchestrator",
    "Organizer",
    "Original",
    "Originator",
    "Ornamental",
    "Overflowing",
    "Overseer",
    "Owner",
    "Pacifist",
    "Pal",
    "Paradigm",
    "Paradise",
    "Paragon",
    "Paramount",
    "Pard",
    "Pardon",
    "Parent",
    "Participant",
    "Particular",
    "Partisan",
    "Partner",
    "Passion",
    "Pathfinder",
    "Patience",
    "Patient",
    "Patriarch",
    "Patron",
    "Peace",
    "Peacekeeper",
    "Peach",
    "Peak",
    "Pearl",
    "Peer",
    "Pep",
    "Perfection",
    "Perfectionist",
    "Performer",
    "Personality",
    "Perspective",
    "Pet",
    "Phenomenon",
    "Philanthropist",
    "Philanthropy",
    "Philosopher",
    "Pick",
    "Pilot",
    "Pioneer",
    "Pivot",
    "Plan",
    "Planner",
    "Play",
    "Player",
    "Playmate",
    "Pleasing",
    "Pleasure",
    "Plenitude",
    "Plenty",
    "Poet",
    "Poise",
    "Positive",
    "Possessor",
    "Possible",
    "Postulant",
    "Potential",
    "Pragmatic",
    "Praise",
    "Prayer",
    "Precious",
    "Preemption",
    "Premier",
    "Premium",
    "Presence",
    "Present",
    "Presenter",
    "President",
    "Pretty",
    "Primary",
    "Prime",
    "Primogenitor",
    "Prince",
    "Princess",
    "Principal",
    "Prize",
    "Pro",
    "Proconsul",
    "Procreator",
    "Prodigy",
    "Produce",
    "Producer",
    "Professional",
    "Professor",
    "Progenitor",
    "Progeny",
    "Progress",
    "Progressive",
    "Prolepsis",
    "Promoter",
    "Promotion",
    "Promulgator",
    "Prophet",
    "Proponent",
    "Proposer",
    "Proprietor",
    "Prospective",
    "Protagonist",
    "Protector",
    "Protege",
    "Provider",
    "Provocative",
    "Publisher",
    "Purveyor",
    "Quaff",
    "Quaintise",
    "Quaintisiness",
    "Quality",
    "Quantity",
    "Quarter",
    "Queen",
    "Queenhood",
    "Querist",
    "Quest",
    "Quester",
    "Question",
    "Quick",
    "Quickness",
    "Quickstep",
    "Quiet",
    "Quillet",
    "Quintessence",
    "Quip",
    "Quirk",
    "Quotation",
    "Radiant",
    "Rapture",
    "Rational",
    "Ready",
    "Real",
    "Reason",
    "Receiver",
    "Reception",
    "Reciprocal",
    "Recuperation",
    "Regulator",
    "Rejoicing",
    "Rejuvenation",
    "Release",
    "Relief",
    "Reliever",
    "Renovation",
    "Reputation",
    "Resource",
    "Respect",
    "Restoration",
    "Result",
    "Reverence",
    "Reward",
    "Rhapsody",
    "Rich",
    "Right",
    "Rise",
    "Roll",
    "Romantic",
    "Romeo",
    "Rooter",
    "Rose",
    "Round",
    "Rouse",
    "Ruler",
    "Ruling",
    "Run",
    "Runner",
    "Sage",
    "Saint",
    "Salient",
    "Salubrity",
    "Salute",
    "Sanctity",
    "Sanctuary",
    "Satisfaction",
    "Savant",
    "Saver",
    "Savior",
    "Savory",
    "Savvy",
    "Scholar",
    "Scholarship",
    "Science",
    "Scion",
    "Script",
    "Scripter",
    "Sculptor",
    "Seeker",
    "Select",
    "Sensation",
    "Sense",
    "Sensibility",
    "Sentiment",
    "Sentinel",
    "Serendipity",
    "Serene",
    "Serenity",
    "Server",
    "Set",
    "Settling",
    "Shape",
    "Share",
    "Sharp",
    "Sharpy",
    "Shaver",
    "Shelter",
    "Shine",
    "Show",
    "Sight",
    "Significance",
    "Significant",
    "Simplicity",
    "Sinew",
    "Sir",
    "Sire",
    "Sister",
    "Size",
    "Skill",
    "Skipper",
    "Sleek",
    "Slick",
    "Smash",
    "Smile",
    "Smooth",
    "Smoothie",
    "Snap",
    "Snuggle",
    "Soar",
    "Sociable",
    "Social",
    "Socializer",
    "Sol",
    "Solid",
    "Sophisticate",
    "Soul",
    "Sovereign",
    "Spark",
    "Sparkling",
    "Special",
    "Specialist",
    "Spectacle",
    "Spectacular",
    "Speed",
    "Spell",
    "Spice",
    "Spirit",
    "Spiritual",
    "Splendor",
    "Sponsor",
    "Sport",
    "Sportsmanship",
    "Spot",
    "Sprite",
    "Sprout",
    "Squire",
    "Stalwart",
    "Standard",
    "Star",
    "State",
    "Steady",
    "Steward",
    "Stipend",
    "Stipendiary",
    "Stir",
    "Stirring",
    "Strategist",
    "Strategy",
    "Stripling",
    "Strive",
    "Student",
    "Style",
    "Stylist",
    "Sublime",
    "Substance",
    "Success",
    "Successor",
    "Sufficiency",
    "Sugar",
    "Suitor",
    "Summary",
    "Summer",
    "Super",
    "Superintendent",
    "Superior",
    "Superlative",
    "Superman",
    "Supervisor",
    "Superwoman",
    "Supplier",
    "Supply",
    "Support",
    "Surety",
    "Surprise",
    "Survivor",
    "Swain",
    "Sweetheart",
    "Sweetness",
    "Swell",
    "Sympathy",
    "Synergy",
    "System",
    "Tact",
    "Talent",
    "Taste",
    "Teacher",
    "Teaching",
    "Team",
    "Teammate",
    "Tender",
    "Testament",
    "Testator",
    "Testimonial",
    "Testimony",
    "Thank",
    "Thanksgiving",
    "Therapy",
    "Thinker",
    "Thrill",
    "Timesaver",
    "Tiptop",
    "Titleholder",
    "Today",
    "Tootsie",
    "Top",
    "Tot",
    "Total",
    "Touch",
    "Tout",
    "Trailblazer",
    "Training",
    "Tranquillity",
    "Transcendent",
    "Transient",
    "Travel",
    "Treasure",
    "Trim",
    "Triumph",
    "Trust",
    "Trustee",
    "Trusty",
    "Truth",
    "Try",
    "Tuition",
    "Tune",
    "Tutor",
    "Tycoon",
    "Uberty",
    "Ubiquitary",
    "Ultimate",
    "Ultimation",
    "Understanding",
    "Underwriter",
    "Unique",
    "Universal",
    "Upholder",
    "Uplift",
    "Valedictorian",
    "Valiant",
    "Validator",
    "Valuable",
    "Value",
    "Vast",
    "Vaulter",
    "Veracity",
    "Vestal",
    "Veteran",
    "Virtue",
    "Virtuosity",
    "Visionary",
    "Visitor",
    "Vitality",
    "Vogue",
    "Votary",
    "Warden",
    "Warmth",
    "Warrantee",
    "Warrantor",
    "Welcome",
    "Well",
    "Wellspring",
    "Whip",
    "Whiz",
    "Whole",
    "Wife",
    "Will",
    "Willpower",
    "Win",
    "Winner",
    "Winning",
    "Wisdom",
    "Wise",
    "Wizard",
    "Wonder",
    "Wonderment",
    "Wooer",
    "Wordsmith",
    "Workhorse",
    "Workmate",
    "Worshipper",
    "Worth",
    "Worthy",
    "Writer",
    "Wunderkind",
    "X",
    "Xenagogue",
    "Xenium",
    "Xenophile",
    "Xenophilia",
    "Xesturgy",
    "Xfactor",
    "Yard",
    "Yeve",
    "Yield",
    "Yift",
    "Yoke",
    "Young",
    "Youngster",
    "Youth",
    "Zaniness",
    "Zarf",
    "Zeal",
    "Zegedine",
    "Zest",
    "Zibeline",
    "Zing"
  ]
