/* Autogenerated file, do not edit manually */
package chat.delta.rpc.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo.Id;
import com.fasterxml.jackson.annotation.JsonTypeInfo.As;

@JsonTypeInfo(use=Id.NAME, include=As.PROPERTY, property="kind")
@JsonSubTypes({@Type(value = Qr.AskVerifyContact.class, name="AskVerifyContact"), @Type(value = Qr.AskVerifyGroup.class, name="AskVerifyGroup"), @Type(value = Qr.AskJoinBroadcast.class, name="AskJoinBroadcast"), @Type(value = Qr.FprOk.class, name="FprOk"), @Type(value = Qr.FprMismatch.class, name="FprMismatch"), @Type(value = Qr.FprWithoutAddr.class, name="FprWithoutAddr"), @Type(value = Qr.Account.class, name="Account"), @Type(value = Qr.Backup2.class, name="Backup2"), @Type(value = Qr.BackupTooNew.class, name="BackupTooNew"), @Type(value = Qr.WebrtcInstance.class, name="WebrtcInstance"), @Type(value = Qr.Proxy.class, name="Proxy"), @Type(value = Qr.Addr.class, name="Addr"), @Type(value = Qr.Url.class, name="Url"), @Type(value = Qr.Text.class, name="Text"), @Type(value = Qr.WithdrawVerifyContact.class, name="WithdrawVerifyContact"), @Type(value = Qr.WithdrawVerifyGroup.class, name="WithdrawVerifyGroup"), @Type(value = Qr.WithdrawJoinBroadcast.class, name="WithdrawJoinBroadcast"), @Type(value = Qr.ReviveVerifyContact.class, name="ReviveVerifyContact"), @Type(value = Qr.ReviveVerifyGroup.class, name="ReviveVerifyGroup"), @Type(value = Qr.ReviveJoinBroadcast.class, name="ReviveJoinBroadcast"), @Type(value = Qr.Login.class, name="Login")})
public abstract class Qr {

/**
 * Ask the user whether to verify the contact.
 * <p>
 * If the user agrees, pass this QR code to [`crate::securejoin::join_securejoin`].
 */
  public static class AskVerifyContact extends Qr {
    /* Authentication code. */
    public String authcode;
    /* ID of the contact. */
    public Integer contact_id;
    /* Fingerprint of the contact key as scanned from the QR code. */
    public String fingerprint;
    /* Invite number. */
    public String invitenumber;
  }

/* Ask the user whether to join the group. */
  public static class AskVerifyGroup extends Qr {
    /* Authentication code. */
    public String authcode;
    /* ID of the contact. */
    public Integer contact_id;
    /* Fingerprint of the contact key as scanned from the QR code. */
    public String fingerprint;
    /* Group ID. */
    public String grpid;
    /* Group name. */
    public String grpname;
    /* Invite number. */
    public String invitenumber;
  }

/* Ask the user whether to join the broadcast channel. */
  public static class AskJoinBroadcast extends Qr {
    /* Authentication code. */
    public String authcode;
    /* ID of the contact who owns the broadcast channel and created the QR code. */
    public Integer contact_id;
    /* Fingerprint of the broadcast channel owner's key as scanned from the QR code. */
    public String fingerprint;
    /* A string of random characters, uniquely identifying this broadcast channel across all databases/clients. Called `grpid` for historic reasons: The id of multi-user chats is always called `grpid` in the database because groups were once the only multi-user chats. */
    public String grpid;
    /* Invite number. */
    public String invitenumber;
    /* The user-visible name of this broadcast channel */
    public String name;
  }

/**
 * Contact fingerprint is verified.
 * <p>
 * Ask the user if they want to start chatting.
 */
  public static class FprOk extends Qr {
    /* Contact ID. */
    public Integer contact_id;
  }

/* Scanned fingerprint does not match the last seen fingerprint. */
  public static class FprMismatch extends Qr {
    /* Contact ID. */
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public Integer contact_id;
  }

/* The scanned QR code contains a fingerprint but no e-mail address. */
  public static class FprWithoutAddr extends Qr {
    /* Key fingerprint. */
    public String fingerprint;
  }

/* Ask the user if they want to create an account on the given domain. */
  public static class Account extends Qr {
    /* Server domain name. */
    public String domain;
  }

/* Provides a backup that can be retrieved using iroh-net based backup transfer protocol. */
  public static class Backup2 extends Qr {
    /* Authentication token. */
    public String auth_token;
    /* Iroh node address. */
    public String node_addr;
  }

  public static class BackupTooNew extends Qr {
  }

/* Ask the user if they want to use the given service for video chats. */
  public static class WebrtcInstance extends Qr {
    public String domain;
    public String instance_pattern;
  }

/**
 * Ask the user if they want to use the given proxy.
 * <p>
 * Note that HTTP(S) URLs without a path and query parameters are treated as HTTP(S) proxy URL. UI may want to still offer to open the URL in the browser if QR code contents starts with `http://` or `https://` and the QR code was not scanned from the proxy configuration screen.
 */
  public static class Proxy extends Qr {
    /* Host extracted from the URL to display in the UI. */
    public String host;
    /* Port extracted from the URL to display in the UI. */
    public Integer port;
    /**
     * Proxy URL.
     * <p>
     * This is the URL that is going to be added.
     */
    public String url;
  }

/**
 * Contact address is scanned.
 * <p>
 * Optionally, a draft message could be provided. Ask the user if they want to start chatting.
 */
  public static class Addr extends Qr {
    /* Contact ID. */
    public Integer contact_id;
    /* Draft message. */
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public String draft;
  }

/**
 * URL scanned.
 * <p>
 * Ask the user if they want to open a browser or copy the URL to clipboard.
 */
  public static class Url extends Qr {
    public String url;
  }

/**
 * Text scanned.
 * <p>
 * Ask the user if they want to copy the text to clipboard.
 */
  public static class Text extends Qr {
    public String text;
  }

/* Ask the user if they want to withdraw their own QR code. */
  public static class WithdrawVerifyContact extends Qr {
    /* Authentication code. */
    public String authcode;
    /* Contact ID. */
    public Integer contact_id;
    /* Fingerprint of the contact key as scanned from the QR code. */
    public String fingerprint;
    /* Invite number. */
    public String invitenumber;
  }

/* Ask the user if they want to withdraw their own group invite QR code. */
  public static class WithdrawVerifyGroup extends Qr {
    /* Authentication code. */
    public String authcode;
    /* Contact ID. */
    public Integer contact_id;
    /* Fingerprint of the contact key as scanned from the QR code. */
    public String fingerprint;
    /* Group ID. */
    public String grpid;
    /* Group name. */
    public String grpname;
    /* Invite number. */
    public String invitenumber;
  }

/* Ask the user if they want to withdraw their own broadcast channel invite QR code. */
  public static class WithdrawJoinBroadcast extends Qr {
    /* Authentication code. */
    public String authcode;
    /* Contact ID. Always `ContactId::SELF`. */
    public Integer contact_id;
    /* Fingerprint of the contact key as scanned from the QR code. */
    public String fingerprint;
    /* ID, uniquely identifying this chat. Called grpid for historic reasons. */
    public String grpid;
    /* Invite number. */
    public String invitenumber;
    /* Broadcast name. */
    public String name;
  }

/* Ask the user if they want to revive their own QR code. */
  public static class ReviveVerifyContact extends Qr {
    /* Authentication code. */
    public String authcode;
    /* Contact ID. */
    public Integer contact_id;
    /* Fingerprint of the contact key as scanned from the QR code. */
    public String fingerprint;
    /* Invite number. */
    public String invitenumber;
  }

/* Ask the user if they want to revive their own group invite QR code. */
  public static class ReviveVerifyGroup extends Qr {
    /* Authentication code. */
    public String authcode;
    /* Contact ID. */
    public Integer contact_id;
    /* Fingerprint of the contact key as scanned from the QR code. */
    public String fingerprint;
    /* Group ID. */
    public String grpid;
    /* Contact ID. */
    public String grpname;
    /* Invite number. */
    public String invitenumber;
  }

/* Ask the user if they want to revive their own broadcast channel invite QR code. */
  public static class ReviveJoinBroadcast extends Qr {
    /* Authentication code. */
    public String authcode;
    /* Contact ID. Always `ContactId::SELF`. */
    public Integer contact_id;
    /* Fingerprint of the contact key as scanned from the QR code. */
    public String fingerprint;
    /* Globally unique chat ID. Called grpid for historic reasons. */
    public String grpid;
    /* Invite number. */
    public String invitenumber;
    /* Broadcast name. */
    public String name;
  }

/**
 * `dclogin:` scheme parameters.
 * <p>
 * Ask the user if they want to login with the email address.
 */
  public static class Login extends Qr {
    public String address;
  }

}