package com.ngrob.android.bluemoon.core.util

import com.ngrob.android.bluemoon.core.model.PillRecipe
import org.junit.Assert
import org.junit.Before
import org.junit.Test
import java.time.LocalDate
import java.time.LocalDateTime
import java.time.LocalTime

class PillUtilTest() {

    lateinit var pillRecipe21: PillRecipe;
    lateinit var pillRecipe24: PillRecipe
    lateinit var pillRecipe28: PillRecipe
    lateinit var pillRecipe91: PillRecipe
    lateinit var scheduledTime: LocalTime

    @Before
    fun setup() {
        pillRecipe21 = PillRecipe(firstIntake = LocalDate.of(2024, 4, 1), numberOfPills = 21)
        pillRecipe24 = PillRecipe(firstIntake = LocalDate.of(2024, 4, 1), numberOfPills = 24)
        pillRecipe28 = PillRecipe(firstIntake = LocalDate.of(2024, 4, 1), numberOfPills = 28)
        pillRecipe91 = PillRecipe(firstIntake = LocalDate.of(2024, 4, 1), numberOfPills = 28)
        scheduledTime = LocalTime.of(17, 0)
    }

    @Test
    fun correctDates21() {
        var date = LocalDate.of(2024, 4, 1)
        val nextPackageStart = date.plusDays(28)

        for (i in 1..21) {
            val expectedDateTime = LocalDateTime.of(date, LocalTime.of(17, 0))
            val actual =
                getDateToSchedulePillReminder(pillRecipe21, date, scheduledTime = scheduledTime)
            Assert.assertEquals(expectedDateTime, actual)
            date = date.plusDays(1)
        }

        for (i in 1..7) {
            val expectedDateTime = LocalDateTime.of(nextPackageStart, LocalTime.of(17, 0))
            val actual =
                getDateToSchedulePillReminder(pillRecipe21, date, scheduledTime = scheduledTime)
            Assert.assertEquals(expectedDateTime, actual)
            date = date.plusDays(1)
        }
    }

    @Test
    fun correctDates24() {
        var date = LocalDate.of(2024, 4, 1)
        val nextPackageStart = date.plusDays(28)

        for (i in 1..24) {
            val expectedDateTime = LocalDateTime.of(date, LocalTime.of(17, 0))
            val actual =
                getDateToSchedulePillReminder(pillRecipe24, date, scheduledTime = scheduledTime)
            Assert.assertEquals(expectedDateTime, actual)
            date = date.plusDays(1)
        }

        for (i in 1..4) {
            val expectedDateTime = LocalDateTime.of(nextPackageStart, LocalTime.of(17, 0))
            val actual =
                getDateToSchedulePillReminder(pillRecipe24, date, scheduledTime = scheduledTime)
            Assert.assertEquals(expectedDateTime, actual)
            date = date.plusDays(1)
        }
    }

    @Test
    fun correctDates28() {
        var date = LocalDate.of(2024, 4, 1)
        val nextPackageStart = date.plusDays(28)

        for (i in 1..28) {
            val expectedDateTime = LocalDateTime.of(date, LocalTime.of(17, 0))
            val actual =
                getDateToSchedulePillReminder(pillRecipe28, date, scheduledTime = scheduledTime)
            Assert.assertEquals(expectedDateTime, actual)
            date = date.plusDays(1)
        }
    }

    @Test
    fun correctDates91() {
        var date = LocalDate.of(2024, 4, 1)
        val nextPackageStart = date.plusDays(91)

        for (i in 1..91) {
            val expectedDateTime = LocalDateTime.of(date, LocalTime.of(17, 0))
            val actual =
                getDateToSchedulePillReminder(pillRecipe91, date, scheduledTime = scheduledTime)
            Assert.assertEquals(expectedDateTime, actual)
            date = date.plusDays(1)
        }
    }

    @Test
    fun correctDates21InFuture() {
        var date = LocalDate.of(2024, 4, 1)
        val nextPackageStart = date.plusDays(28)

        for (i in 1..20) {
            val expectedDateTime = LocalDateTime.of(date.plusDays(1), LocalTime.of(17, 0))
            val actual =
                getDateToSchedulePillInFuture(pillRecipe21, date, scheduledTime = scheduledTime)
            Assert.assertEquals(expectedDateTime, actual)
            date = date.plusDays(1)
        }

        val expectedDateTime = LocalDateTime.of(nextPackageStart, LocalTime.of(17, 0))
        val actual =
            getDateToSchedulePillInFuture(pillRecipe21, date, scheduledTime = scheduledTime)
        Assert.assertEquals(expectedDateTime, actual)

    }

    @Test
    fun correctDates24InFuture() {
        var date = LocalDate.of(2024, 4, 1)
        val nextPackageStart = date.plusDays(28)

        for (i in 1..23) {
            val expectedDateTime = LocalDateTime.of(date.plusDays(1), LocalTime.of(17, 0))
            val actual =
                getDateToSchedulePillInFuture(pillRecipe24, date, scheduledTime = scheduledTime)
            Assert.assertEquals(expectedDateTime, actual)
            date = date.plusDays(1)
        }

        val expectedDateTime = LocalDateTime.of(nextPackageStart, LocalTime.of(17, 0))
        val actual =
            getDateToSchedulePillInFuture(pillRecipe24, date, scheduledTime = scheduledTime)
        Assert.assertEquals(expectedDateTime, actual)

    }
}