package com.ngrob.android.bluemoon.features.symptom.components


import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ExperimentalLayoutApi
import androidx.compose.foundation.layout.FlowRow
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.material3.FilterChip
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.FilterChipDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.rememberUpdatedState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.ngrob.android.bluemoon.core.database.model.BleedingStrength
import com.ngrob.android.bluemoon.core.ui.theme.BluemoonTheme
import com.ngrob.android.bluemoon.core.ui.theme.Gray900
import com.ngrob.android.bluemoon.core.ui.theme.White
import com.ngrob.android.bluemoon.features.symptom.screens.SingleChoiceOption

@OptIn(
    ExperimentalMaterial3Api::class,
    ExperimentalLayoutApi::class
)
@Composable
fun <T> SingleChoiceOptionComponent(
    singleChoice: SingleChoiceOption<T>,
    onAnswer: (T) -> Unit,
    onDeselect: (T) -> Unit,
) {
    val selectedOption by rememberUpdatedState(newValue = singleChoice.selection)
    Column(
        horizontalAlignment = Alignment.Start, modifier = Modifier
            .padding(5.dp)
    ) {
        Text(singleChoice.question, style = MaterialTheme.typography.body1)
        FlowRow {
            singleChoice.options.forEach { option ->
                FilterChip(selected = option == selectedOption,
                    onClick = {
                        if (option == selectedOption) onDeselect(option) else onAnswer(option)
                    },
                    modifier = Modifier.padding(5.dp, 0.dp),
                    enabled = true,
                    colors = FilterChipDefaults.filterChipColors(
                        containerColor = White,
                        selectedContainerColor = Gray900,
                        ),
                    label = {
                        Text(
                            option.toString(),
                            modifier = Modifier.width(70.dp),
                            textAlign = TextAlign.Center,
                            fontSize = 12.sp,
                            color = if (option == selectedOption) White else Gray900
                        )
                    })
            }
        }
    }

}

@Preview(showBackground = false)
@Composable
fun SingleChoiceOptionPreview() {
    BluemoonTheme(darkTheme = true) {
        SingleChoiceOptionComponent<Any>(singleChoice = SingleChoiceOption(
            question = "How heavy is the bleeding?",
            options = BleedingStrength.entries.toList(),
            selection = null
        ), onAnswer = {}, onDeselect = {})
    }
}