package com.ngrob.android.bluemoon.features.symptom.components


import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ExperimentalLayoutApi
import androidx.compose.foundation.layout.FlowRow
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.material3.FilterChip
import androidx.compose.material.MaterialTheme

import androidx.compose.material.Text
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.FilterChipDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.rememberUpdatedState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.ngrob.android.bluemoon.core.database.model.ContraceptiveEnum
import com.ngrob.android.bluemoon.core.ui.theme.BluemoonTheme
import com.ngrob.android.bluemoon.core.ui.theme.Gray900
import com.ngrob.android.bluemoon.core.ui.theme.White
import com.ngrob.android.bluemoon.features.symptom.screens.MultipleChoiceOption



@ExperimentalMaterial3Api
@ExperimentalLayoutApi
@Composable
fun <T> MultipleChoiceOptionComponent(
    multipleChoice: MultipleChoiceOption<T>,
    onAnswer: (T) -> Unit,
    onDeselect: (T) -> Unit,
) {
    val selection by rememberUpdatedState(newValue = multipleChoice.selection)
    Column(horizontalAlignment = Alignment.Start, modifier = Modifier
            .padding(5.dp)) {
            Text(multipleChoice.question, style = MaterialTheme.typography.body1)
            FlowRow{
                multipleChoice.options.forEach{ option ->
                    FilterChip(selected = option in selection, leadingIcon = {}, trailingIcon = {}, onClick = {
                            if (option in selection) onDeselect(option) else onAnswer(option)
                         }, modifier=Modifier.padding(5.dp, 0.dp), enabled = true, colors = FilterChipDefaults.filterChipColors(
                            containerColor = White,
                            selectedContainerColor = Gray900,

                         ), label = { Text(option.toString(), Modifier.width(70.dp), textAlign = TextAlign.Center, fontSize = 12.sp, color = if (option in selection)  White else Gray900 )})
                }

            }
        }

}

@OptIn(ExperimentalLayoutApi::class)
@ExperimentalMaterial3Api
@Preview(showBackground = false)
@Composable
fun MultipleChoiceOptionComponentPreview() {
    BluemoonTheme (darkTheme = true){
       MultipleChoiceOptionComponent<Any>(multipleChoice =  MultipleChoiceOption(
           "Did you use contraceptives?",
           options = ContraceptiveEnum.entries.toList(),
           selection = listOf()
       ), onAnswer =  {}, onDeselect = {} )
    }
}