package com.ngrob.android.bluemoon.features.settings.components

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.Switch
import androidx.compose.material.SwitchDefaults
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.ngrob.android.bluemoon.core.model.PillRecipe
import com.ngrob.android.bluemoon.core.ui.theme.BleedingRed
import com.ngrob.android.bluemoon.core.ui.theme.BluemoonTheme
import com.ngrob.android.bluemoon.core.ui.theme.Gray900
import com.ngrob.android.bluemoon.core.ui.theme.MoodGreen
import java.time.LocalDate

@Composable
fun PillSection(
    shouldTrackBirthControl: Boolean,
    onShouldTrackBirthControlChanged: (shouldTrackBirthControl: Boolean) -> Unit,
    recipe: PillRecipe,
    onRecipeChange: (recipe: PillRecipe) -> Unit,
) {
    Column {
        Column {
            Text(
                modifier = Modifier.padding(vertical = 8.dp, horizontal = 20.dp),
                text = "Birth Control",
                fontWeight = FontWeight.W500,
                fontSize = 18.sp,
                color = Gray900
            )
            Row(
                modifier = Modifier.fillMaxWidth(),
                horizontalArrangement = Arrangement.SpaceBetween,
                verticalAlignment = Alignment.CenterVertically
            ) {
                Text(
                    modifier = Modifier.padding(vertical = 2.dp, horizontal = 20.dp),
                    text = "Enable tracking of \nbirth control pill",
                    fontWeight = FontWeight.W500,
                    fontSize = 12.sp,
                    color = Gray900
                )
                Switch(
                    colors = SwitchDefaults.colors(
                        checkedThumbColor = MoodGreen,
                        checkedTrackAlpha = 0.8f,
                        checkedTrackColor = MoodGreen,
                        disabledCheckedThumbColor = MoodGreen,
                        disabledUncheckedThumbColor = BleedingRed,
                        uncheckedTrackColor = BleedingRed,
                        uncheckedThumbColor = BleedingRed,
                        uncheckedTrackAlpha = 0.8f
                    ),
                    modifier = Modifier.padding(horizontal = 20.dp),
                    checked = shouldTrackBirthControl,
                    onCheckedChange = onShouldTrackBirthControlChanged
                )

            }


        }
        if (shouldTrackBirthControl) {
            PillRecipe(
                recipe = recipe,
                onRecipeChange = onRecipeChange
            )
        }

    }

}

@Preview(showBackground = true)
@Composable
fun PillSectionPreview() {
    BluemoonTheme {
        PillSection(
            shouldTrackBirthControl = true,
            onShouldTrackBirthControlChanged = {},
            recipe = PillRecipe(
                24,
                LocalDate.now()
            ),
            onRecipeChange = {}
        )
    }
}
