@file:OptIn(ExperimentalMaterial3Api::class)

package com.ngrob.android.bluemoon.features.settings.components

import android.net.Uri
import androidx.activity.compose.rememberLauncherForActivityResult
import androidx.activity.result.contract.ActivityResultContracts
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.Text
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.ngrob.android.bluemoon.R
import com.ngrob.android.bluemoon.core.ui.theme.Gray900
import com.ngrob.android.bluemoon.features.settings.screens.SettingsViewModel

enum class AppToImportFrom {
    FLO,
}

@Composable
fun ImportSection(
    viewModel: SettingsViewModel
) {
    val context = LocalContext.current
    val appToImportFrom: MutableState<AppToImportFrom?> = remember { mutableStateOf(null) }

    val launcher =
        rememberLauncherForActivityResult(ActivityResultContracts.GetContent()) { uri: Uri? ->
            if (uri != null && appToImportFrom.value == AppToImportFrom.FLO) {
                viewModel.readFloJsonFile(uri, context)
            }
        }
    val openImportDialog = remember { mutableStateOf(false) }
    Column {
        Text(
            modifier = Modifier.padding(vertical = 8.dp, horizontal = 20.dp),
            text = "Import",
            fontWeight = FontWeight.W500,
            fontSize = 18.sp,
            color = Gray900
        )
        Row(
            horizontalArrangement = Arrangement.SpaceBetween, modifier = Modifier.fillMaxWidth()
        ) {
            Text(
                modifier = Modifier.padding(vertical = 2.dp, horizontal = 20.dp),
                text = stringResource(R.string.import_data_from_another_app),
                fontWeight = FontWeight.W500,
                fontSize = 12.sp,
                color = Gray900
            )
            TextButton(
                enabled = true,
                onClick = { openImportDialog.value = true },
                modifier = Modifier
                    .padding(horizontal = 20.dp)
                    .align(Alignment.Bottom)
            ) {
                Text(text = "Import Data", color = Gray900)
            }
        }
    }
    when {
        openImportDialog.value -> {
            ImportDialog(onDismissRequest = {
                openImportDialog.value = false
            }, onFloImport = {
                appToImportFrom.value = AppToImportFrom.FLO
                openImportDialog.value = false
                launcher.launch("application/json")
            })
        }
    }
}