package com.ngrob.android.bluemoon.features.settings.components

import android.content.Intent
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Icon
import androidx.compose.material.MaterialTheme
import androidx.compose.material3.OutlinedButton
import androidx.compose.material.Text
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.outlined.QuestionMark
import androidx.compose.material3.Card
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.OutlinedCard
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.text.style.TextDecoration
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import androidx.compose.ui.window.Dialog
import com.ngrob.android.bluemoon.R
import com.ngrob.android.bluemoon.core.ui.theme.BluemoonTheme
import com.ngrob.android.bluemoon.core.ui.theme.Gray600
import androidx.core.net.toUri

@ExperimentalMaterial3Api
@Composable
fun ImportDialog(
    onDismissRequest: () -> Unit, onFloImport: () -> Unit
) {
    val context = LocalContext.current
    val docUrl = "https://gitlab.com/ngrob/bluemoon-android/-/wikis/import-data"
    val furtherInstructionsText = buildAnnotatedString {
        val annotatedString = stringResource(R.string.further_instructions)
        val start = length
        append(annotatedString)
        val end = length

        addStyle(
            style = MaterialTheme.typography.body1.toSpanStyle()
                .copy(color = Gray600, fontWeight = FontWeight.W500, fontSize = 16.sp),
            start = start,
            end = end
        )
        addStringAnnotation(
            tag = "URL", annotation = docUrl, start = start, end = end
        )
    }

    val workInProgressHint = buildAnnotatedString {
        val annotatedStart = stringResource(R.string.import_wip_hint)
        var start = length
        append(annotatedStart)
        var end = length

        addStyle(
            style = MaterialTheme.typography.body1.toSpanStyle()
                .copy(color = Gray600, fontWeight = FontWeight.W500, fontSize = 12.sp),
            start = start,
            end = end
        )
        val annotatedEnd = stringResource(R.string.see_more_on_issue)
        start = length
        append(annotatedEnd)
        end = length
        addStringAnnotation(
            tag = "URL",
            annotation = "https://gitlab.com/ngrob/bluemoon-android/-/issues/5",
            start = start,
            end = end
        )
        addStyle(
            style = MaterialTheme.typography.body1.toSpanStyle()
                .copy(color = Gray600, fontWeight = FontWeight.W500, fontSize = 12.sp),
            start = start,
            end = end
        )
        addStyle(
            style = SpanStyle(textDecoration = TextDecoration.Underline), start = start, end = end
        )
    }
    Dialog(onDismissRequest) {
        Card(
            modifier = Modifier
                .fillMaxWidth()
                .padding(16.dp), shape = RoundedCornerShape(16.dp)
        ) {
            Column(Modifier.padding(12.dp, 16.dp)) {
                Text(
                    text = stringResource(R.string.choose_the_app_you_want_to_import),
                    fontSize = 18.sp,
                    fontWeight = FontWeight.W500,
                    modifier = Modifier
                        .fillMaxWidth(),
                    textAlign = TextAlign.Start
                )
                Row(
                    verticalAlignment = Alignment.CenterVertically,
                ) {

                    ClickableTextWithURL(furtherInstructionsText)
                    OutlinedCard(
                        onClick = {
                            val intent = Intent(Intent.ACTION_VIEW, docUrl.toUri())
                            context.startActivity(intent)
                        },
                        modifier = Modifier.align(Alignment.CenterVertically),
                        shape = CircleShape
                    ) {
                        Icon(
                            modifier = Modifier
                                .size(24.dp)
                                .padding(4.dp),
                            imageVector = Icons.Outlined.QuestionMark,
                            contentDescription = "question mark",
                            tint = Gray600
                        )
                    }

                }
                Row(
                    verticalAlignment = Alignment.CenterVertically,
                    modifier = Modifier.fillMaxWidth(),
                ) {
                    OutlinedButton(
                        onFloImport, modifier = Modifier
                            .padding(10.dp)
                            .fillMaxWidth()
                    ) {
                        Text("Flo")
                    }
                }
                ClickableTextWithURL(
                    workInProgressHint,
                    modifier = Modifier.fillMaxWidth(),
                )

            }

        }
    }
}

@OptIn(ExperimentalMaterial3Api::class)
@Preview(showBackground = true)
@Composable
fun ImportDialogPreview() {
    BluemoonTheme {
        ImportDialog({}, {})
    }
}