package com.ngrob.android.bluemoon.features.settings.components

import android.content.Intent
import android.net.Uri
import androidx.compose.foundation.text.ClickableText
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.text.AnnotatedString

@Composable
fun ClickableTextWithURL(text: AnnotatedString, modifier: Modifier = Modifier) {
    val context = LocalContext.current

    ClickableText(
        text = text,
        modifier = modifier,
        onClick = { offset ->
            val clickedRange =
                text.getStringAnnotations("URL", offset, offset)
            clickedRange.firstOrNull()?.let { annotation ->
                Intent(Intent.ACTION_VIEW, Uri.parse(annotation.item)).also {
                    context.startActivity(it, null)
                }

            }
        }
    )
}