package com.ngrob.android.bluemoon.features.edit_period.screens

import android.annotation.SuppressLint
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.rememberLazyListState
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Card
import androidx.compose.material.Text
import androidx.compose.material3.Scaffold
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.testTag
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import androidx.hilt.navigation.compose.hiltViewModel
import androidx.navigation.NavHostController
import com.ngrob.android.bluemoon.core.ui.component.Button
import com.ngrob.android.bluemoon.core.ui.theme.Gray900
import com.ngrob.android.bluemoon.core.ui.theme.White
import com.ngrob.android.bluemoon.features.edit_period.components.EditCalendar
import io.github.boguszpawlowski.composecalendar.rememberCalendarState
import java.time.format.DateTimeFormatter
import java.time.format.FormatStyle
import java.time.temporal.ChronoUnit

@SuppressLint("UnusedMaterial3ScaffoldPaddingParameter")
@Composable
fun EditPeriodScreen(
    modifier: Modifier = Modifier,
    nav: NavHostController,
    viewModel: EditPeriodViewModel = hiltViewModel(),
) {

    val uiState by viewModel.uiState.collectAsState()
    val bleedingDays = uiState.bleedingDays
    val currentCycle = uiState.cycleTracker.getRecentCycle()

    val calendarListState = rememberLazyListState(initialFirstVisibleItemIndex = 1)

    var periodLength = "-"
    var periodEnd = "-"
    var periodStart = "-"
    if (currentCycle != null) {
        periodLength = "${
            ChronoUnit.DAYS.between(
                currentCycle.startDate,
                currentCycle.endDate
            ) + 1
        } Days"
        periodEnd = currentCycle.endDate.format(
            DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)
        )
        periodStart = currentCycle.startDate.format(
            DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)
        )
    }
    Scaffold(modifier) {
        Column(
            Modifier.background(color = Gray900),
            verticalArrangement = Arrangement.SpaceAround
        ) {
            LazyColumn(
                state = calendarListState,
                modifier = Modifier
                    .fillMaxWidth()
                    .fillMaxHeight(0.6f)
                    .testTag("editScreenLazyColumn")
            ) {
                item {
                    EditCalendar(
                        calendarState = rememberCalendarState(
                            initialMonth = uiState.currentMonth.minusMonths(1)
                        ),
                        bleedingDays = bleedingDays,
                        cycleTracker = uiState.cycleTracker,
                        onDayClicked = { viewModel.onBleedingDayClicked(it) }
                    )
                }
                item {

                    EditCalendar(
                        calendarState = rememberCalendarState(
                            initialMonth = uiState.currentMonth
                        ),
                        bleedingDays = bleedingDays,
                        cycleTracker = uiState.cycleTracker,
                        onDayClicked = { viewModel.onBleedingDayClicked(it) }
                    )
                }
                item {
                    EditCalendar(
                        calendarState = rememberCalendarState(
                            initialMonth = uiState.currentMonth.plusMonths(1)
                        ),
                        bleedingDays = bleedingDays,
                        cycleTracker = uiState.cycleTracker,
                        onDayClicked = { viewModel.onBleedingDayClicked(it) }
                    )
                }

            }

            Card(
                modifier = Modifier.fillMaxSize(),
                backgroundColor = White,
                elevation = 0.dp,
                shape = RoundedCornerShape(30.dp, 30.dp, 0.dp, 0.dp)
            ) {
                Column(
                    modifier = Modifier.fillMaxHeight(),
                    verticalArrangement = Arrangement.SpaceBetween
                ) {
                    Column {
                        Text(
                            modifier = Modifier.padding(vertical = 8.dp, horizontal = 20.dp),
                            text = "Latest Period",
                            fontWeight = FontWeight.W500,
                            fontSize = 16.sp,
                            color = Gray900
                        )

                        Row(
                            modifier = Modifier.fillMaxWidth(),
                            horizontalArrangement = Arrangement.SpaceBetween
                        ) {
                            Text(
                                modifier = Modifier.padding(vertical = 8.dp, horizontal = 20.dp),
                                text = "Start",
                                fontWeight = FontWeight.W500,
                                fontSize = 14.sp,
                                color = Gray900
                            )
                            Text(
                                modifier = Modifier.padding(vertical = 8.dp, horizontal = 20.dp),
                                text = periodStart,
                                fontWeight = FontWeight.ExtraBold,
                                fontSize = 14.sp,
                                color = Gray900
                            )
                        }
                        Row(
                            modifier = Modifier.fillMaxWidth(),
                            horizontalArrangement = Arrangement.SpaceBetween
                        ) {
                            Text(
                                modifier = Modifier.padding(vertical = 8.dp, horizontal = 20.dp),
                                text = "End",
                                fontWeight = FontWeight.W500,
                                fontSize = 14.sp,
                                color = Gray900
                            )
                            Text(
                                modifier = Modifier.padding(vertical = 8.dp, horizontal = 20.dp),
                                text = periodEnd,
                                fontWeight = FontWeight.ExtraBold,
                                fontSize = 14.sp,
                                color = Gray900
                            )
                        }
                        Row(
                            modifier = Modifier.fillMaxWidth(),
                            horizontalArrangement = Arrangement.SpaceBetween
                        ) {
                            Text(
                                modifier = Modifier.padding(vertical = 8.dp, horizontal = 20.dp),
                                text = "Length",
                                fontWeight = FontWeight.W500,
                                fontSize = 14.sp,
                                color = Gray900,
                            )
                            Text(
                                modifier = Modifier.padding(vertical = 8.dp, horizontal = 20.dp),
                                text = periodLength,
                                fontWeight = FontWeight.ExtraBold,
                                fontSize = 14.sp,
                                color = Gray900
                            )
                        }
                    }
                    Button(
                        label = "Save Data",
                        enabled = uiState.saveButtonEnabled,
                        onClick = {
                            viewModel.saveData()
                            nav.popBackStack()
                        },
                        primary = false,
                        modifier = Modifier.padding(8.dp)
                    )
                }
            }
        }
    }
}