package com.ngrob.android.bluemoon.features.dashboard.components

import android.annotation.SuppressLint
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.ngrob.android.bluemoon.core.ui.theme.BleedingRed
import com.ngrob.android.bluemoon.core.ui.theme.BluemoonTheme
import com.ngrob.android.bluemoon.core.ui.theme.Gray600
import com.ngrob.android.bluemoon.core.ui.theme.Gray900
import io.github.boguszpawlowski.composecalendar.StaticWeekCalendar
import io.github.boguszpawlowski.composecalendar.WeekCalendarState
import io.github.boguszpawlowski.composecalendar.day.DayState
import io.github.boguszpawlowski.composecalendar.rememberWeekCalendarState
import io.github.boguszpawlowski.composecalendar.selection.EmptySelectionState
import java.time.LocalDate
import java.time.format.TextStyle
import java.util.Locale


@SuppressLint("SuspiciousIndentation")
@Composable
fun CustomDay(
    state: DayState<EmptySelectionState>,
    isBleedingDay: Boolean
) {
    val date = state.date
    Box(
        modifier = Modifier
            .fillMaxWidth()
            .height(90.dp)
            .size(60.dp)
            .padding(2.dp)
            .clip(RoundedCornerShape(10.dp))
            .background(if (state.isCurrentDay) Gray600 else Color.Transparent),
        contentAlignment = Alignment.Center,

        ) {
        Column(
            modifier = Modifier
                .fillMaxHeight()
                .fillMaxWidth()
                .padding(2.dp, 4.dp),
            verticalArrangement = Arrangement.SpaceBetween,
            horizontalAlignment = Alignment.CenterHorizontally
        ) {
            Text(
                text = date.dayOfWeek.getDisplayName(TextStyle.SHORT, Locale.ENGLISH),
                color = Color.White,
            )
            Column(modifier = Modifier.padding(0.dp, 2.dp)) {
                Text(
                    text = date.dayOfMonth.toString(),
                    color = Color.White,
                    fontWeight = if (state.isCurrentDay) FontWeight.Bold else FontWeight.Normal,
                    modifier = Modifier.padding(0.dp, 8.dp)
                )

                Box(
                    modifier = Modifier
                        .align(Alignment.CenterHorizontally)
                        .size(5.dp)
                        .clip(CircleShape)
                        .background(if (isBleedingDay) BleedingRed else Color.Transparent)
                )
            }
        }
    }
}

@Composable
fun WeekCalendar(
    modifier: Modifier = Modifier,
    calendarState: WeekCalendarState<EmptySelectionState>,
    bleedingDays: List<LocalDate>
) {

    StaticWeekCalendar(
        modifier.background(color = Gray900),
        dayContent = { dayState ->
            val isBleedingDay = dayState.date in bleedingDays
            CustomDay(state = dayState, isBleedingDay)
        },
        horizontalSwipeEnabled = false,
        weekHeader = { },
        daysOfWeekHeader = { },
        calendarState = calendarState,
    )
}

@Preview(showBackground = true)
@Composable
fun CalendarPreview() {
    BluemoonTheme {
        WeekCalendar(
            calendarState = rememberWeekCalendarState(),
            bleedingDays = listOf(LocalDate.now())
        )
    }
}