package com.ngrob.android.bluemoon.features.dashboard.components

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Text
import androidx.compose.material3.Button
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.shadow
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.ngrob.android.bluemoon.core.ui.theme.BluemoonTheme
import com.ngrob.android.bluemoon.core.ui.theme.MedicationBlue
import com.ngrob.android.bluemoon.core.ui.theme.White
import java.time.LocalDate
import java.time.format.DateTimeFormatter
import java.time.format.FormatStyle

@Composable
fun PillActionCard(
    takePill: () -> Unit,
    // Is either the pill number of today or the number of the pause
    todayCount: Int,
    totalPillNumber: Int,
    pillTaken: Boolean,
    isIntakePaused: Boolean,
    currentDate: LocalDate
) {
    Card(
        Modifier
            .height(140.dp)
            .fillMaxWidth()
            .padding(vertical = 8.dp, horizontal = 20.dp)
            .shadow(
                2.dp, shape = RoundedCornerShape(12.dp)
            ),
        colors = CardDefaults.elevatedCardColors(containerColor = MedicationBlue.copy(alpha = 1.0f)),
    ) {
        Box(
            modifier = Modifier
                .background(Color.Transparent)
                .padding(12.dp)
        ) {
            Row(
                Modifier
                    .background(Color.Transparent)
                    .fillMaxSize(),
                horizontalArrangement = Arrangement.SpaceBetween
            ) {
                Column(
                    Modifier
                        .background(Color.Transparent)
                        .fillMaxWidth(if (!isIntakePaused) 0.6f else 0.8f)
                ) {
                    Text(
                        text = "Contraceptive",
                        fontSize = 20.sp,
                        color = White,
                        fontWeight = FontWeight.W500
                    )
                    if (!isIntakePaused) {
                        Text(
                            text = "Today you have ${if (pillTaken) "taken" else "to take"} pill number ${todayCount} of ${totalPillNumber}",
                            color = White
                        )
                    } else {
                        Text(
                            text = "Today you have to pause the intake of the pill. You have to take the pill again on ${
                                currentDate.plusDays((28 - totalPillNumber) - todayCount - 1L)
                                    .format(
                                        DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT)
                                    )
                            }",
                            color = White
                        )
                    }

                }
                if (!isIntakePaused) {
                    Button(
                        enabled = !pillTaken,
                        onClick = { takePill() },
                        colors = ButtonDefaults.buttonColors(
                            disabledContainerColor = Color.LightGray,
                            containerColor = White
                        ),
                        modifier = Modifier.align(Alignment.Bottom)
                    ) {
                        Text(
                            text = "Pill taken",
                            color = MedicationBlue,
                            fontWeight = FontWeight.Bold
                        )
                    }
                }

            }
        }

    }
}

@Preview(showBackground = false)
@Composable
fun PillActionCardPreview() {
    BluemoonTheme {
        PillActionCard(
            takePill = {},
            pillTaken = true,
            todayCount = 12,
            totalPillNumber = 21,
            isIntakePaused = false,
            currentDate = LocalDate.now()
        )
    }
}
