package com.ngrob.android.bluemoon.features.dashboard.components

import androidx.compose.foundation.layout.Column
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.sp
import com.ngrob.android.bluemoon.core.ui.theme.BluemoonTheme
import com.ngrob.android.bluemoon.core.ui.theme.White
import java.time.LocalTime

enum class Greetings(val displayString: String) {
    MORNING("Good morning"),
    AFTERNOON("Good afternoon"),
    EVENING("Good evening")
}

@Composable
fun GreetingHeader(
    name: String,
    modifier: Modifier = Modifier,
) {

    val currentTime = LocalTime.now()

    Column(modifier = modifier) {
        Text(
            text = when {
                currentTime.isAfter(LocalTime.MIDNIGHT) && currentTime.isBefore(LocalTime.NOON) -> Greetings.MORNING.displayString
                currentTime.isAfter(LocalTime.NOON) && currentTime.isBefore(
                    LocalTime.of(
                        18,
                        0
                    )
                ) -> Greetings.AFTERNOON.displayString

                else -> Greetings.EVENING.displayString
            },
            color = White,
            fontSize = 20.sp,
            textAlign = TextAlign.Left
        )
//        Text(
//            text = name,
//            color = White,
//            fontSize = 21.sp,
//            textAlign = TextAlign.Left,
//            fontWeight = FontWeight.Bold
//        )

    }

}

@Preview(showBackground = false)
@Composable
fun GreetingHeaderPreview() {
    BluemoonTheme {
        GreetingHeader(name = "Hanna", Modifier)
    }
}