package com.ngrob.android.bluemoon.features.dashboard.components

import androidx.compose.foundation.Canvas
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.geometry.Size
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.drawscope.Stroke
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.ngrob.android.bluemoon.core.ui.theme.BleedingRed
import com.ngrob.android.bluemoon.core.ui.theme.BluemoonTheme
import com.ngrob.android.bluemoon.core.ui.theme.Gray600
import com.ngrob.android.bluemoon.core.ui.theme.Gray900
import com.ngrob.android.bluemoon.core.ui.theme.MedicationBlue
import com.ngrob.android.bluemoon.core.ui.theme.White

data class PhaseBarData(val color: Color, val progress: Float, val offset: Float)

@Composable
fun CycleCircle(
    modifier: Modifier = Modifier,
    progressBars: List<PhaseBarData>,
    currentDayIndicationAngle: Int,
    cycleDayNumber: Int
) {
    Box(modifier = modifier) {
        Canvas(
            modifier = modifier
                .background(Gray900, shape = CircleShape)
        ) {
            val center = Offset(size.width / 2, size.height / 2)
            val radius = size.minDimension / 2 - 8 // Adjust the padding

            // Draw the circle
            drawCircle(
                color = Gray600,
                radius = radius,
                center = center,
                style = Stroke(4f)
            )

            // Draw progress bars
            var currentAngle = -90f
            for (progressBar in progressBars) {
                val sweepAngle = progressBar.progress * 360
                drawArc(
                    color = progressBar.color,
                    startAngle = currentAngle,
                    sweepAngle = sweepAngle,
                    useCenter = false,
                    size = Size(radius * 2, radius * 2),
                    topLeft = center - Offset(radius, radius),
                    style = Stroke(4f)
                )
                currentAngle += (sweepAngle + progressBar.offset * 360)
            }

            // Draw current day indicator
            val endX =
                center.x + radius * kotlin.math.cos(Math.toRadians((currentDayIndicationAngle - 90).toDouble()))
                    .toFloat()
            val endY =
                center.y + radius * kotlin.math.sin(Math.toRadians((currentDayIndicationAngle - 90).toDouble()))
                    .toFloat()
            drawCircle(color = White, radius = 8f, center = Offset(endX, endY))

        }

        Text(
            modifier = Modifier.align(Alignment.Center),
            text = "$cycleDayNumber. \ncycle day",
            color = Color.White,
            textAlign = TextAlign.Center
        )


    }
}

@Preview(showBackground = false)
@Composable
fun DefaultPreview() {
    BluemoonTheme {
        CycleCircle(
            modifier = Modifier
                .size(200.dp)
                .padding(16.dp),
            progressBars = listOf(
                PhaseBarData(BleedingRed, 0.2f, 0.3f),
                PhaseBarData(MedicationBlue, 0.3f, 0.0f),
            ),
            currentDayIndicationAngle = 50,
            cycleDayNumber = 4,
        )
    }
}
