package com.ngrob.android.bluemoon.features.calendar.components

import androidx.compose.foundation.border
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Card
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.ngrob.android.bluemoon.core.ui.theme.BluemoonTheme
import com.ngrob.android.bluemoon.core.ui.theme.Gray900
import com.ngrob.android.bluemoon.features.calendar.screens.TrackedItem
import java.time.LocalDateTime

@Composable
fun EntriesList(
    items: List<TrackedItem>,
    onDismissed: (TrackedItem) -> Unit,
) {
    when {
        items.isEmpty() -> Card(
            modifier = Modifier
                .fillMaxWidth()
                .padding(20.dp)
                .border(1.dp, Gray900, shape = RoundedCornerShape(10.dp)),
            shape = RoundedCornerShape(10.dp)
        ){
            Text(modifier = Modifier.padding(30.dp), text = "Nothing logged for this day", textAlign = TextAlign.Center)
        }

        else -> LazyColumn(Modifier.padding(10.dp)) {
            items(
                items,
                key = { item -> item.cardEntryItem.type.toString().plus(item.id) }) { entry ->
                EntryCard(
                    entryItem = entry.cardEntryItem,
                    values = entry.values,
                    loggedAt = entry.loggedAt,
                    onDismissed = {
                        onDismissed(entry)
                    }
                )
            }

        }
    }


}

@Preview(showBackground = false)
@Composable
fun EntriesListPreview() {
    BluemoonTheme {
        EntriesList(
            items = listOf(
                TrackedItem(
                    id = 1,
                    loggedAt = LocalDateTime.now(),
                    values = mapOf("type" to listOf("partner"), "contraceptives" to listOf("pill")),
                    cardEntryItem = CardEntryItem.Sex,
                ),
                TrackedItem(
                    id = 2,
                    loggedAt = LocalDateTime.now(),
                    values = mapOf("type" to listOf("birth control")),
                    cardEntryItem = CardEntryItem.Medication,
                ),
                TrackedItem(
                    id = 3,
                    loggedAt = LocalDateTime.now(),
                    values = mapOf(
                        "type" to listOf("solo"),
                        "contraceptives" to listOf("pill", "condom")
                    ),
                    cardEntryItem = CardEntryItem.Sex,
                ),
                TrackedItem(
                    id = 4,
                    loggedAt = LocalDateTime.now(),
                    values = mapOf("strength" to listOf("medium")),
                    cardEntryItem = CardEntryItem.Bleeding,
                )
            ),
            onDismissed = {}
        )
    }
}