package com.ngrob.android.bluemoon.core.util

import com.ngrob.android.bluemoon.core.model.PillRecipe
import java.time.LocalDate
import java.time.LocalDateTime
import java.time.LocalTime
import java.time.temporal.ChronoUnit

fun getDateToSchedulePillReminder(
    pillRecipe: PillRecipe,
    currentDate: LocalDate,
    scheduledTime: LocalTime
): LocalDateTime {
    val todayCount = (ChronoUnit.DAYS.between(pillRecipe.firstIntake, currentDate)
        .toInt() + 1) % 29

    if (pillRecipe.numberOfPills == 24 && todayCount > 24) {
        return LocalDateTime.of(currentDate.plusDays(29 - todayCount.toLong()), scheduledTime)


    }
    if (pillRecipe.numberOfPills == 21 && todayCount > 21) {
        return LocalDateTime.of(currentDate.plusDays(29 - todayCount.toLong()), scheduledTime)
    }

    return LocalDateTime.of(currentDate, scheduledTime)
}

fun getDateToSchedulePillInFuture(
    pillRecipe: PillRecipe,
    currentDate: LocalDate,
    scheduledTime: LocalTime
): LocalDateTime {
    val todayCount = (ChronoUnit.DAYS.between(pillRecipe.firstIntake, currentDate)
        .toInt() + 1) % 29

    if (pillRecipe.numberOfPills == 24 && todayCount == 24) {
        return LocalDateTime.of(currentDate.plusDays(5), scheduledTime)
    }

    if (pillRecipe.numberOfPills == 21 && todayCount == 21) {
        return LocalDateTime.of(currentDate.plusDays(8), scheduledTime)
    }

    return LocalDateTime.of(currentDate.plusDays(1), scheduledTime)
}