package com.ngrob.android.bluemoon.core.ui.component

import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material.ButtonDefaults
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.ngrob.android.bluemoon.core.ui.theme.BluemoonTheme
import com.ngrob.android.bluemoon.core.ui.theme.Gray600
import com.ngrob.android.bluemoon.core.ui.theme.Gray800
import com.ngrob.android.bluemoon.core.ui.theme.Gray900
import com.ngrob.android.bluemoon.core.ui.theme.White

@Composable
fun Button(
    label: String,
    enabled: Boolean,
    onClick: () -> Unit,
    modifier: Modifier = Modifier,
    primary: Boolean
) {
    androidx.compose.material.Button(
        onClick = onClick, enabled = enabled, modifier = modifier
            .height(60.dp)
            .fillMaxWidth()
            .padding(5.dp), colors = ButtonDefaults.buttonColors(
            backgroundColor = if (primary) MaterialTheme.colors.primary else Gray900,
            disabledBackgroundColor = if (primary) MaterialTheme.colors.primary.copy(alpha = 0.8f) else Gray800,
        )
    ) {
        Text(
            text = label,
            color = if (enabled) White else if (primary) Color.LightGray else Gray600,
            fontWeight = FontWeight.Bold
        )
    }

}

@Preview(showBackground = false)
@Composable
fun ButtonPreview() {
    BluemoonTheme(darkTheme = true) {
        Button(
            label = "Add Data",
            enabled = false,
            onClick = { /*TODO*/ },
            modifier = Modifier,
            primary = true
        )
    }
}