package com.ngrob.android.bluemoon.core.reminder.di

import com.ngrob.android.bluemoon.core.reminder.BluemoonReminderNotificationScheduler
import com.ngrob.android.bluemoon.core.reminder.BluemoonReminderScheduler
import com.ngrob.android.bluemoon.core.reminder.ReminderNotificationScheduler
import com.ngrob.android.bluemoon.core.reminder.ReminderScheduler
import dagger.Binds
import dagger.Module
import dagger.hilt.InstallIn
import dagger.hilt.components.SingletonComponent

@Module
@InstallIn(SingletonComponent::class)
internal abstract class ReminderModule {
    @Binds
    abstract fun bindReminder(
        reminderScheduler: ReminderNotificationScheduler,
    ): ReminderScheduler

    @Binds
    abstract fun bindBluemoonReminder(
        bluemoonReminderScheduler: BluemoonReminderNotificationScheduler,
    ): BluemoonReminderScheduler
}