package com.ngrob.android.bluemoon.core.reminder

import com.ngrob.android.bluemoon.core.notifications.NotificationType
import java.time.LocalDateTime


data class ReminderItem(
    val alarmTime : LocalDateTime,
    val notificationType: NotificationType
)

interface ReminderScheduler {
    fun schedule(reminderItem: ReminderItem)
    fun cancel(notificationType: NotificationType)
    fun cancelAll()
}