package com.ngrob.android.bluemoon.core.notifications

enum class NotificationType(val contentTitle: String, val contentDescription: String ) {

    DAILY_REMINDER("Log your symptoms", "Don't forget to track your symptoms for today"),
    PILL_REMINDER("Pill reminder", "Remember to take your pill"),
    UPCOMING_PERIOD_REMINDER(
        "Period is coming",
        "Your period is likely to start in the upcoming days"
    ),
//  PERIOD_START_REMINDER("Did your period start?", "Don't forget to log the latest begin of your period"),
//  PERIOD_END_REMINDER("Did your period end?", "Don't forget to log the end of your period"),

}

interface Notifier {
    fun postNotification(notificationType: NotificationType)
}