package com.ngrob.android.bluemoon.core.model

import com.google.gson.annotations.SerializedName

data class FloData(
    var operationalData: OperationalData? = null
)

data class OperationalData(
    var cycles: List<CycleData>? = null
)

data class CycleData(
    @SerializedName("period_start_date")
    var periodStartDate: String,
    @SerializedName("period_end_date")
    var periodEndDate: String,
    @SerializedName("created_at")
    var createdAt: String,
    /**
     * A list of "day": intensity pairs. "day" is a string like "0", "1", or "2" and so on. intensity is a number, where 1 means light, 2 means medium, and 3 means heavy. The data can be incomplete. Example: "{\"0\": 3, \"1\": 3, \"3\": 2, \"4\": 1, \"5\": 1, \"6\": 1}"
     */
    @SerializedName("period_intensity")
    var periodIntensities: String,
)
