package com.ngrob.android.bluemoon.core.domain

import com.ngrob.android.bluemoon.core.data.repository.BleedingRepository
import kotlinx.coroutines.flow.Flow
import java.time.LocalDate
import java.time.YearMonth
import javax.inject.Inject

class GetAllBleedingDaysOfMonthUseCase @Inject constructor(
    private val bleedingRepository: BleedingRepository,
) {
    operator fun invoke(month: YearMonth): Flow<List<LocalDate>> = bleedingRepository.getAllBleedingsOfMonth(month)
}