package com.ngrob.android.bluemoon.core.database.model

import androidx.room.ColumnInfo
import androidx.room.Embedded
import androidx.room.Entity
import androidx.room.ForeignKey
import androidx.room.PrimaryKey
import androidx.room.Relation

enum class ContraceptiveEnum {
    PILL,
    CONDOM,
    IUD,
    PATCH,
    RING,
    IMPLANT,
    DIAPHRAGM,
    OTHER
}

enum class SexType {
    SOLO,
    PARTNER,
    GROUP
}

@Entity
data class Sex(
    @PrimaryKey(autoGenerate = true) val id: Int?,
    @ColumnInfo val type: SexType,
    @ColumnInfo(defaultValue = "2023-09-04") val date: String,
    @ColumnInfo("logged_at") val loggedAt: String
)

@Entity(
    foreignKeys = [
        ForeignKey(
            entity = Sex::class,
            parentColumns = ["id"],
            childColumns = ["usedOnSexId"],
            onDelete = ForeignKey.CASCADE
        )
    ]
)
data class ContraceptiveUse(
    @PrimaryKey(autoGenerate = true) val id: Int?,
    @ColumnInfo val contraceptive: ContraceptiveEnum,
    @ColumnInfo val usedOnSexId: Int,

    )

data class SexWithContraceptives(
    @Embedded val sex: Sex,
    @Relation(
        parentColumn = "id",
        entityColumn = "usedOnSexId"
    )
    val contraceptives: List<ContraceptiveUse>
)
