package com.ngrob.android.bluemoon.core.database.model

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import androidx.room.PrimaryKey

@Entity(indices = [Index(value = ["date"], unique = true)])
data class Pill(
    @PrimaryKey(autoGenerate = true) val id: Int?,
    @ColumnInfo(name = "taken") var taken: Boolean,
    // Is substitute for a forgotten pill
    @ColumnInfo(name = "is_substitute") var isSubstitute: Boolean,
    @ColumnInfo(name = "date") val date: String,
    @ColumnInfo(name = "logged_at") var loggedAt: String,
)