package com.ngrob.android.bluemoon.core.database.model

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import androidx.room.PrimaryKey


enum class BleedingStrength(value: String) {
    SPOTTING("spotting"),
    LIGHT("light"),
    MEDIUM("medium"),
    HEAVY("heavy")
}
@Entity(indices = [Index(value = ["date"], unique = true)])
data class Bleeding(
    @PrimaryKey(autoGenerate = true) val id: Int?,
    @ColumnInfo(name = "strength") var strength: BleedingStrength?,
    @ColumnInfo(name = "date") val date: String,
    @ColumnInfo(name = "logged_at") var loggedAt: String,
    )