package com.ngrob.android.bluemoon.core.database.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Transaction
import com.ngrob.android.bluemoon.core.database.model.ContraceptiveUse
import com.ngrob.android.bluemoon.core.database.model.Sex
import com.ngrob.android.bluemoon.core.database.model.SexWithContraceptives
import kotlinx.coroutines.flow.Flow

@Dao
interface SexDao{
    @Transaction
    @Query("SELECT * FROM Sex WHERE date == :isoDate")
    fun getSexWithContraceptivesOnDate(isoDate: String): Flow<List<SexWithContraceptives>>

    @Insert
    fun insertSex(sex: Sex): Long
    @Query("DELETE FROM sex")
    fun deleteAllSex()
    @Transaction
    @Query("DELETE FROM Sex WHERE id = :id ")
    fun deleteSexById(id:Int)
    @Insert
    fun insertUsedContraceptives(vararg contraceptives: ContraceptiveUse)
}