package com.ngrob.android.bluemoon.core.database.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Transaction
import com.ngrob.android.bluemoon.core.database.model.Pill
import kotlinx.coroutines.flow.Flow

@Dao
interface PillDao {
    @Insert
    fun insertPill(pill: Pill): Long

    @Query("SELECT * FROM pill WHERE date = :dayIso")
    fun getPillOfDay(dayIso: String): Flow<Pill?>

    @Query("DELETE FROM pill")
    fun deleteAllPills()

    @Transaction
    @Query("DELETE FROM pill WHERE id = :id ")
    fun deletePillById(id: Int)

}