package com.ngrob.android.bluemoon.core.database.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import com.ngrob.android.bluemoon.core.database.model.Bleeding
import kotlinx.coroutines.flow.Flow


@Dao
interface BleedingDao {
    @Insert(onConflict = OnConflictStrategy.IGNORE)
    fun insertBleedings(vararg bleedings: Bleeding)

    @Query("DELETE FROM bleeding WHERE date IN (:bleedingDates)")
    fun deleteBleedingDates(bleedingDates: List<String>)
    @Query("DELETE FROM bleeding")
    fun deleteAllBleeding()
    @Query("DELETE FROM bleeding WHERE id = :id")
    fun deleteBleedingById(id: Int)
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun upsertBleedings(vararg bleeding: Bleeding)

    @Query("SELECT * FROM bleeding WHERE date = :dayIso")
    fun getBleedingOfDay(dayIso: String): Flow<Bleeding?>

    @Query("SELECT date FROM bleeding WHERE date BETWEEN :startOfMonthIso AND :endOfMonthIso ORDER BY date ASC")
    fun getAllBleedingDaysOfMonth(startOfMonthIso: String, endOfMonthIso: String): Flow<List<String>>

    @Query("SELECT date FROM bleeding")
    fun getAllBleedingDates(): Flow<List<String>>
}