package com.ngrob.android.bluemoon.core.database

import android.content.Context
import androidx.room.Room
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.qualifiers.ApplicationContext
import dagger.hilt.components.SingletonComponent
import javax.inject.Singleton

@Module
@InstallIn(SingletonComponent::class)
object DatabaseModule {
    @Provides
    @Singleton
    fun providesBluemoonDatabase(
        @ApplicationContext context: Context,
    ): BluemoonDatabase = Room.databaseBuilder(
        context,
        BluemoonDatabase::class.java,
        "bluemoon-database",
    ).build()
}