package com.ngrob.android.bluemoon.core.database

import com.ngrob.android.bluemoon.core.database.dao.BleedingDao
import com.ngrob.android.bluemoon.core.database.dao.PillDao
import com.ngrob.android.bluemoon.core.database.dao.SexDao
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.components.SingletonComponent

@Module
@InstallIn(SingletonComponent::class)
object DaosModule {
    @Provides
    fun providesBleedingDao(
        database: BluemoonDatabase,
    ): BleedingDao = database.bleedingDao()

    @Provides
    fun providesSexDao(
        database: BluemoonDatabase,
    ): SexDao = database.sexDao()

    @Provides
    fun providesPillDao(
        database: BluemoonDatabase
    ): PillDao = database.pillDao()
}
