package com.ngrob.android.bluemoon.core.database

import androidx.room.AutoMigration
import androidx.room.Database
import androidx.room.RoomDatabase
import com.ngrob.android.bluemoon.core.database.dao.BleedingDao
import com.ngrob.android.bluemoon.core.database.dao.PillDao
import com.ngrob.android.bluemoon.core.database.dao.SexDao
import com.ngrob.android.bluemoon.core.database.model.Bleeding
import com.ngrob.android.bluemoon.core.database.model.ContraceptiveUse
import com.ngrob.android.bluemoon.core.database.model.Pill
import com.ngrob.android.bluemoon.core.database.model.Sex

@Database(
    entities = [Bleeding::class, Sex::class, ContraceptiveUse::class, Pill::class],
    autoMigrations = [
        AutoMigration(from = 1, to = 2),
        AutoMigration(from = 2, 3),
        AutoMigration(from = 3, 4),
        AutoMigration(from = 4, 5),
        AutoMigration(from = 5, 6),
        AutoMigration(from = 6, 7)
    ],
    version = 7,
    exportSchema = true
)
abstract class BluemoonDatabase : RoomDatabase() {
    abstract fun bleedingDao(): BleedingDao
    abstract fun sexDao(): SexDao
    abstract fun pillDao(): PillDao
}
