package com.ngrob.android.bluemoon.core.data.repository

import com.ngrob.android.bluemoon.core.database.model.ContraceptiveEnum
import com.ngrob.android.bluemoon.core.database.model.SexType
import com.ngrob.android.bluemoon.core.database.model.SexWithContraceptives
import kotlinx.coroutines.flow.Flow
import java.time.LocalDate

interface SexRepository {
    fun getSexWithContraceptivesOfDate(date: LocalDate): Flow<List<SexWithContraceptives>>
    fun addSex(type: SexType, contraceptives: List<ContraceptiveEnum>, date: LocalDate)
    fun deleteSexById(id: Int)

    fun deleteAllSex()
}