package com.ngrob.android.bluemoon.core.data.repository

import com.ngrob.android.bluemoon.core.database.model.Pill
import kotlinx.coroutines.flow.Flow
import java.time.LocalDate

interface PillRepository {
    fun getPillOfDay(date: LocalDate): Flow<Pill?>

    fun takePill(date: LocalDate, isSubstitute: Boolean = false)
    fun deletePillById(id: Int)
    fun deleteAllPills()
}