package com.ngrob.android.bluemoon.core.data.repository

import com.ngrob.android.bluemoon.core.datastore.BluemoonPreferencesDataSource
import com.ngrob.android.bluemoon.core.model.PillRecipe
import com.ngrob.android.bluemoon.core.model.ReminderSettings
import com.ngrob.android.bluemoon.core.model.UserData
import kotlinx.coroutines.flow.Flow
import javax.inject.Inject

class OfflineUserDataRepository @Inject constructor(
    private val bluemoonPreferencesDataSource: BluemoonPreferencesDataSource,
) : UserDataRepository {

    override val userData: Flow<UserData> =
        bluemoonPreferencesDataSource.userData

    override suspend fun setTrackBirthControl(trackBirthControl: Boolean) {
        bluemoonPreferencesDataSource.setTrackBirthControl(trackBirthControl)
    }

    override suspend fun setPillRecipe(pillRecipe: PillRecipe) {
        bluemoonPreferencesDataSource.setPillRecipe(pillRecipe)
    }

    override suspend fun setReminderSettings(reminderSettings: ReminderSettings) {
        bluemoonPreferencesDataSource.setReminderSettings(reminderSettings)
    }

}